/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common.treetable;

import edu.uoregon.tau.common.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.common.treetable.JTreeTable;
import edu.uoregon.tau.common.treetable.TreeTableModel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeTableExample {
    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("TreeTable");
        JTreeTable jTreeTable = new JTreeTable(new FileSystemModel(), true, true);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new JScrollPane(jTreeTable));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static class FileNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 5674303205543895393L;
        File file;
        Object[] children;
        private MergeSort fileMS = new MergeSort(){

            @Override
            public int compareElementsAt(int n, int n2) {
                return ((String)this.toSort[n]).compareTo((String)this.toSort[n2]);
            }
        };

        public FileNode(File file) {
            this.file = file;
        }

        @Override
        public String toString() {
            return this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        protected Object[] getChildren() {
            if (this.children != null) {
                return this.children;
            }
            try {
                Object[] objectArray = this.file.list();
                if (objectArray != null) {
                    this.fileMS.sort(objectArray);
                    this.children = new FileNode[objectArray.length];
                    String string = this.file.getPath();
                    for (int i = 0; i < objectArray.length; ++i) {
                        File file = new File(string, (String)objectArray[i]);
                        this.children[i] = new FileNode(file);
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return this.children;
        }
    }

    public static class FileSystemModel
    extends AbstractTreeTableModel
    implements TreeTableModel {
        String[] cNames = new String[]{"Name", "Size", "Type", "Modified"};
        Class[] cTypes = new Class[]{TreeTableModel.class, Integer.class, String.class, Date.class};
        final Integer ZERO = new Integer(0);

        public FileSystemModel() {
            super(new FileNode(new File(File.separator)));
        }

        protected File getFile(Object object) {
            FileNode fileNode = (FileNode)object;
            return fileNode.getFile();
        }

        protected Object[] getChildren(Object object) {
            FileNode fileNode = (FileNode)object;
            return fileNode.getChildren();
        }

        @Override
        public int getChildCount(Object object) {
            Object[] objectArray = this.getChildren(object);
            return objectArray == null ? 0 : objectArray.length;
        }

        @Override
        public Object getChild(Object object, int n) {
            return this.getChildren(object)[n];
        }

        @Override
        public boolean isLeaf(Object object) {
            return this.getFile(object).isFile();
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public Class<Object> getColumnClass(int n) {
            return this.cTypes[n];
        }

        @Override
        public Object getValueAt(Object object, int n) {
            File file = this.getFile(object);
            try {
                switch (n) {
                    case 0: {
                        return file.getName();
                    }
                    case 1: {
                        return file.isFile() ? new Integer((int)file.length()) : this.ZERO;
                    }
                    case 2: {
                        return file.isFile() ? "File" : "Directory";
                    }
                    case 3: {
                        return new Date(file.lastModified());
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public int getColorMetric() {
            return 0;
        }
    }

    public static abstract class MergeSort {
        protected Object[] toSort;
        protected Object[] swapSpace;

        public void sort(Object[] objectArray) {
            if (objectArray != null && objectArray.length > 1) {
                int n = objectArray.length;
                this.swapSpace = new Object[n];
                this.toSort = objectArray;
                this.mergeSort(0, n - 1);
                this.swapSpace = null;
                this.toSort = null;
            }
        }

        public abstract int compareElementsAt(int var1, int var2);

        protected void mergeSort(int n, int n2) {
            if (n != n2) {
                int n3 = (n + n2) / 2;
                this.mergeSort(n, n3);
                this.mergeSort(n3 + 1, n2);
                this.merge(n, n3, n2);
            }
        }

        protected void merge(int n, int n2, int n3) {
            int n4;
            int n5 = n4 = n;
            int n6 = n2 + 1;
            while (n5 <= n2 && n6 <= n3) {
                if (this.compareElementsAt(n6, n5) < 0) {
                    this.swapSpace[n4++] = this.toSort[n6++];
                    continue;
                }
                this.swapSpace[n4++] = this.toSort[n5++];
            }
            if (n5 <= n2) {
                while (n5 <= n2) {
                    this.swapSpace[n4++] = this.toSort[n5++];
                }
            } else {
                while (n6 <= n3) {
                    this.swapSpace[n4++] = this.toSort[n6++];
                }
            }
            for (n4 = n; n4 <= n3; ++n4) {
                this.toSort[n4] = this.swapSpace[n4];
            }
        }
    }
}

