/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

import com.graphbuilder.math.AddNode;
import com.graphbuilder.math.DivNode;
import com.graphbuilder.math.Expression;
import com.graphbuilder.math.ExpressionParseException;
import com.graphbuilder.math.FuncNode;
import com.graphbuilder.math.MultNode;
import com.graphbuilder.math.PowNode;
import com.graphbuilder.math.SubNode;
import com.graphbuilder.math.ValNode;
import com.graphbuilder.math.VarNode;
import com.graphbuilder.struc.Stack;

public class ExpressionTree {
    private ExpressionTree() {
    }

    public static Expression parse(String string) {
        if (string == null) {
            throw new ExpressionParseException("Expression string cannot be null.", -1);
        }
        return ExpressionTree.build(string, 0);
    }

    private static Expression build(String string, int n) {
        if (string.trim().length() == 0) {
            return null;
        }
        Stack stack = new Stack();
        Stack stack2 = new Stack();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < string.length(); ++i) {
            Object object;
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n') continue;
            if (bl) {
                if (c == '(') {
                    if (bl3) {
                        throw new ExpressionParseException("Open bracket found after negate.", i);
                    }
                    stack2.push("(");
                    continue;
                }
                if (!(bl2 || c != '+' && c != '-')) {
                    bl2 = true;
                    if (c != '-') continue;
                    bl3 = true;
                    continue;
                }
                if (c >= '0' && c <= '9' || c == '.') {
                    int n2;
                    for (n2 = i + 1; n2 < string.length(); ++n2) {
                        c = string.charAt(n2);
                        if (c >= '0' && c <= '9' || c == '.') {
                            continue;
                        }
                        if (c != 'e' && c != 'E') break;
                        if (++n2 < string.length()) {
                            c = string.charAt(n2);
                            if (c != '+' && c != '-' && (c < '0' || c > '9')) {
                                throw new ExpressionParseException("Expected digit, plus sign or minus sign but found: " + String.valueOf(c), n2 + n);
                            }
                            ++n2;
                        }
                        while (n2 < string.length() && (c = string.charAt(n2)) >= '0' && c <= '9') {
                            ++n2;
                        }
                        break block3;
                    }
                    double d = 0.0;
                    String string2 = string.substring(i, n2);
                    try {
                        d = Double.parseDouble(string2);
                    }
                    catch (Throwable throwable) {
                        throw new ExpressionParseException("Improperly formatted value: " + string2, i + n);
                    }
                    if (bl3) {
                        d = -d;
                    }
                    stack.push(new ValNode(d));
                    i = n2 - 1;
                    bl3 = false;
                    bl = false;
                    bl2 = false;
                    continue;
                }
                if (c != ',' && c != ')' && c != '^' && c != '*' && c != '/' && c != '+' && c != '-') {
                    int n3;
                    for (n3 = i + 1; n3 < string.length() && (c = string.charAt(n3)) != ',' && c != ' ' && c != '\t' && c != '\n' && c != '(' && c != ')' && c != '^' && c != '*' && c != '/' && c != '+' && c != '-'; ++n3) {
                    }
                    if (n3 < string.length()) {
                        int n4 = n3;
                        while ((c == ' ' || c == '\t' || c == '\n') && ++n4 != string.length()) {
                            c = string.charAt(n4);
                        }
                        if (c == '(') {
                            Expression expression;
                            object = new FuncNode(string.substring(i, n3), bl3);
                            int n5 = 1;
                            int n6 = n4 + 1;
                            while (n5 != 0) {
                                if (++n4 >= string.length()) {
                                    throw new ExpressionParseException("Missing function close bracket.", i + n);
                                }
                                c = string.charAt(n4);
                                if (c == ')') {
                                    --n5;
                                    continue;
                                }
                                if (c == '(') {
                                    ++n5;
                                    continue;
                                }
                                if (c != ',' || n5 != 1) continue;
                                expression = ExpressionTree.build(string.substring(n6, n4), n6);
                                if (expression == null) {
                                    throw new ExpressionParseException("Incomplete function.", n6 + n);
                                }
                                ((FuncNode)object).add(expression);
                                n6 = n4 + 1;
                            }
                            expression = ExpressionTree.build(string.substring(n6, n4), n6);
                            if (expression == null) {
                                if (((FuncNode)object).numChildren() > 0) {
                                    throw new ExpressionParseException("Incomplete function.", n6 + n);
                                }
                            } else {
                                ((FuncNode)object).add(expression);
                            }
                            stack.push(object);
                            i = n4;
                        } else {
                            stack.push(new VarNode(string.substring(i, n3), bl3));
                            i = n4 - 1;
                        }
                    } else {
                        stack.push(new VarNode(string.substring(i, n3), bl3));
                        i = n3 - 1;
                    }
                    bl3 = false;
                    bl = false;
                    bl2 = false;
                    continue;
                }
                throw new ExpressionParseException("Unexpected character: " + String.valueOf(c), i + n);
            }
            if (c == ')') {
                Stack stack3 = new Stack();
                Stack stack4 = new Stack();
                while (true) {
                    if (stack2.isEmpty()) {
                        throw new ExpressionParseException("Missing open bracket.", i + n);
                    }
                    object = stack2.pop();
                    if (object.equals("(")) break;
                    stack3.addToTail(stack.pop());
                    stack4.addToTail(object);
                }
                stack3.addToTail(stack.pop());
                stack.push(ExpressionTree.build(stack3, stack4));
                continue;
            }
            if (c == '^' || c == '*' || c == '/' || c == '+' || c == '-') {
                bl = true;
                stack2.push(String.valueOf(c));
                continue;
            }
            throw new ExpressionParseException("Expected operator or close bracket but found: " + String.valueOf(c), i + n);
        }
        if (stack.size() != stack2.size() + 1) {
            throw new ExpressionParseException("Incomplete expression.", n + string.length());
        }
        return ExpressionTree.build(stack, stack2);
    }

    private static Expression build(Stack stack, Stack stack2) {
        Object object;
        Object object2;
        Object object3;
        Stack stack3 = new Stack();
        Stack stack4 = new Stack();
        while (!stack2.isEmpty()) {
            object3 = stack2.removeTail();
            object2 = stack.removeTail();
            object = stack.removeTail();
            if (object3.equals("^")) {
                stack.addToTail(new PowNode((Expression)object2, (Expression)object));
                continue;
            }
            stack.addToTail(object);
            stack4.push(object3);
            stack3.push(object2);
        }
        stack3.push(stack.pop());
        while (!stack4.isEmpty()) {
            object3 = stack4.removeTail();
            object2 = stack3.removeTail();
            object = stack3.removeTail();
            if (object3.equals("*")) {
                stack3.addToTail(new MultNode((Expression)object2, (Expression)object));
                continue;
            }
            if (object3.equals("/")) {
                stack3.addToTail(new DivNode((Expression)object2, (Expression)object));
                continue;
            }
            stack3.addToTail(object);
            stack2.push(object3);
            stack.push(object2);
        }
        stack.push(stack3.pop());
        while (!stack2.isEmpty()) {
            object3 = stack2.removeTail();
            object2 = stack.removeTail();
            object = stack.removeTail();
            if (object3.equals("+")) {
                stack.addToTail(new AddNode((Expression)object2, (Expression)object));
                continue;
            }
            if (object3.equals("-")) {
                stack.addToTail(new SubNode((Expression)object2, (Expression)object));
                continue;
            }
            throw new ExpressionParseException("Unknown operator: " + object3, -1);
        }
        return (Expression)stack.pop();
    }
}

