#ifndef PTI_TOOLS_COMMON_H_
#define PTI_TOOLS_COMMON_H_

typedef enum {
  UnknownTracingId,
  DummyTracingId,
  ZeKernelTracingId,
  L0StartTracingId,
  InitTracingId,
  DriverGetTracingId,
  DriverGetApiVersionTracingId,
  DriverGetPropertiesTracingId,
  DriverGetIpcPropertiesTracingId,
  DriverGetExtensionPropertiesTracingId,
  DeviceGetTracingId,
  DeviceGetSubDevicesTracingId,
  DeviceGetPropertiesTracingId,
  DeviceGetComputePropertiesTracingId,
  DeviceGetModulePropertiesTracingId,
  DeviceGetCommandQueueGroupPropertiesTracingId,
  DeviceGetMemoryPropertiesTracingId,
  DeviceGetMemoryAccessPropertiesTracingId,
  DeviceGetCachePropertiesTracingId,
  DeviceGetImagePropertiesTracingId,
  DeviceGetExternalMemoryPropertiesTracingId,
  DeviceGetP2PPropertiesTracingId,
  DeviceCanAccessPeerTracingId,
  DeviceGetStatusTracingId,
  ContextCreateTracingId,
  ContextDestroyTracingId,
  ContextGetStatusTracingId,
  ContextSystemBarrierTracingId,
  ContextMakeMemoryResidentTracingId,
  ContextEvictMemoryTracingId,
  ContextMakeImageResidentTracingId,
  ContextEvictImageTracingId,
  CommandQueueCreateTracingId,
  CommandQueueDestroyTracingId,
  CommandQueueExecuteCommandListsTracingId,
  CommandQueueSynchronizeTracingId,
  CommandListCreateTracingId,
  CommandListCreateImmediateTracingId,
  CommandListDestroyTracingId,
  CommandListCloseTracingId,
  CommandListResetTracingId,
  CommandListAppendWriteGlobalTimestampTracingId,
  CommandListAppendBarrierTracingId,
  CommandListAppendMemoryRangesBarrierTracingId,
  CommandListAppendMemoryCopyTracingId,
  CommandListAppendMemoryFillTracingId,
  CommandListAppendMemoryCopyRegionTracingId,
  CommandListAppendMemoryCopyFromContextTracingId,
  CommandListAppendImageCopyTracingId,
  CommandListAppendImageCopyRegionTracingId,
  CommandListAppendImageCopyToMemoryTracingId,
  CommandListAppendImageCopyFromMemoryTracingId,
  CommandListAppendMemoryPrefetchTracingId,
  CommandListAppendMemAdviseTracingId,
  CommandListAppendSignalEventTracingId,
  CommandListAppendWaitOnEventsTracingId,
  CommandListAppendEventResetTracingId,
  CommandListAppendQueryKernelTimestampsTracingId,
  CommandListAppendLaunchKernelTracingId,
  CommandListAppendLaunchCooperativeKernelTracingId,
  CommandListAppendLaunchKernelIndirectTracingId,
  CommandListAppendLaunchMultipleKernelsIndirectTracingId,
  ImageGetPropertiesTracingId,
  ImageCreateTracingId,
  ImageDestroyTracingId,
  MemAllocSharedTracingId,
  MemAllocDeviceTracingId,
  MemAllocHostTracingId,
  MemFreeTracingId,
  MemGetAllocPropertiesTracingId,
  MemGetAddressRangeTracingId,
  MemGetIpcHandleTracingId,
  MemOpenIpcHandleTracingId,
  MemCloseIpcHandleTracingId,
  FenceCreateTracingId,
  FenceDestroyTracingId,
  FenceHostSynchronizeTracingId,
  FenceQueryStatusTracingId,
  FenceResetTracingId,
  EventPoolCreateTracingId,
  EventPoolDestroyTracingId,
  EventPoolGetIpcHandleTracingId,
  EventPoolOpenIpcHandleTracingId,
  EventPoolCloseIpcHandleTracingId,
  EventCreateTracingId,
  EventDestroyTracingId,
  EventHostSignalTracingId,
  EventHostSynchronizeTracingId,
  EventQueryStatusTracingId,
  EventHostResetTracingId,
  EventQueryKernelTimestampTracingId,
  ModuleCreateTracingId,
  ModuleDestroyTracingId,
  ModuleDynamicLinkTracingId,
  ModuleGetNativeBinaryTracingId,
  ModuleGetGlobalPointerTracingId,
  ModuleGetKernelNamesTracingId,
  ModuleGetPropertiesTracingId,
  ModuleGetFunctionPointerTracingId,
  ModuleBuildLogDestroyTracingId,
  ModuleBuildLogGetStringTracingId,
  KernelCreateTracingId,
  KernelDestroyTracingId,
  KernelSetCacheConfigTracingId,
  KernelSetGroupSizeTracingId,
  KernelSuggestGroupSizeTracingId,
  KernelSuggestMaxCooperativeGroupCountTracingId,
  KernelSetArgumentValueTracingId,
  KernelSetIndirectAccessTracingId,
  KernelGetIndirectAccessTracingId,
  KernelGetSourceAttributesTracingId,
  KernelGetPropertiesTracingId,
  KernelGetNameTracingId,
  SamplerCreateTracingId,
  SamplerDestroyTracingId,
  PhysicalMemCreateTracingId,
  PhysicalMemDestroyTracingId,
  VirtualMemReserveTracingId,
  VirtualMemFreeTracingId,
  VirtualMemQueryPageSizeTracingId,
  VirtualMemMapTracingId,
  VirtualMemUnmapTracingId,
  VirtualMemSetAccessAttributeTracingId,
  VirtualMemGetAccessAttributeTracingId,
  InitDriversTracingId,
  RTASBuilderCreateExpTracingId,
  RTASBuilderGetBuildPropertiesExpTracingId,
  RTASBuilderBuildExpTracingId,
  RTASBuilderDestroyExpTracingId,
  RTASParallelOperationCreateExpTracingId,
  RTASParallelOperationGetPropertiesExpTracingId,
  RTASParallelOperationJoinExpTracingId,
  RTASParallelOperationDestroyExpTracingId,
  DriverGetExtensionFunctionAddressTracingId,
  DriverGetLastErrorDescriptionTracingId,
  DriverRTASFormatCompatibilityCheckExpTracingId,
  DeviceGetGlobalTimestampsTracingId,
  DeviceImportExternalSemaphoreExtTracingId,
  DeviceReleaseExternalSemaphoreExtTracingId,
  DeviceReserveCacheExtTracingId,
  DeviceSetCacheAdviceExtTracingId,
  DevicePciGetPropertiesExtTracingId,
  DeviceGetFabricVertexExpTracingId,
  DeviceGetRootDeviceTracingId,
  ContextCreateExTracingId,
  CommandQueueGetOrdinalTracingId,
  CommandQueueGetIndexTracingId,
  CommandListGetNextCommandIdWithKernelsExpTracingId,
  CommandListUpdateMutableCommandKernelsExpTracingId,
  CommandListAppendSignalExternalSemaphoreExtTracingId,
  CommandListAppendWaitExternalSemaphoreExtTracingId,
  CommandListAppendImageCopyToMemoryExtTracingId,
  CommandListAppendImageCopyFromMemoryExtTracingId,
  CommandListHostSynchronizeTracingId,
  CommandListCreateCloneExpTracingId,
  CommandListGetDeviceHandleTracingId,
  CommandListGetContextHandleTracingId,
  CommandListGetOrdinalTracingId,
  CommandListImmediateGetIndexTracingId,
  CommandListIsImmediateTracingId,
  CommandListImmediateAppendCommandListsExpTracingId,
  CommandListGetNextCommandIdExpTracingId,
  CommandListUpdateMutableCommandsExpTracingId,
  CommandListUpdateMutableCommandSignalEventExpTracingId,
  CommandListUpdateMutableCommandWaitEventsExpTracingId,
  EventQueryTimestampsExpTracingId,
  EventQueryKernelTimestampsExtTracingId,
  EventGetEventPoolTracingId,
  EventGetSignalScopeTracingId,
  EventGetWaitScopeTracingId,
  EventPoolPutIpcHandleTracingId,
  EventPoolGetContextHandleTracingId,
  EventPoolGetFlagsTracingId,
  ImageGetMemoryPropertiesExpTracingId,
  ImageViewCreateExpTracingId,
  ImageGetAllocPropertiesExtTracingId,
  ImageViewCreateExtTracingId,
  ImageGetDeviceOffsetExpTracingId,
  KernelSetGlobalOffsetExpTracingId,
  KernelGetBinaryExpTracingId,
  KernelSchedulingHintExpTracingId,
  MemFreeExtTracingId,
  MemGetIpcHandleFromFileDescriptorExpTracingId,
  MemGetFileDescriptorFromIpcHandleExpTracingId,
  MemPutIpcHandleTracingId,
  MemSetAtomicAccessAttributeExpTracingId,
  MemGetAtomicAccessAttributeExpTracingId,
  MemGetPitchFor2dImageTracingId,
  ModuleInspectLinkageExtTracingId,
  FabricEdgeGetExpTracingId,
  FabricEdgeGetVerticesExpTracingId,
  FabricEdgeGetPropertiesExpTracingId,
  FabricVertexGetExpTracingId,
  FabricVertexGetSubVerticesExpTracingId,
  FabricVertexGetPropertiesExpTracingId,
  FabricVertexGetDeviceExpTracingId,
  L0EndTracingId,
  OCLStartTracingId,
  clBuildProgramTracingId = OCLStartTracingId,
  clCloneKernelTracingId,
  clCompileProgramTracingId,
  clCreateBufferTracingId,
  clCreateCommandQueueTracingId,
  clCreateCommandQueueWithPropertiesTracingId,
  clCreateContextTracingId,
  clCreateContextFromTypeTracingId,
  clCreateFromGLBufferTracingId,
  clCreateFromGLRenderbufferTracingId,
  clCreateFromGLTextureTracingId,
  clCreateFromGLTexture2DTracingId,
  clCreateFromGLTexture3DTracingId,
  clCreateImageTracingId,
  clCreateImage2DTracingId,
  clCreateImage3DTracingId,
  clCreateKernelTracingId,
  clCreateKernelsInProgramTracingId,
  clCreatePipeTracingId,
  clCreateProgramWithBinaryTracingId,
  clCreateProgramWithBuiltInKernelsTracingId,
  clCreateProgramWithILTracingId,
  clCreateProgramWithSourceTracingId,
  clCreateSamplerTracingId,
  clCreateSamplerWithPropertiesTracingId,
  clCreateSubBufferTracingId,
  clCreateSubDevicesTracingId,
  clCreateUserEventTracingId,
  clEnqueueAcquireGLObjectsTracingId,
  clEnqueueBarrierTracingId,
  clEnqueueBarrierWithWaitListTracingId,
  clEnqueueCopyBufferTracingId,
  clEnqueueCopyBufferRectTracingId,
  clEnqueueCopyBufferToImageTracingId,
  clEnqueueCopyImageTracingId,
  clEnqueueCopyImageToBufferTracingId,
  clEnqueueFillBufferTracingId,
  clEnqueueFillImageTracingId,
  clEnqueueMapBufferTracingId,
  clEnqueueMapImageTracingId,
  clEnqueueMarkerTracingId,
  clEnqueueMarkerWithWaitListTracingId,
  clEnqueueMigrateMemObjectsTracingId,
  clEnqueueNDRangeKernelTracingId,
  clEnqueueNativeKernelTracingId,
  clEnqueueReadBufferTracingId,
  clEnqueueReadBufferRectTracingId,
  clEnqueueReadImageTracingId,
  clEnqueueReleaseGLObjectsTracingId,
  clEnqueueSVMFreeTracingId,
  clEnqueueSVMMapTracingId,
  clEnqueueSVMMemFillTracingId,
  clEnqueueSVMMemcpyTracingId,
  clEnqueueSVMMigrateMemTracingId,
  clEnqueueSVMUnmapTracingId,
  clEnqueueTaskTracingId,
  clEnqueueUnmapMemObjectTracingId,
  clEnqueueWaitForEventsTracingId,
  clEnqueueWriteBufferTracingId,
  clEnqueueWriteBufferRectTracingId,
  clEnqueueWriteImageTracingId,
  clFinishTracingId,
  clFlushTracingId,
  clGetCommandQueueInfoTracingId,
  clGetContextInfoTracingId,
  clGetDeviceAndHostTimerTracingId,
  clGetDeviceIDsTracingId,
  clGetDeviceInfoTracingId,
  clGetEventInfoTracingId,
  clGetEventProfilingInfoTracingId,
  clGetExtensionFunctionAddressTracingId,
  clGetExtensionFunctionAddressForPlatformTracingId,
  clGetGLObjectInfoTracingId,
  clGetGLTextureInfoTracingId,
  clGetHostTimerTracingId,
  clGetImageInfoTracingId,
  clGetKernelArgInfoTracingId,
  clGetKernelInfoTracingId,
  clGetKernelSubGroupInfoTracingId,
  clGetKernelWorkGroupInfoTracingId,
  clGetMemObjectInfoTracingId,
  clGetPipeInfoTracingId,
  clGetPlatformIDsTracingId,
  clGetPlatformInfoTracingId,
  clGetProgramBuildInfoTracingId,
  clGetProgramInfoTracingId,
  clGetSamplerInfoTracingId,
  clGetSupportedImageFormatsTracingId,
  clLinkProgramTracingId,
  clReleaseCommandQueueTracingId,
  clReleaseContextTracingId,
  clReleaseDeviceTracingId,
  clReleaseEventTracingId,
  clReleaseKernelTracingId,
  clReleaseMemObjectTracingId,
  clReleaseProgramTracingId,
  clReleaseSamplerTracingId,
  clRetainCommandQueueTracingId,
  clRetainContextTracingId,
  clRetainDeviceTracingId,
  clRetainEventTracingId,
  clRetainKernelTracingId,
  clRetainMemObjectTracingId,
  clRetainProgramTracingId,
  clRetainSamplerTracingId,
  clSVMAllocTracingId,
  clSVMFreeTracingId,
  clSetCommandQueuePropertyTracingId,
  clSetDefaultDeviceCommandQueueTracingId,
  clSetEventCallbackTracingId,
  clSetKernelArgTracingId,
  clSetKernelArgSVMPointerTracingId,
  clSetKernelExecInfoTracingId,
  clSetMemObjectDestructorCallbackTracingId,
  clSetUserEventStatusTracingId,
  clUnloadCompilerTracingId,
  clUnloadPlatformCompilerTracingId,
  clWaitForEventsTracingId,
  OCLEndTracingId,
  ClKernelTracingId,
  OpenClTracingId,
  XptiTracingId,
  IttTracingId,
} API_TRACING_ID;

 static std::string tracing_api_name [ ] = {
  "zeInit",
  "zeDriverGet",
  "zeDriverGetApiVersion",
  "zeDriverGetProperties",
  "zeDriverGetIpcProperties",
  "zeDriverGetExtensionProperties",
  "zeDeviceGet",
  "zeDeviceGetSubDevices",
  "zeDeviceGetProperties",
  "zeDeviceGetComputeProperties",
  "zeDeviceGetModuleProperties",
  "zeDeviceGetCommandQueueGroupProperties",
  "zeDeviceGetMemoryProperties",
  "zeDeviceGetMemoryAccessProperties",
  "zeDeviceGetCacheProperties",
  "zeDeviceGetImageProperties",
  "zeDeviceGetExternalMemoryProperties",
  "zeDeviceGetP2PProperties",
  "zeDeviceCanAccessPeer",
  "zeDeviceGetStatus",
  "zeContextCreate",
  "zeContextDestroy",
  "zeContextGetStatus",
  "zeContextSystemBarrier",
  "zeContextMakeMemoryResident",
  "zeContextEvictMemory",
  "zeContextMakeImageResident",
  "zeContextEvictImage",
  "zeCommandQueueCreate",
  "zeCommandQueueDestroy",
  "zeCommandQueueExecuteCommandLists",
  "zeCommandQueueSynchronize",
  "zeCommandListCreate",
  "zeCommandListCreateImmediate",
  "zeCommandListDestroy",
  "zeCommandListClose",
  "zeCommandListReset",
  "zeCommandListAppendWriteGlobalTimestamp",
  "zeCommandListAppendBarrier",
  "zeCommandListAppendMemoryRangesBarrier",
  "zeCommandListAppendMemoryCopy",
  "zeCommandListAppendMemoryFill",
  "zeCommandListAppendMemoryCopyRegion",
  "zeCommandListAppendMemoryCopyFromContext",
  "zeCommandListAppendImageCopy",
  "zeCommandListAppendImageCopyRegion",
  "zeCommandListAppendImageCopyToMemory",
  "zeCommandListAppendImageCopyFromMemory",
  "zeCommandListAppendMemoryPrefetch",
  "zeCommandListAppendMemAdvise",
  "zeCommandListAppendSignalEvent",
  "zeCommandListAppendWaitOnEvents",
  "zeCommandListAppendEventReset",
  "zeCommandListAppendQueryKernelTimestamps",
  "zeCommandListAppendLaunchKernel",
  "zeCommandListAppendLaunchCooperativeKernel",
  "zeCommandListAppendLaunchKernelIndirect",
  "zeCommandListAppendLaunchMultipleKernelsIndirect",
  "zeImageGetProperties",
  "zeImageCreate",
  "zeImageDestroy",
  "zeMemAllocShared",
  "zeMemAllocDevice",
  "zeMemAllocHost",
  "zeMemFree",
  "zeMemGetAllocProperties",
  "zeMemGetAddressRange",
  "zeMemGetIpcHandle",
  "zeMemOpenIpcHandle",
  "zeMemCloseIpcHandle",
  "zeFenceCreate",
  "zeFenceDestroy",
  "zeFenceHostSynchronize",
  "zeFenceQueryStatus",
  "zeFenceReset",
  "zeEventPoolCreate",
  "zeEventPoolDestroy",
  "zeEventPoolGetIpcHandle",
  "zeEventPoolOpenIpcHandle",
  "zeEventPoolCloseIpcHandle",
  "zeEventCreate",
  "zeEventDestroy",
  "zeEventHostSignal",
  "zeEventHostSynchronize",
  "zeEventQueryStatus",
  "zeEventHostReset",
  "zeEventQueryKernelTimestamp",
  "zeModuleCreate",
  "zeModuleDestroy",
  "zeModuleDynamicLink",
  "zeModuleGetNativeBinary",
  "zeModuleGetGlobalPointer",
  "zeModuleGetKernelNames",
  "zeModuleGetProperties",
  "zeModuleGetFunctionPointer",
  "zeModuleBuildLogDestroy",
  "zeModuleBuildLogGetString",
  "zeKernelCreate",
  "zeKernelDestroy",
  "zeKernelSetCacheConfig",
  "zeKernelSetGroupSize",
  "zeKernelSuggestGroupSize",
  "zeKernelSuggestMaxCooperativeGroupCount",
  "zeKernelSetArgumentValue",
  "zeKernelSetIndirectAccess",
  "zeKernelGetIndirectAccess",
  "zeKernelGetSourceAttributes",
  "zeKernelGetProperties",
  "zeKernelGetName",
  "zeSamplerCreate",
  "zeSamplerDestroy",
  "zePhysicalMemCreate",
  "zePhysicalMemDestroy",
  "zeVirtualMemReserve",
  "zeVirtualMemFree",
  "zeVirtualMemQueryPageSize",
  "zeVirtualMemMap",
  "zeVirtualMemUnmap",
  "zeVirtualMemSetAccessAttribute",
  "zeVirtualMemGetAccessAttribute",
  "zeInitDrivers",
  "zeRTASBuilderCreateExp",
  "zeRTASBuilderGetBuildPropertiesExp",
  "zeRTASBuilderBuildExp",
  "zeRTASBuilderDestroyExp",
  "zeRTASParallelOperationCreateExp",
  "zeRTASParallelOperationGetPropertiesExp",
  "zeRTASParallelOperationJoinExp",
  "zeRTASParallelOperationDestroyExp",
  "zeDriverGetExtensionFunctionAddress",
  "zeDriverGetLastErrorDescription",
  "zeDriverRTASFormatCompatibilityCheckExp",
  "zeDeviceGetGlobalTimestamps",
  "zeDeviceImportExternalSemaphoreExt",
  "zeDeviceReleaseExternalSemaphoreExt",
  "zeDeviceReserveCacheExt",
  "zeDeviceSetCacheAdviceExt",
  "zeDevicePciGetPropertiesExt",
  "zeDeviceGetFabricVertexExp",
  "zeDeviceGetRootDevice",
  "zeContextCreateEx",
  "zeCommandQueueGetOrdinal",
  "zeCommandQueueGetIndex",
  "zeCommandListGetNextCommandIdWithKernelsExp",
  "zeCommandListUpdateMutableCommandKernelsExp",
  "zeCommandListAppendSignalExternalSemaphoreExt",
  "zeCommandListAppendWaitExternalSemaphoreExt",
  "zeCommandListAppendImageCopyToMemoryExt",
  "zeCommandListAppendImageCopyFromMemoryExt",
  "zeCommandListHostSynchronize",
  "zeCommandListCreateCloneExp",
  "zeCommandListGetDeviceHandle",
  "zeCommandListGetContextHandle",
  "zeCommandListGetOrdinal",
  "zeCommandListImmediateGetIndex",
  "zeCommandListIsImmediate",
  "zeCommandListImmediateAppendCommandListsExp",
  "zeCommandListGetNextCommandIdExp",
  "zeCommandListUpdateMutableCommandsExp",
  "zeCommandListUpdateMutableCommandSignalEventExp",
  "zeCommandListUpdateMutableCommandWaitEventsExp",
  "zeEventQueryTimestampsExp",
  "zeEventQueryKernelTimestampsExt",
  "zeEventGetEventPool",
  "zeEventGetSignalScope",
  "zeEventGetWaitScope",
  "zeEventPoolPutIpcHandle",
  "zeEventPoolGetContextHandle",
  "zeEventPoolGetFlags",
  "zeImageGetMemoryPropertiesExp",
  "zeImageViewCreateExp",
  "zeImageGetAllocPropertiesExt",
  "zeImageViewCreateExt",
  "zeImageGetDeviceOffsetExp",
  "zeKernelSetGlobalOffsetExp",
  "zeKernelGetBinaryExp",
  "zeKernelSchedulingHintExp",
  "zeMemFreeExt",
  "zeMemGetIpcHandleFromFileDescriptorExp",
  "zeMemGetFileDescriptorFromIpcHandleExp",
  "zeMemPutIpcHandle",
  "zeMemSetAtomicAccessAttributeExp",
  "zeMemGetAtomicAccessAttributeExp",
  "zeMemGetPitchFor2dImage",
  "zeModuleInspectLinkageExt",
  "zeFabricEdgeGetExp",
  "zeFabricEdgeGetVerticesExp",
  "zeFabricEdgeGetPropertiesExp",
  "zeFabricVertexGetExp",
  "zeFabricVertexGetSubVerticesExp",
  "zeFabricVertexGetPropertiesExp",
  "zeFabricVertexGetDeviceExp",
  "clBuildProgram",
  "clCloneKernel",
  "clCompileProgram",
  "clCreateBuffer",
  "clCreateCommandQueue",
  "clCreateCommandQueueWithProperties",
  "clCreateContext",
  "clCreateContextFromType",
  "clCreateFromGLBuffer",
  "clCreateFromGLRenderbuffer",
  "clCreateFromGLTexture",
  "clCreateFromGLTexture2D",
  "clCreateFromGLTexture3D",
  "clCreateImage",
  "clCreateImage2D",
  "clCreateImage3D",
  "clCreateKernel",
  "clCreateKernelsInProgram",
  "clCreatePipe",
  "clCreateProgramWithBinary",
  "clCreateProgramWithBuiltInKernels",
  "clCreateProgramWithIL",
  "clCreateProgramWithSource",
  "clCreateSampler",
  "clCreateSamplerWithProperties",
  "clCreateSubBuffer",
  "clCreateSubDevices",
  "clCreateUserEvent",
  "clEnqueueAcquireGLObjects",
  "clEnqueueBarrier",
  "clEnqueueBarrierWithWaitList",
  "clEnqueueCopyBuffer",
  "clEnqueueCopyBufferRect",
  "clEnqueueCopyBufferToImage",
  "clEnqueueCopyImage",
  "clEnqueueCopyImageToBuffer",
  "clEnqueueFillBuffer",
  "clEnqueueFillImage",
  "clEnqueueMapBuffer",
  "clEnqueueMapImage",
  "clEnqueueMarker",
  "clEnqueueMarkerWithWaitList",
  "clEnqueueMigrateMemObjects",
  "clEnqueueNDRangeKernel",
  "clEnqueueNativeKernel",
  "clEnqueueReadBuffer",
  "clEnqueueReadBufferRect",
  "clEnqueueReadImage",
  "clEnqueueReleaseGLObjects",
  "clEnqueueSVMFree",
  "clEnqueueSVMMap",
  "clEnqueueSVMMemFill",
  "clEnqueueSVMMemcpy",
  "clEnqueueSVMMigrateMem",
  "clEnqueueSVMUnmap",
  "clEnqueueTask",
  "clEnqueueUnmapMemObject",
  "clEnqueueWaitForEvents",
  "clEnqueueWriteBuffer",
  "clEnqueueWriteBufferRect",
  "clEnqueueWriteImage",
  "clFinish",
  "clFlush",
  "clGetCommandQueueInfo",
  "clGetContextInfo",
  "clGetDeviceAndHostTimer",
  "clGetDeviceIDs",
  "clGetDeviceInfo",
  "clGetEventInfo",
  "clGetEventProfilingInfo",
  "clGetExtensionFunctionAddress",
  "clGetExtensionFunctionAddressForPlatform",
  "clGetGLObjectInfo",
  "clGetGLTextureInfo",
  "clGetHostTimer",
  "clGetImageInfo",
  "clGetKernelArgInfo",
  "clGetKernelInfo",
  "clGetKernelSubGroupInfo",
  "clGetKernelWorkGroupInfo",
  "clGetMemObjectInfo",
  "clGetPipeInfo",
  "clGetPlatformIDs",
  "clGetPlatformInfo",
  "clGetProgramBuildInfo",
  "clGetProgramInfo",
  "clGetSamplerInfo",
  "clGetSupportedImageFormats",
  "clLinkProgram",
  "clReleaseCommandQueue",
  "clReleaseContext",
  "clReleaseDevice",
  "clReleaseEvent",
  "clReleaseKernel",
  "clReleaseMemObject",
  "clReleaseProgram",
  "clReleaseSampler",
  "clRetainCommandQueue",
  "clRetainContext",
  "clRetainDevice",
  "clRetainEvent",
  "clRetainKernel",
  "clRetainMemObject",
  "clRetainProgram",
  "clRetainSampler",
  "clSVMAlloc",
  "clSVMFree",
  "clSetCommandQueueProperty",
  "clSetDefaultDeviceCommandQueue",
  "clSetEventCallback",
  "clSetKernelArg",
  "clSetKernelArgSVMPointer",
  "clSetKernelExecInfo",
  "clSetMemObjectDestructorCallback",
  "clSetUserEventStatus",
  "clUnloadCompiler",
  "clUnloadPlatformCompiler",
  "clWaitForEvents",
};



static std::string get_symbol(API_TRACING_ID id){
    if (id == UnknownTracingId) {
      return "UnknownAPIName";
    } else if ((id > L0StartTracingId) && (id < L0EndTracingId)) {
      auto index = id - L0StartTracingId;
      return tracing_api_name[index-1];
    } else if ((id >= OCLStartTracingId) && (id < OCLEndTracingId)) {
      auto index = (id - OCLStartTracingId) + (L0EndTracingId - L0StartTracingId);
      return tracing_api_name[index-1];
    } else {
      // Error: never come here
      return "UnknownAPIName";
    }
  }
#endif //PTI_TOOLS_COMMON_H_
