package edu.uoregon.tau.taucdt.preferences;

//import org.eclipse.core.runtime.Preferences;
import java.io.File;
import java.io.FilenameFilter;

import org.eclipse.jface.preference.*;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;
import edu.uoregon.tau.taucdt.TaucdtPlugin;
import edu.uoregon.tau.taucdt.preferences.*;
import org.eclipse.cdt.debug.internal.ui.preferences.ComboFieldEditor;
//import org.eclipse.cdt.debug.ui.*;
//import edu.uoregon.tau.taujava.TaujavaPlugin;
//import org.eclipse.swt.widgets.Combo;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */

public class TauCDTPreferencePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {

	//Used to id the path to the tau selection file
	public static final String TARCH_PATH = "TAUCDTArchPath";
	//Used to id the path to the tau selection file
	public static final String TAU_MAKE = "TAUCDTMakefile";	
	//Used to id the path to the tau selection file
	public static final String TAU_OPTS = "TAUCDTOpts";	
//	Used to indicate if the default output location should be used
	public static final String DEF_OUT = "defaultOutputRoot";
//	Used to id the path (non-default) where the tau output should be put
	public static final String USR_OUT = "outputRoot";
//	Used to indicate if paraprof should be run on profile output
	public static final String PARA_BOOL = "runParaProf";
	//Used to indicate use of dropdown box or text field for selecting makefile
	public static final String MAKE_COMB = "makeCombo";
	
	private DirectoryFieldEditor tarch;
	private VarComboFieldEditor cmake;
	
	
	public TauCDTPreferencePage() {
		super(GRID);
		setPreferenceStore(TaucdtPlugin.getDefault().getPreferenceStore());

		setDescription("Setup Tau CDT integration");
		//PreferenceManager mana = new PreferenceManager();
	}
	
	/**
	 * Creates the field editors. Field editors are abstractions of
	 * the common GUI blocks needed to manipulate various types
	 * of preferences. Each field editor knows how to save and
	 * restore itself.
	 */
	public void createFieldEditors() {

		tarch = new DirectoryFieldEditor(TARCH_PATH, "&TAU Arch Directory:", getFieldEditorParent());
		cmake = new VarComboFieldEditor(MAKE_COMB, "&Select TAU Makefile from Arch Directory", getMakeArray(), getFieldEditorParent());
		//cmake.getComboBoxControl(getFieldEditorParent()).select(0);
		//final Combo comboedit = cmake.getComboBoxControl(getFieldEditorParent());
		//final Combo makecombo = cmake.getComboBoxControl(getFieldEditorParent());
		getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent event) {
				
				//makecombo.select(0);
				if(event.getProperty().equals("TAUCDTArchPath"))
				{   //makecombo.set
					//cmake=initCombo();
					//addField(cmake);
					//initialize();
					//createFieldEditors();
					//.redraw();
					//comboedit.select(0);
					cmake.resetNamesAndValues(getMakeArray());
					//System.out.println("Test: "+event.getProperty());
				}
			}});
		//makecombo=new Combo(getFieldEditorParent(), 0);
		//makecombo.set
		//makecombo.select(0);
		

		//IPropertyChangeListener tarchlistener = ;
		//tarch.setPropertyChangeListener();

		addField(tarch);
		addField(cmake);//MAKE_COMB	
		addField(new FileFieldEditor(TAU_MAKE, "&TAU Makefile:", getFieldEditorParent()));
		addField(new StringFieldEditor(TAU_OPTS, "&TAU Options:", getFieldEditorParent()));
		addField(new BooleanFieldEditor(DEF_OUT,"&Use Alternative TAU Output Directory",getFieldEditorParent()));
		addField(new DirectoryFieldEditor(USR_OUT, "&Alternate TAU Output Directory:", getFieldEditorParent()));
		addField(new BooleanFieldEditor(PARA_BOOL,"&Automatically run ParaProf on profile output",getFieldEditorParent()));
	}

	
	private String[][] getMakeArray(){
		   IPreferenceStore pstore = TaucdtPlugin.getDefault().getPreferenceStore();
		   String apath = pstore.getString("TAUCDTArchPath");

			class makefilter implements FilenameFilter{
				public boolean accept(File dir, String name) {
					if(name.indexOf("Makefile.tau")==0){return true;}
					else{return false;}
				}
			}

			int nummakes=0;
			String[][] makes=null;
			File[] makefiles = null;
			File dir = new File(apath+File.separator+"lib");

			if(dir.exists()){
			makefiles = dir.listFiles(new makefilter());
			//System.out.println(makefiles.length);
			}
			if(makefiles==null){nummakes=0;}
			else{nummakes=makefiles.length;}
			if(nummakes==0){
				makes=new String[][]{{"Specify Makefile Manually (None found in arch)","Manual Spec"}};
			}
			else{
				makes=new String[nummakes+1][2];
				makes[0][0]="Specify Makefile Manually";
				makes[0][1]="Manual Spec";
				for(int i=1;i<nummakes+1;i++){
					makes[i][0]=makefiles[i-1].getName();
					makes[i][1]=makefiles[i-1].getPath();
					//System.out.println(makefiles[i-1].getPath());
				}
			}	 
			return makes;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}
}