
#include "cperfdmf.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>



int main(int argc, char** argv) {
  int i;
  int selection;
  int ce;

  if (argc < 4) {
    fprintf (stderr, "Usage: %s <directory> <experiment name> <trial name>\n",argv[0]);
    return -1;
  }

  char perfdmfcfg[2048];
  sprintf (perfdmfcfg,"%s/.ParaProf/perfdmf.cfg",getenv("HOME"));

  if (CPERFDMF_OK != (ce = cperfdmf_initialize(perfdmfcfg))) {
    fprintf (stderr, "initialization failed: %s\n",cperfdmf_errToString(ce));
    if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
      fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
    }
    return -1;
  }


  if (CPERFDMF_OK != (ce = cperfdmf_connectDB(NULL))) {
    fprintf (stderr, "db initialization failed: %s\n",cperfdmf_errToString(ce));
    if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
      fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
    }
    return -1;
  }


  int appToUse = -1;

  cperfdmf_application_t *apps = NULL;
  int numApps;
  if (CPERFDMF_OK != (ce = cperfdmf_getApplications(&apps, &numApps))) {
    fprintf (stderr, "getApplications failed: %s\n",cperfdmf_errToString(ce));
    if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
      fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
    }
    return -1;
  }

  fprintf (stderr, "Looking for Upload application\n");
  for (i=0; i<numApps; i++) {
    if (!strcmp(apps[i].name,"Upload")) {
      appToUse = apps[i].appId;
    }
  }

  if (appToUse == -1) {
    // make a new one
    cperfdmf_application_t newApp;
    newApp.name = "Upload";
    newApp.appId = -1; // -1 indicates this is new, it will be overwritten when we call save!
    newApp.numFields = 0;

    fprintf (stderr, "Creating application\n");
    if (CPERFDMF_OK != (ce = cperfdmf_saveApplication(&newApp))) {
      fprintf (stderr, "saveApplication failed: %s\n",cperfdmf_errToString(ce));
      if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
	fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
      }
      return -1;
    }

    appToUse = newApp.appId;
  }


  fprintf (stderr, "Looking for experiment\n");

  cperfdmf_experiment_t *exps = NULL;
  int numExps;
  int expToUse = -1;

  if (CPERFDMF_OK != (ce = cperfdmf_getExperiments(&exps, &numExps, appToUse))) {
    fprintf (stderr, "getExperiments failed: %s\n",cperfdmf_errToString(ce));
    if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
      fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
    }
    return -1;
  }

  for (i=0; i<numExps; i++) {
    if (!strcmp(exps[i].name,argv[3])) {
      expToUse = exps[i].expId;
    }
  }

  if (expToUse == -1) {
    fprintf (stderr, "Creating new experiment\n");
    // make a new one
    cperfdmf_experiment_t newExp;
    
    newExp.appId = appToUse;
    newExp.numFields = 0;
    
    newExp.expId = -1; // -1 indicates this is new, it will be overwritten when we call save!
    
    newExp.name = argv[3];
    
    fprintf (stderr, "Saving experiment\n");
    if (CPERFDMF_OK != (ce = cperfdmf_saveExperiment(&newExp))) {
      fprintf (stderr, "saveExperiment failed: %s\n",cperfdmf_errToString(ce));
      if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
	fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
      }
      return -1;
    }
    expToUse = newExp.expId;
  }


  fprintf (stderr, "Loading trial!\n");
  
  int trialId;
  if (CPERFDMF_OK != (ce = cperfdmf_uploadTauOutput(&trialId, argv[1], expToUse))) {
    fprintf (stderr, "upload failed: %s\n",cperfdmf_errToString(ce));
    if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
      fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
    }
    return -1;
  }
  

  cperfdmf_trial_t newTrial;

  newTrial.appId = appToUse;
  newTrial.expId = expToUse;
  newTrial.trialId = trialId;
  newTrial.name = argv[2];
  newTrial.numFields = 0;

  if (CPERFDMF_OK != (ce = cperfdmf_saveTrial(&newTrial))) {
    fprintf (stderr, "saveTrial failed: %s\n",cperfdmf_errToString(ce));
    if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
      fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
    }
    return -1;
  }


  printf ("loaded ok\n");
  return 0;
}
