

import edu.uoregon.tau.dms.dss.*;
import java.util.*;
import java.io.*;


class FileFilter implements FilenameFilter {
    public FileFilter(String regex) {
	this.regex = regex;
    }
    public boolean accept(File okplace, String patternmatch ) {
	//System.out.println("regex = " + regex + ", file = " + patternmatch); 
	if (patternmatch.matches(regex)) {
	    return true;
	} 

	//	if (patternmatch.indexOf(prefix) == 0) {
	//    return true;
	//} 
	return false;
    }
    private String regex;
}


public class Cperfdmf {
    
    DatabaseAPI dbAPI;
    DataSource dataSource;
    
    //int currentApplication = -1;
    //int currentExperiment = -1;
    //int currentTrial = -1;
    
    //Metric currentMetric;


    String exceptionBackTrace;

    final int CPDMF_OK           =  0;
    final int CPDMF_ERR          = -1;
    final int CPDMF_NON_EXISTENT = -2;
    final int CPDMF_ERR_NO_PROFILES  = -3;
    final int CPDMF_ERR_MEMORY = -4;
    final int CPDMF_ERR_BAD_PARSE = -5;
    final int CPDMF_ERR_INTERNAL_ERROR = -6;
    final int CPDMF_ERR_DB_NOT_INITIALIZED = -7;
    final int CPDMF_ERR_SESSION_NOT_INITIALIZED = -8;
    final int CPDMF_ERR_JAVA_EXCEPTION = -9;


    //int currentMetric = -1;

    //    private String encode(String str);
    // Put additional private data here...
    // DO-NOT-DELETE splicer.end(cperfdmf.dmf._data)
    
    public void finalize() {
    
    }

    public int connectDB (
			     /*in*/ java.lang.String configFile,
			     /*in*/ java.lang.String password ) {
	
	dbAPI = new DatabaseAPI();
	
	try {

	    if (password == null) {
		dbAPI.initialize(configFile,false);
	    } else {
		dbAPI.initialize(configFile,password);
	    }

	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
	
	return CPDMF_OK;
    }

    /**
     * Method:  initializeTauOutput[]
     */
    public int initializeTauOutput (
				    /*in*/ java.lang.String path ) 
    {

	try {
	    
	    File[] files = new File[1];
	    files[0] = new File(path);

	    dataSource = UtilFncs.initializeDataSource(files, 0, false);
	  
	  
	    dataSource.load();
	  
	  
	    return CPDMF_OK;
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }
    
    /**
     * Method:  uploadTauOutput[]
     */
    public int uploadTauOutput (
				/*out*/ IntegerHolder newTrialId,
				/*in*/ java.lang.String path,
				/*in*/ int expId ) {
	try {
	    
	    if (dbAPI == null) // let's be a bit more helpful than just a null pointer exception
		return CPDMF_ERR_DB_NOT_INITIALIZED;
	    

	    File[] files = new File[1];
	    files[0] = new File(path);

	    dataSource = UtilFncs.initializeDataSource(files, 0, false);
	    dataSource.load();
	  
  
	    Trial trial = new Trial();
	    trial.setDataSource(dataSource);
	    trial.setExperimentID(expId);

	    int newId = dbAPI.saveTrial(trial, -1);

	    trial.setID(newId);
	  
	    newTrialId.set(newId);
	  
	    return CPDMF_OK;
	  
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
     
    }
    
    /**
     * Method:  getApplications[]
     */
    public int getApplications (/*out*/ StringHolder applications ) {
	try {
	    String appstr = "";
	    
	    if (dbAPI == null) // let's be a bit more helpful than "exception"
		return CPDMF_ERR_DB_NOT_INITIALIZED;
	    
	    Iterator apps = dbAPI.getApplicationList().iterator();
      
	    while (apps.hasNext()) {
		Application app = (Application) apps.next();
		appstr = appstr + app.getID() + ';';
	    }

	    applications.set(appstr);
	    return CPDMF_OK;
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }

    /**
     * Method:  getApplicationMetaData[]
     */
    public int getApplicationMetaData (/*out*/ StringHolder metadata ) {
	try {
	    String metadataStr = "";
	    

	    Application app = new Application();

	    String[] fieldNames = app.getFieldNames();

	    for (int i=0; i < fieldNames.length; i++) {
		metadataStr = metadataStr + encode(fieldNames[i]) + ';';
	    }

	    metadata.set(metadataStr);
	    return CPDMF_OK;
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }

    /**
     * Method:  getApplicationDetail[]
     */
    public int getApplicationDetail (
				     /*out*/ StringHolder detail,
				     /*in*/ int applicationId ) {
	try {
	    if (dbAPI == null)
		return CPDMF_ERR_DB_NOT_INITIALIZED;
	    
	    Application app = null;
	    
	    for (Iterator it = dbAPI.getApplicationList().iterator(); it.hasNext(); ) {
		Application itApp = (Application) it.next();
		if (itApp.getID() == applicationId) {
		    app = itApp;
		}
	    }

	    if (app == null) {
		// no such application
		throw new Exception("No such application: " + applicationId);
	    }

	    String detailStr = encode(app.getName()) + ";" + 
		app.getID() + ";";


	    for (int i = 0; i < app.getNumFields(); i++) {
		detailStr = detailStr + encode(app.getField(i)) + ";";
	    }

	    
	    detail.set(detailStr);
	    return CPDMF_OK;
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }


    /**
     * Method:  setApplicationDetail[]
     */
    public int setApplicationDetail (
				     /*in*/ String detail,
				     /*out*/ IntegerHolder appId ) {
	try {
	    //System.out.println ("Java: asked to set " + detail);
	    
	    if (dbAPI == null) // let's be a bit more helpful than "exception"
		return CPDMF_ERR_DB_NOT_INITIALIZED;
	    
	    int pos = 0, end;
	    Application app = new Application();

	    end = getNextStringPosition(detail, pos);
	    app.setName(decode(detail.substring(pos, end))); pos = end+1;

	    end = getNextStringPosition(detail, pos);
	    app.setID(Integer.parseInt(decode(detail.substring(pos, end)))); pos = end+1;
    


	    for (int i = 0; i < app.getNumFields(); i++) {
		end = getNextStringPosition(detail, pos);
		if (pos < detail.length())
		    app.setField(i, decode(detail.substring(pos,end))); pos = end+1;
	    }

	    appId.set(dbAPI.saveApplication(app));
	} 

	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}

	return CPDMF_OK;
    }

    /**
     * Method:  deleteApplication[]
     */
    public int deleteApplication (
				  /*in*/ int appId ) {
	try {
	    if (dbAPI == null) // let's be a bit more helpful than "exception"
		return CPDMF_ERR_DB_NOT_INITIALIZED;
	    
	    dbAPI.deleteApplication(appId);
	}

	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}

	return CPDMF_OK;
    }

    /**
     * Method:  getExperiments[]
     */
    public int getExperiments (
			       /*out*/ StringHolder experiments,
			       /*in*/ int applicationId ) {
	try {
	    if (dbAPI == null)
		return CPDMF_ERR_DB_NOT_INITIALIZED;
	    
	    dbAPI.setApplication(applicationId);
	    
	    Iterator exps = dbAPI.getExperimentList().iterator();
	    
	    String experimentList = "";
	    
	    while (exps.hasNext()) {
		Experiment exp = (Experiment) exps.next();
		experimentList = experimentList + exp.getID() + ';';
	    }

	    experiments.set(experimentList);
	    return CPDMF_OK;
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }


    /**
     * Method:  getExperimentMetaData[]
     */
    public int getExperimentMetaData (/*out*/ StringHolder metadata ) {
	try {
	    String metadataStr = "";

	    Experiment exp = new Experiment();
	    int numFields = exp.getNumFields();

	    for (int i=0; i < numFields; i++) {
		metadataStr = metadataStr + encode(exp.getFieldName(i)) + ';';
	    }

	    metadata.set(metadataStr);

	    return CPDMF_OK;
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }

    /**
     * Method:  getExperimentDetail[]
     */
    public int getExperimentDetail (
				    /*out*/ StringHolder detail,
				    /*in*/ int experimentId ) {
	try {
	    if (dbAPI == null)
		return CPDMF_ERR_DB_NOT_INITIALIZED;
	    
	    dbAPI.setExperiment(experimentId);

	    Experiment exp = null;

	    for (Iterator it = dbAPI.getExperimentList().iterator(); it.hasNext(); ) {
		Experiment itExp = (Experiment) it.next();
		if (itExp.getID() == experimentId) {
		    exp = itExp;
		}
	    }

	    if (exp == null) {
		// no such application
		throw new Exception("No such experiment: " + experimentId);
	    }

      

	    String detailStr = "";
	    detailStr = detailStr + exp.getApplicationID() + ";";
	    detailStr = detailStr + exp.getID() + ";";
	    detailStr = detailStr + exp.getName() + ";";


	    for (int i = 0; i < exp.getNumFields(); i++) {
		detailStr = detailStr + encode(exp.getField(i)) + ";";
	    }
	    
	    detail.set(detailStr);

	    return CPDMF_OK;
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }
    
    /**
     * Method:  setExperimentDetail[]
     */
    public int setExperimentDetail (
				    /*in*/ java.lang.String detail,
				    /*out*/ IntegerHolder expId ) {
	try {
	    //System.out.println ("Java: asked to set " + detail);
	    
	    int pos = 0, end;
	    Experiment exp = new Experiment();

	    end = getNextStringPosition(detail, pos);
	    exp.setApplicationID(Integer.parseInt(decode(detail.substring(pos, end)))); pos = end+1;


	    end = getNextStringPosition(detail, pos);
	    exp.setID(Integer.parseInt(decode(detail.substring(pos, end)))); pos = end+1;

	    end = getNextStringPosition(detail, pos);
	    exp.setName(decode(detail.substring(pos, end))); pos = end+1;

	    for (int i = 0; i < exp.getNumFields(); i++) {
		end = getNextStringPosition(detail, pos);
		if (pos < detail.length()) {
		    exp.setField(i, decode(detail.substring(pos,end))); pos = end+1;
		}
	    }


	    expId.set(dbAPI.saveExperiment(exp));

	} 

	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}

	return CPDMF_OK;
    }

    /**
     * Method:  deleteExperiment[]
     */
    public int deleteExperiment(
				/*in*/ int expId ) {
	try {
	    if (dbAPI == null) // let's be a bit more helpful than "exception"
		return CPDMF_ERR_DB_NOT_INITIALIZED;
	    
	    dbAPI.deleteExperiment(expId);
	}

	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}

	return CPDMF_OK;
    }
    
    /**
     * Method:  getTrials[]
     */
    public int getTrials(
			 /*out*/ StringHolder trials,
			 /*in*/ int experimentId ) {
	try {
	    if (dbAPI == null)
		return CPDMF_ERR_DB_NOT_INITIALIZED;
      
	    dbAPI.setExperiment(experimentId);
      
	    Iterator trialIter = dbAPI.getTrialList().iterator();
	    Trial trial = null;
      
      
	    String trialList = "";
      
	    while (trialIter.hasNext()) {
		trial = (Trial) trialIter.next();
		trialList = trialList + trial.getID() + ';';
	    }
      
	    trials.set(trialList);
	    return CPDMF_OK;
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }

    /**
     * Method:  getTrialMetaData[]
     */
    public int getTrialMetaData (/*out*/ StringHolder metadata ) {
	try {

	    // what a joke

	    Iterator trialIter = dbAPI.getTrialList().iterator();
	    Trial trial = null;
      
	    int numFields = 0;
	    while (trialIter.hasNext()) {
		trial = (Trial) trialIter.next();
		numFields = trial.getNumFields();
	    }


	    String metadataStr = "";

	    for (int i=0; i < numFields; i++) {
		metadataStr = metadataStr + encode(trial.getFieldName(i)) + ';';
	    }

	    metadata.set(metadataStr);
	    return CPDMF_OK;
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }

    /**
     * Method:  getTrialDetail[]
     */
    public int getTrialDetail(
			      /*out*/ StringHolder detail,
			      /*in*/ int trialId ) {
	try {
	    if (dbAPI == null)
		return CPDMF_ERR_DB_NOT_INITIALIZED;
	    
	    dbAPI.setTrial(trialId);

	    Trial trial = null;

	    for (Iterator it = dbAPI.getTrialList().iterator(); it.hasNext(); ) {
		Trial itTrial = (Trial) it.next();
		if (itTrial.getID() == trialId) {
		    trial = itTrial;
		}
	    }

	    if (trial == null) {
		// no such application
		throw new Exception("No such trial: " + trialId);
	    }



	    String detailStr = "";
	    detailStr = detailStr + trial.getApplicationID() + ";";
	    detailStr = detailStr + trial.getExperimentID() + ";";
	    detailStr = detailStr + trial.getID() + ";";
	    detailStr = detailStr + trial.getName() + ";";

	    for (int i = 0; i < trial.getNumFields(); i++) {
		detailStr = detailStr + encode(trial.getField(i)) + ";";
	    }
	    
	    detail.set(detailStr);
	    //System.out.println(trial.getName() + " returning " + detailStr);

	    return CPDMF_OK;
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }
    
    /**
     * Method:  setTrialDetail[]
     */
    public int setTrialDetail (
			       /*in*/ String detail,
			       /*out*/ IntegerHolder trialId ) {
	try {
	    //System.out.println ("Java: asked to set " + detail);
	    
	    int pos = 0, end;
	    Trial trial = new Trial();
	    
	    end = getNextStringPosition(detail, pos);
	    trial.setApplicationID(Integer.parseInt(decode(detail.substring(pos, end)))); pos = end+1;
	 
	    end = getNextStringPosition(detail, pos);
	    trial.setExperimentID(Integer.parseInt(decode(detail.substring(pos, end)))); pos = end+1;

	    end = getNextStringPosition(detail, pos);
	    trial.setID(Integer.parseInt(decode(detail.substring(pos, end)))); pos = end+1;

	    end = getNextStringPosition(detail, pos);
	    trial.setName(decode(detail.substring(pos, end))); pos = end+1;

	    for (int i = 0; i < trial.getNumFields(); i++) {
		end = getNextStringPosition(detail, pos);
		if (pos < detail.length()) {
		    trial.setField(i, decode(detail.substring(pos,end))); pos = end+1;
		}
	    }

	    trialId.set(dbAPI.saveTrial(trial));

	} 

	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}

	return CPDMF_OK;
    }

    /**
     * Method:  deleteTrial[]
     */
    public int deleteTrial(
			    /*in*/ int trialId ) {
	try {
	    if (dbAPI == null) // let's be a bit more helpful than "exception"
		return CPDMF_ERR_DB_NOT_INITIALIZED;
	    
	    dbAPI.deleteTrial(trialId);
	}

	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}

	return CPDMF_OK;
    }

    /**
     * Method:  selectTrial[]
     */
    public int selectTrial(
			   /*in*/ int trialId ) {
	try {


	    if (dbAPI == null)
		return CPDMF_ERR_DB_NOT_INITIALIZED;
	    
	    dbAPI.setTrial(trialId);
	    
	    
	    dataSource = new DBDataSource(dbAPI);
	    
	    dataSource.load();
	    	   
	    return CPDMF_OK;
	 
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }
    
    /**
     * Method:  getMetrics[]
     */
    public int getMetrics(
			  /*out*/ StringHolder metrics ) {
	try {
	    if (dataSource == null)
		return CPDMF_ERR_SESSION_NOT_INITIALIZED;
	  
	    int numMetrics = dataSource.getNumberOfMetrics();


	    String metricList = "";
	  
	    for (int i=0; i<numMetrics; i++) {
		metricList = metricList + encode(dataSource.getMetricName(i)) + ';';
	    }
	    metrics.set(metricList);

	    return CPDMF_OK;
	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
      
    }

    /**
     * Method:  getFunctions[]
     */
    public int getFunctions(
			    /*out*/ StringHolder functions ) {
	// DO-NOT-DELETE splicer.begin(cperfdmf.dmf.getFunctions)
	
	try {
	    
	    if (dataSource == null)
		return CPDMF_ERR_SESSION_NOT_INITIALIZED;


	    Vector functionVector = new Vector();
	    for (Iterator it = dataSource.getFunctions(); it.hasNext(); ) {
		Function function = (Function) it.next();
		functionVector.add(function);
	    }

	    Collections.sort(functionVector, new Comparator() {
		    public int compare(Object a, Object b) {
			Function fa = (Function)a;
			Function fb = (Function)b;
			return fa.getID() - fb.getID();
		    }

		});
	    
	    String functionList = "";
	    for (Iterator it = functionVector.iterator(); it.hasNext(); ) {
		Function function = (Function) it.next();
		functionList = functionList + encode(function.getName()) + ";";
	    }
	    functions.set(functionList);
	    return CPDMF_OK;

	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
	
    }

    /**
     * Method:  getNumNodes[]
     */
    public int getNumNodes(
			   /*out*/ IntegerHolder numNodes) {
	try {
	    if (dataSource == null)
		return CPDMF_ERR_SESSION_NOT_INITIALIZED;

	    numNodes.set(dataSource.getNumberOfNodes());
	    return CPDMF_OK;
	} 
	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }

    /**
     * Method:  getNumContexts[]
     */
    public int getNumContext(/*out*/ IntegerHolder numContexts,
			     /*in*/ int node ) {
	try {
	    if (dataSource == null)
		return CPDMF_ERR_SESSION_NOT_INITIALIZED;

	    numContexts.set(dataSource.getNumberOfContexts(node));
	    return CPDMF_OK;
	}
	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }

    /**
     * Method:  getNumThreads[]
     */
    public int getNumThreads(/*out*/ IntegerHolder numThreads,
			     /*in*/ int node,
			     /*in*/ int context) {
	try {
	    if (dataSource == null)
		return CPDMF_ERR_SESSION_NOT_INITIALIZED;

	    numThreads.set(dataSource.getNumberOfThreads(node, context));
	    return CPDMF_OK;
	} 
	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }

    /**
     * Method:  getProfileValues[]
     */
    public int getProfileValues(/*out*/ StringHolder profile,
				/*in*/ int functionId,
				/*in*/ int metric,
				/*in*/ int nodeID,
				/*in*/ int contextID,
				/*in*/ int threadID) {
	try {

	    String profileStr = "";
		
	    if (dataSource == null)
		return CPDMF_ERR_SESSION_NOT_INITIALIZED;
	    
	    edu.uoregon.tau.dms.dss.Thread thread;


	    if (nodeID == -1) {
		thread = dataSource.getMeanData();
	    } else if (nodeID == -2) {
		thread = dataSource.getTotalData();
	    } else {
		thread = dataSource.getThread(nodeID, contextID, threadID);
	    }

	    List functionProfiles = thread.getFunctionProfiles();

	    FunctionProfile fp = null;
	    if (functionProfiles != null && functionId < functionProfiles.size()) {
		fp = (FunctionProfile) functionProfiles.get(functionId);
	    }

	    // null would mean that this N:C:T did not call this function
	    if (fp == null) {
		profile = null;
		return CPDMF_OK;
	    }


	    profileStr = profileStr + fp.getExclusive(metric) + ";";
	    profileStr = profileStr + fp.getInclusive(metric) + ";";
	    profileStr = profileStr + fp.getExclusivePercent(metric) + ";";
	    profileStr = profileStr + fp.getInclusivePercent(metric) + ";";
	    profileStr = profileStr + fp.getInclusivePerCall(metric) + ";";
	    profileStr = profileStr + fp.getNumCalls() + ";";
	    profileStr = profileStr + fp.getNumSubr() + ";";

	    // throw the groups on using a different delimeter (since this is an array inside of an array)
	    List groups = fp.getFunction().getGroups();
	    if (groups != null) {
		for (int g=0; g<groups.size(); g++) {
		    profileStr = profileStr + (((Group)groups.get(g)).getID()-1) + "@";
		}
	    }
	    profileStr = profileStr + ";";
	    profile.set(profileStr);
	    return CPDMF_OK;
	}
	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}

	// DO-NOT-DELETE splicer.end(cperfdmf.dmf.getProfileValues)
  }

    /**
     * Method:  getUserEvents[]
     */
    public int getUserEvents(/*out*/ StringHolder userEvents,
			     /*in*/ int nodeID,
			     /*in*/ int contextID,
			     /*in*/ int threadID) {
	try {
	    if (dataSource == null)
		return CPDMF_ERR_SESSION_NOT_INITIALIZED;
	    
	  
	    edu.uoregon.tau.dms.dss.Thread thread = dataSource.getThread(nodeID, contextID, threadID);
	  
	    if (thread == null) {
		userEvents.set("0;");
		return CPDMF_OK;
	    }

	    Iterator l;
	  
	    int count = 0;
	  
	    l = thread.getUserEventProfiles().iterator();
	  
	    while (l.hasNext()) {
		UserEventProfile uep = (UserEventProfile) l.next();
		if (uep!=null) {
		    count++;
		}
	    }

	    //System.out.println ("found " + count + " events");
	  
	    String userEventList = count + ";";
	    l = thread.getUserEventProfiles().iterator();
	  
	    while (l.hasNext()) {
		UserEventProfile uep = (UserEventProfile) l.next();
		if (uep!=null) {
		    //System.out.println ("getMappingName() = " + gtde.getMappingName());
		    userEventList = userEventList + encode(uep.getUserEvent().getName()) + ";";
		    userEventList = userEventList + uep.getUserEventNumberValue() + ";";
		    userEventList = userEventList + uep.getUserEventMinValue() + ";";
		    userEventList = userEventList + uep.getUserEventMaxValue() + ";";
		    userEventList = userEventList + uep.getUserEventMeanValue() + ";";
		    userEventList = userEventList + uep.getUserEventSumSquared() + ";";
		}
	    }
	  
	    userEvents.set(userEventList);
	    return CPDMF_OK;
	}
	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
	
	// DO-NOT-DELETE splicer.end(cperfdmf.dmf.getUserEvents)
    }
    
    /**
     * Method:  getGroups[]
     */
    public int getGroups(/*out*/ StringHolder groups ) {
	try {

	    if (dataSource == null)
		return CPDMF_ERR_SESSION_NOT_INITIALIZED;
	  
	    String groupList = "";
	    for (Iterator it = dataSource.getGroups(); it.hasNext(); ) {
		Group group = (Group) it.next();
		groupList = groupList + encode(group.getName()) + ";";
	    }

	    //System.out.println ("groupList = " + groupList);

	    groups.set(groupList);

	} catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}

	return CPDMF_OK;
    }

    /**
     * Method:  queryNodeExists[]
     */
    public int queryNodeExists(/*out*/ IntegerHolder exists,
			       /*in*/ int node ) {
	try {
	    if (dataSource == null)
		return CPDMF_ERR_SESSION_NOT_INITIALIZED;
	    
	    
	    edu.uoregon.tau.dms.dss.Node nde = dataSource.getNode(node);
	    
	    if (nde != null) {
		exists.set(1);
	    } else {
		exists.set(0);
	    }
	    
	    return CPDMF_OK;
	}
	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }
    
    /**
     * Method:  queryContextExists[]
     */
    public int queryContextExists(/*out*/ IntegerHolder exists,
				  /*in*/ int node,
				  /*in*/ int context) {
	try {
	    if (dataSource == null)
		return CPDMF_ERR_SESSION_NOT_INITIALIZED;
	    
	    edu.uoregon.tau.dms.dss.Context cntxt = dataSource.getContext(node, context);
	    
	    if (cntxt != null) {
		exists.set(1);
	    } else {
		exists.set(0);
	    }
	    
	    return CPDMF_OK;
	}
	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }
    
    /**
     * Method:  queryThreadExists[]
     */
    public int queryThreadExists(/*out*/ IntegerHolder exists,
				 /*in*/ int node,
				 /*in*/ int context,
				 /*in*/ int thread) {
	try {
	    if (dataSource == null)
		return CPDMF_ERR_SESSION_NOT_INITIALIZED;
	    
	    edu.uoregon.tau.dms.dss.Thread thrd = dataSource.getThread(node, context, thread);
	    
	    if (thrd != null) {
		exists.set(1);
	    } else {
		exists.set(0);
	    }
	    
	    return CPDMF_OK;
	}
	catch (Exception e) {
	    setBackTraceMessage(e);
	    return CPDMF_ERR_JAVA_EXCEPTION;
	}
    }

    /**
     * Method:  getExceptionMessage[]
     */

    public java.lang.String getExceptionMessage () {
	return exceptionBackTrace;
    }
    
    
    

    private Vector helperFindFiles (String path, String prefix) {
	Vector v = new Vector();
	
	File file = new File(path);
	if (file.isDirectory() == false) {
	    return v;
	}
	FilenameFilter prefixFilter = new FileFilter(prefix);
	File files[] = file.listFiles(prefixFilter);
	
	if (files.length == 0) {
	    // we didn't find any profile files here, now look for MULTI_ directories
	    FilenameFilter multiFilter = new FileFilter("MULTI__.*");
	    File multiDirs[] = file.listFiles(multiFilter);
	    
	    for (int i=0; i<multiDirs.length; i++) {
		File finalFiles[] = multiDirs[i].listFiles(prefixFilter);
		v.add(finalFiles);
	    }
	} else {
	    v.add(files);
	    return v;
	}
	return v;
    }

    private void setBackTraceMessage(Exception e) {
	StringWriter sw = new StringWriter();
	PrintWriter pw = new PrintWriter(sw);
	e.printStackTrace(pw);
	pw.close();
	this.exceptionBackTrace = sw.toString();
	//e.printStackTrace();
    }



    private int getNextStringPosition(String str, int pos) {
	boolean done = false;
	while (pos < str.length()) {
	    if (str.charAt(pos) == ';')
		return pos;

	    if (str.charAt(pos) == '\\')
		pos++;

	    pos++;
	}
	return pos;
    }

    private String encode(String str) {
	if (str == null) return "";
	str = str.replaceAll("\\\\", "\\\\\\\\");
	str = str.replaceAll(";","\\\\;");
	return str;
    }

    private String decode(String str) {
	if (str == null) return "";
	str = str.replaceAll("\\\\;",";");
	str = str.replaceAll("\\\\\\\\","\\\\");
	return str;
    }

}
