
#include "cperfdmf.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>


void dumpTrialData(char *trialName) {
  int selection;
  char **metrics;
  int numMetrics;
  int metric;
  int function;
  int ec;
  int i;

  if (CPERFDMF_OK != (ec = cperfdmf_getMetrics(&metrics, &numMetrics))) {
    fprintf (stderr, "%s(%d): Error %s\n", __FILE__, __LINE__, cperfdmf_errToString(ec));
    return;
  }

  char **groups;
  int numGroups;
  if (CPERFDMF_OK != (ec = cperfdmf_getGroups(&groups, &numGroups))) {
    fprintf (stderr, "%s(%d): Error %s\n", __FILE__, __LINE__, cperfdmf_errToString(ec));
    return;
  }

  char **functions;
  int numFunctions;
  if (CPERFDMF_OK != (ec = cperfdmf_getFunctions(&functions, &numFunctions))) {
    fprintf (stderr, "%s(%d): Error %s\n", __FILE__, __LINE__, cperfdmf_errToString(ec));
    return;
  }


  
  char metricStr[1024];
  for (metric=0; metric<numMetrics; metric++) {
    
    if (numMetrics > 1) {
      sprintf (metricStr, "MULTI__%s", metrics[metric]);
      // Make MULTI__ directory
      
      for (i=0;i<strlen(metricStr);i++) {
	if (!isalnum(metricStr[i])) {
	  metricStr[i] = '_';
	}
      }
    } else {
      metricStr[0] = 0;
    }
   
    
    int numNodes;
    if (CPERFDMF_OK != (ec = cperfdmf_getNumNodes(&numNodes))) {
      fprintf (stderr, "%s(%d): Error %s\n", __FILE__, __LINE__, cperfdmf_errToString(ec));
    }
    
    int n,c,t;
    int nodesFound;
    int exists;

    nodesFound = 0;
    for (n=0; nodesFound<numNodes; n++) {
      

      if (CPERFDMF_OK != (ec = cperfdmf_queryNodeExists(&exists, n))) {
	fprintf (stderr, "Uh oh: %s\n",cperfdmf_errToString(ec));
      }

      if (!exists) {
	  char dirname[512];
	  sprintf (dirname, "./%s/%s", trialName, metricStr);

	  char filename[512];
	  sprintf (filename, "mkdir -p \"%s\"", dirname);
	  system (filename);

	  char echoCmd[512];
	  sprintf (echoCmd, "echo \"%s/%s\" > \"%s/location\"", trialName, metricStr, dirname);
	  system (echoCmd);

	  sprintf (filename, "./%s/%s/profile.%d.%d.%d", trialName, metricStr, n, 0, 0);

	continue;
      }

      nodesFound++;
      
      int numContexts;
      if (CPERFDMF_OK != (ec = cperfdmf_getNumContexts(&numContexts, n))) {
	fprintf (stderr, "%s(%d): Error %s\n", __FILE__, __LINE__, cperfdmf_errToString(ec));
      }

      int contextsFound = 0;
      
      for (c=0; contextsFound<numContexts; c++) {
	
	if (CPERFDMF_OK != (ec = cperfdmf_queryContextExists(&exists, n, c))) {
	  fprintf (stderr, "%s(%d): Error %s\n", __FILE__, __LINE__, cperfdmf_errToString(ec));
	}
	
	if (!exists) {
	  char dirname[512];
	  sprintf (dirname, "./%s/%s", trialName, metricStr);

	  char filename[512];
	  sprintf (filename, "mkdir -p \"%s\"", dirname);
	  system (filename);

	  char echoCmd[512];
	  sprintf (echoCmd, "echo \"%s/%s\" > \"%s/location\"", trialName, metricStr, dirname);
	  system (echoCmd);

	  sprintf (filename, "./%s/%s/profile.%d.%d.%d", trialName, metricStr, n, c, 0);

	  continue;
	}
	
	contextsFound++;
	  
	int numThreads;
	if (CPERFDMF_OK != (ec = cperfdmf_getNumThreads(&numThreads, n, c))) {
	  fprintf (stderr, "%s(%d): Error %s\n", __FILE__, __LINE__, cperfdmf_errToString(ec));
	}
	
	int threadsFound=0;
	for (t=0; threadsFound<numThreads; t++) {
	  if (CPERFDMF_OK != (ec = cperfdmf_queryThreadExists(&exists, n, c, t))) {
	    fprintf (stderr, "%s(%d): Error %s\n", __FILE__, __LINE__, cperfdmf_errToString(ec));
	  }

	  if (!exists) {
	  
	    char dirname[512];
	    sprintf (dirname, "./%s/%s", trialName, metricStr);
	    
	    char filename[512];
	    sprintf (filename, "mkdir -p \"%s\"", dirname);
	    system (filename);
	    
	    char echoCmd[512];
	    sprintf (echoCmd, "echo \"%s/%s\" > \"%s/location\"", trialName, metricStr, dirname);
	    system (echoCmd);
	    
	    sprintf (filename, "./%s/%s/profile.%d.%d.%d", trialName, metricStr, n, c, t);

	    FILE *f = fopen(filename,"wb");
	    if (numMetrics > 1) {
	      fprintf (f, "%d templated_functions_MULTI_%s\n", numFunctions, metrics[metric]);
	    } else {
	      //fprintf (f, "metric = %s\n",metrics[metric]);
	      if (!strcmp("Time", metrics[metric])) {
		fprintf (f, "%d templated_functions\n", 0);
	      } else {
		fprintf (f, "%d templated_functions_hw_counters\n", 0);
	      }
	    }
	    fprintf (f, "# Name Calls Subrs Excl Incl ProfileCalls\n");
	    fprintf (f, "0 aggregates\n");

	    fclose(f);

	    continue;
	  }

	  threadsFound++;
	  

	  cperfdmf_profile_t prof;
	  
	  char dirname[512];
	  sprintf (dirname, "./%s/%s", trialName, metricStr);

	  char mkdirString[512];
	  sprintf (mkdirString, "mkdir -p \"%s\"", dirname);
	  system (mkdirString);

	  char echoCmd[512];
	  sprintf (echoCmd, "echo \"%s/%s\" > \"%s/location\"", trialName, metricStr, dirname);
	  system (echoCmd);


	  char filename[512];
	  sprintf (filename, "./%s/%s/profile.%d.%d.%d", trialName, metricStr, n, c, t);
	 

	  printf ("opening %s\n", filename);
	  FILE *f = fopen(filename, "wb");
	  if (f == NULL) {
	    printf ("couldn't open '%s' for writing!\n", filename);
	    exit(-1);
	  }
	  
	  if (numMetrics > 1) {
	    fprintf (f, "%d templated_functions_MULTI_%s\n", numFunctions, metrics[metric]);
	  } else {
	    //fprintf (f, "metric = %s\n",metrics[metric]);
	    fprintf (stderr,"metric = %s\n",metrics[metric]);
	    if (!strcmp("Time", metrics[metric])) {
	      fprintf (f, "%d templated_functions\n", numFunctions);
	    } else {
	      fprintf (f, "%d templated_functions_hw_counters\n", numFunctions);
	    }
	  }

	  fprintf (f, "# Name Calls Subrs Excl Incl ProfileCalls\n");
	  for (function=0; function<numFunctions; function++) {

	    
	    if (CPERFDMF_OK == cperfdmf_getValues(&prof, function, metric, n, c, t)) {

	      if (prof.numGroups > 0) {
		fprintf (f, "\"%s\" %d %d %.16G %.16G %d GROUP=\"%s\"\n", functions[function],
			 prof.numCalls, prof.numSubroutines, prof.exclusive, prof.inclusive, 0, groups[prof.groups[0]]);

	      } else {
	      fprintf (f, "\"%s\" %d %d %.16G %.16G %d\n", functions[function],
		       prof.numCalls, prof.numSubroutines, prof.exclusive, prof.inclusive, 0);
	      }
	    } else {
	      // nct didn't call this function
	      
	      // to get the group
	      cperfdmf_profile_t mean, total;

	      cperfdmf_getMeanValues(&mean, function, metric);

	      if (mean.numGroups > 0) {
		fprintf (f, "\"%s\" 0 0 0 0 0 GROUP=\"%s\"\n", functions[function], groups[mean.groups[0]]);
	      } else {
		fprintf (f, "\"%s\" 0 0 0 0 0\n", functions[function]);
	      }
	    }
	    
	  }


	  fprintf (f, "0 aggregates\n");

	  cperfdmf_userEvent_t *userEvents;
	  int numUserEvents;
	  int ce;
	  //int ce = cperfdmf_getUserEvents(&userEvents, &numUserEvents, n, c, t);
	  
	  if (CPERFDMF_OK != (ce = cperfdmf_getUserEvents(&userEvents, &numUserEvents, n, c, t))) {
	    fprintf (stderr, "cperfdmf_getUserEvents failed: %s\n",cperfdmf_errToString(ce));
	    if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
	      fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
	    }
	    return;
	  }
	  
	  int u;
	  if (ce == CPERFDMF_OK && numUserEvents > 0) {
	    fprintf (f, "%d userevents\n", numUserEvents);
	    fprintf (f, "# eventname numevents max min mean sumsqr\n");
	    
	    for (u = 0; u < numUserEvents; u++) {
	      
	      fprintf (f, "\"%s\" %d %.16G %.16G %.16G %.16G\n", userEvents[u].name, userEvents[u].numSamples, userEvents[u].maxValue,
		       userEvents[u].minValue, userEvents[u].meanValue, userEvents[u].sumSquared);
	    }
	  }	    
	  fclose(f);
	}
      }
    
    }
  }
}



int main(int argc, char** argv) {
  int i;
  int ce;

  char perfdmfcfg[2048];
  sprintf (perfdmfcfg,"%s/.ParaProf/perfdmf.cfg",getenv("HOME"));

  if (CPERFDMF_OK != (ce = cperfdmf_initialize(perfdmfcfg))) {
    fprintf (stderr, "initialization failed: %s\n",cperfdmf_errToString(ce));
    if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
      fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
    }
    return -1;
  }


  if (CPERFDMF_OK != (ce = cperfdmf_connectDB(NULL))) {
    fprintf (stderr, "db initialization failed: %s\n",cperfdmf_errToString(ce));
    if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
      fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
    }
    return -1;
  }

  
  cperfdmf_application_t *apps;
  int numApps;
  if (CPERFDMF_OK != (ce = cperfdmf_getApplications(&apps, &numApps))) {
    fprintf (stderr, "cperfdmf_getApplications failed: %s\n",cperfdmf_errToString(ce));
    if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
      fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
    }
    return -1;
  }

  //printf ("\nApplications:\n");
  for (i=0; i<numApps; i++) {
    printf ("Application: %s\n", apps[i].name);


    cperfdmf_experiment_t *exps;
    int numExps;
    
    if (CPERFDMF_OK != (ce = cperfdmf_getExperiments(&exps, &numExps, apps[i].appId))) {
      fprintf (stderr, "cperfdmf_getExperiments failed: %s\n",cperfdmf_errToString(ce));
      if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
	fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
      }
      return -1;
    }
    
    int j;
    for (j=0; j<numExps; j++) {
      printf ("Experiment: %s\n", exps[j].name);

      cperfdmf_trial_t *trials;
      int numTrials;
      if (CPERFDMF_OK != (ce = cperfdmf_getTrials(&trials, &numTrials, exps[j].expId))) {
	fprintf (stderr, "cperfdmf_getTrials failed: %s\n",cperfdmf_errToString(ce));
	if (CPERFDMF_ERR_INTERNAL_ERROR == ce) {
	  fprintf (stderr, "extended error: %s\n",cperfdmf_getExtendedError());
	}
	return -1;
      }

      int k;
      for (k=0; k<numTrials; k++) {
	printf ("Trial: %s\n", trials[k].name);
	cperfdmf_loadTrial(trials[k].trialId);
	char path[4096];
	sprintf (path, "%s/%s/%s", apps[i].name, exps[j].name, trials[k].name);
	dumpTrialData(path);
      }
    }
  }

  return 0;
}
