#ifndef MasterMind_CCA_H
#define MasterMind_CCA_H

#include "cca.h"
#include "stdPorts.h"
#include "Monitor_CCA.h"
#include "Measurement_CCA.h"
#include "PerfParamPort.h"
#include <map>
#include "Record_CCA.h"
#include "CallPathNode.h"

namespace mm
{
  namespace ccaimpl
    {
      /**
       * The MasterMind class
       */
      class MasterMind: 
	public virtual monitor::ccaports::Monitor,
	public virtual perfparam::ccaports::PerfParam,
	public virtual classic::gov::cca::Component,
	public virtual classic::gov::cca::GoPort
	{
	public:
	  MasterMind ();
	  ~MasterMind ();
	  virtual int go() ;
	  virtual void startMonitoring(string rname);
	  virtual void stopMonitoring(string rname, map<string, double> &params);
	  virtual void setFileName(string rname, string fname);
	  virtual void dumpData(string rname);
	  virtual void dumpData(string rnmae, string fname);
	  virtual void destroyRecord(string rname);
	  virtual int getPerformanceData(std::string rname, std::vector<std::vector<double> > &data, bool reset);
	  virtual int getCompMethNames(std::vector<string> &cm_names);
	  virtual void setServices (classic::gov::cca::Services * services);
		  
	private:
	  void createRecord(string rname);
	  bool init_mport;
	  bool init_tree;
	  classic::gov::cca::Services * frameworkServices;
	  performance::ccaports::Measurement * measurement_m;
	  map<string, performance::Record*> records;
	  CallPathNode * call_path_tree;
	};
    }
}
#endif                          // MasterMind_CCA_H
