#ifndef Monitor_CCA_H
#define Monitor_CCA_H

#include <string>
#include <map>

using namespace std;

namespace monitor
{
  namespace ccaports
    {
      /**
       * This abstract class declares the Monitor interface.
       */
      class Monitor:public virtual classic::gov::cca::Port
	{
	public:
	  virtual ~Monitor (){}
	  /** 
	   * Start monitoring the record object with name rname
	   */
	  virtual void startMonitoring(string rname) = 0;
	  
	  /** 
	   * Stop monitoring the record object with the name rname
	   */
	  virtual void stopMonitoring(string rname, map<string, double> &params) = 0;
	  
	  /**
	   * Set dump file name
	   **/
	  
	  virtual void setFileName(string rname, string fname) = 0;
	  
	  /** 
	   * Dump the performance date of record object rname
	   */
	  virtual void dumpData(string rname) = 0;
	  
	  /** 
	   * Dump the performance date of record object rname to file fname
	   */
	  virtual void dumpData(string rname, string fname) = 0;
	  
	  /** 
	   * Destroy record with name rname
	   */
	  virtual void destroyRecord(string rname) = 0;
	  
	};
    }
}
#endif
