#ifndef PerfParamPort_CCA_H
#define PerfParamPort_CCA_H

#include <string>
#include <vector>
#include <neocca.hh>

using namespace neo::cca;

namespace perfparam
{
  namespace ccaports
    {
      /**
       * This abstract class declares the PerfParamPort interface.
       */
      class PerfParam:public virtual Port{
	public:
	  virtual ~PerfParam (){}
	  //get the current records from the MasterMind.  If bool == true, then
	  //delete the parameters when you are done so you start accumulating fresh results.  
	  //If bool == false then continue accumulating values.
	  virtual int getPerformanceData(std::string rname, std::vector<std::vector<double> > &data, bool reset) = 0;
	  //Return a vector of strings containing the component_name::method_name for all 
	  //methods being monitored.
	  virtual int getCompMethNames(std::vector<std::string> &cm_names) = 0;
	};
    }
}
#endif
