MasterMind component documentation.

The Mastermind component is used by the proxies and is responsible for gathering, storing 
and reporting of the measurement data.  A proxy can use the MMs Monitor port to monitor 
the performance of a given routine.
For each routine that is monitored, a record object is created and stored by the Mastermind. The 
record object stores all the measurement data for each of the invocations of a single routine. When 
monitoring is started via a call to the Mastermind, the Mastermind passes the parameters to the 
record object and tells the record to begin timing. TAU measurements are made cumulatively, so in 
order to obtain the measurements for a single invocation, measurements must be made prior to the 
invocation and again after the invocation. To make a measurement, the TAU component is queried in 
order to record the current measurements for the timer, the MPI time, and any hardware metrics being 
measured. The MPI time is determined by the summation of the times of all the MPI routines. When 
monitoring is stopped, the TAU component is again queried to obtain the current time, MPI time and 
hardware measurements. The measurements for the single invocation are determined by the difference 
between the measurements obtained after the invocation and the measurements from before the 
invocation. The single invocation measurements, along with the parameters, are stored in the record. 

The MM also creates a call path tree of the component application.  Using the proxies, the MM
will create the tree using the call path node objects.  Each node in teh call path represents a 
proxy::routine_name pair.  These files can then be used by the 
tool TreePruner, which can perform some rule-based pruning operations.  By pruning the tree,
you can identify the "core" components of the application that make up the majority of the 
work being done by the application.  Selecting the optimal set of implementations for these core 
components may be easier, as you are dealing with a smaller number of components.  The TreePruner's 
usage can be displayed by entering the command "TreePruner -h" after it is built.

The MM will also output a database file which will give the filename for each component where
its routine's performance data is kept.  A particular component may have multiple entries in the 
dbfile if multiple routines are being monitored.

The MM contains a GoPort, that when invoked will output all of the output files.  

