#ifndef RECORD_H
#define RECORD_H

#include <map>
#include <deque>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>
#include <sys/resource.h>
#include <mpi.h>
#include "cca.h"
#include "Measurement_CCA.h"
#include "ports/MPIBorrow.h"

#define MPI_ID 1

using namespace std;

namespace performance{
  class Record{
  private:

    int rank;	                              //rank of cpu
    string name, filename;                    //name of record and dumpfile
    Timer * timer;                            //timer pointer
    //map<string,Timer*> timers;              //map of timers
    //outer vector contains a vector of input parameters per invocation
    vector< vector<double> > parameters;
    vector<string> param_names;               //vector of parameter names
    map<string, double> last_data_exclusive;  //map of last exclusive timing data
    map<string, double> last_data_inclusive;  //map of last inclusive timing data
    map<string, double> mpi_last_data;        //map of last MPI data
    map<string, double>mpi_stop_data;         //map of current MPI data
    deque<map<string,double> > t_data;        //deque of timing data, one map per invocation
    bool pnames_set;
    bool filename_exists;
    performance::ccaports::Measurement * measurement_m;  //measurement port
    classic::gov::cca::Services * svc;                   //services

    //routines
    int startTimer();
    int stopTimer();

  public:
    //constructor, initialize variables to zero
    Record(string n,classic::gov::cca::Services * fs, performance::ccaports::Measurement * m);
    ~Record();
    
    /****************************************************************
     *  Routines
     ***************************************************************/
    int setRank(int r);
    int getRank();
    string getName();
    void getParameters(std::vector<std::vector<double> > &p);
    void resetParameters();
    //start and stop timing will create a timer with the same name as the
    //record object and start and stop it.  The bool parameter specifies
    //whether we should start and stop the MPI timers with the user
    //timer.  The coinciding start and stop timing calls must match (e.g.
    //if you call startTiming(true), you must stop with stopTiming(true))
    //The second input in the stop call is a reference to a map where the 
    //counters can be stored
    int startTiming(bool mpitimers);
    int stopTiming(bool mpitimers, map<string,double> &pc, map<string,double> &params);
    int startMPITimers();
    int stopMPITimers();
    //Set the filename to dump out data.  Can only set once.  If attempted 
    //to be set more than once, the new name is ignored and a -1 is returned.
    //1 is returned on success.
    int setFileName(string s);
    string getFileName();
    //Dump the measurements stored in the performance_data map and timers 
    //map to file.  Default name is dump.out, if not set using 
    //setFileName();
    int dumpToFile(string rname);
  };
}
#endif
