#include "CallPathNode.h"

//first a constructor to build the root node
CallPathNode::CallPathNode(string s){
  name = s;
  count = 1;
  parent = 0;
  significant = true;
}

//Now, a constructor to build non-root nodes
CallPathNode::CallPathNode(string s, CallPathNode* p){
  name = s;
  //add the parent pointer to the top of the stack
  //parent_stack.push_back(p);
  parent = p;
  count = 1;
  significant = true;
}

//Destructor
CallPathNode::~CallPathNode(){
  //cout<<"Begin destructor for "<<name<<endl;
  //delete any children
  vector<CallPathNode*>::iterator it;
  for(it = children.begin(); it != children.end(); it++){
    delete (*it);
  }
  counters.clear();

  //cout<<"End destructor for "<<name<<endl;
}

string CallPathNode::getName(){
  return name;
}

void CallPathNode::setSignificant(bool b){
  significant = b;
}

bool CallPathNode::getSignificant(){
  return significant;
}

int CallPathNode::getCount(){
  return count;
}

void CallPathNode::setCount(int c){
  count = c;
}

void CallPathNode::incrementCount(){
  count++;
}

int CallPathNode::getNumChildren(){
  return children.size();
}

double CallPathNode::getInclusiveCounter(){
  double counter;
  map<string,double>::iterator iter = counters.begin();
  while(iter != counters.end()){
    if((iter->first).substr(0,9) == "Inclusive"){
      counter = iter->second;
      iter = counters.end();
    }//if
    else
      iter++;
  }//while
  return counter;
}

double CallPathNode::getChildrenInclusiveCounter(){
  //calculate and return the total inclusive count for all children
  double totalcount = 0;
  vector<CallPathNode *>::iterator it;
  //if we are a leaf node, just return 0
  if(children.size() == 0){
    return 0;
  }
  //for each child, get the FIRST inclusive counter
  for(it = children.begin(); it != children.end(); it++){
    totalcount += (*it)->getInclusiveCounter();
  }//for
  return totalcount;
}

map<string,double> CallPathNode::getCounters(){
  return counters;
}

void CallPathNode::setCounters(map<string,double> m){
  counters = m;
}

void CallPathNode::incrementCounters(map<string,double> m){
  map<string,double>::iterator it;
  for(it = m.begin(); it != m.end(); it++){
    counters[it->first] += it->second;
  }
}

CallPathNode* CallPathNode::getChild(string s){
  vector<CallPathNode*>::iterator it;
  //iterate thru the vector and see if any of the children have the name we
  //are looking for.  if so, return that child node.
  for(it = children.begin(); it != children.end(); it++){
    if((*it)->getName() == s){
      (*it)->incrementCount();
      return (*it);
    }
  }
  //if we exit the for loop, then we didn't find a child, create one
   return newChild(s);
}

vector<CallPathNode *> CallPathNode::getChildren(){
  return children;
}

CallPathNode* CallPathNode::getParent(){
  return parent;
}

CallPathNode* CallPathNode::getRootPointer(){
  //with only one parent, tree traversal is easy
  CallPathNode * current = this;
  while(parent){
    current = current->getParent();
  }
  return current;
}

void CallPathNode::removeChild(CallPathNode * c){
  //find pointer in vector of children, then erase the object and the vector entry
  vector<CallPathNode *>::iterator vit = children.begin();
  while(vit != children.end()){
    if((*vit) == c){
      delete (*vit);
      children.erase(vit);
      vit = children.end();
    }
    else
      vit++;
  }
}

CallPathNode* CallPathNode::newChild(string s){
  CallPathNode* parent = this;
  CallPathNode* c = new CallPathNode(s,parent);
  //put pointer in vector
  children.insert(children.end(), c);
  return c;
}

void CallPathNode::dumpChildren(string filename){
  //first, we need to see if the file exists.  If it does, assume that there is already some
  //output, so start off the line with a newline character.  Else, we need to create the file,
  //and we don't want to start with a newline.
  int file_exists = access(filename.c_str(), F_OK);
  ofstream outfile(filename.c_str(), std::ios::app);
  if(!file_exists)
    outfile<<"\n";
  //format of output file is:
  //Types of data are separated by a '#', while multiple instances of a type are separated
  //by a '\'.  
  //#<Node_name>#<count>#<counter_name counter_value>\ ...#<parent>#<children_names> \ ...# 
 if(this != 0){
   //print out name
   outfile<<name<<"#";
   //print if significant
   if(!getSignificant())
     outfile<<"INSIGNIFICANT";
   outfile<<"#";
   //print out count
   outfile<<getCount()<<"#";
   //print out pairs of performance counter name and value, each pair separated
   //by a backslash '\'
   map<string,double>::iterator mit;
   int size = counters.size();
   int c = 0;  //count

   for(mit = counters.begin(); mit != counters.end(); mit++){
     c++;
     outfile<<mit->first<<"="<<mit->second;
     if(c<size)
       outfile<<"\\";
   }
   outfile<<"#";
   //if parent exists, print out parent's name
   if(parent)
     outfile<<parent->getName();
   outfile<<"#";
   //print out names of any children that the node may have
   vector<CallPathNode*>::iterator vit;
   size = children.size();
   c = 0;
   for(vit = children.begin(); vit != children.end(); vit++){
     c++;
     outfile<<(*vit)->getName();
     if(c<size)
       outfile<<"\\";
   }

   outfile.close();
   //now, dump out children's children
   for(vit = children.begin(); vit != children.end(); vit++){
     (*vit)->dumpChildren(filename);
   }
 }
 else{
   outfile<<"Woops!  We have a null pointer!"<<endl;
   outfile.close();
 }
}
