#ifndef CALLPATHNODE_H
#define CALLPATHNODE_H

#include <vector>
#include <string>
#include <iostream>
#include <map>
#include <fstream>
#include <unistd.h>
#include <math.h>

using namespace std;

class CallPathNode{
 private:
  int count;  //to store how many times we went through this node
  map<string,double> counters;  //map of performance counters
  string name;  //instance name of node
  vector<CallPathNode*> children; //vector of pointers to any children
  vector<CallPathNode*> parent_stack; //stack of pointers to last parent
  CallPathNode * parent;
  void addParentToStack(CallPathNode * p);
  bool significant;

 public:
  CallPathNode(string s);  //constructor for root node
  CallPathNode(string s, CallPathNode * p);  //constructor for non-root node
  ~CallPathNode();

  /******************************************************************************
   * Routines
   *****************************************************************************/

  //return the name string
  string getName();
  bool getSignificant();
  void setSignificant(bool b);
  //return the counter variable, which holds the number of times the
  //current node has been traversed
  int getCount();
  void setCount(int c);
  //increment the counter variable
  void incrementCount();
  int getNumChildren();
  double getInclusiveCounter();
  double getChildrenInclusiveCounter();
  void incrementCounters(map<string,double> m);
  map<string,double> getCounters();
  void setCounters(map<string,double> m);
  //return a pointer to the child with the given name.  If the child does not
  //exist, create a child with the given name
  CallPathNode * getChild(string s);  
  vector<CallPathNode *> getChildren();
  //creates a child node at the current node.  returns a pointer to the new child
  CallPathNode * newChild(string s);
  void removeChild(CallPathNode * c);
  //return the pointer to the parent that is at the top of the stack
  //under our current construction, a node will only have one parent
  CallPathNode * getParent();
 //return a pointer to the root node
  CallPathNode * getRootPointer();  
  //print out a depth-first traversal of each node and its children
  void dumpChildren(string filename);
};
#endif
