#include <iostream>
#include <fstream>
#include <unistd.h>
#include "MinTreeNode.h"

//first a constructor to build the root node
MinTreeNode::MinTreeNode(std::string s){
  name = s;
  parent = 0;
}

//Now, a constructor to build non-root nodes
MinTreeNode::MinTreeNode(std::string s, MinTreeNode* p){
  name = s;
  parent = p;
}

//Destructor
MinTreeNode::~MinTreeNode(){
  std::vector<MinTreeNode*>::iterator it;
  for(it = children.begin(); it != children.end(); it++){
    delete (*it);
  }
}

std::string MinTreeNode::getName(){
  return name;
}

int MinTreeNode::changeName(std::string n){
  name = n;
  return 1;
}

int MinTreeNode::getNumChildren(){
  return children.size();
}

MinTreeNode* MinTreeNode::getChild(std::string s){
  std::vector<MinTreeNode*>::iterator it;
  //iterate thru the vector and see if any of the children have the name we
  //are looking for.  if so, return that child node.
  for(it = children.begin(); it != children.end(); it++){
    if((*it)->getName() == s){
      return (*it);
    }
  }
  //if we exit the for loop, then we didn't find a child, return a null pointer
  return 0;
}

std::vector<MinTreeNode *> MinTreeNode::getChildren(){
  return children;
}

MinTreeNode* MinTreeNode::getParent(){
  return parent;
}

MinTreeNode* MinTreeNode::getRootPointer(){
  //with only one parent, tree traversal is easy
  MinTreeNode * current = this;
  while(parent){
    current = current->getParent();
  }
  return current;
}

void MinTreeNode::removeChild(MinTreeNode * c){
  //find pointer in vector of children, then erase the object and the vector entry
  std::vector<MinTreeNode *>::iterator vit = children.begin();
  while(vit != children.end()){
    if((*vit) == c){
      delete (*vit);
      children.erase(vit);
      vit = children.end();
    }
    else
      vit++;
  }
}

MinTreeNode* MinTreeNode::newChild(std::string s){
  MinTreeNode* parent = this;
  MinTreeNode* c = new MinTreeNode(s,parent);
  //put pointer in vector
  children.insert(children.end(), c);
  return c;
}

void MinTreeNode::dumpChildren(std::string filename){
  //first, we need to see if the file exists.  If it does, assume that there is already some
  //output, so start off the line with a newline character.  Else, we need to create the file,
  //and we don't want to start with a newline.
  int file_exists = access(filename.c_str(), F_OK);
  std::ofstream outfile(filename.c_str(), std::ios::app);
  if(!file_exists)
    outfile<<"\n";
  //format of output file is:
  //Node name and any parent or children are separated by a '#', with multiple children separated by a '\'
  //#<Node_name>#<parent>#<children_names> \ ...# 
 if(this != 0){
   //print out name
   outfile<<name<<"#";
   //if parent exists, print out parent's name
   if(parent)
     outfile<<parent->getName();
   outfile<<"#";
   //print out names of any children that the node may have
   std::vector<MinTreeNode*>::iterator vit;
   int size = children.size();
   int c = 0;
   for(vit = children.begin(); vit != children.end(); vit++){
     c++;
     outfile<<(*vit)->getName();
     if(c<size)
       outfile<<"\\";
   }
   outfile.close();
   //now, dump out children's children
   for(vit = children.begin(); vit != children.end(); vit++){
     (*vit)->dumpChildren(filename);
   }
 }
 else{
   outfile<<"Woops!  We have a null pointer!"<<std::endl;
   outfile.close();
 }
}
