#ifndef MINTREENODE_H
#define MINTREENODE_H

#include <vector>
#include <string>

class MinTreeNode{
 private:
  std::string name;  //instance name of node
  std::vector<MinTreeNode*> children; //vector of pointers to any children
  MinTreeNode * parent;

 public:
  MinTreeNode(std::string s);  //constructor for root node
  MinTreeNode(std::string s, MinTreeNode * p);  //constructor for non-root node
  ~MinTreeNode();

  /******************************************************************************
   * Routines
   *****************************************************************************/

  //return the name string
  std::string getName();
  int changeName(std::string n);
  int getNumChildren();
  MinTreeNode * getChild(std::string s);  
  std::vector<MinTreeNode *> getChildren();
  //creates a child node at the current node.  returns a pointer to the new child
  MinTreeNode * newChild(std::string s);
  void removeChild(MinTreeNode * c);
  //return the pointer to the parent that is at the top of the stack
  //under our current construction, a node will only have one parent
  MinTreeNode * getParent();
 //return a pointer to the root node
  MinTreeNode * getRootPointer();  
  //print out a depth-first traversal of each node and its children
  void dumpChildren(std::string filename);
};
#endif
