#include "Optimizer_CCA.h"
#include <iostream>

using namespace neo::cca;
using namespace neo::cca::ports;

namespace optimize
{
  namespace ccaimpl
  {

    /** 
     * Default constructor
     */
    Optimizer::Optimizer ()
    {
      frameworkServices = 0;
      first_time = true;
    }

    Optimizer::~Optimizer ()
    {
    }

    /*  This method will start an optimization phase.  The first part is
	to contact the MasterMind and get the performance parameters for 
	each component::routine.  */
    int Optimizer::go(){
 //Now, let's run the problem using the Godunov solver.
 //The godunov component and proxy are already loaded and 
 //instantiated via the startup script.  But, we need to 
 //hook them up and rerurn the application.
 //Since we rerun the application, the test boolean will
 //make sure we only try to replace EFM with Godunov
 //after the first run.
      
      if(first_time){
	first_time = false;
	neo::cca::Port * port = 0;
	port = frameworkServices->getPort("bs");
	neo::cca::ports::BuilderService * bs = 0;
	if(port != 0){
	  std::cerr<<"port is defined -- dynamically casting..."<<std::endl;
	  bs = dynamic_cast < neo::cca::ports::BuilderService * >(port);
	  if(bs == 0){
	    cerr << "Connected to something other than a BuilderService port" <<endl;
	  }
	} else {
	  cerr << "port BuilderService not apparently connected." << endl;
	}

	ComponentID_shared efm_proxy = bs->getComponentID("efm_proxy");
	ComponentID_shared godunov_proxy = bs->getComponentID("godunov_proxy");
	ComponentID_shared efm = bs->getComponentID("efm");
        ComponentID_shared godunov = bs->getComponentID("godunov");
	swapCCAComponentsNT(efm, efm_proxy, godunov, godunov_proxy, bs);
	}
      return 1;
    }
    
    void Optimizer::swapCCAComponentsNT(ComponentID_shared original, ComponentID_shared o_proxy, 
				   ComponentID_shared replacement, ComponentID_shared r_proxy, 
				   neo::cca::ports::BuilderService * bs){
      //First, we need to swap proxies.  The original component's provide links 
      //should all be connected to the proxy.  Thus, we should start by disconnecting
      //those, and connecting the replacement proxy to the replacement component.
      std::vector<neo::cca::ComponentID_shared> o_proxy_list;
      o_proxy_list.push_back(o_proxy);
      std::vector<neo::cca::ConnectionID_shared> proxy_links;
      proxy_links = bs->getConnectionIDs(o_proxy_list);
      std::vector<neo::cca::ConnectionID_shared>::iterator proxy_it;
      for(proxy_it = proxy_links.begin(); proxy_it != proxy_links.end(); proxy_it++){
	std::cerr<<"Provider: "<<((*proxy_it)->getProvider())->getInstanceName()<<endl;
	std::cerr<<"User: "<<((*proxy_it)->getUser())->getInstanceName()<<endl;
	//TypeMap_shared tmap = bs->getPortProperties(o_proxy, (*proxy_it)->getUserPortName());
	//std::string temp = neo::support::helpers::stringValue(tmap, "cca.portName");
	//std::cerr<<temp<<std::endl;
	//std::cerr<<"Provider: "<<((*proxy_it)->getProvider())->getInstanceName()<<endl;
	//std::cerr<<"User: "<<((*proxy_it)->getUser())->getInstanceName()<<endl;
	//if(true){
	if(((*proxy_it)->getProvider())->getInstanceName() == o_proxy->getInstanceName()){
	  std::cerr<<"Proxy is a provider"<<std::endl;
	  //we have a connection with the original proxy is a provider
	  //in this case, we simply swap.
	  ComponentID_shared user = (*proxy_it)->getUser();
	  std::string uses_port = (*proxy_it)->getUserPortName();
	  TypeMap_shared tm = bs->getPortProperties(user,uses_port);
	  std::string port_type = neo::support::helpers::stringValue(tm, "cca.portType");
          //find the corresponding uses port name in replacement proxy
	  std::string proxy_port;
	  std::vector<std::string> proxy_provides = bs->getProvidedPortNames(r_proxy);
	  std::vector<std::string>::iterator pnames_it;
          for(pnames_it = proxy_provides.begin(); pnames_it != proxy_provides.end(); pnames_it++){
            //for each port, we need to get the typemap and check it to
            //see if it is the port type we want
	    std::string pt = neo::support::helpers::stringValue(bs->getPortProperties(r_proxy,*pnames_it), "cca.portType");
            if(pt == port_type){
	      std::cerr<<"We have a match: "<<pt<<" = "<<port_type<<endl;
              proxy_port = *pnames_it;
	    }
          }
	  std::cerr<<uses_port<<" "<<proxy_port<<endl;
          bs->disconnect(*proxy_it, 0);

          bs->connect(user, uses_port, r_proxy, proxy_port);
	}
	else if(((*proxy_it)->getUser())->getInstanceName() == o_proxy->getInstanceName()){
      	  std::cerr<<"Proxy is a user"<<std::endl;
	  //we have a connection consisting of a proxy use port.
	  //The conenction is either a "forwading" port that 
	  //connects to the original component, or a MonitorPort
	  //that connects to the MasterMind.
	  ComponentID_shared provider = (*proxy_it)->getProvider();
	  std::string provides_port = (*proxy_it)->getProviderPortName();
	  std::string port_type = neo::support::helpers::stringValue(bs->getPortProperties(provider, provides_port), "cca.portType");
	  std::cerr<<"Port type : "<<port_type<<endl;
	  if(port_type == "monitor.ccaports.Monitor"){
	    //if we have a monitor port, we need to swap in the new
	    //proxy.
	    std::cerr<<"We have a port of type Monitor!"<<std::endl;
	    std::string proxy_port = "";
	    std::vector<std::string> proxy_uses = bs->getUsedPortNames(r_proxy);
	    std::vector<std::string>::iterator pnames_it;
	    for(pnames_it = proxy_uses.begin(); pnames_it != proxy_uses.end(); pnames_it++){
	      //for each port, we need to get the typemap and check it to
	      //see if it is the port type we want
	      std::string pt = neo::support::helpers::stringValue(bs->getPortProperties(r_proxy,*pnames_it), "cca.portType");
	      std::cerr<<pt<<endl;
	      if(pt == port_type)
		proxy_port = *pnames_it;
	    }
	    bs->disconnect(*proxy_it, 0);
	    bs->connect(r_proxy, proxy_port, provider, provides_port);
	  }
	  else{
	    //else, we have a "forwarding connection, in which 
	    //we need to connect the new proxy up to the replacement
	    //component.  We need to find the names of the ports
	    //in the proxy and replacement component.
	    std::string proxy_port = "";
	    std::vector<std::string> proxy_uses = bs->getUsedPortNames(r_proxy);
	    std::vector<std::string>::iterator pnames_it;
            for(pnames_it = proxy_uses.begin(); pnames_it != proxy_uses.end(); pnames_it++){
              //for each port, we need to get the typemap and check it to
              //see if it is the port type we want
	      std::string pt = neo::support::helpers::stringValue(bs->getPortProperties(r_proxy,*pnames_it), "cca.portType");
              if(pt == port_type)
                proxy_port = *pnames_it;
            }

	    std::string r_port = "";
	    std::vector<std::string> r_uses = bs->getProvidedPortNames(replacement);
	    std::vector<std::string>::iterator rnames_it;
            for(rnames_it = r_uses.begin(); rnames_it != r_uses.end(); rnames_it++){
              //for each port, we need to get the typemap and check it to
              //see if it is the port type we want
	      std::string pt = neo::support::helpers::stringValue(bs->getPortProperties(replacement,*rnames_it), "cca.portType");
              if(pt == port_type)
                r_port = *rnames_it;
            }
	    //now disconnect the exisiting connection, and make 
	    //the new connection
	    bs->disconnect(*proxy_it, 0);
	    bs->connect(r_proxy, proxy_port, replacement, r_port);
	  }
	}
	else{
	  std::cerr<<"ERROR: OPTIMIZER: We have an unknown connection in the proxy"<<endl;
	}
      }

      //Now, get connections for the original component
      std::vector<neo::cca::ComponentID_shared> original_list;
      original_list.push_back(original);
      std::vector<neo::cca::ConnectionID_shared> original_links = bs->getConnectionIDs(original_list);
      //For each of the connections, we need to disconnect, and substitute
      //the replacement
      std::vector<neo::cca::ConnectionID_shared>::iterator conn_it;
      //Iterate through the links that contain the original component.  A link will 
      //either have the original component as a provider or a user.  We will assume
      //that the component being replaced is proxied.  As such, all of its provides ports
      //will be proxied.  When replacing a component, we don't want the replacement to 
      //be connected to the original's proxy, so we will simply disconenct these.  
      //The uses ports will be used to make the corresponding connection between 
      //the replacement component and the provider.
      for(conn_it = original_links.begin(); conn_it != original_links.end(); conn_it++){
	//is the link an original component provide?  There shouldn't be any of these
	//as we have already done the proxy.  If there are, simply disconnect them
	if(((*conn_it)->getProvider())->getInstanceName() == original->getInstanceName()){
	  bs->disconnect((*conn_it), 0);
	}
	//is the original component a user?  If so, disconnect, and swap.
	else if(((*conn_it)->getUser())->getInstanceName() == original->getInstanceName()){
	  //this is a connection with an original uses port
	  ComponentID_shared provider = (*conn_it)->getProvider();
	  std::string provides_port = (*conn_it)->getProviderPortName();
	  //find out the type of connection
	  std::string port_type = neo::support::helpers::stringValue(bs->getPortProperties(provider, provides_port), "cca.portType");
	  //find the corresponding uses port name in replacement component
	  std::string uses_port;
	  std::vector<std::string> replacement_uses = bs->getUsedPortNames(replacement);
	  std::vector<std::string>::iterator unames_it;
	  for(unames_it = replacement_uses.begin(); unames_it != replacement_uses.end(); unames_it++){
	    //for each uses port, we need to get the typemap and check it to
	    //see if it is the port type we want
	    std::string pt = neo::support::helpers::stringValue(bs->getPortProperties(replacement,*unames_it), "cca.portType");
	    if(pt == port_type)
	      uses_port = *unames_it;
	  }
	  bs->disconnect((*conn_it), 0);
	  bs->connect(replacement, uses_port, provider, provides_port);
	}
	else{
	  //ignore, as we have a connection that does not use the original
	  std::cerr<<"ERROR: OPTIMIZER: Non original component connection"<<std::endl;
	}
      }
    }
    
    void Optimizer::releaseServices( Services *q) throw ( Exception )
    {
      if ( q == 0 || q != frameworkServices )
	{
	  throw Exception("Strange services pointer")  ;
	}
      
      frameworkServices->removeProvidesPort("Go") ; 
      frameworkServices->unregisterUsesPort("bs");

    }


    /**
     * The framework passes a pointer to the Services object
     * via this method, which is called by the framework as soon
     * as the component is instantiated.
     */
    void Optimizer::setServices (Services * q) throw ( Exception )
    {
      if ( frameworkServices != 0)
	{
	  throw Exception ("Optimizer::setServices called twice.");
  	  return;
	}
      if ( q == 0 )
	{
	  throw Exception ("Optimizer::setServices(null) called.");
	  return;
	}

      frameworkServices = q;
      frameworkServices->registerForRelease(this);
      //frameworkServices->registerUsesPort("PerfParamPort", "perfparam.ccaports.PerfParamPort");
      frameworkServices->registerUsesPort("bs", "neo.cca.ports.BuilderService");
      frameworkServices->addProvidesPort(this, "Go", "GoPort");
    }
  }
}

//////////////////////////// wrapper                                                 
extern "C" {
  Component *create_Optimizer() {
    Component *comp_ptr;
    optimize::ccaimpl::Optimizer *component;
    component = new optimize::ccaimpl::Optimizer();
    comp_ptr = dynamic_cast<Component *>(component);
    return comp_ptr;
  }
}

