/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.ColorChooserFrame;
import jRacy.SavedPreferences;
import jRacy.jRacy;
import java.awt.Color;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class ColorChooser
implements WindowListener {
    Vector globalColors = new Vector();
    private Color highlightColor = Color.red;
    int highlightColorFunctionID = -1;
    private Color miscFunctionsColor = Color.black;
    private boolean clrChooserFrameShowing = false;
    private ColorChooserFrame clrChooserFrame;

    public ColorChooser(SavedPreferences savedPreferences) {
        if (savedPreferences != null) {
            this.globalColors = savedPreferences.getGlobalColors();
            this.highlightColor = savedPreferences.getHighlightColor();
            this.miscFunctionsColor = savedPreferences.getMiscFunctionsColor();
        } else {
            this.setDefaultColors();
        }
    }

    public void showColorChooser() {
        if (!this.clrChooserFrameShowing) {
            this.clrChooserFrame = new ColorChooserFrame(this);
            this.clrChooserFrame.addWindowListener(this);
            this.clrChooserFrame.show();
            this.clrChooserFrameShowing = true;
        } else {
            this.clrChooserFrame.show();
        }
    }

    public void setSavedColors() {
        jRacy.savedPreferences.setGlobalColors(this.globalColors);
        jRacy.savedPreferences.setHighlightColor(this.highlightColor);
        jRacy.savedPreferences.setMiscFunctionsColor(this.miscFunctionsColor);
    }

    public int getNumberOfColors() {
        return this.globalColors.size();
    }

    public void setColorInLocation(Color color, int n) {
        try {
            this.globalColors.setElementAt(color, n);
        }
        catch (Exception exception) {
            if (exception instanceof ArrayIndexOutOfBoundsException) {
                System.out.println("An out of bounds exception occurred while trying to set a color!");
                System.out.println("The value of the index is: " + n);
            }
            System.out.println("An error occurs whilst setting a color!");
        }
    }

    public Color getColorInLocation(int n) {
        try {
            return (Color)this.globalColors.elementAt(n);
        }
        catch (Exception exception) {
            if (exception instanceof ArrayIndexOutOfBoundsException) {
                System.out.println("An out of bounds exception occurred while trying to get a color!");
                System.out.println("The value of the index is: " + n);
            } else {
                System.out.println("An error occurs whilst getting a color!");
            }
            return null;
        }
    }

    public void addColor(Color color) {
        this.globalColors.add(color);
    }

    public Vector getColorAllColors() {
        return this.globalColors;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColorFunctionID(int n) {
        this.highlightColorFunctionID = n;
        jRacy.systemEvents.updateRegisteredObjects("colorEvent");
    }

    public int getHighlightColorFunctionID() {
        return this.highlightColorFunctionID;
    }

    public void setMiscFunctionsColor(Color color) {
        this.miscFunctionsColor = color;
    }

    public Color getMiscFunctionsColor() {
        return this.miscFunctionsColor;
    }

    public void setDefaultColors() {
        this.globalColors.clear();
        this.addColor(new Color(61, 104, 63));
        this.addColor(new Color(102, 0, 51));
        this.addColor(new Color(0, 102, 102));
        this.addColor(new Color(0, 51, 255));
        this.addColor(new Color(102, 132, 25));
        this.addColor(new Color(119, 71, 145));
        this.addColor(new Color(221, 232, 30));
        this.addColor(new Color(70, 156, 168));
        this.addColor(new Color(255, 153, 0));
        this.addColor(new Color(0, 255, 0));
        this.addColor(new Color(121, 196, 144));
        this.addColor(new Color(86, 88, 112));
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.clrChooserFrame) {
            this.clrChooserFrameShowing = false;
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

