/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.FunctionDataWindow;
import jRacy.GlobalMappingElement;
import jRacy.jRacy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class FunctionLedgerWindowPanel
extends JPanel
implements ActionListener,
MouseListener {
    int xPanelSize = 300;
    int yPanelSize = 400;
    int barHeight;
    int barSpacing;
    Vector NameIDMapping;
    int numberOfColors = 0;
    private JPopupMenu popup = new JPopupMenu();
    Object clickedOnObject = null;

    public FunctionLedgerWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FLWP01");
        }
    }

    public FunctionLedgerWindowPanel(Vector vector) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.NameIDMapping = vector;
            this.addMouseListener(this);
            JMenuItem jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change Function Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FLWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            int n;
            FontMetrics fontMetrics;
            Font font;
            super.paintComponent(graphics);
            this.numberOfColors = jRacy.clrChooser.getNumberOfColors();
            GlobalMappingElement globalMappingElement = null;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n4 = 0;
            n2 = 5;
            if (!jRacy.jRacyPreferences.areBarDetailsSet()) {
                font = new Font(jRacy.jRacyPreferences.getJRacyFont(), jRacy.jRacyPreferences.getFontStyle(), 12);
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics(font);
                n = fontMetrics.getAscent();
                jRacy.jRacyPreferences.setBarDetails(n, n);
                jRacy.jRacyPreferences.setSliders(n, n);
            }
            this.barSpacing = jRacy.jRacyPreferences.getBarSpacing();
            this.barHeight = jRacy.jRacyPreferences.getBarHeight();
            font = new Font(jRacy.jRacyPreferences.getJRacyFont(), jRacy.jRacyPreferences.getFontStyle(), this.barHeight);
            graphics.setFont(font);
            fontMetrics = graphics.getFontMetrics(font);
            n = 0;
            Enumeration enumeration = this.NameIDMapping.elements();
            while (enumeration.hasMoreElements()) {
                globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
                if (!globalMappingElement.getFunctionName().equals("Error ... the function name has not been set!")) {
                    Color color = globalMappingElement.getFunctionColor();
                    graphics.setColor(color);
                    graphics.fillRect(n2, (n3 += this.barSpacing) - this.barHeight, this.barHeight, this.barHeight);
                    if (globalMappingElement.getGlobalID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                        graphics.setColor(jRacy.clrChooser.getHighlightColor());
                        graphics.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                        graphics.drawRect(n2 + 1, n3 - this.barHeight + 1, this.barHeight - 2, this.barHeight - 2);
                    } else {
                        graphics.setColor(Color.black);
                        graphics.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                    }
                    graphics.setColor(Color.black);
                    String string = globalMappingElement.getFunctionName();
                    graphics.drawString(string, n2 += this.barHeight + 10, n3);
                    int n5 = 5 + this.barHeight + fontMetrics.stringWidth(string);
                    if (n4 < n5) {
                        n4 = n5 + 11;
                    }
                    globalMappingElement.setDrawCoords(0, n5, n3 - this.barHeight, n3);
                    n2 -= this.barHeight + 10;
                }
                ++n;
            }
            if (n3 >= this.yPanelSize || n4 >= this.xPanelSize) {
                this.yPanelSize = n3 + 1;
                this.xPanelSize = n4 + 1;
                this.revalidate();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FLWP03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            GlobalMappingElement globalMappingElement = null;
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                        jRacy.clrChooser.setHighlightColorFunctionID(globalMappingElement.getGlobalID());
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(globalMappingElement.getFunctionName(), jRacy.staticMainWindow.getSMWData());
                        jRacy.systemEvents.addObserver(functionDataWindow);
                        functionDataWindow.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                    }
                    Color color = globalMappingElement.getFunctionColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        globalMappingElement.setSpecificColor(color);
                        globalMappingElement.setColorFlag(true);
                        jRacy.systemEvents.updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                    }
                    globalMappingElement.setColorFlag(false);
                    jRacy.systemEvents.updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FLWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            GlobalMappingElement globalMappingElement = null;
            Enumeration enumeration = this.NameIDMapping.elements();
            while (enumeration.hasMoreElements()) {
                globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
                if (n2 > globalMappingElement.getYEnd()) continue;
                if (n2 >= globalMappingElement.getYBeg() && n >= globalMappingElement.getXBeg() && n <= globalMappingElement.getXEnd()) {
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = globalMappingElement;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                        return;
                    }
                    if (jRacy.clrChooser.getHighlightColorFunctionID() == -1) {
                        jRacy.clrChooser.setHighlightColorFunctionID(globalMappingElement.getGlobalID());
                    } else if (jRacy.clrChooser.getHighlightColorFunctionID() != globalMappingElement.getGlobalID()) {
                        jRacy.clrChooser.setHighlightColorFunctionID(globalMappingElement.getGlobalID());
                    } else {
                        jRacy.clrChooser.setHighlightColorFunctionID(-1);
                    }
                    return;
                }
                return;
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FLWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize + 10, this.yPanelSize + 10);
    }
}

