/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.MeanDataWindowPanel;
import jRacy.StaticMainWindowData;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.Border;

public class MeanDataWindow
extends JFrame
implements ActionListener,
Observer {
    private ButtonGroup sortGroup;
    private ButtonGroup sortOrderGroup;
    private ButtonGroup inclusiveExclusiveGroup;
    private ButtonGroup valuePercentGroup;
    private ButtonGroup unitsGroup;
    private JRadioButtonMenuItem ascendingButton;
    private JRadioButtonMenuItem descendingButton;
    private JRadioButtonMenuItem functionIDButton;
    private JRadioButtonMenuItem nameButton;
    private JRadioButtonMenuItem millisecondButton;
    private JRadioButtonMenuItem inclusiveRadioButton;
    private JRadioButtonMenuItem exclusiveRadioButton;
    private JRadioButtonMenuItem valueButton;
    private JRadioButtonMenuItem percentButton;
    private JRadioButtonMenuItem secondsButton;
    private JRadioButtonMenuItem millisecondsButton;
    private JRadioButtonMenuItem microsecondsButton;
    private JRadioButtonMenuItem showZeroFunctionsItem;
    private JLabel barLengthLabel = new JLabel("Bar Mulitiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private MeanDataWindowPanel meanDataWindowPanelRef;
    private StaticMainWindowData sMWData;
    Vector currentSMWMeanData = null;
    private boolean sortByFunctionID = false;
    private boolean sortByName = false;
    private boolean sortByMillisecond = true;
    private boolean descendingOrder = true;
    private boolean inclusive;
    private boolean percent;
    private String unitsString;

    public MeanDataWindow() {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(700, 450));
            this.setTitle("Wrong constructor used!");
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MDW01");
        }
    }

    public MeanDataWindow(StaticMainWindowData staticMainWindowData) {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(700, 450));
            this.sMWData = staticMainWindowData;
            this.currentSMWMeanData = null;
            this.inclusive = false;
            this.percent = true;
            this.unitsString = "milliseconds";
            this.setTitle("Mean Data Window");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MeanDataWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (jRacy.helpWindow.isVisible()) {
                jRacy.helpWindow.clearText();
                jRacy.helpWindow.writeText("This is the mean data window");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("This window shows you the mean values for all functions.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Right click on any function within this window to bring up a popup");
                jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                jRacy.helpWindow.writeText("for the function, or to show more details about the function.");
                jRacy.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
            }
            this.sortLocalData();
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit Racy!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Options");
            JMenu jMenu3 = new JMenu("Sort by ...");
            this.sortGroup = new ButtonGroup();
            this.functionIDButton = new JRadioButtonMenuItem("function ID", false);
            this.functionIDButton.addActionListener(this);
            this.nameButton = new JRadioButtonMenuItem("name", false);
            this.nameButton.addActionListener(this);
            this.millisecondButton = new JRadioButtonMenuItem("millisecond", true);
            this.millisecondButton.addActionListener(this);
            this.sortGroup.add(this.functionIDButton);
            this.sortGroup.add(this.nameButton);
            this.sortGroup.add(this.millisecondButton);
            jMenu3.add(this.functionIDButton);
            jMenu3.add(this.nameButton);
            jMenu3.add(this.millisecondButton);
            jMenu2.add(jMenu3);
            JMenu jMenu4 = new JMenu("Sort Order");
            this.sortOrderGroup = new ButtonGroup();
            this.ascendingButton = new JRadioButtonMenuItem("Ascending", false);
            this.ascendingButton.addActionListener(this);
            this.descendingButton = new JRadioButtonMenuItem("Descending", true);
            this.descendingButton.addActionListener(this);
            this.sortOrderGroup.add(this.ascendingButton);
            this.sortOrderGroup.add(this.descendingButton);
            jMenu4.add(this.ascendingButton);
            jMenu4.add(this.descendingButton);
            jMenu2.add(jMenu4);
            JMenu jMenu5 = new JMenu("Select Inclusive or Exclusive");
            this.inclusiveExclusiveGroup = new ButtonGroup();
            this.inclusiveRadioButton = new JRadioButtonMenuItem("Inclusive", false);
            this.inclusiveRadioButton.addActionListener(this);
            this.exclusiveRadioButton = new JRadioButtonMenuItem("Exclusive", true);
            this.exclusiveRadioButton.addActionListener(this);
            this.inclusiveExclusiveGroup.add(this.inclusiveRadioButton);
            this.inclusiveExclusiveGroup.add(this.exclusiveRadioButton);
            jMenu5.add(this.inclusiveRadioButton);
            jMenu5.add(this.exclusiveRadioButton);
            jMenu2.add(jMenu5);
            JMenu jMenu6 = new JMenu("Select Value or Percent");
            this.valuePercentGroup = new ButtonGroup();
            this.percentButton = new JRadioButtonMenuItem("Percent", true);
            this.percentButton.addActionListener(this);
            this.valueButton = new JRadioButtonMenuItem("Value", false);
            this.valueButton.addActionListener(this);
            this.valuePercentGroup.add(this.percentButton);
            this.valuePercentGroup.add(this.valueButton);
            jMenu6.add(this.percentButton);
            jMenu6.add(this.valueButton);
            jMenu2.add(jMenu6);
            JMenu jMenu7 = new JMenu("Select Units");
            this.unitsGroup = new ButtonGroup();
            this.secondsButton = new JRadioButtonMenuItem("Seconds", false);
            this.secondsButton.addActionListener(this);
            this.millisecondsButton = new JRadioButtonMenuItem("Milliseconds", false);
            this.millisecondsButton.addActionListener(this);
            this.microsecondsButton = new JRadioButtonMenuItem("Microseconds", true);
            this.microsecondsButton.addActionListener(this);
            this.unitsGroup.add(this.secondsButton);
            this.unitsGroup.add(this.millisecondsButton);
            this.unitsGroup.add(this.microsecondsButton);
            jMenu7.add(this.secondsButton);
            jMenu7.add(this.millisecondsButton);
            jMenu7.add(this.microsecondsButton);
            jMenu2.add(jMenu7);
            JMenu jMenu8 = new JMenu("Windows");
            JMenuItem jMenuItem3 = new JMenuItem("Show Function Ledger");
            jMenuItem3.addActionListener(this);
            jMenu8.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Close All Sub-Windows");
            jMenuItem4.addActionListener(this);
            jMenu8.add(jMenuItem4);
            JMenu jMenu9 = new JMenu("Help");
            JMenuItem jMenuItem5 = new JMenuItem("About Racy");
            jMenuItem5.addActionListener(this);
            jMenu9.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Show Help Window");
            jMenuItem6.addActionListener(this);
            jMenu9.add(jMenuItem6);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu8);
            jMenuBar.add(jMenu9);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.meanDataWindowPanelRef = new MeanDataWindowPanel(this, this.sMWData);
            JScrollPane jScrollPane = new JScrollPane(this.meanDataWindowPanelRef);
            jScrollPane.setBorder(border);
            jScrollPane.setPreferredSize(new Dimension(500, 450));
            this.barLengthSlider.setPaintTicks(true);
            this.barLengthSlider.setMajorTickSpacing(5);
            this.barLengthSlider.setMinorTickSpacing(1);
            this.barLengthSlider.setPaintLabels(true);
            this.barLengthSlider.setSnapToTicks(true);
            this.barLengthSlider.addChangeListener(this.meanDataWindowPanelRef);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.475;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.475;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, gridBagConstraints, 1, 0, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.95;
            gridBagConstraints.weighty = 0.98;
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 1, 2, 1);
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MDW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit Racy!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("function ID")) {
                    if (this.functionIDButton.isSelected()) {
                        this.sortByFunctionID = true;
                        this.sortByName = false;
                        this.sortByMillisecond = false;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("name")) {
                    if (this.nameButton.isSelected()) {
                        this.sortByFunctionID = false;
                        this.sortByName = true;
                        this.sortByMillisecond = false;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("millisecond")) {
                    if (this.millisecondButton.isSelected()) {
                        this.sortByFunctionID = false;
                        this.sortByName = false;
                        this.sortByMillisecond = true;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Descending")) {
                    if (this.descendingButton.isSelected()) {
                        this.descendingOrder = true;
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Ascending")) {
                    if (this.ascendingButton.isSelected()) {
                        this.descendingOrder = false;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Inclusive")) {
                    if (this.inclusiveRadioButton.isSelected()) {
                        this.inclusive = true;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Exclusive")) {
                    if (this.exclusiveRadioButton.isSelected()) {
                        this.inclusive = false;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Percent")) {
                    if (this.percentButton.isSelected()) {
                        this.percent = true;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Value")) {
                    if (this.valueButton.isSelected()) {
                        this.percent = false;
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Seconds")) {
                    if (this.secondsButton.isSelected()) {
                        this.unitsString = "Seconds";
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Microseconds")) {
                    if (this.microsecondsButton.isSelected()) {
                        this.unitsString = "Microseconds";
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Milliseconds")) {
                    if (this.millisecondsButton.isSelected()) {
                        this.unitsString = "Milliseconds";
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Show Function Ledger")) {
                    jRacy.staticSystemData.getGlobalMapping().displayFunctionLedger();
                } else if (string.equals("Close All Sub-Windows")) {
                    jRacy.systemEvents.updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    jRacy.helpWindow.clearText();
                    jRacy.helpWindow.show();
                    jRacy.helpWindow.writeText("This is the mean data window");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("This window shows you the mean values for all functions.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Right click on any function within this window to bring up a popup");
                    jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                    jRacy.helpWindow.writeText("for the function, or to show more details about the function.");
                    jRacy.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MDW03");
        }
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.meanDataWindowPanelRef.repaint();
            } else if (string.equals("colorEvent")) {
                this.meanDataWindowPanelRef.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MDW04");
        }
    }

    private void sortLocalData() {
        try {
            if (this.sortByFunctionID) {
                this.currentSMWMeanData = this.inclusive ? (this.descendingOrder ? this.sMWData.getSMWMeanData("FIdDI") : this.sMWData.getSMWMeanData("FIdAI")) : (this.descendingOrder ? this.sMWData.getSMWMeanData("FIdDE") : this.sMWData.getSMWMeanData("FIdAE"));
            } else if (this.sortByName) {
                this.currentSMWMeanData = this.inclusive ? (this.descendingOrder ? this.sMWData.getSMWMeanData("NDI") : this.sMWData.getSMWMeanData("NAI")) : (this.descendingOrder ? this.sMWData.getSMWMeanData("NDE") : this.sMWData.getSMWMeanData("NAE"));
            } else if (this.sortByMillisecond) {
                this.currentSMWMeanData = this.inclusive ? (this.descendingOrder ? this.sMWData.getSMWMeanData("MDI") : this.sMWData.getSMWMeanData("MAI")) : (this.descendingOrder ? this.sMWData.getSMWMeanData("MDE") : this.sMWData.getSMWMeanData("MAE"));
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MDW05");
        }
    }

    public Vector getStaticMainWindowSystemData() {
        return this.currentSMWMeanData;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public String units() {
        return this.unitsString;
    }

    public int getSliderValue() {
        return this.barLengthSlider.getValue();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MDW06");
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (jRacy.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("The Mean Data Window is closing");
                System.out.println("Clearing resourses for this window.");
            }
            ((Component)this).setVisible(false);
            jRacy.systemEvents.deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MDW07");
        }
    }
}

