/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.StaticMainWindowData;
import jRacy.StaticMainWindowPanel;
import jRacy.StaticSystemData;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class StaticMainWindow
extends JFrame
implements ActionListener,
Observer {
    JFileChooser fileChooser = new JFileChooser();
    private StaticMainWindowPanel sMWPanel;
    private StaticMainWindowData sMWData = new StaticMainWindowData();
    ButtonGroup sortGroup;
    ButtonGroup sortOrderGroup;
    JRadioButtonMenuItem functionIDButton;
    JRadioButtonMenuItem nameButton;
    JRadioButtonMenuItem millisecondButton;
    JRadioButtonMenuItem ascendingButton;
    JRadioButtonMenuItem descendingButton;
    boolean sortByFunctionID = false;
    boolean sortByName = false;
    boolean sortByMillisecond = true;
    boolean descendingOrder = true;
    Vector currentSMWGeneralData = null;
    Vector currentSMWMeanData = null;
    private boolean mShown = false;

    public StaticMainWindow() {
        try {
            this.setTitle("jRacy");
            int n = 650;
            int n2 = 300;
            ((Component)this).setSize(new Dimension(n, n2));
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    StaticMainWindow.this.thisWindowClosing(windowEvent);
                }
            });
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            int n3 = dimension.height;
            int n4 = dimension.width;
            int n5 = (n4 - n) / 2;
            int n6 = (n3 - n2) / 2;
            ((Component)this).setLocation(n5, n6);
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenu jMenu2 = new JMenu("Open ...");
            JMenuItem jMenuItem = new JMenuItem("Pprof Dump File");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("jRacy Output File");
            jMenuItem2.addActionListener(this);
            jMenu2.add(jMenuItem2);
            jMenu.add(jMenu2);
            JMenu jMenu3 = new JMenu("Save ...");
            JMenuItem jMenuItem3 = new JMenuItem("To A jRacy Output File");
            jMenuItem3.addActionListener(this);
            jMenu3.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("jRacy Preferrences");
            jMenuItem4.addActionListener(this);
            jMenu3.add(jMenuItem4);
            jMenu.add(jMenu3);
            JMenuItem jMenuItem5 = new JMenuItem("Edit jRacy Preferences!");
            jMenuItem5.addActionListener(this);
            jMenu.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Exit jRacy!");
            jMenuItem6.addActionListener(this);
            jMenu.add(jMenuItem6);
            JMenu jMenu4 = new JMenu("Options");
            JMenu jMenu5 = new JMenu("Sort by ...");
            this.sortGroup = new ButtonGroup();
            this.functionIDButton = new JRadioButtonMenuItem("function ID", false);
            this.functionIDButton.addActionListener(this);
            this.nameButton = new JRadioButtonMenuItem("name", false);
            this.nameButton.addActionListener(this);
            this.millisecondButton = new JRadioButtonMenuItem("millisecond", true);
            this.millisecondButton.addActionListener(this);
            this.sortGroup.add(this.functionIDButton);
            this.sortGroup.add(this.nameButton);
            this.sortGroup.add(this.millisecondButton);
            jMenu5.add(this.functionIDButton);
            jMenu5.add(this.nameButton);
            jMenu5.add(this.millisecondButton);
            jMenu4.add(jMenu5);
            JMenu jMenu6 = new JMenu("Sort Order");
            this.sortOrderGroup = new ButtonGroup();
            this.ascendingButton = new JRadioButtonMenuItem("Ascending", false);
            this.ascendingButton.addActionListener(this);
            this.descendingButton = new JRadioButtonMenuItem("Descending", true);
            this.descendingButton.addActionListener(this);
            this.sortOrderGroup.add(this.ascendingButton);
            this.sortOrderGroup.add(this.descendingButton);
            jMenu6.add(this.ascendingButton);
            jMenu6.add(this.descendingButton);
            jMenu4.add(jMenu6);
            JMenu jMenu7 = new JMenu("Windows");
            JMenuItem jMenuItem7 = new JMenuItem("Show Function Ledger");
            jMenuItem7.addActionListener(this);
            jMenu7.add(jMenuItem7);
            JMenuItem jMenuItem8 = new JMenuItem("Close All Sub-Windows");
            jMenuItem8.addActionListener(this);
            jMenu7.add(jMenuItem8);
            JMenu jMenu8 = new JMenu("Help");
            JMenuItem jMenuItem9 = new JMenuItem("About Racy");
            jMenuItem9.addActionListener(this);
            jMenu8.add(jMenuItem9);
            JMenuItem jMenuItem10 = new JMenuItem("Show Help Window");
            jMenuItem10.addActionListener(this);
            jMenu8.add(jMenuItem10);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu4);
            jMenuBar.add(jMenu7);
            jMenuBar.add(jMenu8);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.sMWPanel = new StaticMainWindowPanel(this);
            this.sMWPanel.setPreferredSize(new Dimension(600, 300));
            JScrollPane jScrollPane = new JScrollPane(this.sMWPanel);
            jScrollPane.setBorder(border);
            jScrollPane.setPreferredSize(new Dimension(600, 300));
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 0, 1, 1);
            this.sMWPanel.repaint();
            File file = new File("pprof.dat");
            if (file.exists()) {
                System.out.println("Found pprof.dat ... loading");
                jRacy.staticSystemData = new StaticSystemData();
                jRacy.staticSystemData.buildStaticData(file);
                this.sMWData.buildStaticMainWindowDataLists();
                this.sortLocalData();
                this.sMWPanel.repaint();
            } else {
                System.out.println("Did not find pprof.dat!");
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "SMW01");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block54: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block54;
                String string = actionEvent.getActionCommand();
                if (string.equals("Pprof Dump File")) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setCurrentDirectory(new File("."));
                    int n = jFileChooser.showOpenDialog(this);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        if (file != null) {
                            jRacy.staticSystemData = new StaticSystemData();
                            this.sMWData = new StaticMainWindowData();
                            System.out.println("Cleaning the virtual machine memory footprint.");
                            jRacy.runtime.gc();
                            System.out.println("Closing all subwindows.");
                            jRacy.systemEvents.updateRegisteredObjects("subWindowCloseEvent");
                            System.out.println("Building internal data system ... please wait ...");
                            jRacy.staticSystemData.buildStaticData(file);
                            System.out.println("Finished building internal data system.");
                            System.out.println("Building internal lists ... please wait ...");
                            this.sMWData.buildStaticMainWindowDataLists();
                            System.out.println("Finished building internal lists.");
                            jRacy.clrChooser.setHighlightColorFunctionID(-1);
                            jRacy.systemEvents.updateRegisteredObjects("dataSetChangeEvent");
                            System.out.println("Done ... loading complete!");
                            this.sMWPanel.repaint();
                        } else {
                            System.out.println("There was some sort of internal error!");
                        }
                    }
                    break block54;
                }
                if (string.equals("jRacy Output File")) {
                    this.fileChooser.setCurrentDirectory(new File("."));
                    int n = this.fileChooser.showOpenDialog(this);
                    if (n != 0) break block54;
                    File file = this.fileChooser.getSelectedFile();
                    if (file != null) {
                        System.out.println("Closing all subwindows.");
                        jRacy.systemEvents.updateRegisteredObjects("subWindowCloseEvent");
                        try {
                            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                            jRacy.staticSystemData = (StaticSystemData)objectInputStream.readObject();
                        }
                        catch (Exception exception) {
                            jRacy.systemError(null, "SMW02A");
                        }
                        this.sMWData = new StaticMainWindowData();
                        System.out.println("Cleaning the virtual machine memory footprint.");
                        jRacy.runtime.gc();
                        System.out.println("Building internal lists ... please wait ...");
                        this.sMWData.buildStaticMainWindowDataLists();
                        System.out.println("Finished building internal lists.");
                        jRacy.clrChooser.setHighlightColorFunctionID(-1);
                        jRacy.systemEvents.updateRegisteredObjects("dataSetChangeEvent");
                        System.out.println("Done ... loading complete!");
                        this.sMWPanel.repaint();
                        break block54;
                    }
                    JOptionPane.showMessageDialog(this, "No file was selected!", "Error!", 0);
                    break block54;
                }
                if (string.equals("To A jRacy Output File")) {
                    this.fileChooser.setCurrentDirectory(new File("."));
                    int n = this.fileChooser.showSaveDialog(this);
                    if (n == 0) {
                        File file = this.fileChooser.getSelectedFile();
                        if (file != null) {
                            try {
                                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                                objectOutputStream.writeObject(jRacy.staticSystemData);
                                objectOutputStream.close();
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(this, "An error occured whilst trying to save jRacy output file.", "Error!", 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(this, "No filename was given!", "Error!", 0);
                        }
                    }
                } else if (string.equals("jRacy Preferrences")) {
                    this.fileChooser.setCurrentDirectory(new File("."));
                    this.fileChooser.setSelectedFile(new File("jRacyPreferences.dat"));
                    int n = this.fileChooser.showSaveDialog(this);
                    if (n == 0) {
                        File file = this.fileChooser.getSelectedFile();
                        if (file != null) {
                            try {
                                jRacy.clrChooser.setSavedColors();
                                jRacy.jRacyPreferences.setSavedPreferences();
                                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                                objectOutputStream.writeObject(jRacy.savedPreferences);
                                objectOutputStream.close();
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(this, "An error occured whilst trying to save jRacy preferences.", "Error!", 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(this, "No filename was given!", "Error!", 0);
                        }
                    }
                } else if (string.equals("Edit jRacy Preferences!")) {
                    jRacy.jRacyPreferences.showPreferencesWindow();
                } else if (string.equals("Exit jRacy!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("function ID")) {
                    if (this.functionIDButton.isSelected()) {
                        this.sortByFunctionID = true;
                        this.sortByName = false;
                        this.sortByMillisecond = false;
                        this.sortLocalData();
                        this.sMWPanel.repaint();
                    }
                } else if (string.equals("name")) {
                    if (this.nameButton.isSelected()) {
                        this.sortByFunctionID = false;
                        this.sortByName = true;
                        this.sortByMillisecond = false;
                        this.sortLocalData();
                        this.sMWPanel.repaint();
                    }
                } else if (string.equals("millisecond")) {
                    if (this.millisecondButton.isSelected()) {
                        this.sortByFunctionID = false;
                        this.sortByName = false;
                        this.sortByMillisecond = true;
                        this.sortLocalData();
                        this.sMWPanel.repaint();
                    }
                } else if (string.equals("Descending")) {
                    if (this.descendingButton.isSelected()) {
                        this.descendingOrder = true;
                        this.sortLocalData();
                        this.sMWPanel.repaint();
                    }
                } else if (string.equals("Ascending")) {
                    if (this.ascendingButton.isSelected()) {
                        this.descendingOrder = false;
                        this.sortLocalData();
                        this.sMWPanel.repaint();
                    }
                } else if (string.equals("Show Function Ledger")) {
                    if (this.sMWData.isDataLoaded()) {
                        jRacy.staticSystemData.getGlobalMapping().displayFunctionLedger();
                    } else {
                        JOptionPane.showMessageDialog(this, "Sorry, but you must load a pprof data file first!", "Selection Error!", 0);
                    }
                } else if (string.equals("Close All Sub-Windows")) {
                    jRacy.systemEvents.updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    jRacy.helpWindow.show();
                    if (!this.sMWData.isDataLoaded()) {
                        jRacy.helpWindow.writeText("Welcome to jRacy");
                        jRacy.helpWindow.writeText("");
                        jRacy.helpWindow.writeText("The first step is to load a pprof dump file.You can find this option in the file menu.");
                        jRacy.helpWindow.writeText("");
                        jRacy.helpWindow.writeText("To create a pprof dump file, simply run pprof with the -d option, and pipe the output to a file.");
                    } else {
                        jRacy.helpWindow.writeText("Welcome to jRacy");
                        jRacy.helpWindow.writeText("");
                    }
                }
            }
            catch (Exception exception) {
                jRacy.systemError(null, "SMW02");
            }
        }
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.sMWPanel.repaint();
            } else if (string.equals("colorEvent")) {
                this.sMWPanel.repaint();
            } else if (string.equals("dataSetChangeEvent")) {
                this.currentSMWGeneralData = null;
                this.currentSMWMeanData = null;
                this.sortLocalData();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "SMW03");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            jRacy.systemError(null, "SMW04");
        }
    }

    public StaticMainWindowData getSMWData() {
        return this.sMWData;
    }

    private void sortLocalData() {
        try {
            if (this.sortByFunctionID) {
                this.currentSMWGeneralData = this.descendingOrder ? this.sMWData.getSMWGeneralData("FIdDE") : this.sMWData.getSMWGeneralData("FIdAE");
            } else if (this.sortByName) {
                this.currentSMWGeneralData = this.descendingOrder ? this.sMWData.getSMWGeneralData("NDE") : this.sMWData.getSMWGeneralData("NAE");
            } else if (this.sortByMillisecond) {
                this.currentSMWGeneralData = this.descendingOrder ? this.sMWData.getSMWGeneralData("MDE") : this.sMWData.getSMWGeneralData("MAE");
            }
            if (this.sortByFunctionID) {
                this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("FIdDE") : this.sMWData.getSMWMeanData("FIdAE");
            } else if (this.sortByName) {
                this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("NDE") : this.sMWData.getSMWMeanData("NAE");
            } else if (this.sortByMillisecond) {
                this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("MDE") : this.sMWData.getSMWMeanData("MAE");
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "SMW05");
        }
    }

    public Vector getSMWGeneralData() {
        return this.currentSMWGeneralData;
    }

    public Vector getSMWMeanData() {
        return this.currentSMWMeanData;
    }

    public boolean isDataLoaded() {
        try {
            return this.sMWData.isDataLoaded();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "SMW06");
            return false;
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            ((Component)this).setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
        System.exit(0);
    }
}

