/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.FunctionDataWindow;
import jRacy.GlobalContext;
import jRacy.GlobalMapping;
import jRacy.GlobalMappingElement;
import jRacy.GlobalServer;
import jRacy.GlobalThread;
import jRacy.SMWThreadDataElement;
import jRacy.StaticMainWindowData;
import jRacy.ThreadDataWindow;
import jRacy.jRacy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ThreadDataWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
ChangeListener {
    int xPanelSize = 700;
    int yPanelSize = 450;
    private Vector staticNodeList;
    private int newXPanelSize = 0;
    private int newYPanelSize = 0;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int defaultBarLength = 250;
    private int maxXLength = 0;
    private int numberOfColors = 0;
    private int serverNumber = -1;
    private int contextNumber = -1;
    private int threadNumber = -1;
    private ThreadDataWindow tDWindow = null;
    private GlobalServer tmpGS = null;
    private Vector tmpGlobalContextList = null;
    private GlobalContext tmpGC = null;
    private Vector tmpGlobalThreadList = null;
    private GlobalThread tmpGT = null;
    private StaticMainWindowData sMWData = null;
    private Vector tmpThreadDataElementList = null;
    private SMWThreadDataElement tmpSMWThreadDataElement = null;
    private JPopupMenu popup = new JPopupMenu();
    private Object clickedOnObject = null;

    public ThreadDataWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDWP01");
        }
    }

    public ThreadDataWindowPanel(int n, int n2, int n3, ThreadDataWindow threadDataWindow, StaticMainWindowData staticMainWindowData) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.serverNumber = n;
            this.contextNumber = n2;
            this.threadNumber = n3;
            this.staticNodeList = jRacy.staticSystemData.getStaticServerList();
            this.tDWindow = threadDataWindow;
            this.sMWData = staticMainWindowData;
            JMenuItem jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change Function Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            FontMetrics fontMetrics;
            Font font;
            super.paintComponent(graphics);
            this.numberOfColors = jRacy.clrChooser.getNumberOfColors();
            if (!jRacy.jRacyPreferences.areBarDetailsSet()) {
                font = new Font(jRacy.jRacyPreferences.getJRacyFont(), jRacy.jRacyPreferences.getFontStyle(), 12);
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics(font);
                int n = fontMetrics.getAscent();
                int n2 = fontMetrics.getMaxDescent();
                int n3 = n + n2;
                jRacy.jRacyPreferences.setBarDetails(n, n3 + 5);
                jRacy.jRacyPreferences.setSliders(n, n3 + 5);
            }
            this.barSpacing = jRacy.jRacyPreferences.getBarSpacing();
            this.barHeight = jRacy.jRacyPreferences.getBarHeight();
            font = new Font(jRacy.jRacyPreferences.getJRacyFont(), jRacy.jRacyPreferences.getFontStyle(), this.barHeight);
            graphics.setFont(font);
            fontMetrics = graphics.getFontMetrics(font);
            boolean bl = false;
            int n = 0;
            int n4 = 0;
            int n5 = 0;
            n = 0;
            this.tmpThreadDataElementList = this.tDWindow.getStaticMainWindowSystemData();
            double d = 0.0;
            Rectangle rectangle = graphics.getClipBounds();
            int n6 = (int)rectangle.getY();
            int n7 = (int)((double)n6 + rectangle.getHeight());
            int n8 = 0;
            int n9 = 0;
            this.tmpGS = (GlobalServer)this.staticNodeList.elementAt(this.serverNumber);
            this.tmpGlobalContextList = this.tmpGS.getContextList();
            this.tmpGC = (GlobalContext)this.tmpGlobalContextList.elementAt(this.contextNumber);
            this.tmpGlobalThreadList = this.tmpGC.getThreadList();
            this.tmpGT = (GlobalThread)this.tmpGlobalThreadList.elementAt(this.threadNumber);
            if (rectangle != null) {
                this.newYPanelSize = n + (this.tmpThreadDataElementList.size() + 1) * this.barSpacing;
                n8 = (n6 - n) / this.barSpacing - 1;
                n9 = (n7 - n) / this.barSpacing + 1;
                if (n8 < 0) {
                    n8 = 0;
                }
                if (n9 < 0) {
                    n9 = 0;
                }
                if (n8 > this.tmpThreadDataElementList.size() - 1) {
                    n8 = this.tmpThreadDataElementList.size() - 1;
                }
                if (n9 > this.tmpThreadDataElementList.size() - 1) {
                    n9 = this.tmpThreadDataElementList.size() - 1;
                }
                n += n8 * this.barSpacing;
                if (this.tDWindow.isInclusive()) {
                    double d2 = this.tmpGT.getMaxInclusivePercentValue();
                    int n10 = (int)(d2 / 100.0 * (double)this.defaultBarLength);
                    n5 = n10 + 60;
                    if (this.tDWindow.isPercent()) {
                        String string = new String(d2 + "%");
                        int n11 = fontMetrics.stringWidth(string);
                        n5 += n11;
                        int n12 = n8;
                        while (n12 <= n9) {
                            this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n12);
                            n += this.barSpacing;
                            double d3 = this.tmpSMWThreadDataElement.getInclusivePercentValue();
                            double d4 = d3 / 100.0;
                            int n13 = (int)(d4 * (double)this.defaultBarLength);
                            if (n13 == 0) {
                                n13 = 1;
                            }
                            Color color = this.tmpSMWThreadDataElement.getFunctionColor();
                            graphics.setColor(color);
                            if (n13 > 2 && this.barHeight > 2) {
                                graphics.fillRect(n5 - n13 + 1, n - this.barHeight + 1, n13 - 1, this.barHeight - 1);
                                if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                    graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                    graphics.drawRect(n5 - n13, n - this.barHeight, n13, this.barHeight);
                                    graphics.drawRect(n5 - n13 + 1, n - this.barHeight + 1, n13 - 2, this.barHeight - 2);
                                } else {
                                    graphics.setColor(Color.black);
                                    graphics.drawRect(n5 - n13, n - this.barHeight, n13, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                    graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                } else {
                                    color = this.tmpSMWThreadDataElement.getFunctionColor();
                                    graphics.setColor(color);
                                }
                                graphics.fillRect(n5 - n13, n - this.barHeight, n13, this.barHeight);
                            }
                            graphics.setColor(Color.black);
                            string = new String(d3 + "%");
                            n11 = fontMetrics.stringWidth(string);
                            int n14 = n5 - n13 - n11 - 5;
                            graphics.drawString(d3 + "%", n14, n);
                            string = this.tmpSMWThreadDataElement.getFunctionName();
                            graphics.drawString(string, n5 + 5, n);
                            n11 = n5 + fontMetrics.stringWidth(string) + 5;
                            if (n4 < n11) {
                                n4 = n11 + 15;
                            }
                            this.tmpSMWThreadDataElement.setTDWDrawCoords(n14, n11, n - this.barHeight, n);
                            ++n12;
                        }
                    } else {
                        int n15;
                        String string;
                        double d5 = this.tmpGT.getMaxInclusiveValue();
                        if (this.tDWindow.units().equals("Seconds")) {
                            string = new String(Double.toString(d5 / 1000000.0));
                            n15 = fontMetrics.stringWidth(string);
                            n5 += n15;
                        } else if (this.tDWindow.units().equals("Milliseconds")) {
                            string = new String(Double.toString(d5 / 1000.0));
                            n15 = fontMetrics.stringWidth(string);
                            n5 += n15;
                        } else {
                            string = new String(Double.toString(d5));
                            n15 = fontMetrics.stringWidth(string);
                            n5 += n15;
                        }
                        int n16 = n8;
                        while (n16 <= n9) {
                            int n17;
                            this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n16);
                            n += this.barSpacing;
                            d5 = this.tmpSMWThreadDataElement.getInclusivePercentValue();
                            double d6 = d5 / 100.0;
                            int n18 = (int)(d6 * (double)this.defaultBarLength);
                            if (n18 == 0) {
                                n18 = 1;
                            }
                            Color color = this.tmpSMWThreadDataElement.getFunctionColor();
                            graphics.setColor(color);
                            if (n18 > 2 && this.barHeight > 2) {
                                graphics.fillRect(n5 - n18 + 1, n - this.barHeight + 1, n18 - 1, this.barHeight - 1);
                                if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                    graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                    graphics.drawRect(n5 - n18, n - this.barHeight, n18, this.barHeight);
                                    graphics.drawRect(n5 - n18 + 1, n - this.barHeight + 1, n18 - 2, this.barHeight - 2);
                                } else {
                                    graphics.setColor(Color.black);
                                    graphics.drawRect(n5 - n18, n - this.barHeight, n18, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                    graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                } else {
                                    color = this.tmpSMWThreadDataElement.getFunctionColor();
                                    graphics.setColor(color);
                                }
                                graphics.fillRect(n5 - n18, n - this.barHeight, n18, this.barHeight);
                            }
                            graphics.setColor(Color.black);
                            d5 = this.tmpSMWThreadDataElement.getInclusiveValue();
                            if (this.tDWindow.units().equals("Seconds")) {
                                string = new String(Double.toString(d5 / 1000000.0));
                                n15 = fontMetrics.stringWidth(string);
                                n17 = n5 - n18 - n15 - 5;
                                graphics.drawString(Double.toString(d5 / 1000000.0), n17, n);
                            } else if (this.tDWindow.units().equals("Milliseconds")) {
                                string = new String(Double.toString(d5 / 1000.0));
                                n15 = fontMetrics.stringWidth(string);
                                n17 = n5 - n18 - n15 - 5;
                                graphics.drawString(Double.toString(d5 / 1000.0), n17, n);
                            } else {
                                string = new String(Double.toString(d5));
                                n15 = fontMetrics.stringWidth(string);
                                n17 = n5 - n18 - n15 - 5;
                                graphics.drawString(Double.toString(d5), n17, n);
                            }
                            string = this.tmpSMWThreadDataElement.getFunctionName();
                            graphics.drawString(string, n5 + 5, n);
                            n15 = n5 + fontMetrics.stringWidth(string) + 5;
                            if (n4 < n15) {
                                n4 = n15 + 15;
                            }
                            this.tmpSMWThreadDataElement.setTDWDrawCoords(n17, n15, n - this.barHeight, n);
                            ++n16;
                        }
                    }
                } else {
                    double d7 = this.tmpGT.getMaxExclusivePercentValue();
                    int n19 = (int)(d7 / 100.0 * (double)this.defaultBarLength);
                    n5 = n19 + 60;
                    if (this.tDWindow.isPercent()) {
                        String string = new String(d7 + "%");
                        int n20 = fontMetrics.stringWidth(string);
                        n5 += n20;
                        int n21 = n8;
                        while (n21 <= n9) {
                            this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n21);
                            n += this.barSpacing;
                            double d8 = this.tmpSMWThreadDataElement.getExclusivePercentValue();
                            double d9 = d8 / 100.0;
                            int n22 = (int)(d9 * (double)this.defaultBarLength);
                            if (n22 == 0) {
                                n22 = 1;
                            }
                            Color color = this.tmpSMWThreadDataElement.getFunctionColor();
                            graphics.setColor(color);
                            if (n22 > 2 && this.barHeight > 2) {
                                graphics.fillRect(n5 - n22 + 1, n - this.barHeight + 1, n22 - 1, this.barHeight - 1);
                                if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                    graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                    graphics.drawRect(n5 - n22, n - this.barHeight, n22, this.barHeight);
                                    graphics.drawRect(n5 - n22 + 1, n - this.barHeight + 1, n22 - 2, this.barHeight - 2);
                                } else {
                                    graphics.setColor(Color.black);
                                    graphics.drawRect(n5 - n22, n - this.barHeight, n22, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                    graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                } else {
                                    color = this.tmpSMWThreadDataElement.getFunctionColor();
                                    graphics.setColor(color);
                                }
                                graphics.fillRect(n5 - n22, n - this.barHeight, n22, this.barHeight);
                            }
                            graphics.setColor(Color.black);
                            string = new String(d8 + "%");
                            n20 = fontMetrics.stringWidth(string);
                            int n23 = n5 - n22 - n20 - 5;
                            graphics.drawString(d8 + "%", n23, n);
                            string = this.tmpSMWThreadDataElement.getFunctionName();
                            graphics.drawString(string, n5 + 5, n);
                            n20 = n5 + fontMetrics.stringWidth(string) + 5;
                            if (n4 < n20) {
                                n4 = n20 + 15;
                            }
                            this.tmpSMWThreadDataElement.setTDWDrawCoords(n23, n20, n - this.barHeight, n);
                            ++n21;
                        }
                    } else {
                        int n24;
                        String string;
                        double d10 = this.tmpGT.getMaxExclusiveValue();
                        if (this.tDWindow.units().equals("Seconds")) {
                            string = new String(Double.toString(d10 / 1000000.0));
                            n24 = fontMetrics.stringWidth(string);
                            n5 += n24;
                        } else if (this.tDWindow.units().equals("Milliseconds")) {
                            string = new String(Double.toString(d10 / 1000.0));
                            n24 = fontMetrics.stringWidth(string);
                            n5 += n24;
                        } else {
                            string = new String(Double.toString(d10));
                            n24 = fontMetrics.stringWidth(string);
                            n5 += n24;
                        }
                        int n25 = n8;
                        while (n25 <= n9) {
                            int n26;
                            this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n25);
                            n += this.barSpacing;
                            d10 = this.tmpSMWThreadDataElement.getExclusivePercentValue();
                            double d11 = d10 / 100.0;
                            int n27 = (int)(d11 * (double)this.defaultBarLength);
                            if (n27 == 0) {
                                n27 = 1;
                            }
                            Color color = this.tmpSMWThreadDataElement.getFunctionColor();
                            graphics.setColor(color);
                            if (n27 > 2 && this.barHeight > 2) {
                                graphics.fillRect(n5 - n27 + 1, n - this.barHeight + 1, n27 - 1, this.barHeight - 1);
                                if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                    graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                    graphics.drawRect(n5 - n27, n - this.barHeight, n27, this.barHeight);
                                    graphics.drawRect(n5 - n27 + 1, n - this.barHeight + 1, n27 - 2, this.barHeight - 2);
                                } else {
                                    graphics.setColor(Color.black);
                                    graphics.drawRect(n5 - n27, n - this.barHeight, n27, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                    graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                } else {
                                    color = this.tmpSMWThreadDataElement.getFunctionColor();
                                    graphics.setColor(color);
                                }
                                graphics.fillRect(n5 - n27, n - this.barHeight, n27, this.barHeight);
                            }
                            graphics.setColor(Color.black);
                            d10 = this.tmpSMWThreadDataElement.getExclusiveValue();
                            if (this.tDWindow.units().equals("Seconds")) {
                                string = new String(Double.toString(d10 / 1000000.0));
                                n24 = fontMetrics.stringWidth(string);
                                n26 = n5 - n27 - n24 - 5;
                                graphics.drawString(Double.toString(d10 / 1000000.0), n26, n);
                            } else if (this.tDWindow.units().equals("Milliseconds")) {
                                string = new String(Double.toString(d10 / 1000.0));
                                n24 = fontMetrics.stringWidth(string);
                                n26 = n5 - n27 - n24 - 5;
                                graphics.drawString(Double.toString(d10 / 1000.0), n26, n);
                            } else {
                                string = new String(Double.toString(d10));
                                n24 = fontMetrics.stringWidth(string);
                                n26 = n5 - n27 - n24 - 5;
                                graphics.drawString(Double.toString(d10), n26, n);
                            }
                            string = this.tmpSMWThreadDataElement.getFunctionName();
                            graphics.drawString(string, n5 + 5, n);
                            n24 = n5 + fontMetrics.stringWidth(string) + 5;
                            if (n4 < n24) {
                                n4 = n24 + 15;
                            }
                            this.tmpSMWThreadDataElement.setTDWDrawCoords(n26, n24, n - this.barHeight, n);
                            ++n25;
                        }
                    }
                }
            } else if (this.tDWindow.isInclusive()) {
                double d12 = this.tmpGT.getMaxInclusivePercentValue();
                int n28 = (int)(d12 / 100.0 * (double)this.defaultBarLength);
                n5 = n28 + 60;
                if (this.tDWindow.isPercent()) {
                    String string = new String(d12 + "%");
                    int n29 = fontMetrics.stringWidth(string);
                    n5 += n29;
                    Enumeration enumeration = this.tmpThreadDataElementList.elements();
                    while (enumeration.hasMoreElements()) {
                        n += this.barSpacing;
                        this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration.nextElement();
                        double d13 = this.tmpSMWThreadDataElement.getInclusivePercentValue();
                        double d14 = d13 / 100.0;
                        int n30 = (int)(d14 * (double)this.defaultBarLength);
                        if (n30 == 0) {
                            n30 = 1;
                        }
                        Color color = this.tmpSMWThreadDataElement.getFunctionColor();
                        graphics.setColor(color);
                        if (n30 > 2 && this.barHeight > 2) {
                            graphics.fillRect(n5 - n30 + 1, n - this.barHeight + 1, n30 - 1, this.barHeight - 1);
                            if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                graphics.drawRect(n5 - n30, n - this.barHeight, n30, this.barHeight);
                                graphics.drawRect(n5 - n30 + 1, n - this.barHeight + 1, n30 - 2, this.barHeight - 2);
                            } else {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n5 - n30, n - this.barHeight, n30, this.barHeight);
                            }
                        } else {
                            if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                graphics.setColor(jRacy.clrChooser.getHighlightColor());
                            } else {
                                color = this.tmpSMWThreadDataElement.getFunctionColor();
                                graphics.setColor(color);
                            }
                            graphics.fillRect(n5 - n30, n - this.barHeight, n30, this.barHeight);
                        }
                        graphics.setColor(Color.black);
                        string = new String(d13 + "%");
                        n29 = fontMetrics.stringWidth(string);
                        int n31 = n5 - n30 - n29 - 5;
                        graphics.drawString(d13 + "%", n31, n);
                        string = this.tmpSMWThreadDataElement.getFunctionName();
                        graphics.drawString(string, n5 + 5, n);
                        n29 = n5 + fontMetrics.stringWidth(string) + 5;
                        if (n4 < n29) {
                            n4 = n29 + 15;
                        }
                        this.tmpSMWThreadDataElement.setTDWDrawCoords(n31, n29, n - this.barHeight, n);
                    }
                } else {
                    int n32;
                    String string;
                    double d15 = this.tmpGT.getMaxInclusiveValue();
                    if (this.tDWindow.units().equals("Seconds")) {
                        string = new String(Double.toString(d15 / 1000000.0));
                        n32 = fontMetrics.stringWidth(string);
                        n5 += n32;
                    } else if (this.tDWindow.units().equals("Milliseconds")) {
                        string = new String(Double.toString(d15 / 1000.0));
                        n32 = fontMetrics.stringWidth(string);
                        n5 += n32;
                    } else {
                        string = new String(Double.toString(d15));
                        n32 = fontMetrics.stringWidth(string);
                        n5 += n32;
                    }
                    Enumeration enumeration = this.tmpThreadDataElementList.elements();
                    while (enumeration.hasMoreElements()) {
                        int n33;
                        n += this.barSpacing;
                        this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration.nextElement();
                        d15 = this.tmpSMWThreadDataElement.getInclusivePercentValue();
                        double d16 = d15 / 100.0;
                        int n34 = (int)(d16 * (double)this.defaultBarLength);
                        if (n34 == 0) {
                            n34 = 1;
                        }
                        Color color = this.tmpSMWThreadDataElement.getFunctionColor();
                        graphics.setColor(color);
                        if (n34 > 2 && this.barHeight > 2) {
                            graphics.fillRect(n5 - n34 + 1, n - this.barHeight + 1, n34 - 1, this.barHeight - 1);
                            if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                graphics.drawRect(n5 - n34, n - this.barHeight, n34, this.barHeight);
                                graphics.drawRect(n5 - n34 + 1, n - this.barHeight + 1, n34 - 2, this.barHeight - 2);
                            } else {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n5 - n34, n - this.barHeight, n34, this.barHeight);
                            }
                        } else {
                            if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                graphics.setColor(jRacy.clrChooser.getHighlightColor());
                            } else {
                                color = this.tmpSMWThreadDataElement.getFunctionColor();
                                graphics.setColor(color);
                            }
                            graphics.fillRect(n5 - n34, n - this.barHeight, n34, this.barHeight);
                        }
                        graphics.setColor(Color.black);
                        d15 = this.tmpSMWThreadDataElement.getInclusiveValue();
                        if (this.tDWindow.units().equals("Seconds")) {
                            string = new String(Double.toString(d15 / 1000000.0));
                            n32 = fontMetrics.stringWidth(string);
                            n33 = n5 - n34 - n32 - 5;
                            graphics.drawString(Double.toString(d15 / 1000000.0), n33, n);
                        } else if (this.tDWindow.units().equals("Milliseconds")) {
                            string = new String(Double.toString(d15 / 1000.0));
                            n32 = fontMetrics.stringWidth(string);
                            n33 = n5 - n34 - n32 - 5;
                            graphics.drawString(Double.toString(d15 / 1000.0), n33, n);
                        } else {
                            string = new String(Double.toString(d15));
                            n32 = fontMetrics.stringWidth(string);
                            n33 = n5 - n34 - n32 - 5;
                            graphics.drawString(Double.toString(d15), n33, n);
                        }
                        string = this.tmpSMWThreadDataElement.getFunctionName();
                        graphics.drawString(string, n5 + 5, n);
                        n32 = n5 + fontMetrics.stringWidth(string) + 5;
                        if (n4 < n32) {
                            n4 = n32 + 15;
                        }
                        this.tmpSMWThreadDataElement.setTDWDrawCoords(n33, n32, n - this.barHeight, n);
                    }
                }
            } else {
                double d17 = this.tmpGT.getMaxExclusivePercentValue();
                int n35 = (int)(d17 / 100.0 * (double)this.defaultBarLength);
                n5 = n35 + 60;
                if (this.tDWindow.isPercent()) {
                    String string = new String(d17 + "%");
                    int n36 = fontMetrics.stringWidth(string);
                    n5 += n36;
                    Enumeration enumeration = this.tmpThreadDataElementList.elements();
                    while (enumeration.hasMoreElements()) {
                        n += this.barSpacing;
                        this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration.nextElement();
                        double d18 = this.tmpSMWThreadDataElement.getExclusivePercentValue();
                        double d19 = d18 / 100.0;
                        int n37 = (int)(d19 * (double)this.defaultBarLength);
                        if (n37 == 0) {
                            n37 = 1;
                        }
                        Color color = this.tmpSMWThreadDataElement.getFunctionColor();
                        graphics.setColor(color);
                        if (n37 > 2 && this.barHeight > 2) {
                            graphics.fillRect(n5 - n37 + 1, n - this.barHeight + 1, n37 - 1, this.barHeight - 1);
                            if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                graphics.drawRect(n5 - n37, n - this.barHeight, n37, this.barHeight);
                                graphics.drawRect(n5 - n37 + 1, n - this.barHeight + 1, n37 - 2, this.barHeight - 2);
                            } else {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n5 - n37, n - this.barHeight, n37, this.barHeight);
                            }
                        } else {
                            if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                graphics.setColor(jRacy.clrChooser.getHighlightColor());
                            } else {
                                color = this.tmpSMWThreadDataElement.getFunctionColor();
                                graphics.setColor(color);
                            }
                            graphics.fillRect(n5 - n37, n - this.barHeight, n37, this.barHeight);
                        }
                        graphics.setColor(Color.black);
                        string = new String(d18 + "%");
                        n36 = fontMetrics.stringWidth(string);
                        int n38 = n5 - n37 - n36 - 5;
                        graphics.drawString(d18 + "%", n38, n);
                        string = this.tmpSMWThreadDataElement.getFunctionName();
                        graphics.drawString(string, n5 + 5, n);
                        n36 = n5 + fontMetrics.stringWidth(string) + 5;
                        if (n4 < n36) {
                            n4 = n36 + 15;
                        }
                        this.tmpSMWThreadDataElement.setTDWDrawCoords(n38, n36, n - this.barHeight, n);
                    }
                } else {
                    int n39;
                    String string;
                    double d20 = this.tmpGT.getMaxExclusiveValue();
                    if (this.tDWindow.units().equals("Seconds")) {
                        string = new String(Double.toString(d20 / 1000000.0));
                        n39 = fontMetrics.stringWidth(string);
                        n5 += n39;
                    } else if (this.tDWindow.units().equals("Milliseconds")) {
                        string = new String(Double.toString(d20 / 1000.0));
                        n39 = fontMetrics.stringWidth(string);
                        n5 += n39;
                    } else {
                        string = new String(Double.toString(d20));
                        n39 = fontMetrics.stringWidth(string);
                        n5 += n39;
                    }
                    Enumeration enumeration = this.tmpThreadDataElementList.elements();
                    while (enumeration.hasMoreElements()) {
                        int n40;
                        n += this.barSpacing;
                        this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration.nextElement();
                        d20 = this.tmpSMWThreadDataElement.getExclusivePercentValue();
                        double d21 = d20 / 100.0;
                        int n41 = (int)(d21 * (double)this.defaultBarLength);
                        if (n41 == 0) {
                            n41 = 1;
                        }
                        Color color = this.tmpSMWThreadDataElement.getFunctionColor();
                        graphics.setColor(color);
                        if (n41 > 2 && this.barHeight > 2) {
                            graphics.fillRect(n5 - n41 + 1, n - this.barHeight + 1, n41 - 1, this.barHeight - 1);
                            if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                graphics.drawRect(n5 - n41, n - this.barHeight, n41, this.barHeight);
                                graphics.drawRect(n5 - n41 + 1, n - this.barHeight + 1, n41 - 2, this.barHeight - 2);
                            } else {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n5 - n41, n - this.barHeight, n41, this.barHeight);
                            }
                        } else {
                            if (this.tmpSMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                graphics.setColor(jRacy.clrChooser.getHighlightColor());
                            } else {
                                color = this.tmpSMWThreadDataElement.getFunctionColor();
                                graphics.setColor(color);
                            }
                            graphics.fillRect(n5 - n41, n - this.barHeight, n41, this.barHeight);
                        }
                        graphics.setColor(Color.black);
                        d20 = this.tmpSMWThreadDataElement.getExclusiveValue();
                        if (this.tDWindow.units().equals("Seconds")) {
                            string = new String(Double.toString(d20 / 1000000.0));
                            n39 = fontMetrics.stringWidth(string);
                            n40 = n5 - n41 - n39 - 5;
                            graphics.drawString(Double.toString(d20 / 1000000.0), n40, n);
                        } else if (this.tDWindow.units().equals("Milliseconds")) {
                            string = new String(Double.toString(d20 / 1000.0));
                            n39 = fontMetrics.stringWidth(string);
                            n40 = n5 - n41 - n39 - 5;
                            graphics.drawString(Double.toString(d20 / 1000.0), n40, n);
                        } else {
                            string = new String(Double.toString(d20));
                            n39 = fontMetrics.stringWidth(string);
                            n40 = n5 - n41 - n39 - 5;
                            graphics.drawString(Double.toString(d20), n40, n);
                        }
                        string = this.tmpSMWThreadDataElement.getFunctionName();
                        graphics.drawString(string, n5 + 5, n);
                        n39 = n5 + fontMetrics.stringWidth(string) + 5;
                        if (n4 < n39) {
                            n4 = n39 + 15;
                        }
                        this.tmpSMWThreadDataElement.setTDWDrawCoords(n40, n39, n - this.barHeight, n);
                    }
                }
            }
            if (this.newYPanelSize >= this.yPanelSize || n4 >= this.xPanelSize) {
                this.yPanelSize = this.newYPanelSize + 1;
                this.xPanelSize = n4 + 1;
                this.revalidate();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDWP03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            SMWThreadDataElement sMWThreadDataElement = null;
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        jRacy.clrChooser.setHighlightColorFunctionID(sMWThreadDataElement.getFunctionID());
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(sMWThreadDataElement.getFunctionName(), this.sMWData);
                        jRacy.systemEvents.addObserver(functionDataWindow);
                        functionDataWindow.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        n = ((SMWThreadDataElement)this.clickedOnObject).getFunctionID();
                    }
                    GlobalMapping globalMapping = jRacy.staticSystemData.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n);
                    Color color = globalMappingElement.getFunctionColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        globalMappingElement.setSpecificColor(color);
                        globalMappingElement.setColorFlag(true);
                        jRacy.systemEvents.updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        n = ((SMWThreadDataElement)this.clickedOnObject).getFunctionID();
                    }
                    GlobalMapping globalMapping = jRacy.staticSystemData.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n);
                    globalMappingElement.setColorFlag(false);
                    jRacy.systemEvents.updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            Enumeration enumeration = this.tmpThreadDataElementList.elements();
            while (enumeration.hasMoreElements()) {
                this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration.nextElement();
                if (n2 > this.tmpSMWThreadDataElement.getTDWYEnd()) continue;
                if (n2 >= this.tmpSMWThreadDataElement.getTDWYBeg() && n >= this.tmpSMWThreadDataElement.getTDWXBeg() && n <= this.tmpSMWThreadDataElement.getTDWXEnd()) {
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = this.tmpSMWThreadDataElement;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                        return;
                    }
                    if (jRacy.clrChooser.getHighlightColorFunctionID() == -1) {
                        jRacy.clrChooser.setHighlightColorFunctionID(this.tmpSMWThreadDataElement.getFunctionID());
                    } else if (jRacy.clrChooser.getHighlightColorFunctionID() != this.tmpSMWThreadDataElement.getFunctionID()) {
                        jRacy.clrChooser.setHighlightColorFunctionID(this.tmpSMWThreadDataElement.getFunctionID());
                    } else {
                        jRacy.clrChooser.setHighlightColorFunctionID(-1);
                    }
                    return;
                }
                return;
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDWP05");
            System.out.println("Please email Robert Bell at: bertie@cs.uoregon.edu");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            int n = this.tDWindow.getSliderValue();
            this.defaultBarLength = 250 * n;
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDWP06");
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }
}

