/*	
	StaticMainWindow.java

	Title:			jRacy
	Author:			Robert Bell
	Description:	
*/

package jRacy;

import java.util.*;
import java.lang.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.colorchooser.*;

public class StaticMainWindow extends JFrame implements ActionListener, Observer  
{	
	//******************************
	//Instance data.
	//******************************
	
	//Create a file chooser to allow the user to select files for loading data.
	JFileChooser fileChooser = new JFileChooser();
		
	//References for some of the componants for this frame.
	private StaticMainWindowPanel sMWPanel;
	private StaticMainWindowData sMWData = new StaticMainWindowData();
	
	ButtonGroup sortGroup;
	ButtonGroup sortOrderGroup;
	
	JRadioButtonMenuItem functionIDButton;
	JRadioButtonMenuItem nameButton;
	JRadioButtonMenuItem millisecondButton;
	
	JRadioButtonMenuItem ascendingButton;
	JRadioButtonMenuItem descendingButton;
	
	boolean sortByFunctionID = false;
	boolean sortByName = false;
	boolean sortByMillisecond = true;
	
	boolean descendingOrder = true;
	
	
	//Local data
 	Vector currentSMWGeneralData = null;
 	Vector currentSMWMeanData = null;
	
	
	//******************************
	//End - Instance data.
	//******************************
	
	
	public StaticMainWindow()
	{
		try{
			//Window Stuff.
			setTitle("jRacy");
			
			int windowWidth = 650;
			int windowHeight = 300;
			setSize(new java.awt.Dimension(windowWidth, windowHeight));
			
			//Add some window listener code
			addWindowListener(new java.awt.event.WindowAdapter() {
				public void windowClosing(java.awt.event.WindowEvent evt) {
					thisWindowClosing(evt);
				}
			});
			
			//Grab the screen size.
			Toolkit tk = Toolkit.getDefaultToolkit();
			Dimension screenDimension = tk.getScreenSize();
			int screenHeight = screenDimension.height;
			int screenWidth = screenDimension.width;
			
			//Set the window to come up in the center of the screen.
			int xPosition = (screenWidth - windowWidth) / 2;
			int yPosition = (screenHeight - windowHeight) / 2;
			
			setLocation(xPosition, yPosition);
			
			//End - Window Stuff.

			//******************************
			//Code to generate the menus.
			//******************************
			
			
			JMenuBar mainMenu = new JMenuBar();
			
			//******************************
			//File menu.
			//******************************
			JMenu fileMenu = new JMenu("File");
			
			
			//Add a submenu.
			JMenu openMenu = new JMenu("Open ...");
				//Add a menu item.
				JMenuItem openPprofDumpFileItem = new JMenuItem("Pprof Dump File");
				openPprofDumpFileItem.addActionListener(this);
				openMenu.add(openPprofDumpFileItem);
				
				
				//Add a menu item.
				JMenuItem openjRacyOutputItem = new JMenuItem("jRacy Output File");
				openjRacyOutputItem.addActionListener(this);
				openMenu.add(openjRacyOutputItem);
				
			fileMenu.add(openMenu);
			//End submenu.
			
			//Add a submenu.
			JMenu saveMenu = new JMenu("Save ...");
				//Add a menu item.
				JMenuItem savejRacyDataFileFileItem = new JMenuItem("To A jRacy Output File");
				savejRacyDataFileFileItem.addActionListener(this);
				saveMenu.add(savejRacyDataFileFileItem);
				
				
				//Add a menu item.
				JMenuItem savejRacyPreferencesItem = new JMenuItem("jRacy Preferrences");
				savejRacyPreferencesItem.addActionListener(this);
				saveMenu.add(savejRacyPreferencesItem);
				
			fileMenu.add(saveMenu);
			//End submenu.
			
			
			//Add a menu item.
			JMenuItem editPrefItem = new JMenuItem("Edit jRacy Preferences!");
			editPrefItem.addActionListener(this);
			fileMenu.add(editPrefItem);
			
			
			//Add a menu item.
			JMenuItem exitItem = new JMenuItem("Exit jRacy!");
			exitItem.addActionListener(this);
			fileMenu.add(exitItem);
			//******************************
			//End - File menu.
			//******************************
			
			//******************************
			//Options menu.
			//******************************
			JMenu optionsMenu = new JMenu("Options");
			
			//Add a submenu.
			JMenu sortMenu = new JMenu("Sort by ...");
			sortGroup = new ButtonGroup();
			
			functionIDButton = new JRadioButtonMenuItem("function ID", false);
			//Add a listener for this radio button.
			functionIDButton.addActionListener(this);
			
			nameButton = new JRadioButtonMenuItem("name", false);
			//Add a listener for this radio button.
			nameButton.addActionListener(this);
			
			millisecondButton = new JRadioButtonMenuItem("millisecond", true);
			//Add a listener for this radio button.
			millisecondButton.addActionListener(this);
			
			sortGroup.add(functionIDButton);
			sortGroup.add(nameButton);
			sortGroup.add(millisecondButton);
			
			sortMenu.add(functionIDButton);
			sortMenu.add(nameButton);
			sortMenu.add(millisecondButton);
			optionsMenu.add(sortMenu);
			//End Submenu.
			
			//Add a submenu.
			JMenu sortOrderMenu = new JMenu("Sort Order");
			sortOrderGroup = new ButtonGroup();
			
			ascendingButton = new JRadioButtonMenuItem("Ascending", false);
			//Add a listener for this radio button.
			ascendingButton.addActionListener(this);
			
			descendingButton = new JRadioButtonMenuItem("Descending", true);
			//Add a listener for this radio button.
			descendingButton.addActionListener(this);
			
			sortOrderGroup.add(ascendingButton);
			sortOrderGroup.add(descendingButton);
			
			sortOrderMenu.add(ascendingButton);
			sortOrderMenu.add(descendingButton);
			optionsMenu.add(sortOrderMenu);
			//End Submenu.
			
			//******************************
			//End - Options menu.
			//******************************
			
			
			//******************************
			//Window menu.
			//******************************
			JMenu windowsMenu = new JMenu("Windows");
			
			//Add a submenu.
			JMenuItem functionLedgerItem = new JMenuItem("Show Function Ledger");
			functionLedgerItem.addActionListener(this);
			windowsMenu.add(functionLedgerItem);
			
			//Add a submenu.
			JMenuItem closeAllSubwindowsItem = new JMenuItem("Close All Sub-Windows");
			closeAllSubwindowsItem.addActionListener(this);
			windowsMenu.add(closeAllSubwindowsItem);
			//******************************
			//End - Window menu.
			//******************************
			
			
			//******************************
			//Help menu.
			//******************************
			JMenu helpMenu = new JMenu("Help");
			
			//Add a menu item.
			JMenuItem aboutItem = new JMenuItem("About Racy");
			aboutItem.addActionListener(this);
			helpMenu.add(aboutItem);
			
			//Add a menu item.
			JMenuItem showHelpWindowItem = new JMenuItem("Show Help Window");
			showHelpWindowItem.addActionListener(this);
			helpMenu.add(showHelpWindowItem);
			//******************************
			//End - Help menu.
			//******************************
			
			
			//Now, add all the menus to the main menu.
			mainMenu.add(fileMenu);
			mainMenu.add(optionsMenu);
			mainMenu.add(windowsMenu);
			mainMenu.add(helpMenu);
			
			setJMenuBar(mainMenu);
			
			//******************************
			//End - Code to generate the menus.
			//******************************
			
			
			//******************************
			//Create and add the componants.
			//******************************
			//Setting up the layout system for the main window.
			Container contentPane = getContentPane();
			GridBagLayout gbl = new GridBagLayout();
			contentPane.setLayout(gbl);
			GridBagConstraints gbc = new GridBagConstraints();
			gbc.insets = new Insets(5, 5, 5, 5);
			
			//Create some borders.
			Border mainloweredbev = BorderFactory.createLoweredBevelBorder();
			Border mainraisedbev = BorderFactory.createRaisedBevelBorder();
			Border mainempty = BorderFactory.createEmptyBorder();
			
			//**********
			//Panel and ScrollPane definition.
			//**********
			sMWPanel = new StaticMainWindowPanel(this);
			sMWPanel.setPreferredSize(new Dimension(600,300));
			//The scroll panes into which the list shall be placed.
			JScrollPane scrollPane = new JScrollPane(sMWPanel);
			scrollPane.setBorder(mainloweredbev);
			scrollPane.setPreferredSize(new Dimension(600, 300));
			
			//**********
			//End - Panel and ScrollPane definition.
			//**********
			
			gbc.fill = GridBagConstraints.BOTH;
			gbc.anchor = GridBagConstraints.CENTER;
			gbc.weightx = 1;
			gbc.weighty = 1;
			addCompItem(scrollPane, gbc, 0, 0, 1, 1);
			
			//******************************
			//End - Create and add the componants.
			//******************************
			sMWPanel.repaint();
			
			//Ok, now check to see if a "pprof.dat" file exists.  If it does, load it.
			File testForPprofDat = new File("pprof.dat");
			if(testForPprofDat.exists())
			{
				System.out.println("Found pprof.dat ... loading");
				
				//Initialize the static data object.
				jRacy.staticSystemData = new StaticSystemData();
				jRacy.staticSystemData.buildStaticData(testForPprofDat);
				
				//Build the static main window data lists.
				sMWData.buildStaticMainWindowDataLists();
				
				//Sort the local data.
				sortLocalData();
				
				//Call a repaint of the sMWPanel
				sMWPanel.repaint();
			}
			else
			{
				System.out.println("Did not find pprof.dat!");
			}
		}
		catch(Exception e)
		{
			
			jRacy.systemError(null, "SMW01");
		}
			
	}
	
	//******************************
	//Event listener code!!
	//******************************
	
	//ActionListener code.
	public void actionPerformed(ActionEvent evt)
	{
		try{
			Object EventSrc = evt.getSource();
			
			if(EventSrc instanceof JMenuItem)
			{
				String arg = evt.getActionCommand();
				if(arg.equals("Pprof Dump File"))
				{
					//Create a file chooser to allow the user to select the pprof dump file.
					JFileChooser pprofDumpFileChooser = new JFileChooser();
					
					//Set the directory to the current directory.
					pprofDumpFileChooser.setCurrentDirectory(new File("."));
					
					//Bring up the file chooser.
					int resultValue = pprofDumpFileChooser.showOpenDialog(this);
					
					if(resultValue == JFileChooser.APPROVE_OPTION)
					{
						//Try and get the file name.
						File file = pprofDumpFileChooser.getSelectedFile();
						
						//Test to see if valid.
						if(file != null)
						{	
							//Initialize the static data object.
							jRacy.staticSystemData = new StaticSystemData();
							sMWData = new StaticMainWindowData();
							
							//Call the garbage collector.
							System.out.println("Cleaning the virtual machine memory footprint.");
							jRacy.runtime.gc();
							
							//Closing all subwindows.
							System.out.println("Closing all subwindows.");
							jRacy.systemEvents.updateRegisteredObjects("subWindowCloseEvent");
							
							System.out.println("Building internal data system ... please wait ...");
							
							jRacy.staticSystemData.buildStaticData(file);
							
							System.out.println("Finished building internal data system.");
							
							//Build the static main window data lists.
							System.out.println("Building internal lists ... please wait ...");
							sMWData.buildStaticMainWindowDataLists();
							System.out.println("Finished building internal lists.");
							
							//Reset the hightlight colour.
							jRacy.clrChooser.setHighlightColorFunctionID(-1);
							
							//Indicate to the rest of the system that there has been a change of data.
							jRacy.systemEvents.updateRegisteredObjects("dataSetChangeEvent");
							
							System.out.println("Done ... loading complete!");
							
							//Call a repaint of the sMWPanel
							sMWPanel.repaint();
							
						}
						else
						{
							System.out.println("There was some sort of internal error!");
						}
					}
					
				}
				else if(arg.equals("jRacy Output File"))
				{	
					//Set the directory to the current directory.
					fileChooser.setCurrentDirectory(new File("."));
					
					//Bring up the open file chooser.
					int resultValue = fileChooser.showOpenDialog(this);
					
					if(resultValue == JFileChooser.APPROVE_OPTION)
					{
						//Get the file.
						File file = fileChooser.getSelectedFile();
						
						
						//Check to make sure that something was obtained.
						if(file != null)
						{
							
							//Closing all subwindows.
							System.out.println("Closing all subwindows.");
							jRacy.systemEvents.updateRegisteredObjects("subWindowCloseEvent");
							
							
							//Get the data object to which this file refers.
							try
							{
								ObjectInputStream racyDataObjectIn = new ObjectInputStream(new FileInputStream(file));
								jRacy.staticSystemData = (StaticSystemData) racyDataObjectIn.readObject();
							}
							catch(Exception e)
							{
								jRacy.systemError(null, "SMW02A");
							}
							
							sMWData = new StaticMainWindowData();
							
							//Call the garbage collector.
							System.out.println("Cleaning the virtual machine memory footprint.");
							jRacy.runtime.gc();
							
							//Build the static main window data lists.
							System.out.println("Building internal lists ... please wait ...");
							sMWData.buildStaticMainWindowDataLists();
							System.out.println("Finished building internal lists.");
							
							//Reset the hightlight colour.
							jRacy.clrChooser.setHighlightColorFunctionID(-1);
							
							//Indicate to the rest of the system that there has been a change of data.
							jRacy.systemEvents.updateRegisteredObjects("dataSetChangeEvent");
							
							System.out.println("Done ... loading complete!");
							
							//Call a repaint of the sMWPanel
							sMWPanel.repaint();
						}
						else
						{
							//Display an error
							JOptionPane.showMessageDialog(this, "No file was selected!", "Error!"
															  	,JOptionPane.ERROR_MESSAGE);
						}
					}
				}
				else if(arg.equals("To A jRacy Output File"))
				{
					
					
					//Set the directory to the current directory.
					fileChooser.setCurrentDirectory(new File("."));
					
					//Bring up the save file chooser.
					int resultValue = fileChooser.showSaveDialog(this);
					
					if(resultValue == JFileChooser.APPROVE_OPTION)
					{
						//Get the file.
						File file = fileChooser.getSelectedFile();
						
						
						//Check to make sure that something was obtained.
						if(file != null)
						{
							try
							{
								ObjectOutputStream experimentOut = new ObjectOutputStream(new FileOutputStream(file));
								experimentOut.writeObject(jRacy.staticSystemData);
								experimentOut.close();
							
							}
							catch(Exception e)
							{
								//Display an error
								JOptionPane.showMessageDialog(this, "An error occured whilst trying to save jRacy output file.", "Error!"
															  	,JOptionPane.ERROR_MESSAGE);
							}
						}
						else
						{
							//Display an error
							JOptionPane.showMessageDialog(this, "No filename was given!", "Error!"
															  	,JOptionPane.ERROR_MESSAGE);
						}
					}
				}
				else if(arg.equals("jRacy Preferrences"))
				{
					
					
					//Set the directory to the current directory.
					fileChooser.setCurrentDirectory(new File("."));
					fileChooser.setSelectedFile(new File("jRacyPreferences.dat"));
					
					//Bring up the save file chooser.
					int resultValue = fileChooser.showSaveDialog(this);
					
					if(resultValue == JFileChooser.APPROVE_OPTION)
					{
						//Get the file.
						File file = fileChooser.getSelectedFile();
						
						
						//Check to make sure that something was obtained.
						if(file != null)
						{
							try
							{
								//Write to the savedPreferences object.
								jRacy.clrChooser.setSavedColors();
								jRacy.jRacyPreferences.setSavedPreferences();
								
								ObjectOutputStream prefsOut = new ObjectOutputStream(new FileOutputStream(file));
								prefsOut.writeObject(jRacy.savedPreferences);
								prefsOut.close();
							
							}
							catch(Exception e)
							{
								//Display an error
								JOptionPane.showMessageDialog(this, "An error occured whilst trying to save jRacy preferences.", "Error!"
															  	,JOptionPane.ERROR_MESSAGE);
							}
						}
						else
						{
							//Display an error
							JOptionPane.showMessageDialog(this, "No filename was given!", "Error!"
															  	,JOptionPane.ERROR_MESSAGE);
						}
					}
				}
				else if(arg.equals("Edit jRacy Preferences!"))
				{
					jRacy.jRacyPreferences.showPreferencesWindow();
				}
					
				else if(arg.equals("Exit jRacy!"))
				{
					setVisible(false);
					dispose();
					System.exit(0);
				}
				else if(arg.equals("function ID"))
				{
					if(functionIDButton.isSelected())
					{
						sortByFunctionID = true;
						sortByName = false;
						sortByMillisecond = false;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						sMWPanel.repaint();
					}
				}
				else if(arg.equals("name"))
				{
					if(nameButton.isSelected())
					{
						sortByFunctionID = false;
						sortByName = true;
						sortByMillisecond = false;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						sMWPanel.repaint();
					}
				}
				else if(arg.equals("millisecond"))
				{
					if(millisecondButton.isSelected())
					{
						sortByFunctionID = false;
						sortByName = false;
						sortByMillisecond = true;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						sMWPanel.repaint();
					}
				}
				else if(arg.equals("Descending"))
				{
					if(descendingButton.isSelected())
					{
						descendingOrder = true;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						sMWPanel.repaint();
					}
				}
				else if(arg.equals("Ascending"))
				{
					if(ascendingButton.isSelected())
					{
						descendingOrder = false;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						sMWPanel.repaint();
					}
				}
				else if(arg.equals("Show Function Ledger"))
				{
					//Check to make sure that the system data file has been loaded!
					if(sMWData.isDataLoaded())
					{
						//Grab the global mapping and bring up the function ledger window.
						(jRacy.staticSystemData.getGlobalMapping()).displayFunctionLedger();
					}
					else
					{
						//Pop up an error!
						JOptionPane.showMessageDialog(this, "Sorry, but you must load a pprof data file first!", "Selection Error!"
																  ,JOptionPane.ERROR_MESSAGE);
					}
				}
				else if(arg.equals("Close All Sub-Windows"))
				{
					//Close the all subwindows.
					jRacy.systemEvents.updateRegisteredObjects("subWindowCloseEvent");
				}
				else if(arg.equals("About Racy"))
				{
					JOptionPane.showMessageDialog(this, jRacy.getInfoString());
				}
				else if(arg.equals("Show Help Window"))
				{
					//Show the racy help window.
					jRacy.helpWindow.show();
					//See if any system data has been loaded.  Give a helpful hint
					//if it has not.
					if(!(sMWData.isDataLoaded()))
					{
						jRacy.helpWindow.writeText("Welcome to jRacy");
						jRacy.helpWindow.writeText("");
						jRacy.helpWindow.writeText("The first step is to load a pprof dump file."
																			+ "You can find this option in the file menu.");
						jRacy.helpWindow.writeText("");
						jRacy.helpWindow.writeText("To create a pprof dump file, simply run pprof" +
												  " with the -d option, and pipe the output to a file.");
					}
					else
					{
						jRacy.helpWindow.writeText("Welcome to jRacy");
						jRacy.helpWindow.writeText("");
						
						
					}
				}
			}
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "SMW02");
		}
	}
	
	//Observer functions.
	public void update(Observable o, Object arg)
	{
		try{
			String tmpString = (String) arg;
			if(tmpString.equals("prefEvent"))
			{
				//Just need to call a repaint on the ThreadDataWindowPanel.
				sMWPanel.repaint();
			}
			else if(tmpString.equals("colorEvent"))
			{
				//Just need to call a repaint on the ThreadDataWindowPanel.
				sMWPanel.repaint();
			}
			else if(tmpString.equals("dataSetChangeEvent"))
			{
				//Clear any locally saved data.
	 			currentSMWGeneralData = null;
	 			currentSMWMeanData = null;
	 			
	 			//Now sort the data.
	 			sortLocalData();
			}
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "SMW03");
		}
	}
		
	private void addCompItem(Component c, GridBagConstraints gbc, int x, int y, int w, int h)
	{
		try{
			gbc.gridx = x;
			gbc.gridy = y;
			gbc.gridwidth = w;
			gbc.gridheight = h;
			
			getContentPane().add(c, gbc);
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "SMW04");
		}
	}
	
	//******************************
	//End - Event listener code!!
	//******************************
	
	public StaticMainWindowData getSMWData()
	{
		return sMWData;
	}
	
	//Updates the sorted lists after a change of sorting method takes place.
	private void sortLocalData()
	{
		try{
			//First, do the currentSMWGeneralData.
			if(sortByFunctionID)
			{
				if(descendingOrder)
					currentSMWGeneralData = sMWData.getSMWGeneralData("FIdDE");
				else
					currentSMWGeneralData = sMWData.getSMWGeneralData("FIdAE");
			}
			else if(sortByName)
			{
				if(descendingOrder)
					currentSMWGeneralData = sMWData.getSMWGeneralData("NDE");
				else
					currentSMWGeneralData = sMWData.getSMWGeneralData("NAE");
			}
			else if(sortByMillisecond)
			{
				if(descendingOrder)
					currentSMWGeneralData = sMWData.getSMWGeneralData("MDE");
				else
					currentSMWGeneralData = sMWData.getSMWGeneralData("MAE");
			}
			
			//Now do the currentSMWMeanData.
			if(sortByFunctionID)
			{
				if(descendingOrder)
					currentSMWMeanData = sMWData.getSMWMeanData("FIdDE");
				else
					currentSMWMeanData = sMWData.getSMWMeanData("FIdAE");
			}
			else if(sortByName)
			{
				if(descendingOrder)
					currentSMWMeanData = sMWData.getSMWMeanData("NDE");
				else
					currentSMWMeanData = sMWData.getSMWMeanData("NAE");
			}
			else if(sortByMillisecond)
			{
				if(descendingOrder)
					currentSMWMeanData = sMWData.getSMWMeanData("MDE");
				else
					currentSMWMeanData = sMWData.getSMWMeanData("MAE");
			}
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "SMW05");
		}
		
	}
	
	//This function passes the correct data list to its panel when asked for.
	//Note:  This is only meant to be called by the StaticMainWindowPanel.
	public Vector getSMWGeneralData()
	{
		return currentSMWGeneralData;
	}
	
	//This function passes the correct data list to its panel when asked for.
	//Note:  This is only meant to be called by the StaticMainWindowPanel.
	public Vector getSMWMeanData()
	{
		return currentSMWMeanData;
	}
	
	public boolean isDataLoaded()
	{
		try{
			return sMWData.isDataLoaded();
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "SMW06");
		}
		
		return false;
	}
	  
  	private boolean mShown = false;
	
	public void addNotify() 
	{
		super.addNotify();
		
		if (mShown)
			return;
			
		// resize frame to account for menubar
		JMenuBar jMenuBar = getJMenuBar();
		if (jMenuBar != null) {
			int jMenuBarHeight = jMenuBar.getPreferredSize().height;
			Dimension dimension = getSize();
			dimension.height += jMenuBarHeight;
			setSize(dimension);
		}

		mShown = true;
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
		setVisible(false);
		dispose();
		System.exit(0);
	}	
}
