/* 
	ThreadDataWindow.java

	Title:			jRacy
	Author:			Robert Bell
	Description:	The container for the FunctionDataWindowPanel.
*/

package jRacy;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

public class ThreadDataWindow extends JFrame implements ActionListener, MenuListener, Observer
{
	
	public ThreadDataWindow()
	{
		try
		{
			setLocation(new java.awt.Point(300, 200));
			setSize(new java.awt.Dimension(700, 450));
			
			//Set the title indicating that there was a problem.
			this.setTitle("Wrong constructor used!");
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "TDW01");
		}
	}
	
	public ThreadDataWindow(int inServerNumber,
							int inContextNumber,
							int inThreadNumber,
							StaticMainWindowData inSMWData)
	{
		try
		{
			setLocation(new java.awt.Point(300, 200));
			setSize(new java.awt.Dimension(700, 450));
			
			sMWData = inSMWData;
			
			server = inServerNumber;
			context = inContextNumber;
			thread = inThreadNumber;
			
			//Now set the title.
			this.setTitle("n,c,t, " + server + "," + context + "," + thread);
			
			//Add some window listener code
			addWindowListener(new java.awt.event.WindowAdapter() {
				public void windowClosing(java.awt.event.WindowEvent evt) {
					thisWindowClosing(evt);
				}
			});
			
			//Set the help window text if required.
			if(jRacy.helpWindow.isVisible())
			{
				jRacy.helpWindow.clearText();
				//Since the data must have been loaded.  Tell them someting about
				//where they are.
				jRacy.helpWindow.writeText("This is the thread data window");
				jRacy.helpWindow.writeText("");
				jRacy.helpWindow.writeText("This window shows you the values for all functions on this thread.");
				jRacy.helpWindow.writeText("");
				jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
				jRacy.helpWindow.writeText("");
				jRacy.helpWindow.writeText("Right click on any function within this window to bring up a popup");
				jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
				jRacy.helpWindow.writeText("for the function, or to show more details about the function.");
				jRacy.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
			}
			
			//Sort the local data.
			sortLocalData();
			
			//******************************
			//Code to generate the menus.
			//******************************
			
			
			JMenuBar mainMenu = new JMenuBar();
			
			//******************************
			//File menu.
			//******************************
			JMenu fileMenu = new JMenu("File");
			
			//Add a menu item.
			JMenuItem closeItem = new JMenuItem("Close This Window");
			closeItem.addActionListener(this);
			fileMenu.add(closeItem);
			
			//Add a menu item.
			JMenuItem exitItem = new JMenuItem("Exit Racy!");
			exitItem.addActionListener(this);
			fileMenu.add(exitItem);
			//******************************
			//End - File menu.
			//******************************
			
			//******************************
			//Options menu.
			//******************************
			JMenu optionsMenu = new JMenu("Options");
			
			optionsMenu.addMenuListener(this);
			
			//***********
			//Submenu.
			JMenu sortMenu = new JMenu("Sort by ...");
			sortGroup = new ButtonGroup();
			
			//Add listeners
			functionIDButton.addActionListener(this);
			nameButton.addActionListener(this);
			millisecondButton.addActionListener(this);
			
			sortGroup.add(functionIDButton);
			sortGroup.add(nameButton);
			sortGroup.add(millisecondButton);
			
			sortMenu.add(functionIDButton);
			sortMenu.add(nameButton);
			sortMenu.add(millisecondButton);
			optionsMenu.add(sortMenu);
			//End - Submenu.
			//***********
			
			//***********
			//Submenu.
			JMenu sortOrderMenu = new JMenu("Sort Order");
			sortOrderGroup = new ButtonGroup();
			
			//Add listeners
			ascendingButton.addActionListener(this);
			descendingButton.addActionListener(this);
			
			sortOrderGroup.add(ascendingButton);
			sortOrderGroup.add(descendingButton);
			
			sortOrderMenu.add(ascendingButton);
			sortOrderMenu.add(descendingButton);
			optionsMenu.add(sortOrderMenu);
			//End - Submenu.
			//***********
			
			//Add a submenu.
			JMenu inclusiveExclusiveMenu = new JMenu("Select Inclusive or Exclusive");
			inclusiveExclusiveGroup = new ButtonGroup();
			
			//Add listeners
			inclusiveRadioButton.addActionListener(this);
			exclusiveRadioButton.addActionListener(this);
			
			inclusiveExclusiveGroup.add(inclusiveRadioButton);
			inclusiveExclusiveGroup.add(exclusiveRadioButton);
			inclusiveExclusiveMenu.add(inclusiveRadioButton);
			inclusiveExclusiveMenu.add(exclusiveRadioButton);
			optionsMenu.add(inclusiveExclusiveMenu);
			//End Submenu.
			
			//***********
			//Submenu.
			JMenu valuePercentMenu = new JMenu("Select Value or Percent");
			valuePercentGroup = new ButtonGroup();
			
			//Add listeners
			percentButton.addActionListener(this);
			valueButton.addActionListener(this);
			
			valuePercentGroup.add(percentButton);
			valuePercentGroup.add(valueButton);
			
			valuePercentMenu.add(percentButton);
			valuePercentMenu.add(valueButton);
			optionsMenu.add(valuePercentMenu);
			//End - Submenu.
			//***********
			
			//***********
			//Submenu.
			unitsGroup = new ButtonGroup();
			
			//Add listeners
			secondsButton.addActionListener(this);
			millisecondsButton.addActionListener(this);
			microsecondsButton.addActionListener(this);
			
			unitsGroup.add(secondsButton);
			unitsGroup.add(millisecondsButton);
			unitsGroup.add(microsecondsButton);
			
			unitsMenu.add(secondsButton);
			unitsMenu.add(millisecondsButton);
			unitsMenu.add(microsecondsButton);
			optionsMenu.add(unitsMenu);
			//End - Submenu.
			//***********
			
			//******************************
			//End - Options menu.
			//******************************
			
			
			//******************************
			//Window menu.
			//******************************
			JMenu windowsMenu = new JMenu("Windows");
			
			JMenuItem functionLedgerItem = new JMenuItem("Show Function Ledger");
			
			JMenuItem closeAllSubwindowsItem = new JMenuItem("Close All Sub-Windows");
			
			//Add listeners
			functionLedgerItem.addActionListener(this);
			closeAllSubwindowsItem.addActionListener(this);
			
			windowsMenu.add(functionLedgerItem);
			windowsMenu.add(closeAllSubwindowsItem);
			//******************************
			//End - Window menu.
			//******************************
			
			
			//******************************
			//Help menu.
			//******************************
			JMenu helpMenu = new JMenu("Help");
			
			JMenuItem aboutItem = new JMenuItem("About Racy");
			
			JMenuItem showHelpWindowItem = new JMenuItem("Show Help Window");
			
			//Add listeners
			aboutItem.addActionListener(this);
			showHelpWindowItem.addActionListener(this);
			
			
			helpMenu.add(aboutItem);
			helpMenu.add(showHelpWindowItem);
			//******************************
			//End - Help menu.
			//******************************
			
			
			//Now, add all the menus to the main menu.
			mainMenu.add(fileMenu);
			mainMenu.add(optionsMenu);
			mainMenu.add(windowsMenu);
			mainMenu.add(helpMenu);
			
			setJMenuBar(mainMenu);
			
			//******************************
			//End - Code to generate the menus.
			//******************************
			
			//******************************
			//Create and add the componants.
			//******************************
			//Setting up the layout system for the main window.
			Container contentPane = getContentPane();
			GridBagLayout gbl = new GridBagLayout();
			contentPane.setLayout(gbl);
			GridBagConstraints gbc = new GridBagConstraints();
			gbc.insets = new Insets(5, 5, 5, 5);
			
			//Create some borders.
			Border mainloweredbev = BorderFactory.createLoweredBevelBorder();
			Border mainraisedbev = BorderFactory.createRaisedBevelBorder();
			Border mainempty = BorderFactory.createEmptyBorder();
			
			//**********
			//Panel and ScrollPane definition.
			//**********
			threadDataWindowPanelRef = new ThreadDataWindowPanel(inServerNumber,
																 inContextNumber,
																 inThreadNumber, this, sMWData);
			
			//**********
			//End - Panel and ScrollPane definition.
			//**********
			
			//The scroll panes into which the list shall be placed.
			JScrollPane threadDataWindowPanelScrollPane = new JScrollPane(threadDataWindowPanelRef);
			threadDataWindowPanelScrollPane.setBorder(mainloweredbev);
			threadDataWindowPanelScrollPane.setPreferredSize(new Dimension(500, 450));
			
			barLengthSlider.setPaintTicks(true);
			barLengthSlider.setMajorTickSpacing(5);
			barLengthSlider.setMinorTickSpacing(1);
			barLengthSlider.setPaintLabels(true);
			barLengthSlider.setSnapToTicks(true);
			barLengthSlider.addChangeListener(threadDataWindowPanelRef);
			
			
			//Now add the componants to the main screen.
			gbc.fill = GridBagConstraints.NONE;
			gbc.anchor = GridBagConstraints.EAST;
			gbc.weightx = 0.475;
			gbc.weighty = 0.01;
			addCompItem(barLengthLabel, gbc, 0, 0, 1, 1);
			
			gbc.fill = GridBagConstraints.HORIZONTAL;
			gbc.anchor = GridBagConstraints.WEST;
			gbc.weightx = 0.475;
			gbc.weighty = 0.01;
			addCompItem(barLengthSlider, gbc, 1, 0, 1, 1);
			
			gbc.fill = GridBagConstraints.BOTH;
			gbc.anchor = GridBagConstraints.CENTER;
			gbc.weightx = 0.95;
			gbc.weighty = 0.98;
			addCompItem(threadDataWindowPanelScrollPane, gbc, 0, 1, 2, 1);
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "TDW02");
		}
		
		
	}
	
	//******************************
	//Event listener code!!
	//******************************
	
	//******************************
	//ActionListener code.
	//******************************
	public void actionPerformed(ActionEvent evt)
	{
		try
		{
			Object EventSrc = evt.getSource();
			
			if(EventSrc instanceof JMenuItem)
			{
				String arg = evt.getActionCommand();
				
				if(arg.equals("Close This Window"))
				{
					closeThisWindow();
				}
				else if(arg.equals("Exit Racy!"))
				{
					setVisible(false);
					dispose();
					System.exit(0);
				}
				else if(arg.equals("function ID"))
				{
					if(functionIDButton.isSelected())
					{
						sortByFunctionID = true;
						sortByName = false;
						sortByMillisecond = false;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("name"))
				{
					if(nameButton.isSelected())
					{
						sortByFunctionID = false;
						sortByName = true;
						sortByMillisecond = false;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("millisecond"))	//Note the difference in case from the millisecond option below.
				{
					if(millisecondButton.isSelected())
					{
						sortByFunctionID = false;
						sortByName = false;
						sortByMillisecond = true;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("Descending"))
				{
					if(descendingButton.isSelected())
					{
						descendingOrder = true;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("Ascending"))
				{
					if(ascendingButton.isSelected())
					{
						descendingOrder = false;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("Inclusive"))
				{
					if(inclusiveRadioButton.isSelected())
					{
						inclusive = true;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("Exclusive"))
				{
					if(exclusiveRadioButton.isSelected())
					{
						inclusive = false;
						//Sort the local data.
						sortLocalData();
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("Percent"))
				{
					if(percentButton.isSelected())
					{
						percent = true;
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("Value"))
				{
					if(valueButton.isSelected())
					{
						percent = false;
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("Seconds"))
				{
					if(secondsButton.isSelected())
					{
						unitsString = "Seconds";
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("Microseconds"))
				{
					if(microsecondsButton.isSelected())
					{
						unitsString = "Microseconds";
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("Milliseconds"))
				{
					if(millisecondsButton.isSelected())
					{
						unitsString = "Milliseconds";
						//Call repaint.
						threadDataWindowPanelRef.repaint();
					}
				}
				else if(arg.equals("Show Function Ledger"))
				{
					//In order to be in this window, I must have loaded the data. So,
					//just show the function ledger window.
					(jRacy.staticSystemData.getGlobalMapping()).displayFunctionLedger();
				}
				else if(arg.equals("Close All Sub-Windows"))
				{
					//Close the all subwindows.
					jRacy.systemEvents.updateRegisteredObjects("subWindowCloseEvent");
				}
				else if(arg.equals("About Racy"))
				{
					JOptionPane.showMessageDialog(this, jRacy.getInfoString());
				}
				else if(arg.equals("Show Help Window"))
				{
					//Show the racy help window.
					jRacy.helpWindow.clearText();
					jRacy.helpWindow.show();
					//Since the data must have been loaded.  Tell them someting about
					//where they are.
					jRacy.helpWindow.writeText("This is the thread data window");
					jRacy.helpWindow.writeText("");
					jRacy.helpWindow.writeText("This window shows you the values for all functions on this thread.");
					jRacy.helpWindow.writeText("");
					jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
					jRacy.helpWindow.writeText("");
					jRacy.helpWindow.writeText("Right click on any function within this window to bring up a popup");
					jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
					jRacy.helpWindow.writeText("for the function, or to show more details about the function.");
					jRacy.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
				}
			}
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "TDW03");
		}
	}
	
	//******************************
	//End - ActionListener code.
	//******************************
	
	//******************************
	//MenuListener code.
	//******************************
	public void menuSelected(MenuEvent evt)
	{
		try
		{
			if(percent)
				unitsMenu.setEnabled(false);
			else
				unitsMenu.setEnabled(true);
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "TDW04");
		}
		
	}
	
	public void menuDeselected(MenuEvent evt)
	{
	}
	
	public void menuCanceled(MenuEvent evt)
	{
	}
	
	//Observer functions.
	public void update(Observable o, Object arg)
	{
		try
		{
			String tmpString = (String) arg;
			if(tmpString.equals("prefEvent"))
			{
				//Just need to call a repaint on the ThreadDataWindowPanel.
				threadDataWindowPanelRef.repaint();
			}
			else if(tmpString.equals("colorEvent"))
			{
				//Just need to call a repaint on the ThreadDataWindowPanel.
				threadDataWindowPanelRef.repaint();
			}
			else if(tmpString.equals("subWindowCloseEvent"))
			{
				closeThisWindow();
			}
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "TDW05");
		}
	}
	
	//Updates the sorted lists after a change of sorting method takes place.
	private void sortLocalData()
	{
		try
		{
			if(sortByFunctionID)
			{
				if(inclusive)
				{
					if(descendingOrder)
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "FIdDI");
					else
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "FIdAI");
				}
				else
				{
					if(descendingOrder)
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "FIdDE");
					else
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "FIdAE");
				}
			}
			else if(sortByName)
			{
				
				if(inclusive)
				{
					if(descendingOrder)
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "NDI");
					else
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "NAI");
				}
				else
				{
					if(descendingOrder)
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "NDE");
					else
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "NAE");
				}
			}
			else if(sortByMillisecond)
			{
				if(inclusive)
				{
					if(descendingOrder)
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "MDI");
					else
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "MAI");
				}
				else
				{
					if(descendingOrder)
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "MDE");
					else
						currentSMWThreadData = sMWData.getSMWThreadData(server, context, thread, "MAE");
				}
			}
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "TDW06");
		}
	}
	
	//This function passes the correct data list to its panel when asked for.
	//Note:  This is only meant to be called by the ThreadDataWindowPanel.
	public Vector getStaticMainWindowSystemData()
	{
		return currentSMWThreadData;
	}
	
	public boolean isInclusive()
	{
		return inclusive;
	}
	
	public boolean isPercent()
	{
		return percent;
	}
	
	public String units()
	{
		return unitsString;
	}
	
	public int getSliderValue()
	{
		int tmpInt = -1;
		
		try
		{
			tmpInt = barLengthSlider.getValue();
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "TDW07");
		}
		
		return tmpInt;
	}
	
	//Helper functions.
	private void addCompItem(Component c, GridBagConstraints gbc, int x, int y, int w, int h)
	{
		try
		{
			gbc.gridx = x;
			gbc.gridy = y;
			gbc.gridwidth = w;
			gbc.gridheight = h;
			
			getContentPane().add(c, gbc);
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "TDW08");
		}
	}
	
	//Respond correctly when this window is closed.
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
		closeThisWindow();
	}
	
	void closeThisWindow()
	{	
		try
		{
			if(jRacy.debugIsOn)
			{
				System.out.println("------------------------");
				System.out.println("A thread window for: \"" + "n,c,t, " + server + "," + context + "," + thread + "\" is closing");
				System.out.println("Clearing resourses for that window.");
			}
			
			setVisible(false);
			jRacy.systemEvents.deleteObserver(this);
			dispose();
		}
		catch(Exception e)
		{
			jRacy.systemError(null, "TDW09");
		}
	}
	
	//******************************
	//Instance data.
	//******************************
	private JMenu unitsMenu = new JMenu("Select Units");
	
	private ButtonGroup sortGroup = null;
	private ButtonGroup sortOrderGroup = null;
	private ButtonGroup inclusiveExclusiveGroup = null;
	private ButtonGroup valuePercentGroup = null;
	private ButtonGroup unitsGroup = null;
	
	private JRadioButtonMenuItem ascendingButton =  new JRadioButtonMenuItem("Ascending", false);
	private JRadioButtonMenuItem descendingButton = new JRadioButtonMenuItem("Descending", true);
	
	private JRadioButtonMenuItem functionIDButton = new JRadioButtonMenuItem("function ID", false);
	private JRadioButtonMenuItem nameButton = new JRadioButtonMenuItem("name", false);
	private JRadioButtonMenuItem millisecondButton =  new JRadioButtonMenuItem("millisecond", true);
	
	private JRadioButtonMenuItem inclusiveRadioButton =  new JRadioButtonMenuItem("Inclusive", false);
	private JRadioButtonMenuItem exclusiveRadioButton = new JRadioButtonMenuItem("Exclusive", true);
	
	private JRadioButtonMenuItem valueButton = new JRadioButtonMenuItem("Value", false);
	private JRadioButtonMenuItem percentButton = new JRadioButtonMenuItem("Percent", true);
	
	private JRadioButtonMenuItem secondsButton = new JRadioButtonMenuItem("Seconds", false);
	private JRadioButtonMenuItem millisecondsButton = new JRadioButtonMenuItem("Milliseconds", false);
	private JRadioButtonMenuItem microsecondsButton = new JRadioButtonMenuItem("Microseconds", true);
	
	private JLabel barLengthLabel = new JLabel("Bar Mulitiple");
	
	private JSlider barLengthSlider = new JSlider(0, 40, 1);
	
 	private ThreadDataWindowPanel threadDataWindowPanelRef = null;
 	
 	private StaticMainWindowData sMWData = null;
 	
 	SMWThreadDataElement tmpSMWThreadDataElement = null;
 	
 	
 	//Local data.
 	Vector currentSMWThreadData = null;
 	
 	private boolean sortByFunctionID = false;
	private boolean sortByName = false;
	private boolean sortByMillisecond = true;
	
	private boolean descendingOrder = true;
 	
 	private boolean inclusive = false;
 	private boolean percent = true;
 	private String unitsString = "milliseconds";
 	
 	private int server = -1;
 	private int context = -1;
 	private int thread = -1;
 	
 	//******************************
	//End - Instance data.
	//******************************


}
