/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.ColorChooser;
import jRacy.CustomCellRenderer;
import jRacy.GlobalMapping;
import jRacy.jRacy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.colorchooser.ColorSelectionModel;

class ColorChooserFrame
extends JFrame
implements ActionListener,
MouseListener {
    ColorChooser colorChooserRef;
    private ColorSelectionModel clrModel;
    JColorChooser clrChooser;
    DefaultListModel listModel;
    JList colorList;
    JButton addColorButton;
    JButton deleteColorButton;
    JButton updateColorButton;
    JButton restoreDefaultsButton;
    JPanel highlightPanel;
    JPanel miscFunctionsPanel;
    int numberOfColors = jRacy.clrChooser.getNumberOfColors();

    public ColorChooserFrame(ColorChooser colorChooser) {
        ((Component)this).setLocation(new Point(100, 100));
        ((Component)this).setSize(new Dimension(850, 450));
        this.colorChooserRef = colorChooser;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Exit jRacy!");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createEmptyBorder();
        this.clrChooser = new JColorChooser();
        this.clrModel = this.clrChooser.getSelectionModel();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel("jRacy Color Set.");
        jLabel.setFont(new Font("SansSerif", 2, 14));
        this.addCompItem(jLabel, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.listModel = new DefaultListModel();
        this.colorList = new JList(this.listModel);
        this.colorList.setSelectionMode(0);
        this.colorList.setCellRenderer(new CustomCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.colorList);
        jScrollPane.setBorder(border);
        this.addCompItem(jScrollPane, gridBagConstraints, 0, 1, 1, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addColorButton = new JButton("Add Color");
        this.addColorButton.addActionListener(this);
        this.addCompItem(this.addColorButton, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.deleteColorButton = new JButton("Delete Selected Color");
        this.deleteColorButton.addActionListener(this);
        this.addCompItem(this.deleteColorButton, gridBagConstraints, 1, 2, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.updateColorButton = new JButton("Update Selected Color");
        this.updateColorButton.addActionListener(this);
        this.addCompItem(this.updateColorButton, gridBagConstraints, 1, 3, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.restoreDefaultsButton = new JButton("Restore Defaults");
        this.restoreDefaultsButton.addActionListener(this);
        this.addCompItem(this.restoreDefaultsButton, gridBagConstraints, 1, 4, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel2 = new JLabel("Function highlight colour!");
        this.highlightPanel = new JPanel();
        this.highlightPanel.setPreferredSize(new Dimension(25, 20));
        this.highlightPanel.addMouseListener(this);
        this.highlightPanel.setBackground(jRacy.clrChooser.getHighlightColor());
        this.addCompItem(jLabel2, gridBagConstraints, 0, 5, 1, 1);
        this.addCompItem(this.highlightPanel, gridBagConstraints, 0, 6, 1, 1);
        JLabel jLabel3 = new JLabel("Misc. Functions");
        this.miscFunctionsPanel = new JPanel();
        this.miscFunctionsPanel.setPreferredSize(new Dimension(25, 20));
        this.miscFunctionsPanel.addMouseListener(this);
        this.miscFunctionsPanel.setBackground(jRacy.clrChooser.getMiscFunctionsColor());
        this.addCompItem(jLabel3, gridBagConstraints, 0, 7, 1, 1);
        this.addCompItem(this.miscFunctionsPanel, gridBagConstraints, 0, 8, 1, 1);
        this.addCompItem(this.clrChooser, gridBagConstraints, 2, 0, 1, 9);
        this.populateColorList();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object instanceof JMenuItem) {
            if (string.equals("Exit jRacy!")) {
                ((Component)this).setVisible(false);
                this.dispose();
                System.exit(0);
            } else if (string.equals("Close This Window")) {
                ((Component)this).setVisible(false);
            }
        } else if (object instanceof JButton) {
            if (string.equals("Add Color")) {
                Color color = this.clrModel.getSelectedColor();
                this.listModel.addElement(color);
                this.colorChooserRef.getColorAllColors().add(color);
                GlobalMapping globalMapping = jRacy.staticSystemData.getGlobalMapping();
                globalMapping.updateGenericColors();
                jRacy.systemEvents.updateRegisteredObjects("colorEvent");
            } else if (string.equals("Delete Selected Color")) {
                Object[] objectArray = this.colorList.getSelectedValues();
                int n = 0;
                while (n < objectArray.length) {
                    this.listModel.removeElement(objectArray[n]);
                    this.colorChooserRef.getColorAllColors().removeElement(objectArray[n]);
                    ++n;
                }
                GlobalMapping globalMapping = jRacy.staticSystemData.getGlobalMapping();
                globalMapping.updateGenericColors();
                jRacy.systemEvents.updateRegisteredObjects("colorEvent");
            } else if (string.equals("Update Selected Color")) {
                Color color = this.clrModel.getSelectedColor();
                int[] nArray = this.colorList.getSelectedIndices();
                int n = 0;
                while (n < nArray.length) {
                    this.listModel.setElementAt(color, nArray[n]);
                    this.colorChooserRef.setColorInLocation(color, nArray[n]);
                    ++n;
                }
                GlobalMapping globalMapping = jRacy.staticSystemData.getGlobalMapping();
                globalMapping.updateGenericColors();
                jRacy.systemEvents.updateRegisteredObjects("colorEvent");
            } else if (string.equals("Restore Defaults")) {
                this.colorChooserRef.setDefaultColors();
                this.listModel.clear();
                this.populateColorList();
                GlobalMapping globalMapping = jRacy.staticSystemData.getGlobalMapping();
                globalMapping.updateGenericColors();
                jRacy.systemEvents.updateRegisteredObjects("colorEvent");
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JPanel jPanel = (JPanel)mouseEvent.getSource();
        jPanel.setBackground(this.clrModel.getSelectedColor());
        if (this.highlightPanel == jPanel) {
            jRacy.clrChooser.setHighlightColor(this.clrModel.getSelectedColor());
        }
        jPanel.repaint();
        jRacy.systemEvents.updateRegisteredObjects("colorEvent");
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void populateColorList() {
        Enumeration enumeration = this.colorChooserRef.getColorAllColors().elements();
        while (enumeration.hasMoreElements()) {
            Color color = (Color)enumeration.nextElement();
            this.listModel.addElement(color);
        }
    }
}

