/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.FunctionDataWindowPanel;
import jRacy.StaticMainWindowData;
import jRacy.ThreadDataWindowPanel;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.Border;

public class FunctionDataWindow
extends JFrame
implements ActionListener,
Observer {
    String functionName = null;
    ButtonGroup inclusiveExclusiveGroup = null;
    ButtonGroup valuePercentGroup = null;
    ButtonGroup unitsGroup = null;
    JRadioButtonMenuItem inclusiveRadioButton = null;
    JRadioButtonMenuItem exclusiveRadioButton = null;
    JRadioButtonMenuItem valueButton = null;
    JRadioButtonMenuItem percentButton = null;
    JRadioButtonMenuItem secondsButton = null;
    JRadioButtonMenuItem millisecondsButton = null;
    JRadioButtonMenuItem microsecondsButton = null;
    private JLabel barLengthLabel = new JLabel("Bar Mulitiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private ThreadDataWindowPanel threadDataWindowPanelRef = null;
    StaticMainWindowData sMWData = null;
    Vector sMWGeneralData = null;
    FunctionDataWindowPanel funDataWinPanelRef = null;
    boolean inclusive = false;
    boolean percent = false;
    String unitsString = null;

    public FunctionDataWindow() {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(550, 550));
            this.setTitle("Wrong constructor used");
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FDW01");
        }
    }

    public FunctionDataWindow(String string, StaticMainWindowData staticMainWindowData) {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(550, 550));
            this.sMWData = staticMainWindowData;
            this.inclusive = false;
            this.percent = true;
            this.unitsString = "milliseconds";
            this.functionName = string;
            this.setTitle(this.functionName);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    FunctionDataWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (jRacy.helpWindow.isVisible()) {
                jRacy.helpWindow.clearText();
                jRacy.helpWindow.writeText("This is the function data window for:");
                jRacy.helpWindow.writeText(this.functionName);
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("This window shows you this function's statistics across all the threads.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Right click anywhere within this window to bring up a popup");
                jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                jRacy.helpWindow.writeText("for this function.");
            }
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit Racy!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Options");
            JMenu jMenu3 = new JMenu("Select Inclusive or Exclusive");
            this.inclusiveExclusiveGroup = new ButtonGroup();
            this.inclusiveRadioButton = new JRadioButtonMenuItem("Inclusive", false);
            this.inclusiveRadioButton.addActionListener(this);
            this.exclusiveRadioButton = new JRadioButtonMenuItem("Exclusive", true);
            this.exclusiveRadioButton.addActionListener(this);
            this.inclusiveExclusiveGroup.add(this.inclusiveRadioButton);
            this.inclusiveExclusiveGroup.add(this.exclusiveRadioButton);
            jMenu3.add(this.inclusiveRadioButton);
            jMenu3.add(this.exclusiveRadioButton);
            jMenu2.add(jMenu3);
            JMenu jMenu4 = new JMenu("Select Value or Percent");
            this.valuePercentGroup = new ButtonGroup();
            this.percentButton = new JRadioButtonMenuItem("Percent", true);
            this.percentButton.addActionListener(this);
            this.valueButton = new JRadioButtonMenuItem("Value", false);
            this.valueButton.addActionListener(this);
            this.valuePercentGroup.add(this.percentButton);
            this.valuePercentGroup.add(this.valueButton);
            jMenu4.add(this.percentButton);
            jMenu4.add(this.valueButton);
            jMenu2.add(jMenu4);
            JMenu jMenu5 = new JMenu("Select Units");
            this.unitsGroup = new ButtonGroup();
            this.secondsButton = new JRadioButtonMenuItem("Seconds", false);
            this.secondsButton.addActionListener(this);
            this.millisecondsButton = new JRadioButtonMenuItem("Milliseconds", false);
            this.millisecondsButton.addActionListener(this);
            this.microsecondsButton = new JRadioButtonMenuItem("Microseconds", true);
            this.microsecondsButton.addActionListener(this);
            this.unitsGroup.add(this.secondsButton);
            this.unitsGroup.add(this.millisecondsButton);
            this.unitsGroup.add(this.microsecondsButton);
            jMenu5.add(this.secondsButton);
            jMenu5.add(this.millisecondsButton);
            jMenu5.add(this.microsecondsButton);
            jMenu2.add(jMenu5);
            JMenu jMenu6 = new JMenu("Windows");
            JMenuItem jMenuItem3 = new JMenuItem("Show Function Ledger");
            jMenuItem3.addActionListener(this);
            jMenu6.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Close All Sub-Windows");
            jMenuItem4.addActionListener(this);
            jMenu6.add(jMenuItem4);
            JMenu jMenu7 = new JMenu("Help");
            JMenuItem jMenuItem5 = new JMenuItem("About Racy");
            jMenuItem5.addActionListener(this);
            jMenu7.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Show Help Window");
            jMenuItem6.addActionListener(this);
            jMenu7.add(jMenuItem6);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu6);
            jMenuBar.add(jMenu7);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.funDataWinPanelRef = new FunctionDataWindowPanel(string, this);
            JScrollPane jScrollPane = new JScrollPane(this.funDataWinPanelRef);
            jScrollPane.setBorder(border);
            jScrollPane.setPreferredSize(new Dimension(500, 450));
            this.barLengthSlider.setPaintTicks(true);
            this.barLengthSlider.setMajorTickSpacing(5);
            this.barLengthSlider.setMinorTickSpacing(1);
            this.barLengthSlider.setPaintLabels(true);
            this.barLengthSlider.setSnapToTicks(true);
            this.barLengthSlider.addChangeListener(this.funDataWinPanelRef);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.475;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.475;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, gridBagConstraints, 1, 0, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.95;
            gridBagConstraints.weighty = 0.98;
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 1, 2, 1);
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FDW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit Racy!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("Inclusive")) {
                    if (this.inclusiveRadioButton.isSelected()) {
                        this.inclusive = true;
                        this.funDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Exclusive")) {
                    if (this.exclusiveRadioButton.isSelected()) {
                        this.inclusive = false;
                        this.funDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Percent")) {
                    if (this.percentButton.isSelected()) {
                        this.percent = true;
                        this.funDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Value")) {
                    if (this.valueButton.isSelected()) {
                        this.percent = false;
                        this.funDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Seconds")) {
                    if (this.secondsButton.isSelected()) {
                        this.unitsString = "Seconds";
                        this.funDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Microseconds")) {
                    if (this.microsecondsButton.isSelected()) {
                        this.unitsString = "Microseconds";
                        this.funDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Milliseconds")) {
                    if (this.millisecondsButton.isSelected()) {
                        this.unitsString = "Milliseconds";
                        this.funDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Show Function Ledger")) {
                    jRacy.staticSystemData.getGlobalMapping().displayFunctionLedger();
                } else if (string.equals("Close All Sub-Windows")) {
                    jRacy.systemEvents.updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    jRacy.helpWindow.clearText();
                    jRacy.helpWindow.show();
                    jRacy.helpWindow.writeText("This is the function data window for:");
                    jRacy.helpWindow.writeText(this.functionName);
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("This window shows you this function's statistics across all the threads.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Right click anywhere within this window to bring up a popup");
                    jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                    jRacy.helpWindow.writeText("for this function.");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FDW03");
        }
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.funDataWinPanelRef.repaint();
            } else if (string.equals("colorEvent")) {
                this.funDataWinPanelRef.repaint();
            } else if (string.equals("dataSetChangeEvent")) {
                this.sMWGeneralData = null;
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FDW04");
        }
    }

    public Vector getStaticMainWindowSystemData() {
        try {
            if (this.sMWGeneralData == null) {
                this.sMWGeneralData = this.sMWData.getSMWGeneralData(null);
                return this.sMWGeneralData;
            }
            return this.sMWGeneralData;
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FDW05");
            return null;
        }
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public String units() {
        return this.unitsString;
    }

    public int getSliderValue() {
        int n = -1;
        try {
            n = this.barLengthSlider.getValue();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FDW06");
        }
        return n;
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FDW07");
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (jRacy.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("A funtion window for: \"" + this.functionName + "\" is closing");
                System.out.println("Clearing resourses for that window.");
            }
            ((Component)this).setVisible(false);
            jRacy.systemEvents.deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "FDW08");
        }
    }
}

