/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.Document;

public class HelpWindow
extends JFrame
implements Observer {
    int windowWidth = 500;
    int windowHeight = 500;
    JTextArea helpJTextArea;
    Document helpJTextAreaDocument;

    public HelpWindow() {
        ((Component)this).setSize(new Dimension(this.windowWidth, this.windowHeight));
        this.setTitle("Racy Help Window");
        this.helpJTextArea = new JTextArea();
        this.helpJTextArea.setLineWrap(true);
        this.helpJTextArea.setWrapStyleWord(true);
        this.helpJTextArea.setSize(new Dimension(this.windowWidth, this.windowHeight));
        this.helpJTextAreaDocument = this.helpJTextArea.getDocument();
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        Border border = BorderFactory.createLoweredBevelBorder();
        JScrollPane jScrollPane = new JScrollPane(this.helpJTextArea);
        jScrollPane.setBorder(border);
        jScrollPane.setPreferredSize(new Dimension(this.windowWidth, this.windowHeight));
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(jScrollPane, gridBagConstraints, 0, 0, 2, 1);
    }

    public void clearText() {
        try {
            this.helpJTextAreaDocument.remove(0, this.helpJTextAreaDocument.getLength());
        }
        catch (Exception exception) {
            System.out.println("There was a problem with the help window!");
            System.out.println(exception.toString());
        }
    }

    public void writeText(String string) {
        this.helpJTextArea.append(string);
        this.helpJTextArea.append("\n");
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("subWindowCloseEvent")) {
            ((Component)this).setVisible(false);
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }
}

