/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.FunctionDataWindow;
import jRacy.GlobalMapping;
import jRacy.GlobalMappingElement;
import jRacy.MeanTotalStatWindow;
import jRacy.SMWMeanDataElement;
import jRacy.jRacy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MeanTotalStatWindowPanel
extends JPanel
implements ActionListener,
MouseListener {
    int xPanelSize = 800;
    int yPanelSize = 600;
    int newXPanelSize = 0;
    int newYPanelSize = 0;
    int startLocation = 0;
    int maxFontAscent = 0;
    int maxFontDescent = 0;
    int spacing = 0;
    int serverNumber;
    int contextNumber;
    int threadNumber;
    MeanTotalStatWindow mTSWindow;
    Vector tmpMeanDataElementList;
    SMWMeanDataElement tmpSMWMeanDataElement;
    Font MonoFont = null;
    FontMetrics fmMonoFont = null;
    private JPopupMenu popup = new JPopupMenu();
    Object clickedOnObject = null;

    public MeanTotalStatWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MTSWP01");
        }
    }

    public MeanTotalStatWindowPanel(MeanTotalStatWindow meanTotalStatWindow) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.mTSWindow = meanTotalStatWindow;
            this.addMouseListener(this);
            JMenuItem jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change Function Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MTSWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            int n = 0;
            int n2 = jRacy.jRacyPreferences.getBarHeight();
            this.spacing = jRacy.jRacyPreferences.getBarSpacing();
            int n3 = 0;
            String string = null;
            String string2 = "";
            this.MonoFont = new Font("Monospaced", jRacy.jRacyPreferences.getFontStyle(), n2);
            this.fmMonoFont = graphics.getFontMetrics(this.MonoFont);
            this.maxFontAscent = this.fmMonoFont.getMaxAscent();
            this.maxFontDescent = this.fmMonoFont.getMaxDescent();
            if (this.spacing <= this.maxFontAscent + this.maxFontDescent) {
                ++this.spacing;
            }
            this.tmpMeanDataElementList = this.mTSWindow.getStaticMainWindowSystemData();
            Rectangle rectangle = graphics.getClipBounds();
            int n4 = (int)rectangle.getY();
            int n5 = (int)((double)n4 + rectangle.getHeight());
            int n6 = 0;
            int n7 = 0;
            if (rectangle != null) {
                string = jRacy.staticSystemData.getHeading();
                int n8 = string.length();
                int n9 = 0;
                while (n9 < n8) {
                    string2 = string2 + "-";
                    ++n9;
                }
                graphics.setColor(Color.black);
                graphics.setFont(this.MonoFont);
                graphics.drawString(string2, 20, n += this.spacing);
                n = n + this.spacing + 10;
                graphics.drawString(string, 20, n);
                n = n + this.spacing + 10;
                graphics.drawString(string2, 20, n);
                this.startLocation = n;
                this.newYPanelSize = n + (this.tmpMeanDataElementList.size() + 1) * this.spacing;
                n6 = (n4 - n) / this.spacing - 1;
                n7 = (n5 - n) / this.spacing + 1;
                if (n > n4 || n > n5) {
                    if (n > n4) {
                        n6 = 0;
                    }
                    if (n > n5) {
                        n7 = 0;
                    }
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                if (n6 > this.tmpMeanDataElementList.size() - 1) {
                    n6 = this.tmpMeanDataElementList.size() - 1;
                }
                if (n7 > this.tmpMeanDataElementList.size() - 1) {
                    n7 = this.tmpMeanDataElementList.size() - 1;
                }
                n += n6 * this.spacing;
                int n10 = n6;
                while (n10 <= n7) {
                    this.tmpSMWMeanDataElement = (SMWMeanDataElement)this.tmpMeanDataElementList.elementAt(n10);
                    string = this.tmpSMWMeanDataElement.getMeanTotalStatString();
                    if (string == null) {
                        System.out.println("Null");
                    } else {
                        n += this.spacing;
                        graphics.setColor(Color.black);
                        AttributedString attributedString = new AttributedString(string);
                        attributedString.addAttribute(TextAttribute.FONT, this.MonoFont);
                        if (jRacy.clrChooser.getHighlightColorFunctionID() != -1) {
                            if (this.tmpSMWMeanDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                attributedString.addAttribute(TextAttribute.FOREGROUND, jRacy.clrChooser.getHighlightColor(), jRacy.staticSystemData.getPositionOfName(), string.length());
                            } else {
                                attributedString.addAttribute(TextAttribute.FOREGROUND, this.tmpSMWMeanDataElement.getFunctionColor(), jRacy.staticSystemData.getPositionOfName(), string.length());
                            }
                        } else {
                            attributedString.addAttribute(TextAttribute.FOREGROUND, this.tmpSMWMeanDataElement.getFunctionColor(), jRacy.staticSystemData.getPositionOfName(), string.length());
                        }
                        graphics.drawString(attributedString.getIterator(), 20, n);
                        if (n3 < 20 + this.fmMonoFont.stringWidth(string) + 5) {
                            n3 = 20 + this.fmMonoFont.stringWidth(string) + 15;
                        }
                    }
                    ++n10;
                }
                if (this.newYPanelSize >= this.yPanelSize || n3 >= this.xPanelSize) {
                    this.yPanelSize = this.newYPanelSize + 1;
                    this.xPanelSize = n3 + 1;
                    this.revalidate();
                }
            } else {
                string = jRacy.staticSystemData.getHeading();
                int n11 = string.length();
                int n12 = 0;
                while (n12 < n11) {
                    string2 = string2 + "-";
                    ++n12;
                }
                graphics.setColor(Color.black);
                graphics.setFont(this.MonoFont);
                graphics.drawString(string2, 20, n += this.spacing);
                n = n + this.spacing + 10;
                graphics.drawString(string, 20, n);
                n = n + this.spacing + 10;
                graphics.drawString(string2, 20, n);
                this.startLocation = n;
                this.newYPanelSize = n + (this.tmpMeanDataElementList.size() + 1) * this.spacing;
                Enumeration enumeration = this.tmpMeanDataElementList.elements();
                while (enumeration.hasMoreElements()) {
                    this.tmpSMWMeanDataElement = (SMWMeanDataElement)enumeration.nextElement();
                    string = this.tmpSMWMeanDataElement.getMeanTotalStatString();
                    n += this.spacing;
                    graphics.setColor(Color.black);
                    AttributedString attributedString = new AttributedString(string);
                    attributedString.addAttribute(TextAttribute.FONT, this.MonoFont);
                    if (jRacy.clrChooser.getHighlightColorFunctionID() != -1) {
                        if (this.tmpSMWMeanDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                            attributedString.addAttribute(TextAttribute.FOREGROUND, jRacy.clrChooser.getHighlightColor(), jRacy.staticSystemData.getPositionOfName(), string.length());
                        } else {
                            attributedString.addAttribute(TextAttribute.FOREGROUND, this.tmpSMWMeanDataElement.getFunctionColor(), jRacy.staticSystemData.getPositionOfName(), string.length());
                        }
                    } else {
                        attributedString.addAttribute(TextAttribute.FOREGROUND, this.tmpSMWMeanDataElement.getFunctionColor(), jRacy.staticSystemData.getPositionOfName(), string.length());
                    }
                    graphics.drawString(attributedString.getIterator(), 20, n);
                    if (n3 >= 20 + this.fmMonoFont.stringWidth(string) + 5) continue;
                    n3 = 20 + this.fmMonoFont.stringWidth(string) + 15;
                }
                if (this.newYPanelSize >= this.yPanelSize || n3 >= this.xPanelSize) {
                    this.yPanelSize = this.newYPanelSize + 1;
                    this.xPanelSize = n3 + 1;
                    this.revalidate();
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MTSWP03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            SMWMeanDataElement sMWMeanDataElement = null;
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof SMWMeanDataElement) {
                        sMWMeanDataElement = (SMWMeanDataElement)this.clickedOnObject;
                        jRacy.clrChooser.setHighlightColorFunctionID(sMWMeanDataElement.getFunctionID());
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(sMWMeanDataElement.getFunctionName(), jRacy.staticMainWindow.getSMWData());
                        jRacy.systemEvents.addObserver(functionDataWindow);
                        functionDataWindow.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWMeanDataElement) {
                        n = ((SMWMeanDataElement)this.clickedOnObject).getFunctionID();
                    }
                    GlobalMapping globalMapping = jRacy.staticSystemData.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n);
                    Color color = globalMappingElement.getFunctionColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        globalMappingElement.setSpecificColor(color);
                        globalMappingElement.setColorFlag(true);
                        jRacy.systemEvents.updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWMeanDataElement) {
                        n = ((SMWMeanDataElement)this.clickedOnObject).getFunctionID();
                    }
                    GlobalMapping globalMapping = jRacy.staticSystemData.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n);
                    globalMappingElement.setColorFlag(false);
                    jRacy.systemEvents.updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MTSWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            int n4 = n2 - this.startLocation;
            int n5 = n4 / this.spacing;
            int n6 = (n5 + 1) * this.spacing;
            int n7 = n6 - this.maxFontAscent;
            if (n4 >= n7 && n4 <= n6 && n5 < this.tmpMeanDataElementList.size()) {
                String string;
                int n8;
                this.tmpSMWMeanDataElement = (SMWMeanDataElement)this.tmpMeanDataElementList.elementAt(n5);
                if (this.fmMonoFont != null && n <= (n8 = this.fmMonoFont.stringWidth(string = this.tmpSMWMeanDataElement.getMeanTotalStatString()) + 20)) {
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = this.tmpSMWMeanDataElement;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                    } else if (jRacy.clrChooser.getHighlightColorFunctionID() == -1) {
                        jRacy.clrChooser.setHighlightColorFunctionID(this.tmpSMWMeanDataElement.getFunctionID());
                    } else if (jRacy.clrChooser.getHighlightColorFunctionID() != this.tmpSMWMeanDataElement.getFunctionID()) {
                        jRacy.clrChooser.setHighlightColorFunctionID(this.tmpSMWMeanDataElement.getFunctionID());
                    } else {
                        jRacy.clrChooser.setHighlightColorFunctionID(-1);
                    }
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "MTSWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }
}

