/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.PrefColorPanel;
import jRacy.PrefSpacingPanel;
import jRacy.SavedPreferences;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.Border;

public class Preferences
extends JFrame
implements ActionListener,
Observer {
    private PrefColorPanel pCPanel;
    private PrefSpacingPanel pSPanel;
    private JCheckBox loadPprofDat;
    private JRadioButton normal;
    private JRadioButton bold;
    private JRadioButton italic;
    private ButtonGroup buttonGroup;
    private JLabel fontLabel = new JLabel("Font Selection");
    private JComboBox fontComboBox;
    private JLabel barSpacingLabel = new JLabel("Adjust Bar Spacing");
    private JLabel barHeightLabel = new JLabel("Adjust Bar Height");
    private JSlider barSpacingSlider = new JSlider(1, 0, 100, 0);
    private JSlider barHeightSlider = new JSlider(1, 0, 100, 0);
    private JButton colorButton;
    private JButton closeButton;
    int fontStyle;
    private boolean barDetailsSet = false;
    private int barSpacing = -1;
    private int barHeight = -1;
    String jRacyFont;
    String inExValue;
    String sortBy;
    private boolean mShown = false;

    public Preferences(SavedPreferences savedPreferences) {
        Object object;
        if (savedPreferences != null) {
            this.jRacyFont = savedPreferences.getJRacyFont();
            this.barSpacing = savedPreferences.getBarSpacing();
            this.barHeight = savedPreferences.getBarHeight();
            this.inExValue = savedPreferences.getInExValue();
            this.sortBy = savedPreferences.getSortBy();
            this.fontStyle = savedPreferences.getFontStyle();
            this.barDetailsSet = savedPreferences.getBarDetailsSet();
        } else {
            this.inExValue = new String("Exclusive");
            object = new String("functionID");
            this.jRacyFont = "SansSerif";
            this.barHeight = 0;
            this.barSpacing = 0;
            this.fontStyle = 0;
        }
        object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = ((GraphicsEnvironment)object).getAvailableFontFamilyNames();
        this.fontComboBox = new JComboBox<String>(stringArray);
        int n = this.fontComboBox.getItemCount();
        int n2 = 0;
        String string = (String)this.fontComboBox.getItemAt(n2);
        while (n2 < n && !this.jRacyFont.equals(string)) {
            string = (String)this.fontComboBox.getItemAt(++n2);
        }
        if (n2 == n) {
            System.out.println("The default font was not found!!  This is not a good thing as it is a default Java font!!");
        } else {
            this.fontComboBox.setSelectedIndex(n2);
        }
        this.barHeightSlider.setValue(this.barHeight);
        this.barSpacingSlider.setValue(this.barSpacing);
        this.fontComboBox.addActionListener(this);
        this.pCPanel = new PrefColorPanel();
        this.pSPanel = new PrefSpacingPanel();
        this.setTitle("jRacy Preferences");
        int n3 = 900;
        int n4 = 450;
        ((Component)this).setSize(new Dimension(n3, n4));
        this.setResizable(false);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n5 = dimension.height;
        int n6 = dimension.width;
        int n7 = 0;
        int n8 = 0;
        ((Component)this).setLocation(n7, n8);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Exit jRacy!");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        Border border = BorderFactory.createLoweredBevelBorder();
        Border border2 = BorderFactory.createRaisedBevelBorder();
        Border border3 = BorderFactory.createEmptyBorder();
        JScrollPane jScrollPane = new JScrollPane(this.pCPanel);
        jScrollPane.setBorder(border);
        jScrollPane.setPreferredSize(new Dimension(500, 100));
        JScrollPane jScrollPane2 = new JScrollPane(this.pSPanel);
        jScrollPane2.setBorder(border);
        jScrollPane2.setPreferredSize(new Dimension(500, 200));
        this.barSpacingSlider.setPaintTicks(true);
        this.barSpacingSlider.setMajorTickSpacing(20);
        this.barSpacingSlider.setMinorTickSpacing(5);
        this.barSpacingSlider.setPaintLabels(true);
        this.barSpacingSlider.addChangeListener(this.pSPanel);
        this.barSpacingSlider.addChangeListener(this.pCPanel);
        this.barHeightSlider.setPaintTicks(true);
        this.barHeightSlider.setMajorTickSpacing(20);
        this.barHeightSlider.setMinorTickSpacing(5);
        this.barHeightSlider.setPaintLabels(true);
        this.barHeightSlider.addChangeListener(this.pSPanel);
        this.barHeightSlider.addChangeListener(this.pCPanel);
        this.colorButton = new JButton("Adjust Colours");
        this.colorButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.normal = new JRadioButton("Plain Font", this.fontStyle == 0 || this.fontStyle == 2);
        this.normal.addActionListener(this);
        this.bold = new JRadioButton("Bold Font", this.fontStyle == 1 || this.fontStyle == 3);
        this.bold.addActionListener(this);
        this.italic = new JRadioButton("Italic Font", this.fontStyle == 2 || this.fontStyle == 3);
        this.italic.addActionListener(this);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.normal);
        this.buttonGroup.add(this.bold);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.fontLabel, gridBagConstraints, 2, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.fontComboBox, gridBagConstraints, 3, 0, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.colorButton, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.normal, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.bold, gridBagConstraints, 2, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.italic, gridBagConstraints, 3, 1, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(jScrollPane2, gridBagConstraints, 0, 3, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.barSpacingLabel, gridBagConstraints, 2, 3, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.barSpacingSlider, gridBagConstraints, 2, 4, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.barHeightLabel, gridBagConstraints, 3, 3, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.barHeightSlider, gridBagConstraints, 3, 4, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.closeButton, gridBagConstraints, 3, 5, 1, 1);
        this.pCPanel.repaint();
    }

    public void showPreferencesWindow() {
        this.show();
    }

    public void setSavedPreferences() {
        jRacy.savedPreferences.setJRacyFont(this.jRacyFont);
        jRacy.savedPreferences.setBarSpacing(this.barSpacing);
        jRacy.savedPreferences.setBarHeight(this.barHeight);
        jRacy.savedPreferences.setInExValue(this.inExValue);
        jRacy.savedPreferences.setSortBy(this.sortBy);
        jRacy.savedPreferences.setFontStyle(this.fontStyle);
        jRacy.savedPreferences.setBarDetailsSet(this.barDetailsSet);
    }

    public boolean areBarDetailsSet() {
        return this.barDetailsSet;
    }

    public String getJRacyFont() {
        return this.jRacyFont;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setBarDetails(int n, int n2) {
        this.barHeight = n;
        this.barSpacing = n2;
        this.barDetailsSet = true;
    }

    public void setSliders(int n, int n2) {
        this.barHeightSlider.setValue(n);
        this.barSpacingSlider.setValue(n2);
    }

    public int getBarSpacing() {
        return this.barSpacing;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setInExValue(String string) {
        this.inExValue = string;
    }

    public String getInExValue() {
        return this.inExValue;
    }

    public void setSortBy(String string) {
        this.sortBy = string;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("colorEvent")) {
            this.pCPanel.repaint();
            this.pSPanel.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object instanceof JMenuItem) {
            if (string.equals("Exit jRacy!")) {
                ((Component)this).setVisible(false);
                this.dispose();
                System.exit(0);
            } else if (string.equals("Close This Window")) {
                ((Component)this).setVisible(false);
            }
        } else if (object instanceof JButton) {
            if (string.equals("Close")) {
                ((Component)this).setVisible(false);
                jRacy.systemEvents.updateRegisteredObjects("prefEvent");
            }
            if (string.equals("Adjust Colours")) {
                jRacy.clrChooser.showColorChooser();
            }
        } else if (object instanceof JRadioButton) {
            if (string.equals("Plain Font")) {
                this.fontStyle = this.italic.isSelected() ? 2 : 0;
                this.pSPanel.repaint();
            } else if (string.equals("Bold Font")) {
                this.fontStyle = this.italic.isSelected() ? 3 : 1;
                this.pSPanel.repaint();
            } else if (string.equals("Italic Font")) {
                this.fontStyle = this.italic.isSelected() ? (this.normal.isSelected() ? 2 : 3) : (this.normal.isSelected() ? 0 : 1);
                this.pSPanel.repaint();
            }
        } else if (object == this.fontComboBox) {
            this.jRacyFont = (String)this.fontComboBox.getSelectedItem();
            this.pSPanel.repaint();
        }
    }

    public void updateBarDetails() {
        this.barHeight = this.barHeightSlider.getValue();
        this.barSpacing = this.barSpacingSlider.getValue();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            ((Component)this).setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }
}

