/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.FunctionDataWindow;
import jRacy.GlobalMapping;
import jRacy.GlobalMappingElement;
import jRacy.MeanDataWindow;
import jRacy.MeanTotalStatWindow;
import jRacy.SMWContext;
import jRacy.SMWMeanDataElement;
import jRacy.SMWServer;
import jRacy.SMWThread;
import jRacy.SMWThreadDataElement;
import jRacy.StaticMainWindow;
import jRacy.ThreadDataWindow;
import jRacy.TotalStatWindow;
import jRacy.jRacy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class StaticMainWindowPanel
extends JPanel
implements ActionListener,
MouseListener {
    StaticMainWindow sMWindow = null;
    int xPanelSize = 600;
    int yPanelSize = 300;
    private JPopupMenu popup = new JPopupMenu();
    Vector contextList = null;
    Vector threadList = null;
    Vector threadDataList = null;
    SMWServer sMWServer = null;
    SMWContext sMWContext = null;
    SMWThread sMWThread = null;
    SMWThreadDataElement sMWThreadDataElement = null;
    SMWMeanDataElement sMWMeanDataElement = null;
    int serverCounter = 0;
    int contextCounter = 0;
    int threadCounter = 0;
    int sMWThreadDataElementCounter = 0;
    int colorCounter = 0;
    int xCoord = -1;
    int yCoord = -1;
    Object clickedOnObject = null;
    String tmpString = null;
    double tmpSum = -1.0;
    double tmpDataValue = -1.0;
    Color tmpColor = null;
    boolean highlighted = false;
    int barXStart = -1;
    int numberOfColors = 0;

    public StaticMainWindowPanel() {
        try {
            this.setToolTipText("Incorrect Constructor!!!");
        }
        catch (Exception exception) {
            jRacy.systemError(null, "SMWP01");
        }
    }

    public StaticMainWindowPanel(StaticMainWindow staticMainWindow) {
        try {
            this.setToolTipText("Racy bar graph draw window!");
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.sMWindow = staticMainWindow;
            this.barXStart = 100;
            JMenuItem jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change Function Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Highlight this Function");
            jMenuItem4.addActionListener(this);
            this.popup.add(jMenuItem4);
            JMenuItem jMenuItem5 = new JMenuItem("Un-Highlight this Function");
            jMenuItem5.addActionListener(this);
            this.popup.add(jMenuItem5);
        }
        catch (Exception exception) {
            jRacy.systemError(null, "SMWP02");
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        try {
            int n = 0;
            int n2 = 0;
            this.xCoord = mouseEvent.getX();
            this.yCoord = mouseEvent.getY();
            if (this.sMWindow.isDataLoaded()) {
                Enumeration enumeration;
                if (!this.sMWindow.getSMWMeanData().isEmpty()) {
                    this.sMWMeanDataElement = (SMWMeanDataElement)this.sMWindow.getSMWMeanData().elementAt(0);
                    if (this.yCoord >= this.sMWMeanDataElement.getYBeg() && this.yCoord <= this.sMWMeanDataElement.getYEnd()) {
                        enumeration = this.sMWindow.getSMWMeanData().elements();
                        while (enumeration.hasMoreElements()) {
                            this.sMWMeanDataElement = (SMWMeanDataElement)enumeration.nextElement();
                            if (this.xCoord < this.barXStart) {
                                if (jRacy.helpWindow.isShowing()) {
                                    jRacy.helpWindow.clearText();
                                    jRacy.helpWindow.writeText("You are to the left of the mean bar.");
                                    jRacy.helpWindow.writeText("");
                                    jRacy.helpWindow.writeText("Using either the right or left mouse buttons, click once to display more detailed data about the mean values for the functions in the system.");
                                }
                                return new String("Right click here to display mean data.");
                            }
                            if (this.xCoord >= this.sMWMeanDataElement.getXEnd()) continue;
                            if (jRacy.helpWindow.isShowing()) {
                                jRacy.helpWindow.clearText();
                                jRacy.helpWindow.writeText("Your mouse is over the mean draw bar!");
                                jRacy.helpWindow.writeText("");
                                jRacy.helpWindow.writeText("Current function name is: " + this.sMWMeanDataElement.getFunctionName());
                                jRacy.helpWindow.writeText("");
                                jRacy.helpWindow.writeText("The mean draw bars give a visual representation of the mean values for the functions which have run in the system.  The funtions are assigned a color from the current Racy color set.  The colors are cycled through when the number of funtions exceeds the number of available colors.  Use the right and left mouse buttons to give additional information.");
                            }
                            return this.sMWMeanDataElement.getFunctionName();
                        }
                        if (this.xCoord <= this.barXStart + 500) {
                            if (jRacy.helpWindow.isShowing()) {
                                jRacy.helpWindow.clearText();
                                jRacy.helpWindow.writeText("Your mouse is over the misc. function section!");
                                jRacy.helpWindow.writeText("");
                                jRacy.helpWindow.writeText("These are functions which have a non zero value, but whose screen representation is less than a pixel.");
                                jRacy.helpWindow.writeText("");
                                jRacy.helpWindow.writeText("To view these functions, right or left click to the left of this bar to bring up windows which will show more detailed information.");
                            }
                            return "Misc function section ... see help window for details";
                        }
                    }
                }
                enumeration = this.sMWindow.getSMWGeneralData().elements();
                while (enumeration.hasMoreElements()) {
                    this.sMWServer = (SMWServer)enumeration.nextElement();
                    if (this.yCoord > this.sMWServer.getYDrawCoord()) continue;
                    this.contextList = this.sMWServer.getContextList();
                    Enumeration enumeration2 = this.contextList.elements();
                    while (enumeration2.hasMoreElements()) {
                        this.sMWContext = (SMWContext)enumeration2.nextElement();
                        if (this.yCoord > this.sMWContext.getYDrawCoord()) continue;
                        this.threadList = this.sMWContext.getThreadList();
                        Enumeration enumeration3 = this.threadList.elements();
                        while (enumeration3.hasMoreElements()) {
                            this.sMWThread = (SMWThread)enumeration3.nextElement();
                            if (this.yCoord > this.sMWThread.getYDrawCoord()) continue;
                            this.threadDataList = this.sMWThread.getThreadDataList();
                            this.sMWThreadDataElementCounter = 0;
                            Enumeration enumeration4 = this.threadDataList.elements();
                            while (enumeration4.hasMoreElements()) {
                                this.sMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                                n = this.sMWThreadDataElement.getYBeg();
                                n2 = this.sMWThreadDataElement.getYEnd();
                                if (this.xCoord < this.barXStart) {
                                    if (this.yCoord >= n && this.yCoord <= n2) {
                                        if (jRacy.helpWindow.isShowing()) {
                                            jRacy.helpWindow.clearText();
                                            jRacy.helpWindow.writeText("n,c,t stands for: Node, Context and Thread.");
                                            jRacy.helpWindow.writeText("");
                                            jRacy.helpWindow.writeText("Using either the right or left mouse buttons, click once to display more detailed data about this thread.");
                                        }
                                        return new String("Click once here to display more thread data.");
                                    }
                                    return string;
                                }
                                if (this.xCoord < this.sMWThreadDataElement.getXEnd()) {
                                    if (this.yCoord >= n && this.yCoord <= n2) {
                                        if (jRacy.helpWindow.isShowing()) {
                                            jRacy.helpWindow.clearText();
                                            jRacy.helpWindow.writeText("Your mouse is over one of the thread draw bars!");
                                            jRacy.helpWindow.writeText("");
                                            jRacy.helpWindow.writeText("Current function name is: " + this.sMWThreadDataElement.getFunctionName());
                                            jRacy.helpWindow.writeText("");
                                            jRacy.helpWindow.writeText("The thread draw bars give a visual representation functions which have run on this thread.  The funtions are assigned a color from the current Racy color set.  The colors are cycled through when the number of funtions exceeds the number of available colors.  Use the right and left mouse buttons to give additional information.");
                                        }
                                        return this.sMWThreadDataElement.getFunctionName();
                                    }
                                    return string;
                                }
                                ++this.sMWThreadDataElementCounter;
                            }
                            if (this.yCoord >= n && this.yCoord <= n2 && this.xCoord <= this.barXStart + 500) {
                                if (jRacy.helpWindow.isShowing()) {
                                    jRacy.helpWindow.clearText();
                                    jRacy.helpWindow.writeText("Your mouse is over the misc. function section!");
                                    jRacy.helpWindow.writeText("");
                                    jRacy.helpWindow.writeText("These are functions which have a non zero value, but whose screen representation is less than a pixel.");
                                    jRacy.helpWindow.writeText("");
                                    jRacy.helpWindow.writeText("To view these functions, right or left click to the left of this bar to bring up windows which will show more detailed information.");
                                }
                                return "Misc function section ... see help window for details";
                            }
                            return string;
                        }
                    }
                    return string;
                }
                return string;
            }
            return string;
        }
        catch (Exception exception) {
            jRacy.systemError(null, "SMWP03");
            return string;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            SMWThreadDataElement sMWThreadDataElement = null;
            SMWMeanDataElement sMWMeanDataElement = null;
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        jRacy.clrChooser.setHighlightColorFunctionID(sMWThreadDataElement.getFunctionID());
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(sMWThreadDataElement.getFunctionName(), this.sMWindow.getSMWData());
                        jRacy.systemEvents.addObserver(functionDataWindow);
                        functionDataWindow.show();
                    } else {
                        sMWMeanDataElement = (SMWMeanDataElement)this.clickedOnObject;
                        jRacy.clrChooser.setHighlightColorFunctionID(sMWMeanDataElement.getFunctionID());
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(sMWMeanDataElement.getFunctionName(), this.sMWindow.getSMWData());
                        jRacy.systemEvents.addObserver(functionDataWindow);
                        functionDataWindow.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    int n = -1;
                    n = this.clickedOnObject instanceof SMWThreadDataElement ? ((SMWThreadDataElement)this.clickedOnObject).getFunctionID() : ((SMWMeanDataElement)this.clickedOnObject).getFunctionID();
                    GlobalMapping globalMapping = jRacy.staticSystemData.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n);
                    Color color = globalMappingElement.getFunctionColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        globalMappingElement.setSpecificColor(color);
                        globalMappingElement.setColorFlag(true);
                        jRacy.systemEvents.updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    int n = -1;
                    n = this.clickedOnObject instanceof SMWThreadDataElement ? ((SMWThreadDataElement)this.clickedOnObject).getFunctionID() : ((SMWMeanDataElement)this.clickedOnObject).getFunctionID();
                    GlobalMapping globalMapping = jRacy.staticSystemData.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n);
                    globalMappingElement.setColorFlag(false);
                    jRacy.systemEvents.updateRegisteredObjects("colorEvent");
                } else if (string.equals("Highlight this Function")) {
                    int n = -1;
                    n = this.clickedOnObject instanceof SMWThreadDataElement ? ((SMWThreadDataElement)this.clickedOnObject).getFunctionID() : ((SMWMeanDataElement)this.clickedOnObject).getFunctionID();
                    jRacy.clrChooser.setHighlightColorFunctionID(n);
                } else if (string.equals("Un-Highlight this Function")) {
                    jRacy.clrChooser.setHighlightColorFunctionID(-1);
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "SMWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            Enumeration enumeration;
            this.xCoord = mouseEvent.getX();
            this.yCoord = mouseEvent.getY();
            int n = mouseEvent.getClickCount();
            this.sMWThreadDataElementCounter = 0;
            this.threadCounter = 0;
            this.contextCounter = 0;
            this.serverCounter = 0;
            if (!this.sMWindow.getSMWMeanData().isEmpty()) {
                this.sMWMeanDataElement = (SMWMeanDataElement)this.sMWindow.getSMWMeanData().elementAt(0);
                if (this.yCoord >= this.sMWMeanDataElement.getYBeg() && this.yCoord <= this.sMWMeanDataElement.getYEnd()) {
                    enumeration = this.sMWindow.getSMWMeanData().elements();
                    while (enumeration.hasMoreElements()) {
                        this.sMWMeanDataElement = (SMWMeanDataElement)enumeration.nextElement();
                        if (this.xCoord < this.barXStart) {
                            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                                MeanDataWindow meanDataWindow = new MeanDataWindow(this.sMWindow.getSMWData());
                                jRacy.systemEvents.addObserver(meanDataWindow);
                                meanDataWindow.show();
                            } else {
                                MeanTotalStatWindow meanTotalStatWindow = new MeanTotalStatWindow(this.sMWindow.getSMWData());
                                jRacy.systemEvents.addObserver(meanTotalStatWindow);
                                meanTotalStatWindow.show();
                            }
                            return;
                        }
                        if (this.xCoord >= this.sMWMeanDataElement.getXEnd()) continue;
                        if ((mouseEvent.getModifiers() & 0x10) == 0) {
                            this.clickedOnObject = this.sMWMeanDataElement;
                            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                            return;
                        }
                        jRacy.clrChooser.setHighlightColorFunctionID(this.sMWMeanDataElement.getFunctionID());
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(this.sMWMeanDataElement.getFunctionName(), this.sMWindow.getSMWData());
                        jRacy.systemEvents.addObserver(functionDataWindow);
                        functionDataWindow.show();
                        return;
                    }
                }
            }
            enumeration = this.sMWindow.getSMWGeneralData().elements();
            while (enumeration.hasMoreElements()) {
                this.sMWServer = (SMWServer)enumeration.nextElement();
                if (this.yCoord <= this.sMWServer.getYDrawCoord()) {
                    this.contextList = this.sMWServer.getContextList();
                    Enumeration enumeration2 = this.contextList.elements();
                    while (enumeration2.hasMoreElements()) {
                        this.sMWContext = (SMWContext)enumeration2.nextElement();
                        if (this.yCoord <= this.sMWContext.getYDrawCoord()) {
                            this.threadList = this.sMWContext.getThreadList();
                            Enumeration enumeration3 = this.threadList.elements();
                            while (enumeration3.hasMoreElements()) {
                                this.sMWThread = (SMWThread)enumeration3.nextElement();
                                if (this.yCoord <= this.sMWThread.getYDrawCoord()) {
                                    this.threadDataList = this.sMWThread.getThreadDataList();
                                    this.sMWThreadDataElementCounter = 0;
                                    Enumeration enumeration4 = this.threadDataList.elements();
                                    while (enumeration4.hasMoreElements()) {
                                        this.sMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                                        if (this.xCoord < this.barXStart) {
                                            if (this.yCoord >= this.sMWThreadDataElement.getYBeg() && this.yCoord <= this.sMWThreadDataElement.getYEnd()) {
                                                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                                                    ThreadDataWindow threadDataWindow = new ThreadDataWindow(this.serverCounter, this.contextCounter, this.threadCounter, this.sMWindow.getSMWData());
                                                    jRacy.systemEvents.addObserver(threadDataWindow);
                                                    threadDataWindow.show();
                                                } else {
                                                    TotalStatWindow totalStatWindow = new TotalStatWindow(this.serverCounter, this.contextCounter, this.threadCounter, this.sMWindow.getSMWData());
                                                    jRacy.systemEvents.addObserver(totalStatWindow);
                                                    totalStatWindow.show();
                                                }
                                            }
                                            return;
                                        }
                                        if (this.xCoord < this.sMWThreadDataElement.getXEnd()) {
                                            if (this.yCoord < this.sMWThreadDataElement.getYBeg() || this.yCoord > this.sMWThreadDataElement.getYEnd()) continue;
                                            if ((mouseEvent.getModifiers() & 0x10) == 0) {
                                                this.clickedOnObject = this.sMWThreadDataElement;
                                                this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                                                return;
                                            }
                                            jRacy.clrChooser.setHighlightColorFunctionID(this.sMWThreadDataElement.getFunctionID());
                                            FunctionDataWindow functionDataWindow = new FunctionDataWindow(this.sMWThreadDataElement.getFunctionName(), this.sMWindow.getSMWData());
                                            jRacy.systemEvents.addObserver(functionDataWindow);
                                            functionDataWindow.show();
                                            return;
                                        }
                                        ++this.sMWThreadDataElementCounter;
                                    }
                                }
                                ++this.threadCounter;
                            }
                        }
                        ++this.contextCounter;
                    }
                }
                ++this.serverCounter;
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "SMWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.numberOfColors = jRacy.clrChooser.getNumberOfColors();
            if (this.sMWindow.isDataLoaded()) {
                this.colorCounter = 0;
                this.sMWThreadDataElementCounter = 0;
                this.threadCounter = 0;
                this.contextCounter = 0;
                this.serverCounter = 0;
                this.highlighted = false;
                this.yCoord = 0;
                this.xCoord = 0;
                if (!jRacy.jRacyPreferences.areBarDetailsSet()) {
                    Font font = new Font(jRacy.jRacyPreferences.getJRacyFont(), jRacy.jRacyPreferences.getFontStyle(), 12);
                    graphics.setFont(font);
                    FontMetrics fontMetrics = graphics.getFontMetrics(font);
                    int n = fontMetrics.getAscent();
                    int n2 = fontMetrics.getMaxDescent();
                    int n3 = n + n2;
                    jRacy.jRacyPreferences.setBarDetails(n, n3 + 5);
                    jRacy.jRacyPreferences.setSliders(n, n3 + 5);
                }
                int n = jRacy.jRacyPreferences.getBarSpacing();
                int n4 = jRacy.jRacyPreferences.getBarHeight();
                Font font = new Font(jRacy.jRacyPreferences.getJRacyFont(), jRacy.jRacyPreferences.getFontStyle(), n4);
                graphics.setFont(font);
                FontMetrics fontMetrics = graphics.getFontMetrics(font);
                String string = new String("n,c,t 99,99,99");
                int n5 = fontMetrics.stringWidth(string);
                this.barXStart = n5 + 15;
                int n6 = this.barXStart + 500;
                int n7 = this.barXStart;
                this.yCoord += n;
                String string2 = "Mean";
                int n8 = fontMetrics.stringWidth(string2);
                graphics.drawString(string2, this.barXStart - n8 - 5, this.yCoord);
                this.tmpSum = 0.0;
                Enumeration enumeration = this.sMWindow.getSMWMeanData().elements();
                while (enumeration.hasMoreElements()) {
                    this.sMWMeanDataElement = (SMWMeanDataElement)enumeration.nextElement();
                    this.tmpSum += this.sMWMeanDataElement.getValue();
                }
                this.colorCounter = 0;
                n7 = this.barXStart;
                Enumeration enumeration2 = this.sMWindow.getSMWMeanData().elements();
                while (enumeration2.hasMoreElements()) {
                    this.sMWMeanDataElement = (SMWMeanDataElement)enumeration2.nextElement();
                    this.tmpDataValue = this.sMWMeanDataElement.getValue();
                    if (this.tmpDataValue > 0.0) {
                        double d = this.tmpDataValue / this.tmpSum;
                        int n9 = (int)(d * 500.0);
                        if (n9 > 2) {
                            if (n4 > 2) {
                                this.tmpColor = this.sMWMeanDataElement.getFunctionColor();
                                graphics.setColor(this.tmpColor);
                                graphics.fillRect(n7 + 1, this.yCoord - n4 + 1, n9 - 1, n4 - 1);
                                if (this.sMWMeanDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                    this.highlighted = true;
                                    graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                    graphics.drawRect(n7, this.yCoord - n4, n9, n4);
                                    graphics.drawRect(n7 + 1, this.yCoord - n4 + 1, n9 - 2, n4 - 2);
                                } else {
                                    graphics.setColor(Color.black);
                                    if (this.highlighted) {
                                        graphics.drawLine(n7 + 1, this.yCoord - n4, n7 + 1 + n9, this.yCoord - n4);
                                        graphics.drawLine(n7 + 1, this.yCoord, n7 + 1 + n9, this.yCoord);
                                        graphics.drawLine(n7 + 1 + n9, this.yCoord - n4, n7 + 1 + n9, this.yCoord);
                                        this.highlighted = false;
                                    } else {
                                        graphics.drawRect(n7, this.yCoord - n4, n9, n4);
                                    }
                                }
                                this.sMWMeanDataElement.setDrawCoords(n7, n7 + n9, this.yCoord - n4, this.yCoord);
                                n7 += n9;
                            } else {
                                if (jRacy.clrChooser.getHighlightColorFunctionID() != -1) {
                                    if (this.sMWMeanDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                        graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                    } else {
                                        this.tmpColor = this.sMWMeanDataElement.getFunctionColor();
                                        graphics.setColor(this.tmpColor);
                                    }
                                } else {
                                    this.tmpColor = this.sMWMeanDataElement.getFunctionColor();
                                    graphics.setColor(this.tmpColor);
                                }
                                graphics.fillRect(n7, this.yCoord - n4, n9, n4);
                                graphics.setColor(Color.black);
                                graphics.drawRect(n7, this.yCoord - n4, n9, n4);
                                this.sMWMeanDataElement.setDrawCoords(n7, n7 + n9, this.yCoord - n4, this.yCoord);
                                n7 += n9;
                            }
                        }
                        this.sMWMeanDataElement.setDrawCoords(n7, n7, this.yCoord - n4, this.yCoord);
                    } else {
                        this.sMWMeanDataElement.setDrawCoords(n7, n7, this.yCoord - n4, this.yCoord);
                    }
                    this.colorCounter = (this.colorCounter + 1) % this.numberOfColors;
                }
                if (n7 < 500 + this.barXStart) {
                    graphics.setColor(jRacy.clrChooser.getMiscFunctionsColor());
                    graphics.fillRect(n7, this.yCoord - n4, 500 + this.barXStart - n7, n4);
                    graphics.setColor(Color.black);
                    graphics.drawRect(n7, this.yCoord - n4, 500 + this.barXStart - n7, n4);
                }
                graphics.setColor(Color.black);
                this.serverCounter = 0;
                Enumeration enumeration3 = this.sMWindow.getSMWGeneralData().elements();
                while (enumeration3.hasMoreElements()) {
                    this.sMWServer = (SMWServer)enumeration3.nextElement();
                    this.contextList = this.sMWServer.getContextList();
                    this.contextCounter = 0;
                    Enumeration enumeration4 = this.contextList.elements();
                    while (enumeration4.hasMoreElements()) {
                        this.sMWContext = (SMWContext)enumeration4.nextElement();
                        this.threadList = this.sMWContext.getThreadList();
                        this.threadCounter = 0;
                        Enumeration enumeration5 = this.threadList.elements();
                        while (enumeration5.hasMoreElements()) {
                            this.highlighted = false;
                            this.yCoord += n;
                            this.sMWThread = (SMWThread)enumeration5.nextElement();
                            String string3 = "n,c,t   " + this.serverCounter + "," + this.contextCounter + "," + this.threadCounter;
                            int n10 = fontMetrics.stringWidth(string3);
                            graphics.drawString(string3, this.barXStart - n10 - 5, this.yCoord);
                            this.threadDataList = this.sMWThread.getThreadDataList();
                            this.tmpSum = 0.0;
                            Enumeration enumeration6 = this.threadDataList.elements();
                            while (enumeration6.hasMoreElements()) {
                                this.sMWThreadDataElement = (SMWThreadDataElement)enumeration6.nextElement();
                                this.tmpSum += this.sMWThreadDataElement.getValue();
                            }
                            this.colorCounter = 0;
                            n7 = this.barXStart;
                            Enumeration enumeration7 = this.threadDataList.elements();
                            while (enumeration7.hasMoreElements()) {
                                this.sMWThreadDataElement = (SMWThreadDataElement)enumeration7.nextElement();
                                this.tmpDataValue = this.sMWThreadDataElement.getValue();
                                if (this.tmpDataValue > 0.0) {
                                    double d = this.tmpDataValue / this.tmpSum;
                                    int n11 = (int)(d * 500.0);
                                    if (n11 > 2) {
                                        if (n4 > 2) {
                                            this.tmpColor = this.sMWThreadDataElement.getFunctionColor();
                                            graphics.setColor(this.tmpColor);
                                            graphics.fillRect(n7 + 1, this.yCoord - n4 + 1, n11 - 1, n4 - 1);
                                            if (this.sMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                                this.highlighted = true;
                                                graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                                graphics.drawRect(n7, this.yCoord - n4, n11, n4);
                                                graphics.drawRect(n7 + 1, this.yCoord - n4 + 1, n11 - 2, n4 - 2);
                                            } else {
                                                graphics.setColor(Color.black);
                                                if (this.highlighted) {
                                                    graphics.drawLine(n7 + 1, this.yCoord - n4, n7 + 1 + n11, this.yCoord - n4);
                                                    graphics.drawLine(n7 + 1, this.yCoord, n7 + 1 + n11, this.yCoord);
                                                    graphics.drawLine(n7 + 1 + n11, this.yCoord - n4, n7 + 1 + n11, this.yCoord);
                                                    this.highlighted = false;
                                                } else {
                                                    graphics.drawRect(n7, this.yCoord - n4, n11, n4);
                                                }
                                            }
                                            this.sMWThreadDataElement.setDrawCoords(n7, n7 + n11, this.yCoord - n4, this.yCoord);
                                            n7 += n11;
                                        } else {
                                            if (jRacy.clrChooser.getHighlightColorFunctionID() != -1) {
                                                if (this.sMWThreadDataElement.getFunctionID() == jRacy.clrChooser.getHighlightColorFunctionID()) {
                                                    graphics.setColor(jRacy.clrChooser.getHighlightColor());
                                                } else {
                                                    this.tmpColor = this.sMWThreadDataElement.getFunctionColor();
                                                    graphics.setColor(this.tmpColor);
                                                }
                                            } else {
                                                this.tmpColor = this.sMWThreadDataElement.getFunctionColor();
                                                graphics.setColor(this.tmpColor);
                                            }
                                            graphics.fillRect(n7, this.yCoord - n4, n11, n4);
                                            graphics.setColor(Color.black);
                                            graphics.drawRect(n7, this.yCoord - n4, n11, n4);
                                            this.sMWThreadDataElement.setDrawCoords(n7, n7 + n11, this.yCoord - n4, this.yCoord);
                                            n7 += n11;
                                        }
                                    }
                                    this.sMWThreadDataElement.setDrawCoords(n7, n7, this.yCoord - n4, this.yCoord);
                                } else {
                                    this.sMWThreadDataElement.setDrawCoords(n7, n7, this.yCoord - n4, this.yCoord);
                                }
                                this.colorCounter = (this.colorCounter + 1) % this.numberOfColors;
                            }
                            if (n7 < 500 + this.barXStart) {
                                graphics.setColor(jRacy.clrChooser.getMiscFunctionsColor());
                                graphics.fillRect(n7, this.yCoord - n4, 500 + this.barXStart - n7, n4);
                                graphics.setColor(Color.black);
                                graphics.drawRect(n7, this.yCoord - n4, 500 + this.barXStart - n7, n4);
                            }
                            graphics.setColor(Color.black);
                            this.sMWThread.setYDrawCoord(this.yCoord);
                            ++this.threadCounter;
                        }
                        this.sMWContext.setYDrawCoord(this.yCoord);
                        ++this.contextCounter;
                    }
                    this.sMWServer.setYDrawCoord(this.yCoord);
                    ++this.serverCounter;
                }
                if (this.yCoord >= this.yPanelSize || n6 >= this.xPanelSize) {
                    this.xPanelSize = n6 + 1;
                    this.yPanelSize = this.yCoord + 1;
                    this.revalidate();
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "SMWP06");
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize + 10, this.yPanelSize + 10);
    }
}

