/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.SMWThreadDataElement;
import jRacy.StaticMainWindowData;
import jRacy.ThreadDataWindowPanel;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ThreadDataWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer {
    private JMenu unitsMenu = new JMenu("Select Units");
    private ButtonGroup sortGroup = null;
    private ButtonGroup sortOrderGroup = null;
    private ButtonGroup inclusiveExclusiveGroup = null;
    private ButtonGroup valuePercentGroup = null;
    private ButtonGroup unitsGroup = null;
    private JRadioButtonMenuItem ascendingButton = new JRadioButtonMenuItem("Ascending", false);
    private JRadioButtonMenuItem descendingButton = new JRadioButtonMenuItem("Descending", true);
    private JRadioButtonMenuItem functionIDButton = new JRadioButtonMenuItem("function ID", false);
    private JRadioButtonMenuItem nameButton = new JRadioButtonMenuItem("name", false);
    private JRadioButtonMenuItem millisecondButton = new JRadioButtonMenuItem("millisecond", true);
    private JRadioButtonMenuItem inclusiveRadioButton = new JRadioButtonMenuItem("Inclusive", false);
    private JRadioButtonMenuItem exclusiveRadioButton = new JRadioButtonMenuItem("Exclusive", true);
    private JRadioButtonMenuItem valueButton = new JRadioButtonMenuItem("Value", false);
    private JRadioButtonMenuItem percentButton = new JRadioButtonMenuItem("Percent", true);
    private JRadioButtonMenuItem secondsButton = new JRadioButtonMenuItem("Seconds", false);
    private JRadioButtonMenuItem millisecondsButton = new JRadioButtonMenuItem("Milliseconds", false);
    private JRadioButtonMenuItem microsecondsButton = new JRadioButtonMenuItem("Microseconds", true);
    private JLabel barLengthLabel = new JLabel("Bar Mulitiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private ThreadDataWindowPanel threadDataWindowPanelRef = null;
    private StaticMainWindowData sMWData = null;
    SMWThreadDataElement tmpSMWThreadDataElement = null;
    Vector currentSMWThreadData = null;
    private boolean sortByFunctionID = false;
    private boolean sortByName = false;
    private boolean sortByMillisecond = true;
    private boolean descendingOrder = true;
    private boolean inclusive = false;
    private boolean percent = true;
    private String unitsString = "milliseconds";
    private int server = -1;
    private int context = -1;
    private int thread = -1;

    public ThreadDataWindow() {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(700, 450));
            this.setTitle("Wrong constructor used!");
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDW01");
        }
    }

    public ThreadDataWindow(int n, int n2, int n3, StaticMainWindowData staticMainWindowData) {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(700, 450));
            this.sMWData = staticMainWindowData;
            this.server = n;
            this.context = n2;
            this.thread = n3;
            this.setTitle("n,c,t, " + this.server + "," + this.context + "," + this.thread);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ThreadDataWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (jRacy.helpWindow.isVisible()) {
                jRacy.helpWindow.clearText();
                jRacy.helpWindow.writeText("This is the thread data window");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("This window shows you the values for all functions on this thread.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Right click on any function within this window to bring up a popup");
                jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                jRacy.helpWindow.writeText("for the function, or to show more details about the function.");
                jRacy.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
            }
            this.sortLocalData();
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit Racy!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Options");
            jMenu2.addMenuListener(this);
            JMenu jMenu3 = new JMenu("Sort by ...");
            this.sortGroup = new ButtonGroup();
            this.functionIDButton.addActionListener(this);
            this.nameButton.addActionListener(this);
            this.millisecondButton.addActionListener(this);
            this.sortGroup.add(this.functionIDButton);
            this.sortGroup.add(this.nameButton);
            this.sortGroup.add(this.millisecondButton);
            jMenu3.add(this.functionIDButton);
            jMenu3.add(this.nameButton);
            jMenu3.add(this.millisecondButton);
            jMenu2.add(jMenu3);
            JMenu jMenu4 = new JMenu("Sort Order");
            this.sortOrderGroup = new ButtonGroup();
            this.ascendingButton.addActionListener(this);
            this.descendingButton.addActionListener(this);
            this.sortOrderGroup.add(this.ascendingButton);
            this.sortOrderGroup.add(this.descendingButton);
            jMenu4.add(this.ascendingButton);
            jMenu4.add(this.descendingButton);
            jMenu2.add(jMenu4);
            JMenu jMenu5 = new JMenu("Select Inclusive or Exclusive");
            this.inclusiveExclusiveGroup = new ButtonGroup();
            this.inclusiveRadioButton.addActionListener(this);
            this.exclusiveRadioButton.addActionListener(this);
            this.inclusiveExclusiveGroup.add(this.inclusiveRadioButton);
            this.inclusiveExclusiveGroup.add(this.exclusiveRadioButton);
            jMenu5.add(this.inclusiveRadioButton);
            jMenu5.add(this.exclusiveRadioButton);
            jMenu2.add(jMenu5);
            JMenu jMenu6 = new JMenu("Select Value or Percent");
            this.valuePercentGroup = new ButtonGroup();
            this.percentButton.addActionListener(this);
            this.valueButton.addActionListener(this);
            this.valuePercentGroup.add(this.percentButton);
            this.valuePercentGroup.add(this.valueButton);
            jMenu6.add(this.percentButton);
            jMenu6.add(this.valueButton);
            jMenu2.add(jMenu6);
            this.unitsGroup = new ButtonGroup();
            this.secondsButton.addActionListener(this);
            this.millisecondsButton.addActionListener(this);
            this.microsecondsButton.addActionListener(this);
            this.unitsGroup.add(this.secondsButton);
            this.unitsGroup.add(this.millisecondsButton);
            this.unitsGroup.add(this.microsecondsButton);
            this.unitsMenu.add(this.secondsButton);
            this.unitsMenu.add(this.millisecondsButton);
            this.unitsMenu.add(this.microsecondsButton);
            jMenu2.add(this.unitsMenu);
            JMenu jMenu7 = new JMenu("Windows");
            JMenuItem jMenuItem3 = new JMenuItem("Show Function Ledger");
            JMenuItem jMenuItem4 = new JMenuItem("Close All Sub-Windows");
            jMenuItem3.addActionListener(this);
            jMenuItem4.addActionListener(this);
            jMenu7.add(jMenuItem3);
            jMenu7.add(jMenuItem4);
            JMenu jMenu8 = new JMenu("Help");
            JMenuItem jMenuItem5 = new JMenuItem("About Racy");
            JMenuItem jMenuItem6 = new JMenuItem("Show Help Window");
            jMenuItem5.addActionListener(this);
            jMenuItem6.addActionListener(this);
            jMenu8.add(jMenuItem5);
            jMenu8.add(jMenuItem6);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu7);
            jMenuBar.add(jMenu8);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.threadDataWindowPanelRef = new ThreadDataWindowPanel(n, n2, n3, this, this.sMWData);
            JScrollPane jScrollPane = new JScrollPane(this.threadDataWindowPanelRef);
            jScrollPane.setBorder(border);
            jScrollPane.setPreferredSize(new Dimension(500, 450));
            this.barLengthSlider.setPaintTicks(true);
            this.barLengthSlider.setMajorTickSpacing(5);
            this.barLengthSlider.setMinorTickSpacing(1);
            this.barLengthSlider.setPaintLabels(true);
            this.barLengthSlider.setSnapToTicks(true);
            this.barLengthSlider.addChangeListener(this.threadDataWindowPanelRef);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.475;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.475;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, gridBagConstraints, 1, 0, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.95;
            gridBagConstraints.weighty = 0.98;
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 1, 2, 1);
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit Racy!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("function ID")) {
                    if (this.functionIDButton.isSelected()) {
                        this.sortByFunctionID = true;
                        this.sortByName = false;
                        this.sortByMillisecond = false;
                        this.sortLocalData();
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("name")) {
                    if (this.nameButton.isSelected()) {
                        this.sortByFunctionID = false;
                        this.sortByName = true;
                        this.sortByMillisecond = false;
                        this.sortLocalData();
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("millisecond")) {
                    if (this.millisecondButton.isSelected()) {
                        this.sortByFunctionID = false;
                        this.sortByName = false;
                        this.sortByMillisecond = true;
                        this.sortLocalData();
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Descending")) {
                    if (this.descendingButton.isSelected()) {
                        this.descendingOrder = true;
                        this.sortLocalData();
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Ascending")) {
                    if (this.ascendingButton.isSelected()) {
                        this.descendingOrder = false;
                        this.sortLocalData();
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Inclusive")) {
                    if (this.inclusiveRadioButton.isSelected()) {
                        this.inclusive = true;
                        this.sortLocalData();
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Exclusive")) {
                    if (this.exclusiveRadioButton.isSelected()) {
                        this.inclusive = false;
                        this.sortLocalData();
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Percent")) {
                    if (this.percentButton.isSelected()) {
                        this.percent = true;
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Value")) {
                    if (this.valueButton.isSelected()) {
                        this.percent = false;
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Seconds")) {
                    if (this.secondsButton.isSelected()) {
                        this.unitsString = "Seconds";
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Microseconds")) {
                    if (this.microsecondsButton.isSelected()) {
                        this.unitsString = "Microseconds";
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Milliseconds")) {
                    if (this.millisecondsButton.isSelected()) {
                        this.unitsString = "Milliseconds";
                        this.threadDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Show Function Ledger")) {
                    jRacy.staticSystemData.getGlobalMapping().displayFunctionLedger();
                } else if (string.equals("Close All Sub-Windows")) {
                    jRacy.systemEvents.updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    jRacy.helpWindow.clearText();
                    jRacy.helpWindow.show();
                    jRacy.helpWindow.writeText("This is the thread data window");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("This window shows you the values for all functions on this thread.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Right click on any function within this window to bring up a popup");
                    jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                    jRacy.helpWindow.writeText("for the function, or to show more details about the function.");
                    jRacy.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDW03");
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.percent) {
                this.unitsMenu.setEnabled(false);
            } else {
                this.unitsMenu.setEnabled(true);
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDW04");
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.threadDataWindowPanelRef.repaint();
            } else if (string.equals("colorEvent")) {
                this.threadDataWindowPanelRef.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDW05");
        }
    }

    private void sortLocalData() {
        try {
            if (this.sortByFunctionID) {
                this.currentSMWThreadData = this.inclusive ? (this.descendingOrder ? this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "FIdDI") : this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "FIdAI")) : (this.descendingOrder ? this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "FIdDE") : this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "FIdAE"));
            } else if (this.sortByName) {
                this.currentSMWThreadData = this.inclusive ? (this.descendingOrder ? this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "NDI") : this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "NAI")) : (this.descendingOrder ? this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "NDE") : this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "NAE"));
            } else if (this.sortByMillisecond) {
                this.currentSMWThreadData = this.inclusive ? (this.descendingOrder ? this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDI") : this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MAI")) : (this.descendingOrder ? this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDE") : this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MAE"));
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDW06");
        }
    }

    public Vector getStaticMainWindowSystemData() {
        return this.currentSMWThreadData;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public String units() {
        return this.unitsString;
    }

    public int getSliderValue() {
        int n = -1;
        try {
            n = this.barLengthSlider.getValue();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDW07");
        }
        return n;
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDW08");
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (jRacy.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("A thread window for: \"n,c,t, " + this.server + "," + this.context + "," + this.thread + "\" is closing");
                System.out.println("Clearing resourses for that window.");
            }
            ((Component)this).setVisible(false);
            jRacy.systemEvents.deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TDW09");
        }
    }
}

