/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.StaticMainWindowData;
import jRacy.TotalStatWindowPanel;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class TotalStatWindow
extends JFrame
implements ActionListener,
Observer {
    private TotalStatWindowPanel totalStatWindowPanelRef;
    private StaticMainWindowData sMWData = new StaticMainWindowData();
    ButtonGroup sortGroup;
    ButtonGroup sortOrderGroup;
    ButtonGroup inclusiveExclusiveGroup;
    JRadioButtonMenuItem functionIDButton;
    JRadioButtonMenuItem nameButton;
    JRadioButtonMenuItem millisecondButton;
    JRadioButtonMenuItem ascendingButton;
    JRadioButtonMenuItem descendingButton;
    JRadioButtonMenuItem inclusiveRadioButton;
    JRadioButtonMenuItem exclusiveRadioButton;
    boolean sortByFunctionID = false;
    boolean sortByName = false;
    boolean sortByMillisecond = true;
    boolean descendingOrder = true;
    boolean inclusive = false;
    int server;
    int context;
    int thread;
    Vector FIdDE;
    Vector FIdAE;
    Vector NDE;
    Vector NAE;
    Vector MDE;
    Vector MAE;
    Vector MDI;
    Vector MAI;

    public TotalStatWindow() {
        try {
            ((Component)this).setLocation(new Point(0, 0));
            ((Component)this).setSize(new Dimension(800, 600));
            this.setTitle("Wrong constructor used!");
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TSW01");
        }
    }

    public TotalStatWindow(int n, int n2, int n3, StaticMainWindowData staticMainWindowData) {
        try {
            ((Component)this).setLocation(new Point(0, 0));
            ((Component)this).setSize(new Dimension(800, 600));
            this.setTitle("Total n,c,t, " + n + "," + n2 + "," + n3);
            this.server = n;
            this.context = n2;
            this.thread = n3;
            this.FIdDE = null;
            this.FIdAE = null;
            this.NDE = null;
            this.NAE = null;
            this.MDE = null;
            this.MAE = null;
            this.MDI = null;
            this.MAI = null;
            this.sMWData = staticMainWindowData;
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    TotalStatWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (jRacy.helpWindow.isVisible()) {
                jRacy.helpWindow.clearText();
                jRacy.helpWindow.writeText("This is the total function statistics window.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("This window shows you the total statistics for all functions on this thread.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Right click on any function within this window to bring up a popup");
                jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                jRacy.helpWindow.writeText("for the function, or to show more details about the function.");
                jRacy.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
            }
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit Racy!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Options");
            JMenu jMenu3 = new JMenu("Sort by ...");
            this.sortGroup = new ButtonGroup();
            this.functionIDButton = new JRadioButtonMenuItem("function ID", false);
            this.functionIDButton.addActionListener(this);
            this.nameButton = new JRadioButtonMenuItem("name", false);
            this.nameButton.addActionListener(this);
            this.millisecondButton = new JRadioButtonMenuItem("millisecond", true);
            this.millisecondButton.addActionListener(this);
            this.sortGroup.add(this.functionIDButton);
            this.sortGroup.add(this.nameButton);
            this.sortGroup.add(this.millisecondButton);
            jMenu3.add(this.functionIDButton);
            jMenu3.add(this.nameButton);
            jMenu3.add(this.millisecondButton);
            jMenu2.add(jMenu3);
            JMenu jMenu4 = new JMenu("Sort Order");
            this.sortOrderGroup = new ButtonGroup();
            this.ascendingButton = new JRadioButtonMenuItem("Ascending", false);
            this.ascendingButton.addActionListener(this);
            this.descendingButton = new JRadioButtonMenuItem("Descending", true);
            this.descendingButton.addActionListener(this);
            this.sortOrderGroup.add(this.ascendingButton);
            this.sortOrderGroup.add(this.descendingButton);
            jMenu4.add(this.ascendingButton);
            jMenu4.add(this.descendingButton);
            jMenu2.add(jMenu4);
            JMenu jMenu5 = new JMenu("Select Inclusive or Exclusive");
            this.inclusiveExclusiveGroup = new ButtonGroup();
            this.inclusiveRadioButton = new JRadioButtonMenuItem("Inclusive", false);
            this.inclusiveRadioButton.addActionListener(this);
            this.exclusiveRadioButton = new JRadioButtonMenuItem("Exclusive", true);
            this.exclusiveRadioButton.addActionListener(this);
            this.inclusiveExclusiveGroup.add(this.inclusiveRadioButton);
            this.inclusiveExclusiveGroup.add(this.exclusiveRadioButton);
            jMenu5.add(this.inclusiveRadioButton);
            jMenu5.add(this.exclusiveRadioButton);
            jMenu2.add(jMenu5);
            JMenuItem jMenuItem3 = new JMenuItem("Adjust Racy Colors");
            jMenuItem3.addActionListener(this);
            jMenu2.add(jMenuItem3);
            JMenu jMenu6 = new JMenu("Windows");
            JMenuItem jMenuItem4 = new JMenuItem("Show Function Ledger");
            jMenuItem4.addActionListener(this);
            jMenu6.add(jMenuItem4);
            JMenuItem jMenuItem5 = new JMenuItem("Close All Sub-Windows");
            jMenuItem5.addActionListener(this);
            jMenu6.add(jMenuItem5);
            JMenu jMenu7 = new JMenu("Help");
            JMenuItem jMenuItem6 = new JMenuItem("About Racy");
            jMenuItem6.addActionListener(this);
            jMenu7.add(jMenuItem6);
            JMenuItem jMenuItem7 = new JMenuItem("Show Help Window");
            jMenuItem7.addActionListener(this);
            jMenu7.add(jMenuItem7);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu6);
            jMenuBar.add(jMenu7);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.totalStatWindowPanelRef = new TotalStatWindowPanel(n, n2, n3, this);
            JScrollPane jScrollPane = new JScrollPane(this.totalStatWindowPanelRef);
            JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
            jScrollBar.setUnitIncrement(35);
            jScrollPane.setBorder(border);
            jScrollPane.setPreferredSize(new Dimension(500, 450));
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 0, 1, 1);
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TSW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit Racy!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("Adjust Racy Colors")) {
                    jRacy.clrChooser.showColorChooser();
                } else if (string.equals("function ID")) {
                    if (this.functionIDButton.isSelected()) {
                        this.sortByFunctionID = true;
                        this.sortByName = false;
                        this.sortByMillisecond = false;
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("name")) {
                    if (this.nameButton.isSelected()) {
                        this.sortByFunctionID = false;
                        this.sortByName = true;
                        this.sortByMillisecond = false;
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("millisecond")) {
                    if (this.millisecondButton.isSelected()) {
                        this.sortByFunctionID = false;
                        this.sortByName = false;
                        this.sortByMillisecond = true;
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Descending")) {
                    if (this.descendingButton.isSelected()) {
                        this.descendingOrder = true;
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Ascending")) {
                    if (this.ascendingButton.isSelected()) {
                        this.descendingOrder = false;
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Inclusive")) {
                    if (this.inclusiveRadioButton.isSelected()) {
                        this.inclusive = true;
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Exclusive")) {
                    if (this.exclusiveRadioButton.isSelected()) {
                        this.inclusive = false;
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Show Function Ledger")) {
                    jRacy.staticSystemData.getGlobalMapping().displayFunctionLedger();
                } else if (string.equals("Close All Sub-Windows")) {
                    jRacy.systemEvents.updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    jRacy.helpWindow.clearText();
                    jRacy.helpWindow.show();
                    jRacy.helpWindow.writeText("This is the total function statistics window.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("This window shows you the total statistics for all functions on this thread.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Right click on any function within this window to bring up a popup");
                    jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                    jRacy.helpWindow.writeText("for the function, or to show more details about the function.");
                    jRacy.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TSW03");
        }
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.totalStatWindowPanelRef.repaint();
            }
            if (string.equals("colorEvent")) {
                this.totalStatWindowPanelRef.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TSW04");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TSW05");
        }
    }

    public Vector getStaticMainWindowSystemData() {
        try {
            if (this.sortByFunctionID) {
                if (this.descendingOrder) {
                    if (this.FIdDE == null) {
                        this.FIdDE = this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "FIdDE");
                        return this.FIdDE;
                    }
                    return this.FIdDE;
                }
                if (this.FIdAE == null) {
                    this.FIdAE = this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "FIdAE");
                    return this.FIdAE;
                }
                return this.FIdAE;
            }
            if (this.sortByName) {
                if (this.descendingOrder) {
                    if (this.NDE == null) {
                        this.NDE = this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "NDE");
                        return this.NDE;
                    }
                    return this.NDE;
                }
                if (this.NAE == null) {
                    this.NAE = this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "NAE");
                    return this.NAE;
                }
                return this.NAE;
            }
            if (this.sortByMillisecond) {
                if (this.inclusive) {
                    if (this.descendingOrder) {
                        if (this.MDI == null) {
                            this.MDI = this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDI");
                            return this.MDI;
                        }
                        return this.MDI;
                    }
                    if (this.MAI == null) {
                        this.MAI = this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MAI");
                        return this.MAI;
                    }
                    return this.MAI;
                }
                if (this.descendingOrder) {
                    if (this.MDE == null) {
                        this.MDE = this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDE");
                        return this.MDE;
                    }
                    return this.MDE;
                }
                if (this.MAE == null) {
                    this.MAE = this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MAE");
                    return this.MAE;
                }
                return this.MAE;
            }
            return null;
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TSW06");
            return null;
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (jRacy.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("A total stat window for: \"n,c,t, " + this.server + "," + this.context + "," + this.thread + "\" is closing");
                System.out.println("Clearing resourses for this window.");
            }
            ((Component)this).setVisible(false);
            jRacy.systemEvents.deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            jRacy.systemError(null, "TSW07");
        }
    }
}

