/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import paraprof.BinWindowPanel;
import paraprof.ParaProf;
import paraprof.ParaProfManager;
import paraprof.StaticMainWindowData;
import paraprof.Trial;

public class BinWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer {
    Trial trial = null;
    private BinWindowPanel bWPanel;
    private StaticMainWindowData sMWData = null;
    private int mappingID = -1;
    private Vector sMWGeneralData = null;
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    private JScrollPane scrollPane;
    private JMenuItem mappingGroupLedgerItem;
    private JMenuItem userEventLedgerItem;
    private Vector currentSMWGeneralData = null;
    private Vector currentSMWMeanData = null;
    private boolean mShown = false;

    public BinWindow(Trial trial, StaticMainWindowData staticMainWindowData, boolean bl, int n) {
        try {
            this.trial = trial;
            this.mappingID = n;
            this.sMWData = staticMainWindowData;
            this.setTitle("ParaProf: " + this.trial.getProfilePathName());
            int n2 = 750;
            int n3 = 500;
            this.setSize(new Dimension(n2, n3));
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    BinWindow.this.thisWindowClosing(windowEvent);
                }
            });
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            int n4 = dimension.height;
            int n5 = dimension.width;
            int n6 = (n5 - n2) / 2;
            int n7 = (n4 - n3) / 2;
            this.setLocation(n6, n7);
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenu jMenu2 = new JMenu("Open ...");
            JMenuItem jMenuItem = new JMenuItem("ParaProf Manager");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenu.add(jMenu2);
            JMenuItem jMenuItem2 = new JMenuItem("Edit ParaProf Preferences!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Exit ParaProf!");
            jMenuItem3.addActionListener(this);
            jMenu.add(jMenuItem3);
            JMenu jMenu3 = new JMenu("Options");
            JMenu jMenu4 = new JMenu("Windows");
            jMenu4.addMenuListener(this);
            JMenuItem jMenuItem4 = new JMenuItem("Show Function Ledger");
            jMenuItem4.addActionListener(this);
            jMenu4.add(jMenuItem4);
            this.mappingGroupLedgerItem = new JMenuItem("Show Group Ledger");
            this.mappingGroupLedgerItem.addActionListener(this);
            jMenu4.add(this.mappingGroupLedgerItem);
            this.userEventLedgerItem = new JMenuItem("Show User Event Ledger");
            this.userEventLedgerItem.addActionListener(this);
            jMenu4.add(this.userEventLedgerItem);
            JMenuItem jMenuItem5 = new JMenuItem("Close All Sub-Windows");
            jMenuItem5.addActionListener(this);
            jMenu4.add(jMenuItem5);
            JMenu jMenu5 = new JMenu("Help");
            JMenuItem jMenuItem6 = new JMenuItem("Show Help Window");
            jMenuItem6.addActionListener(this);
            jMenu5.add(jMenuItem6);
            JMenuItem jMenuItem7 = new JMenuItem("About Racy");
            jMenuItem7.addActionListener(this);
            jMenu5.add(jMenuItem7);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu3);
            jMenuBar.add(jMenu4);
            jMenuBar.add(jMenu5);
            this.setJMenuBar(jMenuBar);
            this.contentPane = this.getContentPane();
            this.gbl = new GridBagLayout();
            this.contentPane.setLayout(this.gbl);
            this.gbc = new GridBagConstraints();
            this.gbc.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.bWPanel = new BinWindowPanel(this.trial, this, bl, n);
            this.bWPanel.setPreferredSize(new Dimension(600, 300));
            this.scrollPane = new JScrollPane(this.bWPanel);
            this.scrollPane.setBorder(border);
            this.scrollPane.setPreferredSize(new Dimension(600, 300));
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
            this.addCompItem(this.scrollPane, this.gbc, 0, 0, 1, 1);
            this.bWPanel.repaint();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "BW01");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block19: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block19;
                String string = actionEvent.getActionCommand();
                if (string.equals("ParaProf Manager")) {
                    ParaProfManager paraProfManager = new ParaProfManager();
                    paraProfManager.show();
                } else if (string.equals("Edit ParaProf Preferences!")) {
                    this.trial.getPreferences().showPreferencesWindow();
                } else if (string.equals("Exit ParaProf!")) {
                    this.setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("Show Function Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(0);
                } else if (string.equals("Show Group Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(1);
                } else if (string.equals("Show User Event Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(2);
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    ParaProf.helpWindow.show();
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "BW02");
            }
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        block5: {
            try {
                if (this.trial.groupNamesPresent()) {
                    this.mappingGroupLedgerItem.setEnabled(true);
                } else {
                    this.mappingGroupLedgerItem.setEnabled(false);
                }
                if (this.trial.userEventsPresent()) {
                    this.userEventLedgerItem.setEnabled(true);
                    break block5;
                }
                this.userEventLedgerItem.setEnabled(false);
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "BW03");
            }
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.bWPanel.repaint();
            } else if (string.equals("colorEvent")) {
                this.bWPanel.repaint();
            } else if (string.equals("dataEvent")) {
                this.bWPanel.repaint();
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "BW04");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.contentPane.add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "BW05");
        }
    }

    public Vector getStaticMainWindowSystemData() {
        try {
            if (this.sMWGeneralData == null) {
                this.sMWGeneralData = this.sMWData.getSMWMappingData(this.mappingID);
                return this.sMWGeneralData;
            }
            return this.sMWGeneralData;
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDW06");
            return null;
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

