/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import paraprof.BinWindow;
import paraprof.GlobalMapping;
import paraprof.GlobalMappingElement;
import paraprof.ParaProf;
import paraprof.SMWContext;
import paraprof.SMWMeanDataElement;
import paraprof.SMWServer;
import paraprof.SMWThread;
import paraprof.SMWThreadDataElement;
import paraprof.Trial;

public class BinWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
PopupMenuListener {
    private Trial trial = null;
    BinWindow binWindow = null;
    boolean normalBin = true;
    int mappingID = -1;
    int xPanelSize = 600;
    int yPanelSize = 400;
    private JPopupMenu popup = new JPopupMenu();
    private JPopupMenu popup2 = new JPopupMenu();
    JMenuItem tUESWItem = new JMenuItem("Show Total User Event Statistics Windows");
    Vector contextList = null;
    Vector threadList = null;
    Vector threadDataList = null;
    SMWServer sMWServer = null;
    SMWContext sMWContext = null;
    SMWThread sMWThread = null;
    SMWThreadDataElement sMWThreadDataElement = null;
    SMWMeanDataElement sMWMeanDataElement = null;
    int xCoord = -1;
    int yCoord = -1;
    Object clickedOnObject = null;
    String counterName = null;
    private int defaultBarLength = 500;
    String tmpString = null;
    double tmpSum = -1.0;
    double tmpDataValue = -1.0;
    Color tmpColor = null;
    boolean highlighted = false;
    int barXStart = -1;
    int numberOfColors = 0;

    public BinWindowPanel() {
        try {
            this.setToolTipText("Incorrect Constructor!!!");
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMWP01");
        }
    }

    public BinWindowPanel(Trial trial, BinWindow binWindow, boolean bl, int n) {
        try {
            this.setToolTipText("ParaProf bar graph draw window!");
            this.setBackground(Color.white);
            this.normalBin = bl;
            this.mappingID = n;
            this.addMouseListener(this);
            this.trial = trial;
            this.binWindow = binWindow;
            this.barXStart = 100;
            JMenuItem jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change Function Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Highlight this Function");
            jMenuItem4.addActionListener(this);
            this.popup.add(jMenuItem4);
            JMenuItem jMenuItem5 = new JMenuItem("Un-Highlight this Function");
            jMenuItem5.addActionListener(this);
            this.popup.add(jMenuItem5);
            this.popup2.addPopupMenuListener(this);
            JMenuItem jMenuItem6 = new JMenuItem("Show Total Statistics Windows");
            jMenuItem6.addActionListener(this);
            this.popup2.add(jMenuItem6);
            this.tUESWItem = new JMenuItem("Show Total User Event Statistics Windows");
            this.tUESWItem.addActionListener(this);
            this.popup2.add(this.tUESWItem);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMWP02");
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void paintComponent(Graphics graphics) {
        try {
            Object object;
            Object object2;
            Object object3;
            Cloneable cloneable;
            Cloneable cloneable2;
            Cloneable cloneable3;
            Object object4;
            Serializable serializable;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.numberOfColors = this.trial.getColorChooser().getNumberOfColors();
            GlobalMapping globalMapping = this.trial.getGlobalMapping();
            boolean bl = false;
            int n = 0;
            if (globalMapping.getIsSelectedGroupOn()) {
                bl = true;
                n = globalMapping.getSelectedGroupID();
            }
            this.highlighted = false;
            this.yCoord = 0;
            this.xCoord = 0;
            if (!this.trial.getPreferences().areBarDetailsSet()) {
                Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), 12);
                graphics.setFont(font);
                FontMetrics fontMetrics = graphics.getFontMetrics(font);
                int n2 = fontMetrics.getAscent();
                int n3 = fontMetrics.getMaxDescent();
                int n4 = n2 + n3;
                this.trial.getPreferences().setBarDetails(n2, n4 + 5);
                this.trial.getPreferences().setSliders(n2, n4 + 5);
            }
            int n5 = this.trial.getPreferences().getBarSpacing();
            int n6 = this.trial.getPreferences().getBarHeight();
            Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), n6);
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            String string = new String("n,c,t 99,99,99");
            int n7 = fontMetrics.stringWidth(string);
            this.barXStart = n7 + 15;
            int n8 = this.barXStart + this.defaultBarLength;
            int n9 = this.barXStart;
            this.yCoord += n5;
            Vector vector = this.trial.getGlobalMapping().getMapping(0);
            this.counterName = this.trial.getCounterName();
            if (this.counterName != null) {
                graphics.drawString("COUNTER NAME: " + this.counterName, 5, this.yCoord);
                serializable = (GlobalMappingElement)vector.elementAt(this.mappingID);
                String string2 = ((GlobalMappingElement)serializable).getMappingName();
                graphics.drawString(string2, 360, this.yCoord);
                this.yCoord += n5;
            }
            serializable = graphics.getClipBounds();
            int n10 = (int)((Rectangle)serializable).getY();
            int n11 = (int)((double)n10 + ((Rectangle)serializable).getHeight());
            n11 += n5;
            this.yCoord += n5;
            graphics.setColor(Color.black);
            graphics.drawLine(35, 430, 35, 30);
            graphics.drawLine(35, 430, 585, 430);
            double d = 0.0;
            double d2 = 0.0;
            boolean bl2 = true;
            if (this.normalBin) {
                int n12 = 0;
                while (n12 < vector.size()) {
                    object4 = (GlobalMappingElement)vector.elementAt(n12);
                    double d3 = ((GlobalMappingElement)object4).getTotalExclusiveValue(this.trial.getCurValLoc());
                    if (d3 > d) {
                        d = d3;
                    }
                    ++n12;
                }
            } else {
                SMWServer sMWServer = null;
                object4 = null;
                SMWThread sMWThread = null;
                SMWThreadDataElement sMWThreadDataElement = null;
                cloneable3 = null;
                cloneable2 = null;
                cloneable = null;
                object3 = this.binWindow.getStaticMainWindowSystemData().elements();
                while (object3.hasMoreElements()) {
                    sMWServer = (SMWServer)object3.nextElement();
                    cloneable3 = sMWServer.getContextList();
                    object2 = cloneable3.elements();
                    while (object2.hasMoreElements()) {
                        object4 = (SMWContext)object2.nextElement();
                        cloneable2 = ((SMWContext)object4).getThreadList();
                        Enumeration enumeration = ((Vector)cloneable2).elements();
                        while (enumeration.hasMoreElements()) {
                            sMWThread = (SMWThread)enumeration.nextElement();
                            cloneable = sMWThread.getThreadDataList();
                            object = ((Vector)cloneable).elements();
                            while (object.hasMoreElements()) {
                                sMWThreadDataElement = (SMWThreadDataElement)object.nextElement();
                                if (sMWThreadDataElement.getMappingID() != this.mappingID) continue;
                                double d4 = sMWThreadDataElement.getExclusiveValue();
                                if (bl2) {
                                    d2 = d4;
                                    bl2 = false;
                                }
                                System.out.println("value is: " + d4);
                                if (d4 > d) {
                                    d = d4;
                                }
                                if (!(d4 < d2)) continue;
                                d2 = d4;
                            }
                        }
                    }
                }
            }
            System.out.println("maxValue: " + d);
            double d5 = d / 10.0;
            int n13 = 0;
            while (n13 < 10) {
                graphics.drawLine(30, 30 + n13 * 40, 35, 30 + n13 * 40);
                graphics.drawString("" + 10 * (10 - n13), 5, 33 + n13 * 40);
                ++n13;
            }
            int n14 = 1;
            while (n14 < 11) {
                graphics.drawLine(35 + n14 * 55, 430, 35 + n14 * 55, 435);
                ++n14;
            }
            cloneable3 = graphics2D.getTransform();
            cloneable2 = new AffineTransform();
            ((AffineTransform)cloneable2).translate(30.0, 495.0);
            ((AffineTransform)cloneable2).rotate(Math.toRadians(90.0));
            graphics2D.setTransform((AffineTransform)cloneable2);
            cloneable = new AffineTransform();
            ((AffineTransform)cloneable).translate(27.5, 0.0);
            ((AffineTransform)cloneable2).preConcatenate((AffineTransform)cloneable);
            graphics2D.setTransform((AffineTransform)cloneable2);
            object3 = new AffineTransform();
            ((AffineTransform)object3).translate(55.0, 0.0);
            graphics2D.setTransform((AffineTransform)cloneable3);
            graphics.drawString("Min Value  = " + d2, 35, 450);
            graphics.drawString("Max Value = " + d, 552, 450);
            object2 = new int[10];
            int n15 = 0;
            while (n15 < 10) {
                object2[n15] = false;
                ++n15;
            }
            if (!this.normalBin) {
                object = null;
                SMWContext sMWContext = null;
                SMWThread sMWThread = null;
                SMWThreadDataElement sMWThreadDataElement = null;
                Vector vector2 = null;
                Vector vector3 = null;
                Vector vector4 = null;
                Enumeration enumeration = this.binWindow.getStaticMainWindowSystemData().elements();
                while (enumeration.hasMoreElements()) {
                    object = (SMWServer)enumeration.nextElement();
                    vector2 = ((SMWServer)object).getContextList();
                    Enumeration enumeration2 = vector2.elements();
                    while (enumeration2.hasMoreElements()) {
                        sMWContext = (SMWContext)enumeration2.nextElement();
                        vector3 = sMWContext.getThreadList();
                        Enumeration enumeration3 = vector3.elements();
                        while (enumeration3.hasMoreElements()) {
                            sMWThread = (SMWThread)enumeration3.nextElement();
                            vector4 = sMWThread.getThreadDataList();
                            Enumeration enumeration4 = vector4.elements();
                            block13: while (enumeration4.hasMoreElements()) {
                                sMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                                if (sMWThreadDataElement.getMappingID() != this.mappingID) continue;
                                double d6 = sMWThreadDataElement.getExclusiveValue();
                                int n16 = 10;
                                while (n16 > 0) {
                                    if (d6 <= d2 + (d - d2) / (double)n16) {
                                        Object object5 = object2;
                                        int n17 = 10 - n16;
                                        object5[n17] = object5[n17] + true;
                                        continue block13;
                                    }
                                    --n16;
                                }
                            }
                        }
                    }
                }
            } else {
                int n18 = 0;
                while (n18 < vector.size()) {
                    GlobalMappingElement globalMappingElement = (GlobalMappingElement)vector.elementAt(n18);
                    double d7 = globalMappingElement.getTotalExclusiveValue(this.trial.getCurValLoc());
                    int n19 = 10;
                    while (n19 > 0) {
                        if (d7 <= d / (double)n19) {
                            Object object6 = object2;
                            int n20 = 10 - n19;
                            object6[n20] = object6[n20] + true;
                            break;
                        }
                        --n19;
                    }
                    ++n18;
                }
            }
            int n21 = 0;
            while (n21 < 10) {
                System.out.println("Arr. Loc. " + n21 + " is: " + (int)object2[n21]);
                ++n21;
            }
            graphics.setColor(Color.red);
            int n22 = 512;
            System.out.println("Number of gm is: " + n22);
            int n23 = 0;
            while (n23 < 10) {
                if (object2[n23] != false) {
                    double d8 = (double)object2[n23];
                    double d9 = d8 / (double)n22 * 100.0;
                    int n24 = (int)d9;
                    System.out.println("result is: " + n24);
                    graphics.fillRect(38 + n23 * 55, 430 - n24 * 4, 49, n24 * 4);
                }
                ++n23;
            }
            boolean bl3 = false;
            if (n8 > 600) {
                this.xPanelSize = n8 + 1;
                bl3 = true;
            }
            if (this.yCoord > 300) {
                this.yPanelSize = this.yCoord + 1;
                bl3 = true;
            }
            if (bl3) {
                this.revalidate();
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMWP06");
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        block3: {
            try {
                if (this.trial.userEventsPresent()) {
                    this.tUESWItem.setEnabled(true);
                    break block3;
                }
                this.tUESWItem.setEnabled(false);
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "SMW03");
            }
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize + 10, this.yPanelSize + 10);
    }
}

