/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import paraprof.CallPathTextWindowPanel;
import paraprof.ParaProf;
import paraprof.ParaProfIterator;
import paraprof.StaticMainWindowData;
import paraprof.Trial;

public class CallPathTextWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer {
    private Trial trial = null;
    private CallPathTextWindowPanel panel;
    private StaticMainWindowData sMWData;
    private boolean global = false;
    private JMenu unitsMenu = null;
    private JMenuItem mappingGroupLedgerItem = null;
    private JMenuItem userEventLedgerItem = null;
    private ButtonGroup sortGroup = null;
    private ButtonGroup sortOrderGroup = null;
    private ButtonGroup unitsGroup = null;
    private ButtonGroup metricGroup = null;
    JRadioButtonMenuItem ascendingButton = new JRadioButtonMenuItem("Ascending", false);
    JRadioButtonMenuItem descendingButton = new JRadioButtonMenuItem("Descending", true);
    private JRadioButtonMenuItem nameButton = new JRadioButtonMenuItem("Name", false);
    private JRadioButtonMenuItem inclusiveRadioButton = new JRadioButtonMenuItem("Inclusive", false);
    private JRadioButtonMenuItem exclusiveRadioButton = new JRadioButtonMenuItem("Exclusive", true);
    private JRadioButtonMenuItem numOfCallsRadioButton = new JRadioButtonMenuItem("Number of Calls", false);
    private JRadioButtonMenuItem numOfSubRoutinesRadioButton = new JRadioButtonMenuItem("Number of Subroutines", false);
    private JRadioButtonMenuItem userSecPerCallRadioButton = new JRadioButtonMenuItem("Per Call Value", false);
    private JRadioButtonMenuItem secondsButton = null;
    private JRadioButtonMenuItem millisecondsButton = null;
    private JRadioButtonMenuItem microsecondsButton = null;
    private JRadioButtonMenuItem hMSButton = null;
    private String metric = "Exclusive";
    boolean sortByMappingID = false;
    boolean sortByName = false;
    boolean sortByMillisecond = true;
    boolean descendingOrder = true;
    boolean inclusive = false;
    private int units = 0;
    int server;
    int context;
    int thread;

    public CallPathTextWindow() {
        try {
            this.setLocation(new Point(0, 0));
            this.setSize(new Dimension(800, 600));
            this.setTitle("Wrong constructor used!");
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CPTW01");
        }
    }

    public CallPathTextWindow(Trial trial, int n, int n2, int n3, StaticMainWindowData staticMainWindowData, boolean bl) {
        try {
            this.trial = trial;
            this.sMWData = staticMainWindowData;
            this.global = bl;
            this.setLocation(new Point(0, 0));
            this.setSize(new Dimension(800, 600));
            if (bl) {
                this.setTitle("Call Path Data Relations - " + this.trial.getProfilePathName());
            } else {
                this.setTitle("Call Path Data n,c,t, " + n + "," + n2 + "," + n3 + " - " + this.trial.getProfilePathName());
            }
            this.server = n;
            this.context = n2;
            this.thread = n3;
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    CallPathTextWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (ParaProf.helpWindow.isVisible()) {
                ParaProf.helpWindow.clearText();
                ParaProf.helpWindow.writeText("Call path text window.");
                ParaProf.helpWindow.writeText("");
                ParaProf.helpWindow.writeText("This window displays call path relationships in two ways:");
                ParaProf.helpWindow.writeText("1- If this window has been invoked from the \"windows\" menu of");
                ParaProf.helpWindow.writeText("ParaProf, the information displayed is all call path relations found.");
                ParaProf.helpWindow.writeText("That is, all the parent/child relationships.");
                ParaProf.helpWindow.writeText("Thus, in this case, given the parallel nature of ParaProf, this information");
                ParaProf.helpWindow.writeText("might not be valid for a particular thread. It is however useful to observe");
                ParaProf.helpWindow.writeText("all the realtionships that exist in the data.");
                ParaProf.helpWindow.writeText("");
                ParaProf.helpWindow.writeText("2- If this window has been invoked from the popup menu to the left of a thread bar");
                ParaProf.helpWindow.writeText("in the main ParaProf window, the information dispayed will be specific to this thread,");
                ParaProf.helpWindow.writeText("and will thus contain both parent/child relations and the data relating to those");
                ParaProf.helpWindow.writeText("relationships.");
            }
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit ParaProf!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Options");
            jMenu2.addMenuListener(this);
            this.sortGroup = new ButtonGroup();
            this.ascendingButton.addActionListener(this);
            this.descendingButton.addActionListener(this);
            this.sortGroup.add(this.ascendingButton);
            this.sortGroup.add(this.descendingButton);
            JMenu jMenu3 = new JMenu("Sort Order");
            this.sortOrderGroup = new ButtonGroup();
            this.nameButton.addActionListener(this);
            this.inclusiveRadioButton.addActionListener(this);
            this.exclusiveRadioButton.addActionListener(this);
            this.numOfCallsRadioButton.addActionListener(this);
            this.numOfSubRoutinesRadioButton.addActionListener(this);
            this.userSecPerCallRadioButton.addActionListener(this);
            this.sortOrderGroup.add(this.ascendingButton);
            this.sortOrderGroup.add(this.descendingButton);
            this.sortOrderGroup.add(this.nameButton);
            this.sortOrderGroup.add(this.inclusiveRadioButton);
            this.sortOrderGroup.add(this.exclusiveRadioButton);
            this.sortOrderGroup.add(this.numOfCallsRadioButton);
            this.sortOrderGroup.add(this.numOfSubRoutinesRadioButton);
            this.sortOrderGroup.add(this.userSecPerCallRadioButton);
            jMenu3.add(this.ascendingButton);
            jMenu3.add(this.descendingButton);
            jMenu3.add(this.nameButton);
            jMenu3.add(this.inclusiveRadioButton);
            jMenu3.add(this.exclusiveRadioButton);
            jMenu3.add(this.numOfCallsRadioButton);
            jMenu3.add(this.numOfSubRoutinesRadioButton);
            jMenu3.add(this.userSecPerCallRadioButton);
            jMenu3.insertSeparator(2);
            jMenu2.add(jMenu3);
            this.unitsMenu = new JMenu("Select Units");
            this.unitsGroup = new ButtonGroup();
            this.secondsButton = new JRadioButtonMenuItem("Seconds", false);
            this.secondsButton.addActionListener(this);
            this.millisecondsButton = new JRadioButtonMenuItem("Milliseconds", false);
            this.millisecondsButton.addActionListener(this);
            this.microsecondsButton = new JRadioButtonMenuItem("Microseconds", true);
            this.microsecondsButton.addActionListener(this);
            this.hMSButton = new JRadioButtonMenuItem("hr:min:sec", false);
            this.hMSButton.addActionListener(this);
            this.unitsGroup.add(this.secondsButton);
            this.unitsGroup.add(this.millisecondsButton);
            this.unitsGroup.add(this.microsecondsButton);
            this.unitsGroup.add(this.hMSButton);
            this.unitsMenu.add(this.secondsButton);
            this.unitsMenu.add(this.millisecondsButton);
            this.unitsMenu.add(this.microsecondsButton);
            this.unitsMenu.add(this.hMSButton);
            jMenu2.add(this.unitsMenu);
            JMenu jMenu4 = new JMenu("Windows");
            jMenu4.addMenuListener(this);
            JMenuItem jMenuItem3 = new JMenuItem("Show Function Ledger");
            jMenuItem3.addActionListener(this);
            jMenu4.add(jMenuItem3);
            this.mappingGroupLedgerItem = new JMenuItem("Show Group Ledger");
            this.mappingGroupLedgerItem.addActionListener(this);
            jMenu4.add(this.mappingGroupLedgerItem);
            this.userEventLedgerItem = new JMenuItem("Show User Event Ledger");
            this.userEventLedgerItem.addActionListener(this);
            jMenu4.add(this.userEventLedgerItem);
            JMenuItem jMenuItem4 = new JMenuItem("Close All Sub-Windows");
            jMenuItem4.addActionListener(this);
            jMenu4.add(jMenuItem4);
            JMenu jMenu5 = new JMenu("Help");
            JMenuItem jMenuItem5 = new JMenuItem("About ParaProf");
            jMenuItem5.addActionListener(this);
            jMenu5.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Show Help Window");
            jMenuItem6.addActionListener(this);
            jMenu5.add(jMenuItem6);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu4);
            jMenuBar.add(jMenu5);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.panel = new CallPathTextWindowPanel(this.trial, n, n2, n3, this, bl);
            JScrollPane jScrollPane = new JScrollPane(this.panel);
            JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
            jScrollBar.setUnitIncrement(35);
            jScrollPane.setBorder(border);
            jScrollPane.setPreferredSize(new Dimension(500, 450));
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 0, 1, 1);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CPTW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block27: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block27;
                String string = actionEvent.getActionCommand();
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                    break block27;
                }
                if (string.equals("Exit ParaProf!")) {
                    this.setVisible(false);
                    this.dispose();
                    System.exit(0);
                    break block27;
                }
                if (string.equals("Name")) {
                    if (!this.nameButton.isSelected()) break block27;
                    this.metric = "Name";
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Descending")) {
                    if (!this.descendingButton.isSelected()) break block27;
                    this.descendingOrder = true;
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Ascending")) {
                    if (!this.ascendingButton.isSelected()) break block27;
                    this.descendingOrder = false;
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Inclusive")) {
                    if (!this.inclusiveRadioButton.isSelected()) break block27;
                    this.metric = "Inclusive";
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Exclusive")) {
                    if (!this.exclusiveRadioButton.isSelected()) break block27;
                    this.metric = "Exclusive";
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Number of Calls")) {
                    if (!this.numOfCallsRadioButton.isSelected()) break block27;
                    this.metric = "Number of Calls";
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Number of Subroutines")) {
                    if (!this.numOfSubRoutinesRadioButton.isSelected()) break block27;
                    this.metric = "Number of Subroutines";
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Per Call Value")) {
                    if (!this.userSecPerCallRadioButton.isSelected()) break block27;
                    this.metric = "Per Call Value";
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("hr:min:sec")) {
                    if (!this.hMSButton.isSelected()) break block27;
                    this.units = 3;
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Microseconds")) {
                    if (!this.microsecondsButton.isSelected()) break block27;
                    this.units = 0;
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Milliseconds")) {
                    if (!this.millisecondsButton.isSelected()) break block27;
                    this.units = 1;
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Seconds")) {
                    if (!this.secondsButton.isSelected()) break block27;
                    this.units = 2;
                    this.panel.repaint();
                    break block27;
                }
                if (string.equals("Show Function Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(0);
                } else if (string.equals("Show Group Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(1);
                } else if (string.equals("Show User Event Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(2);
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    ParaProf.helpWindow.clearText();
                    ParaProf.helpWindow.show();
                    ParaProf.helpWindow.writeText("Call path text window.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("This window displays call path relationships in two ways:");
                    ParaProf.helpWindow.writeText("1- If this window has been invoked from the \"windows\" menu of");
                    ParaProf.helpWindow.writeText("ParaProf, the information displayed is all call path relations found.");
                    ParaProf.helpWindow.writeText("That is, all the parent/child relationships.");
                    ParaProf.helpWindow.writeText("Thus, in this case, given the parallel nature of ParaProf, this information");
                    ParaProf.helpWindow.writeText("might not be valid for a particular thread. It is however useful to observe");
                    ParaProf.helpWindow.writeText("all the realtionships that exist in the data.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("2- If this window has been invoked from the popup menu to the left of a thread bar");
                    ParaProf.helpWindow.writeText("in the main ParaProf window, the information dispayed will be specific to this thread,");
                    ParaProf.helpWindow.writeText("and will thus contain both parent/child relations and the data relating to those");
                    ParaProf.helpWindow.writeText("relationships.");
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "CPTW03");
            }
        }
    }

    public int units() {
        return this.units;
    }

    public void menuSelected(MenuEvent menuEvent) {
        block7: {
            try {
                String string = this.trial.getCounterName();
                string = string.toUpperCase();
                if (this.trial.isTimeMetric() && !this.global) {
                    this.unitsMenu.setEnabled(true);
                } else {
                    this.unitsMenu.setEnabled(false);
                }
                if (this.trial.groupNamesPresent()) {
                    this.mappingGroupLedgerItem.setEnabled(true);
                } else {
                    this.mappingGroupLedgerItem.setEnabled(false);
                }
                if (this.trial.userEventsPresent()) {
                    this.userEventLedgerItem.setEnabled(true);
                    break block7;
                }
                this.userEventLedgerItem.setEnabled(false);
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "CPTW03");
            }
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.panel.repaint();
            }
            if (string.equals("colorEvent")) {
                this.panel.repaint();
            } else if (string.equals("dataEvent")) {
                this.panel.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CPTW04");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CPTW05");
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public Vector getData() {
        try {
            if (this.metric.equals("Name")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "NDE");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "NAE");
            }
            if (this.metric.equals("Inclusive")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDI");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MAI");
            }
            if (this.metric.equals("Exclusive")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDE");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MAE");
            }
            if (this.metric.equals("Number of Calls")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDNC");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MANC");
            }
            if (this.metric.equals("Number of Subroutines")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDNS");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MANS");
            }
            if (this.metric.equals("Per Call Value")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDUS");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MAUS");
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CTPW06");
        }
        return null;
    }

    public ListIterator getDataIterator() {
        return new ParaProfIterator(this.getData());
    }

    void closeThisWindow() {
        try {
            if (ParaProf.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("A total stat window for: \"n,c,t, " + this.server + "," + this.context + "," + this.thread + "\" is closing");
                System.out.println("Clearing resourses for this window.");
            }
            this.setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CPTW06");
        }
    }
}

