/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JPanel;
import paraprof.CallPathTextWindow;
import paraprof.GlobalContext;
import paraprof.GlobalMapping;
import paraprof.GlobalMappingElement;
import paraprof.GlobalServer;
import paraprof.GlobalThread;
import paraprof.GlobalThreadDataElement;
import paraprof.ParaProf;
import paraprof.ParaProfIterator;
import paraprof.SMWThreadDataElement;
import paraprof.Trial;
import paraprof.UtilFncs;

public class CallPathTextWindowPanel
extends JPanel
implements ActionListener {
    int xPanelSize = 800;
    int yPanelSize = 600;
    int startLocation = 0;
    int maxFontAscent = 0;
    int maxFontDescent = 0;
    int spacing = 0;
    int node = -1;
    int context = -1;
    int thread = -1;
    private Trial trial = null;
    CallPathTextWindow cPTWindow = null;
    boolean global = false;
    Font MonoFont = null;
    FontMetrics fmMonoFont = null;

    public CallPathTextWindowPanel(Trial trial, int n, int n2, int n3, CallPathTextWindow callPathTextWindow, boolean bl) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.node = n;
            this.context = n2;
            this.thread = n3;
            this.trial = trial;
            this.cPTWindow = callPathTextWindow;
            this.global = bl;
            this.repaint();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CPTWP01");
        }
    }

    public void paintComponent(Graphics graphics) {
        block36: {
            try {
                int n;
                int n2;
                super.paintComponent(graphics);
                int n3 = ParaProf.defaultNumberPrecision;
                int n4 = 0;
                int n5 = this.trial.getPreferences().getBarHeight();
                this.spacing = this.trial.getPreferences().getBarSpacing();
                boolean bl = false;
                Object var6_7 = null;
                this.MonoFont = new Font("Monospaced", this.trial.getPreferences().getFontStyle(), n5);
                this.fmMonoFont = graphics.getFontMetrics(this.MonoFont);
                this.maxFontAscent = this.fmMonoFont.getMaxAscent();
                this.maxFontDescent = this.fmMonoFont.getMaxDescent();
                graphics.setFont(this.MonoFont);
                if (this.spacing <= this.maxFontAscent + this.maxFontDescent) {
                    ++this.spacing;
                }
                if (this.global) {
                    ListIterator listIterator = null;
                    ListIterator listIterator2 = null;
                    ListIterator listIterator3 = null;
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = null;
                    GlobalMappingElement globalMappingElement2 = null;
                    Integer n6 = null;
                    String string = null;
                    int n7 = 0;
                    int n8 = 0;
                    n7 += this.spacing;
                    listIterator = globalMapping.getMappingIterator(0);
                    while (listIterator.hasNext()) {
                        globalMappingElement = (GlobalMappingElement)listIterator.next();
                        if (globalMappingElement.isCallPathObject()) continue;
                        listIterator2 = globalMappingElement.getParentsIterator();
                        while (listIterator2.hasNext()) {
                            n6 = (Integer)listIterator2.next();
                            n7 += this.spacing;
                        }
                        if (globalMappingElement.getMappingName().length() > n8) {
                            n8 = globalMappingElement.getMappingName().length();
                        }
                        n7 += this.spacing;
                        listIterator2 = globalMappingElement.getChildrenIterator();
                        while (listIterator2.hasNext()) {
                            n6 = (Integer)listIterator2.next();
                            n7 += this.spacing;
                        }
                        n7 += this.spacing;
                        n7 += this.spacing;
                    }
                    if (ParaProf.debugIsOn) {
                        n7 += this.spacing;
                        listIterator = globalMapping.getMappingIterator(0);
                        while (listIterator.hasNext()) {
                            globalMappingElement = (GlobalMappingElement)listIterator.next();
                            n7 += this.spacing;
                        }
                    }
                    boolean bl2 = false;
                    if (n8 > this.xPanelSize) {
                        this.xPanelSize = n8 + 10;
                        bl2 = true;
                    }
                    if (n7 > this.yPanelSize) {
                        this.yPanelSize = n7 + 10;
                        bl2 = true;
                    }
                    if (bl2) {
                        this.revalidate();
                    }
                    n4 += this.spacing;
                    graphics.setColor(Color.black);
                    listIterator = globalMapping.getMappingIterator(0);
                    while (listIterator.hasNext()) {
                        globalMappingElement = (GlobalMappingElement)listIterator.next();
                        if (globalMappingElement.isCallPathObject()) continue;
                        listIterator2 = globalMappingElement.getParentsIterator();
                        while (listIterator2.hasNext()) {
                            n6 = (Integer)listIterator2.next();
                            globalMappingElement2 = globalMapping.getGlobalMappingElement(n6, 0);
                            listIterator3 = globalMappingElement.getCallPathIDParents(n6);
                            string = "        parent callpath(s)";
                            while (listIterator3.hasNext()) {
                                string = string + ":[" + ((Integer)listIterator3.next()).toString() + "]";
                            }
                            graphics.drawString("    " + globalMappingElement2.getMappingName() + "[" + globalMappingElement2.getGlobalID() + "]" + string, 20, n4);
                            n4 += this.spacing;
                        }
                        graphics.drawString("--> " + globalMappingElement.getMappingName() + "[" + globalMappingElement.getGlobalID() + "]", 20, n4);
                        n4 += this.spacing;
                        listIterator2 = globalMappingElement.getChildrenIterator();
                        while (listIterator2.hasNext()) {
                            n6 = (Integer)listIterator2.next();
                            globalMappingElement2 = globalMapping.getGlobalMappingElement(n6, 0);
                            listIterator3 = globalMappingElement.getCallPathIDChildren(n6);
                            string = "        child callpath(s)";
                            while (listIterator3.hasNext()) {
                                string = string + ":[" + ((Integer)listIterator3.next()).toString() + "]";
                            }
                            graphics.drawString("    " + globalMappingElement2.getMappingName() + "[" + globalMappingElement2.getGlobalID() + "]" + string, 20, n4);
                            n4 += this.spacing;
                        }
                        n4 += this.spacing;
                        n4 += this.spacing;
                    }
                    if (!ParaProf.debugIsOn) break block36;
                    graphics.drawString("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@", 20, n4);
                    n4 += this.spacing;
                    listIterator = globalMapping.getMappingIterator(0);
                    while (listIterator.hasNext()) {
                        globalMappingElement = (GlobalMappingElement)listIterator.next();
                        graphics.drawString("[" + globalMappingElement.getGlobalID() + "] - " + globalMappingElement.getMappingName(), 20, n4);
                        n4 += this.spacing;
                    }
                    break block36;
                }
                ListIterator listIterator = null;
                ListIterator listIterator4 = null;
                ListIterator listIterator5 = null;
                GlobalMapping globalMapping = this.trial.getGlobalMapping();
                GlobalMappingElement globalMappingElement = null;
                Object var12_19 = null;
                Integer n9 = null;
                String string = null;
                Vector vector = null;
                GlobalServer globalServer = null;
                GlobalContext globalContext = null;
                GlobalThread globalThread = null;
                Vector vector2 = null;
                GlobalThreadDataElement globalThreadDataElement = null;
                SMWThreadDataElement sMWThreadDataElement = null;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                int n10 = 0;
                vector = this.trial.getNodes();
                globalServer = (GlobalServer)vector.elementAt(this.node);
                Vector vector3 = globalServer.getContextList();
                globalContext = (GlobalContext)vector3.elementAt(this.context);
                vector3 = globalContext.getThreadList();
                globalThread = (GlobalThread)vector3.elementAt(this.thread);
                vector2 = globalThread.getThreadDataList();
                int n11 = 0;
                int n12 = 0;
                n11 += this.spacing;
                n11 += this.spacing;
                n11 += this.spacing;
                listIterator = this.cPTWindow.getDataIterator();
                while (listIterator.hasNext()) {
                    sMWThreadDataElement = (SMWThreadDataElement)listIterator.next();
                    if (sMWThreadDataElement.isCallPathObject()) continue;
                    listIterator4 = sMWThreadDataElement.getParentsIterator();
                    while (listIterator4.hasNext()) {
                        n9 = (Integer)listIterator4.next();
                        n11 += this.spacing;
                        listIterator5 = sMWThreadDataElement.getCallPathIDParents(n9);
                        d2 = 0.0;
                        d3 = 0.0;
                        while (listIterator5.hasNext()) {
                            globalThreadDataElement = (GlobalThreadDataElement)vector2.elementAt((Integer)listIterator5.next());
                            d2 += globalThreadDataElement.getExclusiveValue(this.trial.getCurValLoc());
                            d3 += globalThreadDataElement.getInclusiveValue(this.trial.getCurValLoc());
                        }
                        d = this.setMax(d, d2, d3);
                    }
                    d2 = sMWThreadDataElement.getExclusiveValue();
                    d3 = sMWThreadDataElement.getInclusiveValue();
                    d = this.setMax(d, d2, d3);
                    n11 += this.spacing;
                    listIterator4 = sMWThreadDataElement.getChildrenIterator();
                    while (listIterator4.hasNext()) {
                        n9 = (Integer)listIterator4.next();
                        n11 += this.spacing;
                        listIterator5 = sMWThreadDataElement.getCallPathIDChildren(n9);
                        d2 = 0.0;
                        d3 = 0.0;
                        while (listIterator5.hasNext()) {
                            globalThreadDataElement = (GlobalThreadDataElement)vector2.elementAt((Integer)listIterator5.next());
                            d2 += globalThreadDataElement.getExclusiveValue(this.trial.getCurValLoc());
                            d3 += globalThreadDataElement.getInclusiveValue(this.trial.getCurValLoc());
                        }
                        d = this.setMax(d, d2, d3);
                        n11 += this.spacing;
                        n11 += this.spacing;
                    }
                }
                int n13 = 0;
                int n14 = 20;
                int n15 = this.fmMonoFont.stringWidth("--> ") + n14;
                int n16 = this.fmMonoFont.stringWidth(UtilFncs.getTestString(d, n3)) + 5;
                if (n16 < (n13 = this.fmMonoFont.stringWidth("Exclusive"))) {
                    n16 = n13 + 5;
                }
                if ((n2 = this.fmMonoFont.stringWidth(Integer.toString(globalThread.getMaxNumberOfCalls())) + 5) < (n13 = this.fmMonoFont.stringWidth("Calls/Tot.Calls"))) {
                    n2 = n13 + 5;
                }
                int n17 = n15;
                int n18 = n17 + n16;
                int n19 = n18 + n16;
                int n20 = n19 + n2;
                int n21 = n20 + n2;
                listIterator = (ParaProfIterator)globalMapping.getMappingIterator(0);
                while (listIterator.hasNext()) {
                    n = 0;
                    globalMappingElement = (GlobalMappingElement)listIterator.next();
                    if (globalMappingElement.isCallPathObject()) continue;
                    String string2 = globalMappingElement.getMappingName();
                    if (string2 != null) {
                        n = string2.length();
                    }
                    if (n12 >= n) continue;
                    n12 = n;
                }
                n12 = n12 + n21 + 5;
                n = 0;
                if (n12 > this.xPanelSize) {
                    this.xPanelSize = n12 + 10;
                    n = 1;
                }
                if (n11 > this.yPanelSize) {
                    this.yPanelSize = n11 + 10;
                    n = 1;
                }
                if (n != 0) {
                    this.revalidate();
                }
                graphics.setColor(Color.black);
                graphics.drawString("Exclusive", n17, n4 += this.spacing);
                graphics.drawString("Inclusive", n18, n4);
                graphics.drawString("Calls/Tot.Calls", n19, n4);
                graphics.drawString("Name[id]", n21, n4);
                graphics.drawString("--------------------------------------------------------------------------------", n18, n4 += this.spacing);
                n4 += this.spacing;
                listIterator = this.cPTWindow.getDataIterator();
                while (listIterator.hasNext()) {
                    sMWThreadDataElement = (SMWThreadDataElement)listIterator.next();
                    if (sMWThreadDataElement.isCallPathObject()) continue;
                    listIterator4 = sMWThreadDataElement.getParentsIterator();
                    while (listIterator4.hasNext()) {
                        n9 = (Integer)listIterator4.next();
                        listIterator5 = sMWThreadDataElement.getCallPathIDParents(n9);
                        d2 = 0.0;
                        d3 = 0.0;
                        n10 = 0;
                        string = "        parent callpath(s)";
                        while (listIterator5.hasNext()) {
                            int n22 = (Integer)listIterator5.next();
                            globalThreadDataElement = (GlobalThreadDataElement)vector2.elementAt(n22);
                            d2 += globalThreadDataElement.getExclusiveValue(this.trial.getCurValLoc());
                            d3 += globalThreadDataElement.getInclusiveValue(this.trial.getCurValLoc());
                            n10 += globalThreadDataElement.getNumberOfCalls();
                            string = string + ":[" + n22 + "]";
                        }
                        graphics.drawString(UtilFncs.getOutputString(this.cPTWindow.units(), d2), n17, n4);
                        graphics.drawString(UtilFncs.getOutputString(this.cPTWindow.units(), d3), n18, n4);
                        graphics.drawString(n10 + "/" + sMWThreadDataElement.getNumberOfCalls(), n19, n4);
                        globalThreadDataElement = (GlobalThreadDataElement)vector2.elementAt(n9);
                        graphics.drawString(globalThreadDataElement.getMappingName() + "[" + globalThreadDataElement.getMappingID() + "]", n21, n4);
                        n4 += this.spacing;
                    }
                    d2 = sMWThreadDataElement.getExclusiveValue();
                    d3 = sMWThreadDataElement.getInclusiveValue();
                    graphics.drawString("--> " + UtilFncs.getOutputString(this.cPTWindow.units(), d2), n14, n4);
                    graphics.drawString(UtilFncs.getOutputString(this.cPTWindow.units(), d3), n18, n4);
                    graphics.drawString(Integer.toString(sMWThreadDataElement.getNumberOfCalls()), n19, n4);
                    graphics.drawString(sMWThreadDataElement.getMappingName() + "[" + sMWThreadDataElement.getMappingID() + "]", n21, n4);
                    n4 += this.spacing;
                    listIterator4 = sMWThreadDataElement.getChildrenIterator();
                    while (listIterator4.hasNext()) {
                        n9 = (Integer)listIterator4.next();
                        listIterator5 = sMWThreadDataElement.getCallPathIDChildren(n9);
                        d2 = 0.0;
                        d3 = 0.0;
                        n10 = 0;
                        string = "        child callpath(s)";
                        while (listIterator5.hasNext()) {
                            int n23 = (Integer)listIterator5.next();
                            globalThreadDataElement = (GlobalThreadDataElement)vector2.elementAt(n23);
                            d2 += globalThreadDataElement.getExclusiveValue(this.trial.getCurValLoc());
                            d3 += globalThreadDataElement.getInclusiveValue(this.trial.getCurValLoc());
                            n10 += globalThreadDataElement.getNumberOfCalls();
                            string = string + ":[" + n23 + "]";
                        }
                        graphics.drawString(UtilFncs.getOutputString(this.cPTWindow.units(), d2), n17, n4);
                        graphics.drawString(UtilFncs.getOutputString(this.cPTWindow.units(), d3), n18, n4);
                        globalThreadDataElement = (GlobalThreadDataElement)vector2.elementAt(n9);
                        graphics.drawString(n10 + "/" + globalThreadDataElement.getNumberOfCalls(), n19, n4);
                        graphics.drawString(globalThreadDataElement.getMappingName() + "[" + globalThreadDataElement.getMappingID() + "]", n21, n4);
                        n4 += this.spacing;
                    }
                    n4 += this.spacing;
                    n4 += this.spacing;
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, this, "CPTWP02");
            }
        }
    }

    private double setMax(double d, double d2, double d3) {
        if (d < d2) {
            d = d2;
        }
        if (d < d3) {
            d = d3;
        }
        return d;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }
}

