/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import paraprof.ColorChooserFrame;
import paraprof.ParaProf;
import paraprof.SavedPreferences;
import paraprof.Trial;

public class ColorChooser
implements WindowListener {
    private Trial trial;
    Vector globalColors;
    Vector mappingGroupColors;
    private Color highlightColor;
    int highlightColorMappingID;
    private Color groupHighlightColor;
    int groupHighlightColorMappingID;
    private Color uEHC;
    private int uEHCMappingID;
    private Color miscMappingsColor;
    private boolean clrChooserFrameShowing;
    private ColorChooserFrame clrChooserFrame;

    public ColorChooser(Trial trial, SavedPreferences savedPreferences) {
        block3: {
            this.trial = null;
            this.globalColors = new Vector();
            this.mappingGroupColors = new Vector();
            this.highlightColor = Color.red;
            this.highlightColorMappingID = -1;
            this.groupHighlightColor = new Color(0, 255, 255);
            this.groupHighlightColorMappingID = -1;
            this.uEHC = new Color(255, 255, 0);
            this.uEHCMappingID = -1;
            this.miscMappingsColor = Color.black;
            this.clrChooserFrameShowing = false;
            try {
                this.trial = trial;
                if (savedPreferences != null) {
                    this.globalColors = savedPreferences.getGlobalColors();
                    this.mappingGroupColors = savedPreferences.getMappingGroupColors();
                    this.highlightColor = savedPreferences.getHighlightColor();
                    this.groupHighlightColor = savedPreferences.getGroupHighlightColor();
                    this.uEHC = savedPreferences.getUEHC();
                    this.miscMappingsColor = savedPreferences.getMiscMappingsColor();
                    break block3;
                }
                this.setDefaultColors();
                this.setDefaultMappingGroupColors();
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "CC01");
            }
        }
    }

    public void showColorChooser() {
        block3: {
            try {
                if (!this.clrChooserFrameShowing) {
                    this.clrChooserFrame = new ColorChooserFrame(this.trial, this);
                    this.clrChooserFrame.addWindowListener(this);
                    this.clrChooserFrame.show();
                    this.clrChooserFrameShowing = true;
                    break block3;
                }
                this.clrChooserFrame.show();
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "CC02");
            }
        }
    }

    public void setSavedColors() {
        try {
            ParaProf.savedPreferences.setGlobalColors(this.globalColors);
            ParaProf.savedPreferences.setMappingGroupColors(this.mappingGroupColors);
            ParaProf.savedPreferences.setHighlightColor(this.highlightColor);
            ParaProf.savedPreferences.setGroupHighlightColor(this.groupHighlightColor);
            ParaProf.savedPreferences.setMiscMappingsColor(this.miscMappingsColor);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC03");
        }
    }

    public int getNumberOfColors() {
        int n = -1;
        try {
            n = this.globalColors.size();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC04");
        }
        return n;
    }

    public int getNumberOfMappingGroupColors() {
        int n = -1;
        try {
            n = this.mappingGroupColors.size();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC05");
        }
        return n;
    }

    public void setColorInLocation(Color color, int n) {
        try {
            this.globalColors.setElementAt(color, n);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC06");
        }
    }

    public void setMappingGroupColorInLocation(Color color, int n) {
        try {
            this.mappingGroupColors.setElementAt(color, n);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC07");
        }
    }

    public Color getColorInLocation(int n) {
        Color color = null;
        try {
            color = (Color)this.globalColors.elementAt(n);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC08");
        }
        return color;
    }

    public Color getMappingGroupColorInLocation(int n) {
        Color color = null;
        try {
            color = (Color)this.mappingGroupColors.elementAt(n);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC09");
        }
        return color;
    }

    public void addColor(Color color) {
        try {
            this.globalColors.add(color);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC10");
        }
    }

    public void addMappingGroupColor(Color color) {
        try {
            this.mappingGroupColors.add(color);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC11");
        }
    }

    public Vector getAllColors() {
        return this.globalColors;
    }

    public Vector getAllMappingGroupColors() {
        return this.mappingGroupColors;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColorMappingID(int n) {
        this.highlightColorMappingID = n;
        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public int getHighlightColorMappingID() {
        return this.highlightColorMappingID;
    }

    public void setGroupHighlightColor(Color color) {
        this.groupHighlightColor = color;
    }

    public Color getGroupHighlightColor() {
        return this.groupHighlightColor;
    }

    public void setGroupHighlightColorMappingID(int n) {
        try {
            this.groupHighlightColorMappingID = n;
            this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC12");
        }
    }

    public int getGHCMID() {
        return this.groupHighlightColorMappingID;
    }

    public void setUEHC(Color color) {
        this.uEHC = color;
    }

    public Color getUEHC() {
        return this.uEHC;
    }

    public void setUEHCMappingID(int n) {
        try {
            this.uEHCMappingID = n;
            this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC13");
        }
    }

    public int getUEHCMappingID() {
        return this.uEHCMappingID;
    }

    public void setMiscMappingsColor(Color color) {
        this.miscMappingsColor = color;
    }

    public Color getMiscMappingsColor() {
        return this.miscMappingsColor;
    }

    public void setDefaultColors() {
        try {
            this.globalColors.clear();
            this.addColor(new Color(61, 104, 63));
            this.addColor(new Color(102, 0, 51));
            this.addColor(new Color(0, 102, 102));
            this.addColor(new Color(0, 51, 255));
            this.addColor(new Color(102, 132, 25));
            this.addColor(new Color(119, 71, 145));
            this.addColor(new Color(221, 232, 30));
            this.addColor(new Color(70, 156, 168));
            this.addColor(new Color(255, 153, 0));
            this.addColor(new Color(0, 255, 0));
            this.addColor(new Color(121, 196, 144));
            this.addColor(new Color(86, 88, 112));
            this.addColor(new Color(151, 204, 255));
            this.addColor(new Color(102, 102, 255));
            this.addColor(new Color(204, 255, 51));
            this.addColor(new Color(255, 204, 153));
            this.addColor(new Color(204, 0, 204));
            this.addColor(new Color(0, 102, 102));
            this.addColor(new Color(204, 204, 255));
            this.addColor(new Color(102, 255, 255));
            this.addColor(new Color(255, 102, 102));
            this.addColor(new Color(255, 204, 204));
            this.addColor(new Color(240, 97, 159));
            this.addColor(new Color(0, 102, 153));
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC14");
        }
    }

    public void setDefaultMappingGroupColors() {
        try {
            this.mappingGroupColors.clear();
            this.addMappingGroupColor(new Color(102, 0, 102));
            this.addMappingGroupColor(new Color(51, 51, 0));
            this.addMappingGroupColor(new Color(204, 0, 51));
            this.addMappingGroupColor(new Color(0, 102, 102));
            this.addMappingGroupColor(new Color(255, 255, 102));
            this.addMappingGroupColor(new Color(0, 0, 102));
            this.addMappingGroupColor(new Color(153, 153, 255));
            this.addMappingGroupColor(new Color(255, 51, 0));
            this.addMappingGroupColor(new Color(255, 153, 0));
            this.addMappingGroupColor(new Color(255, 102, 102));
            this.addMappingGroupColor(new Color(51, 0, 51));
            this.addMappingGroupColor(new Color(255, 255, 102));
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CC15");
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.clrChooserFrame) {
            this.clrChooserFrameShowing = false;
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

