/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.colorchooser.ColorSelectionModel;
import paraprof.ColorChooser;
import paraprof.CustomCellRenderer;
import paraprof.GlobalMapping;
import paraprof.ParaProf;
import paraprof.Trial;

class ColorChooserFrame
extends JFrame
implements ActionListener {
    private Trial trial = null;
    ColorChooser colorChooserRef;
    private ColorSelectionModel clrModel;
    JColorChooser clrChooser;
    DefaultListModel listModel;
    JList colorList;
    JButton addColorButton;
    JButton addMappingGroupColorButton;
    JButton deleteColorButton;
    JButton updateColorButton;
    JButton restoreDefaultsButton;
    int numberOfColors = -1;

    public ColorChooserFrame(Trial trial, ColorChooser colorChooser) {
        try {
            this.setLocation(new Point(100, 100));
            this.setSize(new Dimension(850, 450));
            this.trial = trial;
            this.colorChooserRef = colorChooser;
            this.numberOfColors = this.trial.getColorChooser().getNumberOfColors();
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit ParaProf!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            jMenuBar.add(jMenu);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createRaisedBevelBorder();
            Border border2 = BorderFactory.createEmptyBorder();
            this.clrChooser = new JColorChooser();
            this.clrModel = this.clrChooser.getSelectionModel();
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            JLabel jLabel = new JLabel("ParaProf Color Set.");
            jLabel.setFont(new Font("SansSerif", 2, 14));
            this.addCompItem(jLabel, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.listModel = new DefaultListModel();
            this.colorList = new JList(this.listModel);
            this.colorList.setSelectionMode(0);
            this.colorList.setCellRenderer(new CustomCellRenderer(this.trial));
            JScrollPane jScrollPane = new JScrollPane(this.colorList);
            jScrollPane.setBorder(border);
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 1, 1, 5);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addColorButton = new JButton("Add Color");
            this.addColorButton.addActionListener(this);
            this.addCompItem(this.addColorButton, gridBagConstraints, 1, 1, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addMappingGroupColorButton = new JButton("Add Mapping Gr. Color");
            this.addMappingGroupColorButton.addActionListener(this);
            this.addCompItem(this.addMappingGroupColorButton, gridBagConstraints, 1, 2, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.deleteColorButton = new JButton("Delete Selected Color");
            this.deleteColorButton.addActionListener(this);
            this.addCompItem(this.deleteColorButton, gridBagConstraints, 1, 3, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.updateColorButton = new JButton("Update Selected Color");
            this.updateColorButton.addActionListener(this);
            this.addCompItem(this.updateColorButton, gridBagConstraints, 1, 4, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.restoreDefaultsButton = new JButton("Restore Defaults");
            this.restoreDefaultsButton.addActionListener(this);
            this.addCompItem(this.restoreDefaultsButton, gridBagConstraints, 1, 5, 1, 1);
            this.addCompItem(this.clrChooser, gridBagConstraints, 2, 0, 1, 6);
            this.populateColorList();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "CCF01");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object instanceof JMenuItem) {
            if (string.equals("Exit ParaProf!")) {
                this.setVisible(false);
                this.dispose();
                System.exit(0);
            } else if (string.equals("Close This Window")) {
                this.setVisible(false);
            }
        } else if (object instanceof JButton) {
            if (string.equals("Add Color")) {
                Color color = this.clrModel.getSelectedColor();
                this.colorChooserRef.getAllColors().add(color);
                this.listModel.clear();
                this.populateColorList();
                GlobalMapping globalMapping = this.trial.getGlobalMapping();
                globalMapping.updateGenericColors(0);
                this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
            } else if (string.equals("Add Mapping Gr. Color")) {
                Color color = this.clrModel.getSelectedColor();
                this.colorChooserRef.getAllMappingGroupColors().add(color);
                this.listModel.clear();
                this.populateColorList();
                GlobalMapping globalMapping = this.trial.getGlobalMapping();
                globalMapping.updateGenericColors(1);
                this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
            } else if (string.equals("Delete Selected Color")) {
                int[] nArray = this.colorList.getSelectedIndices();
                int n = 0;
                while (n < nArray.length) {
                    GlobalMapping globalMapping;
                    if (nArray[n] < this.trial.getColorChooser().getNumberOfColors()) {
                        System.out.println("The value being deleted is: " + nArray[n]);
                        this.listModel.removeElementAt(nArray[n]);
                        this.colorChooserRef.getAllColors().removeElementAt(nArray[n]);
                        globalMapping = this.trial.getGlobalMapping();
                        globalMapping.updateGenericColors(0);
                    } else if (nArray[n] < this.trial.getColorChooser().getNumberOfColors() + this.trial.getColorChooser().getNumberOfMappingGroupColors()) {
                        System.out.println("The value being deleted is: " + nArray[n]);
                        this.listModel.removeElementAt(nArray[n]);
                        this.colorChooserRef.getAllMappingGroupColors().removeElementAt(nArray[n] - this.trial.getColorChooser().getNumberOfColors());
                        globalMapping = this.trial.getGlobalMapping();
                        globalMapping.updateGenericColors(1);
                    }
                    ++n;
                }
                this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
            } else if (string.equals("Update Selected Color")) {
                Color color = this.clrModel.getSelectedColor();
                int[] nArray = this.colorList.getSelectedIndices();
                int n = 0;
                while (n < nArray.length) {
                    GlobalMapping globalMapping;
                    this.listModel.setElementAt(color, nArray[n]);
                    int n2 = this.trial.getColorChooser().getNumberOfColors() + this.trial.getColorChooser().getNumberOfMappingGroupColors();
                    if (nArray[n] == n2) {
                        this.trial.getColorChooser().setHighlightColor(color);
                    } else if (nArray[n] == n2 + 1) {
                        this.trial.getColorChooser().setGroupHighlightColor(color);
                    } else if (nArray[n] == n2 + 2) {
                        this.trial.getColorChooser().setUEHC(color);
                    } else if (nArray[n] == n2 + 3) {
                        this.trial.getColorChooser().setMiscMappingsColor(color);
                    } else if (nArray[n] < this.trial.getColorChooser().getNumberOfColors()) {
                        this.colorChooserRef.setColorInLocation(color, nArray[n]);
                        globalMapping = this.trial.getGlobalMapping();
                        globalMapping.updateGenericColors(0);
                    } else {
                        this.colorChooserRef.setMappingGroupColorInLocation(color, nArray[n] - this.trial.getColorChooser().getNumberOfColors());
                        globalMapping = this.trial.getGlobalMapping();
                        globalMapping.updateGenericColors(1);
                    }
                    ++n;
                }
                this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
            } else if (string.equals("Restore Defaults")) {
                this.colorChooserRef.setDefaultColors();
                this.colorChooserRef.setDefaultMappingGroupColors();
                this.colorChooserRef.setHighlightColor(Color.red);
                this.colorChooserRef.setGroupHighlightColor(new Color(0, 255, 255));
                this.colorChooserRef.setUEHC(new Color(255, 255, 0));
                this.colorChooserRef.setMiscMappingsColor(Color.black);
                this.listModel.clear();
                this.populateColorList();
                GlobalMapping globalMapping = this.trial.getGlobalMapping();
                globalMapping.updateGenericColors(0);
                globalMapping.updateGenericColors(1);
                this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
            }
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void populateColorList() {
        Color color;
        Enumeration enumeration = this.colorChooserRef.getAllColors().elements();
        while (enumeration.hasMoreElements()) {
            color = (Color)enumeration.nextElement();
            this.listModel.addElement(color);
        }
        Enumeration enumeration2 = this.colorChooserRef.getAllMappingGroupColors().elements();
        while (enumeration2.hasMoreElements()) {
            color = (Color)enumeration2.nextElement();
            this.listModel.addElement(color);
        }
        color = this.trial.getColorChooser().getHighlightColor();
        this.listModel.addElement(color);
        color = this.trial.getColorChooser().getGroupHighlightColor();
        this.listModel.addElement(color);
        color = this.trial.getColorChooser().getUEHC();
        this.listModel.addElement(color);
        color = this.trial.getColorChooser().getMiscMappingsColor();
        this.listModel.addElement(color);
    }
}

