/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ListIterator;
import java.util.Vector;
import paraprof.GlobalMapping;
import paraprof.ParaProf;
import paraprof.ParaProfIterator;
import paraprof.Trial;
import paraprof.UtilFncs;

public class GlobalMappingElement
implements Serializable,
Comparable {
    private Trial trial = null;
    private String mappingName = null;
    private int globalID = -1;
    private int[] groups = null;
    private int numberOfGroups = 0;
    private Vector parents = null;
    private Vector children = null;
    private Vector callPathIDSParents = null;
    private Vector callPathIDSChildren = null;
    private boolean callPathObject = false;
    private boolean colorFlag = false;
    private Color genericMappingColor = null;
    private Color specificMappingColor = null;
    private double[] doubleList = new double[14];
    private int maxNumberOfCalls = 0;
    private int maxNumberOfSubRoutines = 0;
    private int maxUserEventNumberValue = 0;
    private double maxUserEventMinValue = 0.0;
    private double maxUserEventMaxValue = 0.0;
    private double maxUserEventMeanValue = 0.0;
    private double meanNumberOfCalls = 0.0;
    private double meanNumberOfSubRoutines = 0.0;
    private int xBeginPosition;
    private int xEndPosition;
    private int yBeginPosition;
    private int yEndPosition;
    private boolean meanValuesSet = false;
    private int counter = 0;
    private double totalExclusiveValue = 0.0;
    private double totalInclusiveValue = 0.0;

    public GlobalMappingElement(Trial trial) {
        this.trial = trial;
    }

    public void incrementStorage() {
        int n = this.doubleList.length;
        double[] dArray = new double[n + 14];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.doubleList[n2];
            ++n2;
        }
        this.doubleList = dArray;
    }

    public void setMappingName(String string) {
        this.mappingName = string;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public void setGlobalID(int n) {
        this.globalID = n;
    }

    public int getGlobalID() {
        return this.globalID;
    }

    public void addGroup(int n) {
        if (this.groups == null) {
            this.groups = new int[5];
        } else if (this.groups.length < this.numberOfGroups) {
            int n2 = this.groups.length;
            int[] nArray = new int[n2 + 5];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = this.groups[n3];
                ++n3;
            }
            this.groups = nArray;
        }
        this.groups[this.numberOfGroups] = n;
        ++this.numberOfGroups;
    }

    public boolean isGroupMember(int n) {
        GlobalMapping globalMapping = this.trial.getGlobalMapping();
        boolean bl = globalMapping.getIsAllExceptGroupOn();
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < this.numberOfGroups) {
            if (this.groups[n2] == n) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            return bl2;
        }
        return !bl2;
    }

    public void addParent(int n, int n2) {
        int n3 = UtilFncs.exists(this.parents, n);
        if (n3 == -1) {
            if (this.parents == null) {
                this.parents = new Vector();
                this.callPathIDSParents = new Vector();
            }
            this.parents.add(new Integer(n));
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(new Integer(n2));
            this.callPathIDSParents.add(vector);
        } else {
            Vector vector = (Vector)this.callPathIDSParents.elementAt(n3);
            vector.add(new Integer(n2));
        }
    }

    public Vector getParents() {
        return this.parents;
    }

    public Vector getChildren() {
        return this.children;
    }

    public ListIterator getParentsIterator() {
        return new ParaProfIterator(this.parents);
    }

    public ListIterator getChildrenIterator() {
        return new ParaProfIterator(this.children);
    }

    public ListIterator getCallPathIDParents(int n) {
        int n2 = UtilFncs.exists(this.parents, n);
        return new ParaProfIterator((Vector)this.callPathIDSParents.elementAt(n2));
    }

    public ListIterator getCallPathIDChildren(int n) {
        int n2 = UtilFncs.exists(this.children, n);
        return new ParaProfIterator((Vector)this.callPathIDSChildren.elementAt(n2));
    }

    public void addChild(int n, int n2) {
        int n3 = UtilFncs.exists(this.children, n);
        if (n3 == -1) {
            if (this.children == null) {
                this.children = new Vector();
                this.callPathIDSChildren = new Vector();
            }
            this.children.add(new Integer(n));
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(new Integer(n2));
            this.callPathIDSChildren.add(vector);
        } else {
            Vector vector = (Vector)this.callPathIDSChildren.elementAt(n3);
            vector.add(new Integer(n2));
        }
    }

    public void setCallPathObject(boolean bl) {
        this.callPathObject = bl;
    }

    public boolean isCallPathObject() {
        return this.callPathObject;
    }

    public void setColorFlag(boolean bl) {
        this.colorFlag = bl;
    }

    public boolean isColorFlagSet() {
        return this.colorFlag;
    }

    public void setGenericColor(Color color) {
        this.genericMappingColor = color;
    }

    public void setSpecificColor(Color color) {
        this.specificMappingColor = color;
    }

    public Color getMappingColor() {
        if (this.colorFlag) {
            return this.specificMappingColor;
        }
        return this.genericMappingColor;
    }

    public Color getGenericColor() {
        return this.genericMappingColor;
    }

    public void setMaxInclusiveValue(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public double getMaxInclusiveValue(int n) {
        return this.getDouble(n, 0);
    }

    public void setMaxExclusiveValue(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public double getMaxExclusiveValue(int n) {
        return this.getDouble(n, 1);
    }

    public void setMaxInclusivePercentValue(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public double getMaxInclusivePercentValue(int n) {
        return this.getDouble(n, 2);
    }

    public void setMaxExclusivePercentValue(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public double getMaxExclusivePercentValue(int n) {
        return this.getDouble(n, 3);
    }

    public void setMaxNumberOfCalls(int n) {
        this.maxNumberOfCalls = n;
    }

    public int getMaxNumberOfCalls() {
        return this.maxNumberOfCalls;
    }

    public void setMaxNumberOfSubRoutines(int n) {
        this.maxNumberOfSubRoutines = n;
    }

    public int getMaxNumberOfSubRoutines() {
        return this.maxNumberOfSubRoutines;
    }

    public void setMaxUserSecPerCall(int n, double d) {
        this.insertDouble(n, 4, d);
    }

    public double getMaxUserSecPerCall(int n) {
        return this.getDouble(n, 4);
    }

    public void setMaxUserEventNumberValue(int n) {
        this.maxUserEventNumberValue = n;
    }

    public int getMaxUserEventNumberValue() {
        return this.maxUserEventNumberValue;
    }

    public void setMaxUserEventMinValue(double d) {
        this.maxUserEventMinValue = d;
    }

    public double getMaxUserEventMinValue() {
        return this.maxUserEventMinValue;
    }

    public void setMaxUserEventMaxValue(double d) {
        this.maxUserEventMaxValue = d;
    }

    public double getMaxUserEventMaxValue() {
        return this.maxUserEventMaxValue;
    }

    public void setMaxUserEventMeanValue(double d) {
        this.maxUserEventMeanValue = d;
    }

    public double getMaxUserEventMeanValue() {
        return this.maxUserEventMeanValue;
    }

    public void setMeanInclusiveValue(int n, double d) {
        this.insertDouble(n, 5, d);
    }

    public double getMeanInclusiveValue(int n) {
        return this.getDouble(n, 5);
    }

    public void setMeanExclusiveValue(int n, double d) {
        this.insertDouble(n, 6, d);
    }

    public double getMeanExclusiveValue(int n) {
        return this.getDouble(n, 6);
    }

    public void setMeanInclusivePercentValue(int n, double d) {
        this.insertDouble(n, 7, d);
    }

    public double getMeanInclusivePercentValue(int n) {
        return this.getDouble(n, 7);
    }

    public void setMeanExclusivePercentValue(int n, double d) {
        this.insertDouble(n, 8, d);
    }

    public double getMeanExclusivePercentValue(int n) {
        return this.getDouble(n, 8);
    }

    public void setMeanNumberOfCalls(double d) {
        this.meanNumberOfCalls = d;
    }

    public double getMeanNumberOfCalls() {
        return this.meanNumberOfCalls;
    }

    public void setMeanNumberOfSubRoutines(double d) {
        this.meanNumberOfSubRoutines = d;
    }

    public double getMeanNumberOfSubRoutines() {
        return this.meanNumberOfSubRoutines;
    }

    public void setMeanUserSecPerCall(int n, double d) {
        this.insertDouble(n, 9, d);
    }

    public double getMeanUserSecPerCall(int n) {
        return this.getDouble(n, 9);
    }

    public void setTotalInclusiveValue(int n, double d) {
        this.insertDouble(n, 10, d);
    }

    public double getTotalInclusiveValue(int n) {
        return this.getDouble(n, 10);
    }

    public void setTotalExclusiveValue(int n, double d) {
        this.insertDouble(n, 11, d);
    }

    public double getTotalExclusiveValue(int n) {
        return this.getDouble(n, 11);
    }

    public void setTotalInclusivePercentValue(int n, double d) {
        this.insertDouble(n, 12, d);
    }

    public double getTotalInclusivePercentValue(int n) {
        return this.getDouble(n, 12);
    }

    public void setTotalExclusivePercentValue(int n, double d) {
        this.insertDouble(n, 13, d);
    }

    public double getTotalExclusivePercentValue(int n) {
        return this.getDouble(n, 13);
    }

    public String getMeanTotalStatString(int n, int n2) {
        try {
            int n3 = ParaProf.defaultNumberPrecision;
            int n4 = 99;
            int n5 = 0;
            char[] cArray = new char[n4];
            this.insertSpaces(cArray, 0, 99);
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.applyPattern("##0.0");
            char[] cArray2 = decimalFormat.format(this.getMeanInclusivePercentValue(n2)).toCharArray();
            int n6 = 0;
            while (n6 < cArray2.length) {
                cArray[n5] = cArray2[n6];
                ++n5;
                ++n6;
            }
            n5 = 9;
            String string = UtilFncs.getOutputString(n, this.getMeanExclusiveValue(n2));
            cArray2 = string.toCharArray();
            int n7 = 0;
            while (n7 < cArray2.length) {
                cArray[n5] = cArray2[n7];
                ++n5;
                ++n7;
            }
            n5 = 27;
            string = UtilFncs.getOutputString(n, this.getMeanInclusiveValue(n2));
            cArray2 = string.toCharArray();
            int n8 = 0;
            while (n8 < cArray2.length) {
                cArray[n5] = cArray2[n8];
                ++n5;
                ++n8;
            }
            n5 = 45;
            string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getMeanNumberOfCalls(), n3)));
            cArray2 = string.toCharArray();
            int n9 = 0;
            while (n9 < cArray2.length) {
                cArray[n5] = cArray2[n9];
                ++n5;
                ++n9;
            }
            n5 = 63;
            string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getMeanNumberOfSubRoutines(), n3)));
            cArray2 = string.toCharArray();
            int n10 = 0;
            while (n10 < cArray2.length) {
                cArray[n5] = cArray2[n10];
                ++n5;
                ++n10;
            }
            n5 = 81;
            string = UtilFncs.getOutputString(n, this.getMeanUserSecPerCall(n2));
            cArray2 = string.toCharArray();
            int n11 = 0;
            while (n11 < cArray2.length) {
                cArray[n5] = cArray2[n11];
                ++n5;
                ++n11;
            }
            String string2 = new String(cArray);
            return string2 + this.getMappingName();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "GTDE01");
            return "An error occured pocessing this string!";
        }
    }

    private int insertSpaces(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            cArray[n] = 32;
            ++n;
            ++n3;
        }
        return n;
    }

    public void setMeanValuesSet(boolean bl) {
        this.meanValuesSet = bl;
    }

    public boolean getMeanValuesSet() {
        return this.meanValuesSet;
    }

    public void setDrawCoords(int n, int n2, int n3, int n4) {
        this.xBeginPosition = n;
        this.xEndPosition = n2;
        this.yBeginPosition = n3;
        this.yEndPosition = n4;
    }

    public int getXBeg() {
        return this.xBeginPosition;
    }

    public int getXEnd() {
        return this.xEndPosition;
    }

    public int getYBeg() {
        return this.yBeginPosition;
    }

    public int getYEnd() {
        return this.yEndPosition;
    }

    public void setTotalExclusiveValue(double d) {
        this.totalExclusiveValue = d;
    }

    public void incrementTotalExclusiveValue(double d) {
        this.totalExclusiveValue += d;
    }

    public double getTotalExclusiveValue() {
        return this.totalExclusiveValue;
    }

    public void setTotalInclusiveValue(double d) {
        this.totalInclusiveValue = d;
    }

    public void incrementTotalInclusiveValue(double d) {
        this.totalInclusiveValue += d;
    }

    public double getTotalInclusiveValue() {
        return this.totalInclusiveValue;
    }

    public void setCounter(int n) {
        this.counter = n;
    }

    public void incrementCounter() {
        ++this.counter;
    }

    public int getCounter() {
        return this.counter;
    }

    public int compareTo(Object object) {
        return this.mappingName.compareTo((String)object);
    }

    private void insertDouble(int n, int n2, double d) {
        int n3 = n * 14 + n2;
        try {
            this.doubleList[n3] = d;
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "GME01");
        }
    }

    private double getDouble(int n, int n2) {
        int n3 = n * 14 + n2;
        try {
            return this.doubleList[n3];
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "GME02");
            return -1.0;
        }
    }
}

