/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.util.ListIterator;
import java.util.Vector;
import paraprof.GlobalThreadDataElement;
import paraprof.ParaProf;
import paraprof.ParaProfIterator;

public class GlobalThread {
    Vector threadDataList;
    Vector userThreadDataList;
    private double[] doubleList = new double[5];
    double totalExclusiveValue = 0.0;
    double totalInclusiveValue = 0.0;
    private int maxNumberOfCalls = 0;
    private int maxNumberOfSubRoutines = 0;
    private boolean trimmed = false;

    public void initializeThreadDataList(int n) {
        this.threadDataList = new Vector(n);
        Object e = null;
        int n2 = 0;
        while (n2 < n) {
            this.threadDataList.add(e);
            ++n2;
        }
    }

    public void initializeUserThreadDataList(int n) {
        this.userThreadDataList = new Vector(n);
        Object e = null;
        int n2 = 0;
        while (n2 < n) {
            this.userThreadDataList.add(e);
            ++n2;
        }
    }

    public void incrementStorage() {
        int n = this.doubleList.length;
        double[] dArray = new double[n + 5];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.doubleList[n2];
            ++n2;
        }
        this.doubleList = dArray;
    }

    private void insertDouble(int n, int n2, double d) {
        int n3 = n * 5 + n2;
        try {
            this.doubleList[n3] = d;
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "GT01");
        }
    }

    private double getDouble(int n, int n2) {
        int n3 = n * 5 + n2;
        try {
            return this.doubleList[n3];
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "GT01");
            return -1.0;
        }
    }

    void addThreadDataElement(GlobalThreadDataElement globalThreadDataElement) {
        this.threadDataList.addElement(globalThreadDataElement);
    }

    void addThreadDataElement(GlobalThreadDataElement globalThreadDataElement, int n) {
        this.threadDataList.setElementAt(globalThreadDataElement, n);
    }

    void addUserThreadDataElement(GlobalThreadDataElement globalThreadDataElement) {
        this.userThreadDataList.addElement(globalThreadDataElement);
    }

    void addUserThreadDataElement(GlobalThreadDataElement globalThreadDataElement, int n) {
        this.userThreadDataList.setElementAt(globalThreadDataElement, n);
    }

    public Vector getThreadDataList() {
        return this.threadDataList;
    }

    public ListIterator getThreadDataListIterator() {
        return new ParaProfIterator(this.threadDataList);
    }

    public Vector getUserThreadDataList() {
        return this.userThreadDataList;
    }

    public void setMaxInclusiveValue(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public double getMaxInclusiveValue(int n) {
        return this.getDouble(n, 0);
    }

    public void setMaxExclusiveValue(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public double getMaxExclusiveValue(int n) {
        return this.getDouble(n, 1);
    }

    public void setMaxInclusivePercentValue(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public double getMaxInclusivePercentValue(int n) {
        return this.getDouble(n, 2);
    }

    public void setMaxExclusivePercentValue(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public double getMaxExclusivePercentValue(int n) {
        return this.getDouble(n, 3);
    }

    public void setMaxUserSecPerCall(int n, double d) {
        this.insertDouble(n, 4, d);
    }

    public double getMaxUserSecPerCall(int n) {
        return this.getDouble(n, 4);
    }

    public void setMaxNumberOfCalls(int n) {
        this.maxNumberOfCalls = n;
    }

    public int getMaxNumberOfCalls() {
        return this.maxNumberOfCalls;
    }

    public void setMaxNumberOfSubRoutines(int n) {
        this.maxNumberOfSubRoutines = n;
    }

    public int getMaxNumberOfSubRoutines() {
        return this.maxNumberOfSubRoutines;
    }

    public void setTotalExclusiveValue(double d) {
        this.totalExclusiveValue = d;
    }

    public void incrementTotalExclusiveValue(double d) {
        this.totalExclusiveValue += d;
    }

    public double getTotalExclusiveValue() {
        return this.totalExclusiveValue;
    }

    public void setTotalInclusiveValue(double d) {
        this.totalInclusiveValue = d;
    }

    public void incrementTotalInclusiveValue(double d) {
        this.totalInclusiveValue += d;
    }

    public double getTotalInclusiveValue() {
        return this.totalInclusiveValue;
    }

    public void setTrimmed(boolean bl) {
        this.trimmed = bl;
    }

    public boolean trimmed() {
        return this.trimmed;
    }
}

