/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.text.DecimalFormat;
import java.util.ListIterator;
import java.util.Vector;
import paraprof.GlobalMappingElement;
import paraprof.ParaProf;
import paraprof.ParaProfIterator;
import paraprof.Trial;
import paraprof.UtilFncs;

public class GlobalThreadDataElement {
    private Trial trial = null;
    boolean mappingExists = false;
    int mappingID;
    private double[] doubleList;
    private int numberOfCalls = 0;
    private int numberOfSubRoutines = 0;
    int userEventNumberValue = 0;
    boolean userElement = false;
    private Vector parents = null;
    private Vector children = null;
    private Vector callPathIDSParents = null;
    private Vector callPathIDSChildren = null;

    public GlobalThreadDataElement(Trial trial, boolean bl) {
        this.trial = trial;
        this.mappingID = -1;
        if (bl) {
            this.userElement = true;
            this.doubleList = new double[3];
        } else {
            this.doubleList = new double[5];
        }
    }

    public String getMappingName() {
        GlobalMappingElement globalMappingElement = this.trial.getGlobalMapping().getGlobalMappingElement(this.mappingID, 0);
        return globalMappingElement.getMappingName();
    }

    public void setMappingID(int n) {
        this.mappingID = n;
    }

    public void setMappingExists() {
        this.mappingExists = true;
    }

    public boolean getMappingExists() {
        return this.mappingExists;
    }

    public int getMappingID() {
        return this.mappingID;
    }

    public void setInclusiveValue(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public double getInclusiveValue(int n) {
        return this.getDouble(n, 0);
    }

    public void setExclusiveValue(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public double getExclusiveValue(int n) {
        return this.getDouble(n, 1);
    }

    public void setInclusivePercentValue(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public double getInclusivePercentValue(int n) {
        return this.getDouble(n, 2);
    }

    public void setExclusivePercentValue(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public double getExclusivePercentValue(int n) {
        return this.getDouble(n, 3);
    }

    public void setNumberOfCalls(int n) {
        this.numberOfCalls = n;
    }

    public int getNumberOfCalls() {
        return this.numberOfCalls;
    }

    public void setNumberOfSubRoutines(int n) {
        this.numberOfSubRoutines = n;
    }

    public int getNumberOfSubRoutines() {
        return this.numberOfSubRoutines;
    }

    public void setUserSecPerCall(int n, double d) {
        this.insertDouble(n, 4, d);
    }

    public double getUserSecPerCall(int n) {
        return this.getDouble(n, 4);
    }

    public static int getPositionOfName() {
        return 97;
    }

    public static String getTStatStringHeading(Trial trial) {
        String string = null;
        string = trial.isTimeMetric() ? "time" : "counts";
        try {
            int n = ParaProf.defaultNumberPrecision;
            int n2 = 103;
            int n3 = 0;
            char[] cArray = new char[n2];
            GlobalThreadDataElement.insertSpaces(cArray, 0, 103);
            char[] cArray2 = ("%" + string).toCharArray();
            int n4 = 0;
            while (n4 < cArray2.length) {
                cArray[n3] = cArray2[n4];
                ++n3;
                ++n4;
            }
            n3 = 9;
            cArray2 = string.toCharArray();
            int n5 = 0;
            while (n5 < cArray2.length) {
                cArray[n3] = cArray2[n5];
                ++n3;
                ++n5;
            }
            n3 = 27;
            cArray2 = ("total " + string).toCharArray();
            int n6 = 0;
            while (n6 < cArray2.length) {
                cArray[n3] = cArray2[n6];
                ++n3;
                ++n6;
            }
            n3 = 45;
            cArray2 = "#calls".toCharArray();
            int n7 = 0;
            while (n7 < cArray2.length) {
                cArray[n3] = cArray2[n7];
                ++n3;
                ++n7;
            }
            n3 = 63;
            cArray2 = "#subrs".toCharArray();
            int n8 = 0;
            while (n8 < cArray2.length) {
                cArray[n3] = cArray2[n8];
                ++n3;
                ++n8;
            }
            n3 = 81;
            cArray2 = ("total " + string + "/call").toCharArray();
            int n9 = 0;
            while (n9 < cArray2.length) {
                cArray[n3] = cArray2[n9];
                ++n3;
                ++n9;
            }
            n3 = 99;
            cArray2 = "name".toCharArray();
            int n10 = 0;
            while (n10 < cArray2.length) {
                cArray[n3] = cArray2[n10];
                ++n3;
                ++n10;
            }
            return new String(cArray);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "GTDE01");
            return "An error occured pocessing this string!";
        }
    }

    public String getTStatString(int n, int n2) {
        try {
            int n3 = ParaProf.defaultNumberPrecision;
            int n4 = 99;
            int n5 = 0;
            char[] cArray = new char[n4];
            GlobalThreadDataElement.insertSpaces(cArray, 0, 99);
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.applyPattern("##0.0");
            char[] cArray2 = decimalFormat.format(this.getInclusivePercentValue(n2)).toCharArray();
            int n6 = 0;
            while (n6 < cArray2.length) {
                cArray[n5] = cArray2[n6];
                ++n5;
                ++n6;
            }
            n5 = 9;
            String string = UtilFncs.getOutputString(n, this.getExclusiveValue(n2));
            cArray2 = string.toCharArray();
            int n7 = 0;
            while (n7 < cArray2.length) {
                cArray[n5] = cArray2[n7];
                ++n5;
                ++n7;
            }
            n5 = 27;
            string = UtilFncs.getOutputString(n, this.getInclusiveValue(n2));
            cArray2 = string.toCharArray();
            int n8 = 0;
            while (n8 < cArray2.length) {
                cArray[n5] = cArray2[n8];
                ++n5;
                ++n8;
            }
            n5 = 45;
            string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getNumberOfCalls(), n3)));
            cArray2 = string.toCharArray();
            int n9 = 0;
            while (n9 < cArray2.length) {
                cArray[n5] = cArray2[n9];
                ++n5;
                ++n9;
            }
            n5 = 63;
            string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getNumberOfSubRoutines(), n3)));
            cArray2 = string.toCharArray();
            int n10 = 0;
            while (n10 < cArray2.length) {
                cArray[n5] = cArray2[n10];
                ++n5;
                ++n10;
            }
            n5 = 81;
            string = UtilFncs.getOutputString(n, this.getUserSecPerCall(n2));
            cArray2 = string.toCharArray();
            int n11 = 0;
            while (n11 < cArray2.length) {
                cArray[n5] = cArray2[n11];
                ++n5;
                ++n11;
            }
            String string2 = new String(cArray);
            return string2 + this.getMappingName();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "GTDE01");
            return "An error occured pocessing this string!";
        }
    }

    public String getUserEventName() {
        GlobalMappingElement globalMappingElement = this.trial.getGlobalMapping().getGlobalMappingElement(this.mappingID, 2);
        return globalMappingElement.getMappingName();
    }

    public void setUserEventID(int n) {
        this.mappingID = n;
    }

    public int getUserEventID() {
        return this.mappingID;
    }

    public void setUserEventNumberValue(int n) {
        this.userEventNumberValue = n;
    }

    public int getUserEventNumberValue() {
        return this.userEventNumberValue;
    }

    public void setUserEventMinValue(double d) {
        this.doubleList[0] = d;
    }

    public double getUserEventMinValue() {
        return this.doubleList[0];
    }

    public void setUserEventMaxValue(double d) {
        this.doubleList[1] = d;
    }

    public double getUserEventMaxValue() {
        return this.doubleList[1];
    }

    public void setUserEventMeanValue(double d) {
        this.doubleList[2] = d;
    }

    public double getUserEventMeanValue() {
        return this.doubleList[2];
    }

    public static String getUserEventStatStringHeading() {
        try {
            int n = ParaProf.defaultNumberPrecision;
            int n2 = 82;
            int n3 = 0;
            char[] cArray = new char[n2];
            GlobalThreadDataElement.insertSpaces(cArray, 0, 82);
            char[] cArray2 = "NumSamples".toCharArray();
            int n4 = 0;
            while (n4 < cArray2.length) {
                cArray[n3] = cArray2[n4];
                ++n3;
                ++n4;
            }
            n3 = 18;
            cArray2 = "MaxValue".toCharArray();
            int n5 = 0;
            while (n5 < cArray2.length) {
                cArray[n3] = cArray2[n5];
                ++n3;
                ++n5;
            }
            n3 = 36;
            cArray2 = "MinValue".toCharArray();
            int n6 = 0;
            while (n6 < cArray2.length) {
                cArray[n3] = cArray2[n6];
                ++n3;
                ++n6;
            }
            n3 = 54;
            cArray2 = "MeanValue".toCharArray();
            int n7 = 0;
            while (n7 < cArray2.length) {
                cArray[n3] = cArray2[n7];
                ++n3;
                ++n7;
            }
            n3 = 72;
            cArray2 = "Event Name".toCharArray();
            int n8 = 0;
            while (n8 < cArray2.length) {
                cArray[n3] = cArray2[n8];
                ++n3;
                ++n8;
            }
            return new String(cArray);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "GTDE01");
            return "An error occured pocessing this string!";
        }
    }

    public String getUserEventStatString() {
        try {
            int n = ParaProf.defaultNumberPrecision;
            int n2 = 72;
            int n3 = 0;
            char[] cArray = new char[n2];
            GlobalThreadDataElement.insertSpaces(cArray, 0, 72);
            char[] cArray2 = Integer.toString(this.getUserEventNumberValue()).toCharArray();
            int n4 = 0;
            while (n4 < cArray2.length) {
                cArray[n3] = cArray2[n4];
                ++n3;
                ++n4;
            }
            n3 = 18;
            String string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getUserEventMaxValue(), n)));
            cArray2 = string.toCharArray();
            int n5 = 0;
            while (n5 < cArray2.length) {
                cArray[n3] = cArray2[n5];
                ++n3;
                ++n5;
            }
            n3 = 36;
            string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getUserEventMinValue(), n)));
            cArray2 = string.toCharArray();
            int n6 = 0;
            while (n6 < cArray2.length) {
                cArray[n3] = cArray2[n6];
                ++n3;
                ++n6;
            }
            n3 = 54;
            string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getUserEventMeanValue(), n)));
            cArray2 = string.toCharArray();
            int n7 = 0;
            while (n7 < cArray2.length) {
                cArray[n3] = cArray2[n7];
                ++n3;
                ++n7;
            }
            String string2 = new String(cArray);
            return string2 + this.getUserEventName();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "GTDE01");
            return "An error occured pocessing this string!";
        }
    }

    public static int getPositionOfUserEventName() {
        return 72;
    }

    public boolean isCallPathObject() {
        GlobalMappingElement globalMappingElement = this.trial.getGlobalMapping().getGlobalMappingElement(this.mappingID, 0);
        return globalMappingElement.isCallPathObject();
    }

    public int addParent(int n) {
        if (this.parents == null) {
            this.parents = new Vector();
            this.callPathIDSParents = new Vector();
        }
        this.parents.add(new Integer(n));
        Vector vector = new Vector();
        this.callPathIDSParents.add(vector);
        return this.parents.size() - 1;
    }

    public void addParentCallPathID(int n, int n2) {
        Vector vector = (Vector)this.callPathIDSParents.elementAt(n);
        vector.add(new Integer(n2));
    }

    public void addParent(int n, int n2) {
        int n3 = UtilFncs.exists(this.parents, n);
        if (n3 == -1) {
            if (this.parents == null) {
                this.parents = new Vector();
                this.callPathIDSParents = new Vector();
            }
            this.parents.add(new Integer(n));
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(new Integer(n2));
            this.callPathIDSParents.add(vector);
        } else {
            Vector vector = (Vector)this.callPathIDSParents.elementAt(n3);
            vector.add(new Integer(n2));
        }
    }

    public Vector getParents() {
        return this.parents;
    }

    public Vector getChildren() {
        return this.children;
    }

    public ListIterator getParentsIterator() {
        return new ParaProfIterator(this.parents);
    }

    public ListIterator getChildrenIterator() {
        return new ParaProfIterator(this.children);
    }

    public ListIterator getCallPathIDParents(int n) {
        int n2 = UtilFncs.exists(this.parents, n);
        return new ParaProfIterator((Vector)this.callPathIDSParents.elementAt(n2));
    }

    public ListIterator getCallPathIDChildren(int n) {
        int n2 = UtilFncs.exists(this.children, n);
        return new ParaProfIterator((Vector)this.callPathIDSChildren.elementAt(n2));
    }

    public int addChild(int n) {
        if (this.children == null) {
            this.children = new Vector();
            this.callPathIDSChildren = new Vector();
        }
        this.children.add(new Integer(n));
        Vector vector = new Vector();
        this.callPathIDSChildren.add(vector);
        return this.children.size() - 1;
    }

    public void addChildCallPathID(int n, int n2) {
        Vector vector = (Vector)this.callPathIDSChildren.elementAt(n);
        vector.add(new Integer(n2));
    }

    public void addChild(int n, int n2) {
        int n3 = UtilFncs.exists(this.children, n);
        if (n3 == -1) {
            if (this.children == null) {
                this.children = new Vector();
                this.callPathIDSChildren = new Vector();
            }
            this.children.add(new Integer(n));
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(new Integer(n2));
            this.callPathIDSChildren.add(vector);
        } else {
            Vector vector = (Vector)this.callPathIDSChildren.elementAt(n3);
            vector.add(new Integer(n2));
        }
    }

    private static int insertSpaces(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            cArray[n] = 32;
            ++n;
            ++n3;
        }
        return n;
    }

    private void insertDouble(int n, int n2, double d) {
        int n3 = n * 5 + n2;
        try {
            this.doubleList[n3] = d;
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "GTDE06");
        }
    }

    private double getDouble(int n, int n2) {
        int n3 = n * 5 + n2;
        try {
            return this.doubleList[n3];
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "GTDE06");
            return -1.0;
        }
    }

    public void incrementStorage() {
        if (this.userElement) {
            System.out.println("We are trying to increase storage on a user event object!");
        }
        int n = this.doubleList.length;
        double[] dArray = new double[n + 5];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.doubleList[n2];
            ++n2;
        }
        this.doubleList = dArray;
    }
}

