/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.Document;
import paraprof.ParaProf;

public class HelpWindow
extends JFrame
implements ActionListener,
Observer {
    int windowWidth = 750;
    int windowHeight = 500;
    JTextArea helpJTextArea;
    Document helpJTextAreaDocument;

    public HelpWindow() {
        this.setSize(new Dimension(this.windowWidth, this.windowHeight));
        this.setTitle("Racy Help Window");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Display General Help");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Close ParaProf Help Window");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Exit ParaProf!");
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.helpJTextArea = new JTextArea();
        this.helpJTextArea.setLineWrap(true);
        this.helpJTextArea.setWrapStyleWord(true);
        this.helpJTextArea.setSize(new Dimension(this.windowWidth, this.windowHeight));
        this.helpJTextAreaDocument = this.helpJTextArea.getDocument();
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        Border border = BorderFactory.createLoweredBevelBorder();
        JScrollPane jScrollPane = new JScrollPane(this.helpJTextArea);
        jScrollPane.setBorder(border);
        jScrollPane.setPreferredSize(new Dimension(this.windowWidth, this.windowHeight));
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(jScrollPane, gridBagConstraints, 0, 0, 2, 1);
        this.writeText("Welcome to ParaProf!");
        this.writeText("");
        this.writeText("For general help, please select display general help from the file menu.");
    }

    public void clearText() {
        try {
            this.helpJTextAreaDocument.remove(0, this.helpJTextAreaDocument.getLength());
        }
        catch (Exception exception) {
            System.out.println("There was a problem with the help window!");
            System.out.println(exception.toString());
        }
    }

    public void writeText(String string) {
        this.helpJTextArea.append(string);
        this.helpJTextArea.append("\n");
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("subWindowCloseEvent")) {
            this.setVisible(false);
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block7;
                String string = actionEvent.getActionCommand();
                if (string.equals("Display General Help")) {
                    this.clearText();
                    this.writeText("Welcome to ParaProf!");
                    this.writeText("");
                    this.writeText("More detailed information can be found in the ParaProfHelp.txt that is distributed with TAU. What follows is a brief summary of the new features.");
                    this.writeText("");
                    this.writeText("1) Added new group tracking in ParaProf:");
                    this.writeText("pprof has been updated to track group names, and ParaProf has also been updated to take advantage of this.  At present, a new group ledger window has been added to display groups. Clicking on one of the groups in this window will cause all members of the group to be highlighted in all open windows, except for the total stat windows. This is only the first stage of group capabilities, but it has proved more time consuming than expected to add all the features.  Much more to follow!");
                    this.writeText("");
                    this.writeText("2) Add the ability to save color maps between sessions:");
                    this.writeText("When you save a color map, a text file is created with the current map. Loading a map causes the system to try and match the mapping names it know about with names in the selected color map file. If it finds a match, it updates the color. This means that you do not need to have exactly the same mappings in the system as when the map was saved.");
                    this.writeText("");
                    this.writeText("3) Sliders have been added to all windows that have bars.");
                    this.writeText("To display the sliders, select the display sliders option from the options menu of any window containing bars.  This will display the sliders for that window.  The slider options are as follows: A drop down list selecting a portion of the original length, and a bar giving a multiple of this length.  This has proved useful in tailoring the exact lengths of bars needed.");
                    this.writeText("");
                    this.writeText("4) Added more color selections for mapping group colors.");
                    this.writeText("");
                    this.writeText("5) Added full masking of groups.");
                    this.writeText("");
                    this.writeText("6) A number of other minor changes and bug fixes.  As always, this is an ongoing project as such, ANY suggestions are welcome.  There will also be a clean up of the code to provide more effective searching as some things have been implimented just to get it working.");
                } else if (string.equals("Close ParaProf Help Window")) {
                    this.setVisible(false);
                } else if (string.equals("Exit ParaProf!")) {
                    this.setVisible(false);
                    this.dispose();
                    System.exit(0);
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "HW01");
            }
        }
    }
}

