/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import paraprof.GlobalMappingElement;
import paraprof.MappingDataWindow;
import paraprof.ParaProf;
import paraprof.SMWContext;
import paraprof.SMWServer;
import paraprof.SMWThread;
import paraprof.SMWThreadDataElement;
import paraprof.StaticMainWindowData;
import paraprof.Trial;
import paraprof.UtilFncs;

public class MappingDataWindowPanel
extends JPanel
implements ActionListener,
MouseListener {
    private Vector staticNodeList;
    private String counterName = null;
    private int mappingID = -1;
    private String mappingName;
    GlobalMappingElement gME = null;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 250;
    private int barLength = 0;
    private int textOffset = 60;
    private int maxXLength = 0;
    private boolean groupMember = false;
    private int aT = -1;
    private int serverNumber = -1;
    private int contextNumber = -1;
    private int threadNumber = -1;
    private Trial trial = null;
    private MappingDataWindow mDWindow = null;
    private StaticMainWindowData sMWData = null;
    private SMWServer tmpSMWServer = null;
    private SMWContext tmpSMWContext = null;
    private SMWThread tmpSMWThread = null;
    private SMWThreadDataElement tmpSMWThreadDataElement = null;
    private Vector tmpContextList = null;
    private Vector tmpThreadList = null;
    private Vector tmpThreadDataElementList = null;
    int xPanelSize = 0;
    int yPanelSize = 0;
    private JPopupMenu popup = new JPopupMenu();

    public MappingDataWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDWP01");
        }
    }

    public MappingDataWindowPanel(Trial trial, int n, MappingDataWindow mappingDataWindow) {
        try {
            this.trial = trial;
            this.mDWindow = mappingDataWindow;
            this.gME = this.trial.getGlobalMapping().getGlobalMappingElement(n, 0);
            this.mappingName = this.gME.getMappingName();
            this.mappingID = this.gME.getGlobalID();
            this.barLength = this.baseBarLength;
            this.setBackground(Color.white);
            this.addMouseListener(this);
            JMenuItem jMenuItem = new JMenuItem("Change Function Color");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Reset to Generic Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = 0.0;
            double d2 = 0.0;
            int n = 0;
            int n2 = 0;
            int n3 = this.barLength + this.textOffset;
            this.trial.getPreferences().setBarDetails(graphics2D);
            this.barSpacing = this.trial.getPreferences().getBarSpacing();
            this.barHeight = this.trial.getPreferences().getBarHeight();
            Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            Rectangle rectangle = graphics2D.getClipBounds();
            int n4 = (int)rectangle.getY();
            int n5 = (int)((double)n4 + rectangle.getHeight());
            n5 += this.barSpacing;
            switch (this.mDWindow.getMetric()) {
                case 0: {
                    if (this.mDWindow.isPercent()) {
                        d2 = this.gME.getMaxInclusivePercentValue(this.trial.getCurValLoc());
                        d = this.gME.getMeanInclusivePercentValue(this.trial.getCurValLoc());
                        break;
                    }
                    d2 = this.gME.getMaxInclusiveValue(this.trial.getCurValLoc());
                    d = this.gME.getMeanInclusiveValue(this.trial.getCurValLoc());
                    break;
                }
                case 1: {
                    if (this.mDWindow.isPercent()) {
                        d2 = this.gME.getMaxExclusivePercentValue(this.trial.getCurValLoc());
                        d = this.gME.getMeanExclusivePercentValue(this.trial.getCurValLoc());
                        break;
                    }
                    d2 = this.gME.getMaxExclusiveValue(this.trial.getCurValLoc());
                    d = this.gME.getMeanExclusiveValue(this.trial.getCurValLoc());
                    break;
                }
                case 2: {
                    d2 = this.gME.getMaxNumberOfCalls();
                    d = this.gME.getMeanNumberOfCalls();
                    break;
                }
                case 3: {
                    d2 = this.gME.getMaxNumberOfSubRoutines();
                    d = this.gME.getMeanNumberOfSubRoutines();
                    break;
                }
                case 4: {
                    d2 = this.gME.getMaxUserSecPerCall(this.trial.getCurValLoc());
                    d = this.gME.getMeanUserSecPerCall(this.trial.getCurValLoc());
                    break;
                }
                default: {
                    ParaProf.systemError(null, null, "Unexpected type - MDWP value: " + this.mDWindow.getMetric());
                }
            }
            if (this.mDWindow.isPercent()) {
                n = fontMetrics.stringWidth(UtilFncs.getTestString(d2, ParaProf.defaultNumberPrecision) + "%");
                n3 += n;
            } else {
                n = fontMetrics.stringWidth(UtilFncs.getOutputString(this.mDWindow.units(), d2));
                n3 += n;
            }
            if (this.resizePanel(fontMetrics, n3)) {
                this.revalidate();
                return;
            }
            this.groupMember = this.gME.isGroupMember(this.trial.getColorChooser().getGHCMID());
            if ((n2 += this.barSpacing) >= n4 && n2 <= n5) {
                this.drawBar(graphics2D, fontMetrics, d, d2, "mean", n3, n2, this.barHeight, this.groupMember);
            }
            this.serverNumber = 0;
            Enumeration enumeration = this.mDWindow.getStaticMainWindowSystemData().elements();
            while (enumeration.hasMoreElements()) {
                this.tmpSMWServer = (SMWServer)enumeration.nextElement();
                this.contextNumber = 0;
                this.tmpContextList = this.tmpSMWServer.getContextList();
                Enumeration enumeration2 = this.tmpContextList.elements();
                while (enumeration2.hasMoreElements()) {
                    this.tmpSMWContext = (SMWContext)enumeration2.nextElement();
                    this.tmpThreadList = this.tmpSMWContext.getThreadList();
                    this.threadNumber = 0;
                    Enumeration enumeration3 = this.tmpThreadList.elements();
                    while (enumeration3.hasMoreElements()) {
                        this.tmpSMWThread = (SMWThread)enumeration3.nextElement();
                        this.tmpThreadDataElementList = this.tmpSMWThread.getThreadDataList();
                        Enumeration enumeration4 = this.tmpThreadDataElementList.elements();
                        while (enumeration4.hasMoreElements()) {
                            this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                            if (this.tmpSMWThreadDataElement.getMappingID() != this.mappingID) continue;
                            switch (this.mDWindow.getMetric()) {
                                case 0: {
                                    if (this.mDWindow.isPercent()) {
                                        d = this.tmpSMWThreadDataElement.getInclusivePercentValue();
                                        break;
                                    }
                                    d = this.tmpSMWThreadDataElement.getInclusiveValue();
                                    break;
                                }
                                case 1: {
                                    if (this.mDWindow.isPercent()) {
                                        d = this.tmpSMWThreadDataElement.getExclusivePercentValue();
                                        break;
                                    }
                                    d = this.tmpSMWThreadDataElement.getExclusiveValue();
                                    break;
                                }
                                case 2: {
                                    d = this.tmpSMWThreadDataElement.getNumberOfCalls();
                                    break;
                                }
                                case 3: {
                                    d = this.tmpSMWThreadDataElement.getNumberOfSubRoutines();
                                    break;
                                }
                                case 4: {
                                    d = this.tmpSMWThreadDataElement.getUserSecPerCall();
                                    break;
                                }
                                default: {
                                    ParaProf.systemError(null, null, "Unexpected type - MDWP value: " + this.mDWindow.getMetric());
                                }
                            }
                            if ((n2 += this.barSpacing) < n4 || n2 > n5) continue;
                            this.drawBar(graphics2D, fontMetrics, d, d2, "n,c,t " + this.serverNumber + "," + this.contextNumber + "," + this.threadNumber, n3, n2, this.barHeight, this.groupMember);
                        }
                        ++this.threadNumber;
                    }
                    ++this.contextNumber;
                }
                ++this.serverNumber;
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDWP03");
        }
    }

    private int activeThreads() {
        if (this.aT == -1) {
            Enumeration enumeration = this.mDWindow.getStaticMainWindowSystemData().elements();
            while (enumeration.hasMoreElements()) {
                this.tmpSMWServer = (SMWServer)enumeration.nextElement();
                this.tmpContextList = this.tmpSMWServer.getContextList();
                Enumeration enumeration2 = this.tmpContextList.elements();
                while (enumeration2.hasMoreElements()) {
                    this.tmpSMWContext = (SMWContext)enumeration2.nextElement();
                    this.tmpThreadList = this.tmpSMWContext.getThreadList();
                    Enumeration enumeration3 = this.tmpThreadList.elements();
                    while (enumeration3.hasMoreElements()) {
                        this.tmpSMWThread = (SMWThread)enumeration3.nextElement();
                        this.tmpThreadDataElementList = this.tmpSMWThread.getThreadDataList();
                        Enumeration enumeration4 = this.tmpThreadDataElementList.elements();
                        while (enumeration4.hasMoreElements()) {
                            this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                            if (this.tmpSMWThreadDataElement.getMappingID() != this.mappingID) continue;
                            ++this.aT;
                        }
                    }
                }
            }
        }
        return this.aT;
    }

    private void drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, double d, double d2, String string, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        String string2 = null;
        int n5 = 0;
        int n6 = 0;
        d3 = d / d2;
        n4 = (int)(d3 * (double)this.barLength);
        if (n4 == 0) {
            n4 = 1;
        }
        if (n4 > 2 && n3 > 2) {
            graphics2D.setColor(this.gME.getMappingColor());
            graphics2D.fillRect(n - n4 + 1, n2 - n3 + 1, n4 - 1, n3 - 1);
            if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
                graphics2D.drawRect(n - n4 + 1, n2 - n3 + 1, n4 - 2, n3 - 2);
            } else if (bl) {
                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
                graphics2D.drawRect(n - n4 + 1, n2 - n3 + 1, n4 - 2, n3 - 2);
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
            }
        } else {
            if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
            } else if (this.gME.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
            } else {
                graphics2D.setColor(this.gME.getMappingColor());
            }
            graphics2D.fillRect(n - n4, n2 - n3, n4, n3);
        }
        graphics2D.setColor(Color.black);
        string2 = this.mDWindow.isPercent() && this.mDWindow.getMetric() < 2 ? UtilFncs.adjustDoublePresision(d, ParaProf.defaultNumberPrecision) + "%" : UtilFncs.getOutputString(this.mDWindow.units(), d);
        n5 = fontMetrics.stringWidth(string2);
        n6 = n - n4 - n5 - 5;
        graphics2D.drawString(string2, n6, n2);
        graphics2D.drawString(string, n + 5, n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block4: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block4;
                String string = actionEvent.getActionCommand();
                if (string.equals("Change Function Color")) {
                    Color color = this.gME.getMappingColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) == null) break block4;
                    this.gME.setSpecificColor(color);
                    this.gME.setColorFlag(true);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    break block4;
                }
                if (string.equals("Reset to Generic Color")) {
                    this.gME.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "MDWP04");
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            if ((mouseEvent.getModifiers() & 0x10) == 0) {
                this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void changeInMultiples() {
        this.computeBarLength();
        this.repaint();
    }

    public void computeBarLength() {
        try {
            double d = this.mDWindow.getSliderValue();
            double d2 = this.mDWindow.getSliderMultiple();
            this.barLength = this.baseBarLength * (int)(d * d2);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDWP06");
        }
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        try {
            int n2 = (this.activeThreads() + 2) * this.barSpacing + 10;
            int[] nArray = this.trial.getMaxNCTNumbers();
            String string = "n,c,t " + nArray[0] + "," + nArray[1] + "," + nArray[2];
            int n3 = n + 5 + fontMetrics.stringWidth(string) + 25;
            if (n2 != this.yPanelSize || n3 != this.xPanelSize) {
                this.yPanelSize = n2;
                this.xPanelSize = n3;
                this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
                bl = false;
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDWP07");
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize);
    }
}

