/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import paraprof.MappingLedgerWindowPanel;
import paraprof.ParaProf;
import paraprof.Trial;

public class MappingLedgerWindow
extends JFrame
implements ActionListener,
Observer {
    Vector serverDataVector;
    int mappingSelection = -1;
    private Trial trial = null;
    MappingLedgerWindowPanel mappingLedgerWinPanelRef;

    public MappingLedgerWindow() {
        try {
            this.setLocation(new Point(300, 200));
            this.setSize(new Dimension(350, 450));
            this.setTitle("Wrong constructor used");
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MLW01");
        }
    }

    public MappingLedgerWindow(Trial trial, Vector vector, int n) {
        try {
            this.trial = trial;
            this.mappingSelection = n;
            this.setLocation(new Point(300, 200));
            this.setSize(new Dimension(350, 450));
            if (this.mappingSelection == 0) {
                this.setTitle("Function Ledger Window: " + this.trial.getProfilePathName());
            } else if (this.mappingSelection == 1) {
                this.setTitle("Group Ledger Window: " + this.trial.getProfilePathName());
            } else {
                this.setTitle("User Event Window: " + this.trial.getProfilePathName());
            }
            if (ParaProf.helpWindow.isVisible()) {
                ParaProf.helpWindow.clearText();
                if (this.mappingSelection == 0) {
                    ParaProf.helpWindow.writeText("This is the function ledger window.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("This window shows all the functions tracked in this profile.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("To see more information about any of the mappings shown here,");
                    ParaProf.helpWindow.writeText("right click on that function, and select from the popup menu.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
                } else if (this.mappingSelection == 1) {
                    ParaProf.helpWindow.writeText("This is the group ledger window.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("This window shows all the groups tracked in this profile.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("Left click any group to hightlight it in the system.");
                    ParaProf.helpWindow.writeText("Right click on any group, and select from the popup menu to display more options for masking or displaying functions in a particular group.");
                } else {
                    ParaProf.helpWindow.writeText("This is the user event ledger window.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("This window shows all the user events tracked in this profile.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("Left click any mapping to hightlight it in the system.");
                    ParaProf.helpWindow.writeText("Right click on any user event, and select from the popup menu.");
                }
            }
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MappingLedgerWindow.this.trial.getGlobalMapping().closeMappingLedger(MappingLedgerWindow.this.mappingSelection);
                }
            });
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenu jMenu2 = new JMenu("Save ...");
            JMenuItem jMenuItem = new JMenuItem("ParaProf Preferrences");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenu.add(jMenu2);
            JMenuItem jMenuItem2 = new JMenuItem("Edit ParaProf Preferences");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenuItem jMenuItem3 = null;
            jMenuItem3 = this.mappingSelection == 0 ? new JMenuItem("Close Function Ledger Window") : (this.mappingSelection == 1 ? new JMenuItem("Close Group Ledger Window") : new JMenuItem("Close User Event Window"));
            jMenuItem3.addActionListener(this);
            jMenu.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Exit ParaProf!");
            jMenuItem4.addActionListener(this);
            jMenu.add(jMenuItem4);
            JMenu jMenu3 = new JMenu("Windows");
            JMenuItem jMenuItem5 = new JMenuItem("Close All Sub-Windows");
            jMenuItem5.addActionListener(this);
            jMenu3.add(jMenuItem5);
            JMenu jMenu4 = new JMenu("Help");
            JMenuItem jMenuItem6 = new JMenuItem("About Racy");
            jMenuItem6.addActionListener(this);
            jMenu4.add(jMenuItem6);
            JMenuItem jMenuItem7 = new JMenuItem("Show Help Window");
            jMenuItem7.addActionListener(this);
            jMenu4.add(jMenuItem7);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu3);
            jMenuBar.add(jMenu4);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.mappingLedgerWinPanelRef = new MappingLedgerWindowPanel(this.trial, vector, this.mappingSelection);
            JScrollPane jScrollPane = new JScrollPane(this.mappingLedgerWinPanelRef);
            jScrollPane.setBorder(border);
            jScrollPane.setPreferredSize(new Dimension(350, 400));
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 0, 1, 1);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MLW02");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MLW03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block11: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block11;
                String string = actionEvent.getActionCommand();
                if (string.equals("Edit ParaProf Preferences")) {
                    this.trial.getPreferences().showPreferencesWindow();
                    break block11;
                }
                if (string.equals("Exit ParaProf!")) {
                    this.setVisible(false);
                    this.dispose();
                    System.exit(0);
                    break block11;
                }
                if (string.equals("Close Function Ledger Window")) {
                    this.trial.getGlobalMapping().closeMappingLedger(this.mappingSelection);
                    break block11;
                }
                if (string.equals("Close Group Ledger Window")) {
                    this.trial.getGlobalMapping().closeMappingLedger(this.mappingSelection);
                    break block11;
                }
                if (string.equals("Close User Event Window")) {
                    this.trial.getGlobalMapping().closeMappingLedger(this.mappingSelection);
                    break block11;
                }
                if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                    break block11;
                }
                if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                    break block11;
                }
                if (!string.equals("Show Help Window")) break block11;
                ParaProf.helpWindow.clearText();
                ParaProf.helpWindow.show();
                if (this.mappingSelection == 0) {
                    ParaProf.helpWindow.writeText("This is the function ledger window.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("This window shows all the functions tracked in this profile.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("To see more information about any of the functions shown here,");
                    ParaProf.helpWindow.writeText("right click on that function, and select from the popup menu.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
                    break block11;
                }
                if (this.mappingSelection == 1) {
                    ParaProf.helpWindow.writeText("This is the group ledger window.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("This window shows all the groups tracked in this profile.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("Left click any group to hightlight it in the system.");
                    ParaProf.helpWindow.writeText("Right click on any group, and select from the popup menu to display more options for masking or displaying functions in a particular group.");
                    break block11;
                }
                ParaProf.helpWindow.writeText("This is the user event ledger window.");
                ParaProf.helpWindow.writeText("");
                ParaProf.helpWindow.writeText("This window shows all the user events tracked in this profile.");
                ParaProf.helpWindow.writeText("");
                ParaProf.helpWindow.writeText("Left click any user event to hightlight it in the system.");
                ParaProf.helpWindow.writeText("Right click on any user event, and select from the popup menu.");
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "MLW04");
            }
        }
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.mappingLedgerWinPanelRef.repaint();
            } else if (string.equals("colorEvent")) {
                this.mappingLedgerWinPanelRef.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.trial.getGlobalMapping().closeMappingLedger(this.mappingSelection);
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MLW05");
        }
    }
}

