/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import paraprof.GlobalMapping;
import paraprof.GlobalMappingElement;
import paraprof.MappingDataWindow;
import paraprof.ParaProf;
import paraprof.Trial;
import paraprof.UserEventWindow;

public class MappingLedgerWindowPanel
extends JPanel
implements ActionListener,
MouseListener {
    int xPanelSize = 300;
    int yPanelSize = 400;
    int barHeight;
    int barSpacing;
    Trial trial = null;
    Vector NameIDMapping;
    int mappingSelection = -1;
    int numberOfColors = 0;
    private JPopupMenu popup = new JPopupMenu();
    String counterName = null;
    Object clickedOnObject = null;

    public MappingLedgerWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MLWP01");
        }
    }

    public MappingLedgerWindowPanel(Trial trial, Vector vector, int n) {
        try {
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.trial = trial;
            this.NameIDMapping = vector;
            this.mappingSelection = n;
            this.addMouseListener(this);
            if (this.mappingSelection == 0) {
                jMenuItem2 = new JMenuItem("Show Function Details");
                jMenuItem2.addActionListener(this);
                this.popup.add(jMenuItem2);
                jMenuItem = new JMenuItem("Change Function Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
            }
            if (this.mappingSelection == 2) {
                jMenuItem2 = new JMenuItem("Show User Event Details");
                jMenuItem2.addActionListener(this);
                this.popup.add(jMenuItem2);
                jMenuItem = new JMenuItem("Change User Event Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
            }
            jMenuItem2 = new JMenuItem("Reset to Generic Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            if (this.mappingSelection == 1) {
                jMenuItem = new JMenuItem("Show This Group Only");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                JMenuItem jMenuItem3 = new JMenuItem("Show All Groups Except This One");
                jMenuItem3.addActionListener(this);
                this.popup.add(jMenuItem3);
                JMenuItem jMenuItem4 = new JMenuItem("Show All Groups");
                jMenuItem4.addActionListener(this);
                this.popup.add(jMenuItem4);
            }
            this.repaint();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MLWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            int n;
            FontMetrics fontMetrics;
            Font font;
            super.paintComponent(graphics);
            this.numberOfColors = this.trial.getColorChooser().getNumberOfColors();
            GlobalMappingElement globalMappingElement = null;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n4 = 0;
            n2 = 5;
            if (!this.trial.getPreferences().areBarDetailsSet()) {
                font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), 12);
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics(font);
                n = fontMetrics.getAscent();
                this.trial.getPreferences().setBarDetails(n, n);
                this.trial.getPreferences().setSliders(n, n);
            }
            this.barSpacing = this.trial.getPreferences().getBarSpacing();
            this.barHeight = this.trial.getPreferences().getBarHeight();
            font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
            graphics.setFont(font);
            fontMetrics = graphics.getFontMetrics(font);
            n3 += this.barSpacing;
            this.counterName = this.trial.getCounterName();
            if (this.counterName != null) {
                graphics.drawString("COUNTER NAME: " + this.counterName, 5, n3);
                n3 += this.barSpacing;
            }
            n = 0;
            Enumeration enumeration = this.NameIDMapping.elements();
            while (enumeration.hasMoreElements()) {
                globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
                if (globalMappingElement.getMappingName() != null) {
                    Color color = globalMappingElement.getMappingColor();
                    graphics.setColor(color);
                    graphics.fillRect(n2, (n3 += this.barSpacing) - this.barHeight, this.barHeight, this.barHeight);
                    if (this.mappingSelection == 2) {
                        if (globalMappingElement.getGlobalID() == this.trial.getColorChooser().getUEHCMappingID()) {
                            graphics.setColor(this.trial.getColorChooser().getUEHC());
                            graphics.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                            graphics.drawRect(n2 + 1, n3 - this.barHeight + 1, this.barHeight - 2, this.barHeight - 2);
                        } else {
                            graphics.setColor(Color.black);
                            graphics.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                        }
                    } else if (this.mappingSelection == 1) {
                        if (globalMappingElement.getGlobalID() == this.trial.getColorChooser().getGHCMID()) {
                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            graphics.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                            graphics.drawRect(n2 + 1, n3 - this.barHeight + 1, this.barHeight - 2, this.barHeight - 2);
                        } else {
                            graphics.setColor(Color.black);
                            graphics.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                        }
                    } else if (globalMappingElement.getGlobalID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                        graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                        graphics.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                        graphics.drawRect(n2 + 1, n3 - this.barHeight + 1, this.barHeight - 2, this.barHeight - 2);
                    } else {
                        graphics.setColor(Color.black);
                        graphics.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                    }
                    graphics.setColor(Color.black);
                    String string = globalMappingElement.getMappingName();
                    graphics.drawString(string, n2 += this.barHeight + 10, n3);
                    int n5 = 5 + this.barHeight + fontMetrics.stringWidth(string);
                    if (n4 < n5) {
                        n4 = n5 + 11;
                    }
                    globalMappingElement.setDrawCoords(0, n5, n3 - this.barHeight, n3);
                    n2 -= this.barHeight + 10;
                }
                ++n;
            }
            if (n3 >= this.yPanelSize || n4 >= this.xPanelSize) {
                this.yPanelSize = n3 + 1;
                this.xPanelSize = n4 + 1;
                this.revalidate();
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MLWP03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block17: {
            try {
                Object object = actionEvent.getSource();
                GlobalMappingElement globalMappingElement = null;
                if (!(object instanceof JMenuItem)) break block17;
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (!(this.clickedOnObject instanceof GlobalMappingElement)) break block17;
                    globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                    this.trial.getColorChooser().setHighlightColorMappingID(globalMappingElement.getGlobalID());
                    MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, globalMappingElement.getGlobalID(), this.trial.getStaticMainWindow().getSMWData());
                    this.trial.getSystemEvents().addObserver(mappingDataWindow);
                    mappingDataWindow.show();
                    break block17;
                }
                if (string.equals("Show User Event Details")) {
                    if (!(this.clickedOnObject instanceof GlobalMappingElement)) break block17;
                    globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                    this.trial.getColorChooser().setUEHCMappingID(globalMappingElement.getGlobalID());
                    UserEventWindow userEventWindow = new UserEventWindow(this.trial, globalMappingElement.getGlobalID(), this.trial.getStaticMainWindow().getSMWData());
                    this.trial.getSystemEvents().addObserver(userEventWindow);
                    userEventWindow.show();
                    break block17;
                }
                if (string.equals("Change Function Color") || string.equals("Change User Event Color")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                    }
                    Color color = globalMappingElement.getMappingColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) == null) break block17;
                    globalMappingElement.setSpecificColor(color);
                    globalMappingElement.setColorFlag(true);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    break block17;
                }
                if (string.equals("Reset to Generic Color")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                    }
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                } else if (string.equals("Show This Group Only")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    globalMapping.setIsSelectedGroupOn(true);
                    globalMapping.setIsAllExceptGroupOn(false);
                    globalMapping.setSelectedGroupID(globalMappingElement.getGlobalID());
                    this.trial.getSystemEvents().updateRegisteredObjects("dataEvent");
                } else if (string.equals("Show All Groups Except This One")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    globalMapping.setIsSelectedGroupOn(true);
                    globalMapping.setIsAllExceptGroupOn(true);
                    globalMapping.setSelectedGroupID(globalMappingElement.getGlobalID());
                    this.trial.getSystemEvents().updateRegisteredObjects("dataEvent");
                } else if (string.equals("Show All Groups")) {
                    if (this.clickedOnObject instanceof GlobalMappingElement) {
                        globalMappingElement = (GlobalMappingElement)this.clickedOnObject;
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    globalMapping.setIsSelectedGroupOn(false);
                    globalMapping.setIsAllExceptGroupOn(false);
                    globalMapping.setSelectedGroupID(-1);
                    this.trial.getSystemEvents().updateRegisteredObjects("dataEvent");
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "MLWP04");
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            GlobalMappingElement globalMappingElement = null;
            Enumeration enumeration = this.NameIDMapping.elements();
            while (enumeration.hasMoreElements()) {
                globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
                if (n2 > globalMappingElement.getYEnd()) continue;
                if (n2 >= globalMappingElement.getYBeg() && n >= globalMappingElement.getXBeg() && n <= globalMappingElement.getXEnd()) {
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = globalMappingElement;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                        return;
                    }
                    if (this.mappingSelection == 2) {
                        if (this.trial.getColorChooser().getUEHCMappingID() == -1) {
                            this.trial.getColorChooser().setUEHCMappingID(globalMappingElement.getGlobalID());
                        } else if (this.trial.getColorChooser().getUEHCMappingID() != globalMappingElement.getGlobalID()) {
                            this.trial.getColorChooser().setUEHCMappingID(globalMappingElement.getGlobalID());
                        } else {
                            this.trial.getColorChooser().setUEHCMappingID(-1);
                        }
                    } else if (this.mappingSelection == 1) {
                        if (this.trial.getColorChooser().getGHCMID() == -1) {
                            this.trial.getColorChooser().setGroupHighlightColorMappingID(globalMappingElement.getGlobalID());
                        } else if (this.trial.getColorChooser().getGHCMID() != globalMappingElement.getGlobalID()) {
                            this.trial.getColorChooser().setGroupHighlightColorMappingID(globalMappingElement.getGlobalID());
                        } else {
                            this.trial.getColorChooser().setGroupHighlightColorMappingID(-1);
                        }
                    } else if (this.trial.getColorChooser().getHighlightColorMappingID() == -1) {
                        this.trial.getColorChooser().setHighlightColorMappingID(globalMappingElement.getGlobalID());
                    } else if (this.trial.getColorChooser().getHighlightColorMappingID() != globalMappingElement.getGlobalID()) {
                        this.trial.getColorChooser().setHighlightColorMappingID(globalMappingElement.getGlobalID());
                    } else {
                        this.trial.getColorChooser().setHighlightColorMappingID(-1);
                    }
                    return;
                }
                return;
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MLWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize + 10, this.yPanelSize + 10);
    }
}

