/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import paraprof.GlobalMapping;
import paraprof.GlobalMappingElement;
import paraprof.MappingDataWindow;
import paraprof.MeanDataWindow;
import paraprof.ParaProf;
import paraprof.SMWMeanDataElement;
import paraprof.StaticMainWindowData;
import paraprof.Trial;
import paraprof.UtilFncs;

public class MeanDataWindowPanel
extends JPanel
implements ActionListener,
MouseListener {
    int xPanelSize = 700;
    int yPanelSize = 450;
    Vector staticNodeList;
    int newXPanelSize = 0;
    int newYPanelSize = 0;
    String counterName = null;
    int barHeight;
    int barSpacing;
    int defaultBarLength = 250;
    int maxXLength = 0;
    int numberOfColors = 0;
    private Trial trial = null;
    MeanDataWindow mDWindow;
    StaticMainWindowData sMWData;
    Vector tmpMeanDataElementList;
    SMWMeanDataElement tmpSMWMeanDataElement;
    private double maxInclusiveValue = 0.0;
    private double maxExclusiveValue = 0.0;
    private double maxInclusivePercentValue = 0.0;
    private double maxExclusivePercentValue = 0.0;
    private double maxNumberOfCalls = 0.0;
    private double maxNumberOfSubroutines = 0.0;
    private double maxUserSecPerCall = 0.0;
    private JPopupMenu popup = new JPopupMenu();
    Object clickedOnObject = null;

    public MeanDataWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDWP01");
        }
    }

    public MeanDataWindowPanel(Trial trial, MeanDataWindow meanDataWindow, StaticMainWindowData staticMainWindowData) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.staticNodeList = trial.getNodes();
            this.trial = trial;
            this.mDWindow = meanDataWindow;
            this.sMWData = staticMainWindowData;
            JMenuItem jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change Function Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            this.repaint();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            int n;
            int n2;
            FontMetrics fontMetrics;
            Font font;
            super.paintComponent(graphics);
            this.numberOfColors = this.trial.getColorChooser().getNumberOfColors();
            if (!this.trial.getPreferences().areBarDetailsSet()) {
                font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), 12);
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics(font);
                n2 = fontMetrics.getAscent();
                int n3 = fontMetrics.getMaxDescent();
                int n4 = n2 + n3;
                this.trial.getPreferences().setBarDetails(n2, n4 + 5);
                this.trial.getPreferences().setSliders(n2, n4 + 5);
            }
            this.barSpacing = this.trial.getPreferences().getBarSpacing();
            this.barHeight = this.trial.getPreferences().getBarHeight();
            font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
            graphics.setFont(font);
            fontMetrics = graphics.getFontMetrics(font);
            n2 = ParaProf.defaultNumberPrecision;
            boolean bl = false;
            int n5 = 0;
            int n6 = 0;
            int n7 = this.defaultBarLength + 60;
            n5 = 0;
            n5 += this.barSpacing;
            this.counterName = this.trial.getCounterName();
            if (this.counterName != null) {
                graphics.drawString("COUNTER NAME: " + this.counterName, 5, n5);
                n5 += this.barSpacing;
            }
            this.tmpMeanDataElementList = this.mDWindow.getStaticMainWindowSystemData();
            if (this.tmpMeanDataElementList.size() == 0) {
                return;
            }
            double d = 0.0;
            Rectangle rectangle = graphics.getClipBounds();
            int n8 = (int)rectangle.getY();
            int n9 = (int)((double)n8 + rectangle.getHeight());
            int n10 = 0;
            int n11 = 0;
            if (rectangle != null) {
                int n12;
                this.newYPanelSize = n5 + (this.tmpMeanDataElementList.size() + 1) * this.barSpacing;
                n10 = (n8 - n5) / this.barSpacing - 1;
                n11 = (n9 - n5) / this.barSpacing + 1;
                if (n10 < 0) {
                    n10 = 0;
                }
                if (n11 < 0) {
                    n11 = 0;
                }
                if (n10 > this.tmpMeanDataElementList.size() - 1) {
                    n10 = this.tmpMeanDataElementList.size() - 1;
                }
                if (n11 > this.tmpMeanDataElementList.size() - 1) {
                    n11 = this.tmpMeanDataElementList.size() - 1;
                }
                n5 += n10 * this.barSpacing;
                this.maxInclusiveValue = this.trial.getMaxMeanInclusiveValue(this.trial.getCurValLoc());
                this.maxExclusiveValue = this.trial.getMaxMeanExclusiveValue(this.trial.getCurValLoc());
                this.maxInclusivePercentValue = this.trial.getMaxMeanInclusivePercentValue(this.trial.getCurValLoc());
                this.maxExclusivePercentValue = this.trial.getMaxMeanExclusivePercentValue(this.trial.getCurValLoc());
                this.maxNumberOfCalls = this.trial.getMaxMeanNumberOfCalls();
                this.maxNumberOfSubroutines = this.trial.getMaxMeanNumberOfSubRoutines();
                this.maxUserSecPerCall = this.trial.getMaxMeanUserSecPerCall(this.trial.getCurValLoc());
                if (this.mDWindow.isInclusive()) {
                    if (this.mDWindow.isPercent()) {
                        n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusivePercentValue, n2) + "%");
                        n7 += n12;
                    } else if (this.mDWindow.units() == 2) {
                        n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusiveValue / 1000000.0, n2));
                        n7 += n12;
                    } else if (this.mDWindow.units() == 1) {
                        n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusiveValue / 1000.0, n2));
                        n7 += n12;
                    } else {
                        n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusiveValue, n2));
                        n7 += n12;
                    }
                } else if (this.mDWindow.isPercent()) {
                    n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusivePercentValue, n2) + "%");
                    n7 += n12;
                } else if (this.mDWindow.units() == 2) {
                    n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusiveValue / 1000000.0, n2));
                    n7 += n12;
                } else if (this.mDWindow.units() == 1) {
                    n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusiveValue / 1000.0, n2));
                    n7 += n12;
                } else {
                    n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusiveValue, n2));
                    n7 += n12;
                }
                if (this.mDWindow.getMetric() == 0) {
                    if (this.mDWindow.isPercent()) {
                        n = n10;
                        while (n <= n11) {
                            this.tmpSMWMeanDataElement = (SMWMeanDataElement)this.tmpMeanDataElementList.elementAt(n);
                            n5 += this.barSpacing;
                            double d2 = this.tmpSMWMeanDataElement.getMeanInclusivePercentValue();
                            double d3 = d2 / this.maxInclusivePercentValue;
                            int n13 = (int)(d3 * (double)this.defaultBarLength);
                            if (n13 == 0) {
                                n13 = 1;
                            }
                            Color color = this.tmpSMWMeanDataElement.getMappingColor();
                            graphics.setColor(color);
                            if (n13 > 2 && this.barHeight > 2) {
                                graphics.fillRect(n7 - n13 + 1, n5 - this.barHeight + 1, n13 - 1, this.barHeight - 1);
                                if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                    graphics.drawRect(n7 - n13, n5 - this.barHeight, n13, this.barHeight);
                                    graphics.drawRect(n7 - n13 + 1, n5 - this.barHeight + 1, n13 - 2, this.barHeight - 2);
                                } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                    graphics.drawRect(n7 - n13, n5 - this.barHeight, n13, this.barHeight);
                                    graphics.drawRect(n7 - n13 + 1, n5 - this.barHeight + 1, n13 - 2, this.barHeight - 2);
                                } else {
                                    graphics.setColor(Color.black);
                                    graphics.drawRect(n7 - n13, n5 - this.barHeight, n13, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                } else {
                                    color = this.tmpSMWMeanDataElement.getMappingColor();
                                    graphics.setColor(color);
                                }
                                graphics.fillRect(n7 - n13, n5 - this.barHeight, n13, this.barHeight);
                            }
                            graphics.setColor(Color.black);
                            String string = UtilFncs.adjustDoublePresision(d2, n2) + "%";
                            n12 = fontMetrics.stringWidth(string);
                            int n14 = n7 - n13 - n12 - 5;
                            graphics.drawString(string, n14, n5);
                            string = this.tmpSMWMeanDataElement.getMappingName();
                            graphics.drawString(string, n7 + 5, n5);
                            n12 = n7 + fontMetrics.stringWidth(string) + 5;
                            if (n6 < n12) {
                                n6 = n12 + 15;
                            }
                            this.tmpSMWMeanDataElement.setDrawCoords(n14, n12, n5 - this.barHeight, n5);
                            ++n;
                        }
                    } else {
                        n = n10;
                        while (n <= n11) {
                            int n15;
                            String string;
                            this.tmpSMWMeanDataElement = (SMWMeanDataElement)this.tmpMeanDataElementList.elementAt(n);
                            n5 += this.barSpacing;
                            double d4 = this.tmpSMWMeanDataElement.getMeanInclusiveValue();
                            double d5 = d4 / this.maxInclusiveValue;
                            int n16 = (int)(d5 * (double)this.defaultBarLength);
                            if (n16 == 0) {
                                n16 = 1;
                            }
                            Color color = this.tmpSMWMeanDataElement.getMappingColor();
                            graphics.setColor(color);
                            if (n16 > 2 && this.barHeight > 2) {
                                graphics.fillRect(n7 - n16 + 1, n5 - this.barHeight + 1, n16 - 1, this.barHeight - 1);
                                if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                    graphics.drawRect(n7 - n16, n5 - this.barHeight, n16, this.barHeight);
                                    graphics.drawRect(n7 - n16 + 1, n5 - this.barHeight + 1, n16 - 2, this.barHeight - 2);
                                } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                    graphics.drawRect(n7 - n16, n5 - this.barHeight, n16, this.barHeight);
                                    graphics.drawRect(n7 - n16 + 1, n5 - this.barHeight + 1, n16 - 2, this.barHeight - 2);
                                } else {
                                    graphics.setColor(Color.black);
                                    graphics.drawRect(n7 - n16, n5 - this.barHeight, n16, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                } else {
                                    color = this.tmpSMWMeanDataElement.getMappingColor();
                                    graphics.setColor(color);
                                }
                                graphics.fillRect(n7 - n16, n5 - this.barHeight, n16, this.barHeight);
                            }
                            graphics.setColor(Color.black);
                            if (this.mDWindow.units() == 2) {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d4 / 1000000.0, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n15 = n7 - n16 - n12 - 5;
                                graphics.drawString(string, n15, n5);
                            } else if (this.mDWindow.units() == 1) {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d4 / 1000.0, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n15 = n7 - n16 - n12 - 5;
                                graphics.drawString(string, n15, n5);
                            } else {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d4, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n15 = n7 - n16 - n12 - 5;
                                graphics.drawString(string, n15, n5);
                            }
                            string = this.tmpSMWMeanDataElement.getMappingName();
                            graphics.drawString(string, n7 + 5, n5);
                            n12 = n7 + fontMetrics.stringWidth(string) + 5;
                            if (n6 < n12) {
                                n6 = n12 + 15;
                            }
                            this.tmpSMWMeanDataElement.setDrawCoords(n15, n12, n5 - this.barHeight, n5);
                            ++n;
                        }
                    }
                } else if (this.mDWindow.getMetric() == 1) {
                    if (this.mDWindow.isPercent()) {
                        n = n10;
                        while (n <= n11) {
                            this.tmpSMWMeanDataElement = (SMWMeanDataElement)this.tmpMeanDataElementList.elementAt(n);
                            n5 += this.barSpacing;
                            double d6 = this.tmpSMWMeanDataElement.getMeanExclusivePercentValue();
                            double d7 = d6 / this.maxExclusivePercentValue;
                            int n17 = (int)(d7 * (double)this.defaultBarLength);
                            if (n17 == 0) {
                                n17 = 1;
                            }
                            Color color = this.tmpSMWMeanDataElement.getMappingColor();
                            graphics.setColor(color);
                            if (n17 > 2 && this.barHeight > 2) {
                                graphics.fillRect(n7 - n17 + 1, n5 - this.barHeight + 1, n17 - 1, this.barHeight - 1);
                                if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                    graphics.drawRect(n7 - n17, n5 - this.barHeight, n17, this.barHeight);
                                    graphics.drawRect(n7 - n17 + 1, n5 - this.barHeight + 1, n17 - 2, this.barHeight - 2);
                                } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                    graphics.drawRect(n7 - n17, n5 - this.barHeight, n17, this.barHeight);
                                    graphics.drawRect(n7 - n17 + 1, n5 - this.barHeight + 1, n17 - 2, this.barHeight - 2);
                                } else {
                                    graphics.setColor(Color.black);
                                    graphics.drawRect(n7 - n17, n5 - this.barHeight, n17, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                } else {
                                    color = this.tmpSMWMeanDataElement.getMappingColor();
                                    graphics.setColor(color);
                                }
                                graphics.fillRect(n7 - n17, n5 - this.barHeight, n17, this.barHeight);
                            }
                            graphics.setColor(Color.black);
                            String string = UtilFncs.adjustDoublePresision(d6, n2) + "%";
                            n12 = fontMetrics.stringWidth(string);
                            int n18 = n7 - n17 - n12 - 5;
                            graphics.drawString(string, n18, n5);
                            string = this.tmpSMWMeanDataElement.getMappingName();
                            graphics.drawString(string, n7 + 5, n5);
                            n12 = n7 + fontMetrics.stringWidth(string) + 5;
                            if (n6 < n12) {
                                n6 = n12 + 15;
                            }
                            this.tmpSMWMeanDataElement.setDrawCoords(n18, n12, n5 - this.barHeight, n5);
                            ++n;
                        }
                    } else {
                        n = n10;
                        while (n <= n11) {
                            int n19;
                            String string;
                            this.tmpSMWMeanDataElement = (SMWMeanDataElement)this.tmpMeanDataElementList.elementAt(n);
                            n5 += this.barSpacing;
                            double d8 = this.tmpSMWMeanDataElement.getMeanExclusiveValue();
                            double d9 = d8 / this.maxExclusiveValue;
                            int n20 = (int)(d9 * (double)this.defaultBarLength);
                            if (n20 == 0) {
                                n20 = 1;
                            }
                            Color color = this.tmpSMWMeanDataElement.getMappingColor();
                            graphics.setColor(color);
                            if (n20 > 2 && this.barHeight > 2) {
                                graphics.fillRect(n7 - n20 + 1, n5 - this.barHeight + 1, n20 - 1, this.barHeight - 1);
                                if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                    graphics.drawRect(n7 - n20, n5 - this.barHeight, n20, this.barHeight);
                                    graphics.drawRect(n7 - n20 + 1, n5 - this.barHeight + 1, n20 - 2, this.barHeight - 2);
                                } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                    graphics.drawRect(n7 - n20, n5 - this.barHeight, n20, this.barHeight);
                                    graphics.drawRect(n7 - n20 + 1, n5 - this.barHeight + 1, n20 - 2, this.barHeight - 2);
                                } else {
                                    graphics.setColor(Color.black);
                                    graphics.drawRect(n7 - n20, n5 - this.barHeight, n20, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                } else {
                                    color = this.tmpSMWMeanDataElement.getMappingColor();
                                    graphics.setColor(color);
                                }
                                graphics.fillRect(n7 - n20, n5 - this.barHeight, n20, this.barHeight);
                            }
                            graphics.setColor(Color.black);
                            if (this.mDWindow.units() == 2) {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d8 / 1000000.0, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n19 = n7 - n20 - n12 - 5;
                                graphics.drawString(string, n19, n5);
                            } else if (this.mDWindow.units() == 1) {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d8 / 1000.0, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n19 = n7 - n20 - n12 - 5;
                                graphics.drawString(string, n19, n5);
                            } else {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d8, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n19 = n7 - n20 - n12 - 5;
                                graphics.drawString(string, n19, n5);
                            }
                            string = this.tmpSMWMeanDataElement.getMappingName();
                            graphics.drawString(string, n7 + 5, n5);
                            n12 = n7 + fontMetrics.stringWidth(string) + 5;
                            if (n6 < n12) {
                                n6 = n12 + 15;
                            }
                            this.tmpSMWMeanDataElement.setDrawCoords(n19, n12, n5 - this.barHeight, n5);
                            ++n;
                        }
                    }
                } else if (this.mDWindow.getMetric() == 2) {
                    n = n10;
                    while (n <= n11) {
                        this.tmpSMWMeanDataElement = (SMWMeanDataElement)this.tmpMeanDataElementList.elementAt(n);
                        n5 += this.barSpacing;
                        double d10 = this.tmpSMWMeanDataElement.getMeanNumberOfCalls();
                        double d11 = d10 / this.maxNumberOfCalls;
                        int n21 = (int)(d11 * (double)this.defaultBarLength);
                        if (n21 == 0) {
                            n21 = 1;
                        }
                        Color color = this.tmpSMWMeanDataElement.getMappingColor();
                        graphics.setColor(color);
                        if (n21 > 2 && this.barHeight > 2) {
                            graphics.fillRect(n7 - n21 + 1, n5 - this.barHeight + 1, n21 - 1, this.barHeight - 1);
                            if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                graphics.drawRect(n7 - n21, n5 - this.barHeight, n21, this.barHeight);
                                graphics.drawRect(n7 - n21 + 1, n5 - this.barHeight + 1, n21 - 2, this.barHeight - 2);
                            } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                graphics.drawRect(n7 - n21, n5 - this.barHeight, n21, this.barHeight);
                                graphics.drawRect(n7 - n21 + 1, n5 - this.barHeight + 1, n21 - 2, this.barHeight - 2);
                            } else {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n7 - n21, n5 - this.barHeight, n21, this.barHeight);
                            }
                        } else {
                            if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                            } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            } else {
                                color = this.tmpSMWMeanDataElement.getMappingColor();
                                graphics.setColor(color);
                            }
                            graphics.fillRect(n7 - n21, n5 - this.barHeight, n21, this.barHeight);
                        }
                        graphics.setColor(Color.black);
                        String string = new String(Double.toString(d10));
                        n12 = fontMetrics.stringWidth(string);
                        int n22 = n7 - n21 - n12 - 5;
                        graphics.drawString(Double.toString(d10), n22, n5);
                        string = this.tmpSMWMeanDataElement.getMappingName();
                        graphics.drawString(string, n7 + 5, n5);
                        n12 = n7 + fontMetrics.stringWidth(string) + 5;
                        if (n6 < n12) {
                            n6 = n12 + 15;
                        }
                        this.tmpSMWMeanDataElement.setDrawCoords(n22, n12, n5 - this.barHeight, n5);
                        ++n;
                    }
                } else if (this.mDWindow.getMetric() == 3) {
                    n = n10;
                    while (n <= n11) {
                        this.tmpSMWMeanDataElement = (SMWMeanDataElement)this.tmpMeanDataElementList.elementAt(n);
                        n5 += this.barSpacing;
                        double d12 = this.tmpSMWMeanDataElement.getMeanNumberOfSubRoutines();
                        double d13 = d12 / this.maxNumberOfSubroutines;
                        int n23 = (int)(d13 * (double)this.defaultBarLength);
                        if (n23 == 0) {
                            n23 = 1;
                        }
                        Color color = this.tmpSMWMeanDataElement.getMappingColor();
                        graphics.setColor(color);
                        if (n23 > 2 && this.barHeight > 2) {
                            graphics.fillRect(n7 - n23 + 1, n5 - this.barHeight + 1, n23 - 1, this.barHeight - 1);
                            if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                graphics.drawRect(n7 - n23, n5 - this.barHeight, n23, this.barHeight);
                                graphics.drawRect(n7 - n23 + 1, n5 - this.barHeight + 1, n23 - 2, this.barHeight - 2);
                            } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                graphics.drawRect(n7 - n23, n5 - this.barHeight, n23, this.barHeight);
                                graphics.drawRect(n7 - n23 + 1, n5 - this.barHeight + 1, n23 - 2, this.barHeight - 2);
                            } else {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n7 - n23, n5 - this.barHeight, n23, this.barHeight);
                            }
                        } else {
                            if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                            } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            } else {
                                color = this.tmpSMWMeanDataElement.getMappingColor();
                                graphics.setColor(color);
                            }
                            graphics.fillRect(n7 - n23, n5 - this.barHeight, n23, this.barHeight);
                        }
                        graphics.setColor(Color.black);
                        String string = new String(Double.toString(d12));
                        n12 = fontMetrics.stringWidth(string);
                        int n24 = n7 - n23 - n12 - 5;
                        graphics.drawString(Double.toString(d12), n24, n5);
                        string = this.tmpSMWMeanDataElement.getMappingName();
                        graphics.drawString(string, n7 + 5, n5);
                        n12 = n7 + fontMetrics.stringWidth(string) + 5;
                        if (n6 < n12) {
                            n6 = n12 + 15;
                        }
                        this.tmpSMWMeanDataElement.setDrawCoords(n24, n12, n5 - this.barHeight, n5);
                        ++n;
                    }
                } else if (this.mDWindow.getMetric() == 4) {
                    n = n10;
                    while (n <= n11) {
                        this.tmpSMWMeanDataElement = (SMWMeanDataElement)this.tmpMeanDataElementList.elementAt(n);
                        n5 += this.barSpacing;
                        double d14 = this.tmpSMWMeanDataElement.getMeanUserSecPerCall();
                        double d15 = d14 / this.maxUserSecPerCall;
                        int n25 = (int)(d15 * (double)this.defaultBarLength);
                        if (n25 == 0) {
                            n25 = 1;
                        }
                        Color color = this.tmpSMWMeanDataElement.getMappingColor();
                        graphics.setColor(color);
                        if (n25 > 2 && this.barHeight > 2) {
                            graphics.fillRect(n7 - n25 + 1, n5 - this.barHeight + 1, n25 - 1, this.barHeight - 1);
                            if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                graphics.drawRect(n7 - n25, n5 - this.barHeight, n25, this.barHeight);
                                graphics.drawRect(n7 - n25 + 1, n5 - this.barHeight + 1, n25 - 2, this.barHeight - 2);
                            } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                graphics.drawRect(n7 - n25, n5 - this.barHeight, n25, this.barHeight);
                                graphics.drawRect(n7 - n25 + 1, n5 - this.barHeight + 1, n25 - 2, this.barHeight - 2);
                            } else {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n7 - n25, n5 - this.barHeight, n25, this.barHeight);
                            }
                        } else {
                            if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                            } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            } else {
                                color = this.tmpSMWMeanDataElement.getMappingColor();
                                graphics.setColor(color);
                            }
                            graphics.fillRect(n7 - n25, n5 - this.barHeight, n25, this.barHeight);
                        }
                        graphics.setColor(Color.black);
                        String string = new String(Double.toString(UtilFncs.adjustDoublePresision(d14, n2)));
                        n12 = fontMetrics.stringWidth(string);
                        int n26 = n7 - n25 - n12 - 5;
                        graphics.drawString(string, n26, n5);
                        string = this.tmpSMWMeanDataElement.getMappingName();
                        graphics.drawString(string, n7 + 5, n5);
                        n12 = n7 + fontMetrics.stringWidth(string) + 5;
                        if (n6 < n12) {
                            n6 = n12 + 15;
                        }
                        this.tmpSMWMeanDataElement.setDrawCoords(n26, n12, n5 - this.barHeight, n5);
                        ++n;
                    }
                }
            }
            n = 0;
            if (n6 > 550) {
                this.xPanelSize = n6 + 1;
                n = 1;
            }
            if (this.newYPanelSize > 550) {
                this.yPanelSize = this.newYPanelSize + 1;
                n = 1;
            }
            if (n != 0) {
                this.revalidate();
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDWP03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            try {
                Object object = actionEvent.getSource();
                SMWMeanDataElement sMWMeanDataElement = null;
                if (!(object instanceof JMenuItem)) break block7;
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (!(this.clickedOnObject instanceof SMWMeanDataElement)) break block7;
                    sMWMeanDataElement = (SMWMeanDataElement)this.clickedOnObject;
                    this.trial.getColorChooser().setHighlightColorMappingID(sMWMeanDataElement.getMappingID());
                    MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, sMWMeanDataElement.getMappingID(), this.sMWData);
                    this.trial.getSystemEvents().addObserver(mappingDataWindow);
                    mappingDataWindow.show();
                    break block7;
                }
                if (string.equals("Change Function Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWMeanDataElement) {
                        n = ((SMWMeanDataElement)this.clickedOnObject).getMappingID();
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    Color color = globalMappingElement.getMappingColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) == null) break block7;
                    globalMappingElement.setSpecificColor(color);
                    globalMappingElement.setColorFlag(true);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    break block7;
                }
                if (string.equals("Reset to Generic Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWMeanDataElement) {
                        n = ((SMWMeanDataElement)this.clickedOnObject).getMappingID();
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "MDWP04");
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            Enumeration enumeration = this.tmpMeanDataElementList.elements();
            while (enumeration.hasMoreElements()) {
                this.tmpSMWMeanDataElement = (SMWMeanDataElement)enumeration.nextElement();
                if (n2 > this.tmpSMWMeanDataElement.getYEnd()) continue;
                if (n2 >= this.tmpSMWMeanDataElement.getYBeg() && n >= this.tmpSMWMeanDataElement.getXBeg() && n <= this.tmpSMWMeanDataElement.getXEnd()) {
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = this.tmpSMWMeanDataElement;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                        return;
                    }
                    if (this.trial.getColorChooser().getHighlightColorMappingID() == -1) {
                        this.trial.getColorChooser().setHighlightColorMappingID(this.tmpSMWMeanDataElement.getMappingID());
                    } else if (this.trial.getColorChooser().getHighlightColorMappingID() != this.tmpSMWMeanDataElement.getMappingID()) {
                        this.trial.getColorChooser().setHighlightColorMappingID(this.tmpSMWMeanDataElement.getMappingID());
                    } else {
                        this.trial.getColorChooser().setHighlightColorMappingID(-1);
                    }
                    return;
                }
                return;
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void changeInMultiples() {
        this.computeDefaultBarLength();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public void computeDefaultBarLength() {
        try {
            double d = this.mDWindow.getSliderValue();
            double d2 = this.mDWindow.getSliderMultiple();
            double d3 = 250.0 * d * d2;
            this.defaultBarLength = (int)d3;
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MDWP06");
        }
    }
}

