/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import paraprof.GlobalMapping;
import paraprof.GlobalMappingElement;
import paraprof.GlobalThreadDataElement;
import paraprof.MappingDataWindow;
import paraprof.MeanTotalStatWindow;
import paraprof.ParaProf;
import paraprof.SMWMeanDataElement;
import paraprof.Trial;
import paraprof.UtilFncs;

public class MeanTotalStatWindowPanel
extends JPanel
implements ActionListener,
MouseListener {
    private Trial trial = null;
    int xPanelSize = 800;
    int yPanelSize = 600;
    int newXPanelSize = 0;
    int newYPanelSize = 0;
    int startLocation = 0;
    int maxFontAscent = 0;
    int maxFontDescent = 0;
    int spacing = 0;
    int serverNumber;
    int contextNumber;
    int threadNumber;
    MeanTotalStatWindow mTSWindow;
    Vector tmpMeanDataElementList;
    SMWMeanDataElement tmpSMWMeanDataElement;
    Font MonoFont = null;
    FontMetrics fmMonoFont = null;
    private JPopupMenu popup = new JPopupMenu();
    Object clickedOnObject = null;

    public MeanTotalStatWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MTSWP01");
        }
    }

    public MeanTotalStatWindowPanel(Trial trial, MeanTotalStatWindow meanTotalStatWindow) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.trial = trial;
            this.mTSWindow = meanTotalStatWindow;
            this.addMouseListener(this);
            JMenuItem jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change Function Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            this.repaint();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "MTSWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        block20: {
            try {
                super.paintComponent(graphics);
                int n = 0;
                int n2 = this.trial.getPreferences().getBarHeight();
                this.spacing = this.trial.getPreferences().getBarSpacing();
                int n3 = 0;
                String string = null;
                String string2 = "";
                this.MonoFont = new Font("Monospaced", this.trial.getPreferences().getFontStyle(), n2);
                this.fmMonoFont = graphics.getFontMetrics(this.MonoFont);
                this.maxFontAscent = this.fmMonoFont.getMaxAscent();
                this.maxFontDescent = this.fmMonoFont.getMaxDescent();
                graphics.setFont(this.MonoFont);
                if (this.spacing <= this.maxFontAscent + this.maxFontDescent) {
                    ++this.spacing;
                }
                this.tmpMeanDataElementList = this.mTSWindow.getStaticMainWindowSystemData();
                if (this.tmpMeanDataElementList.size() == 0) {
                    return;
                }
                Rectangle rectangle = graphics.getClipBounds();
                int n4 = (int)rectangle.getY();
                int n5 = (int)((double)n4 + rectangle.getHeight());
                int n6 = 0;
                int n7 = 0;
                n += this.spacing;
                String string3 = this.trial.getCounterName();
                if (string3 != null) {
                    graphics.drawString("COUNTER NAME: " + string3 + UtilFncs.getUnitsString(this.mTSWindow.units(), this.trial.isTimeMetric()), 5, n);
                    n += this.spacing;
                }
                if (rectangle == null) break block20;
                string = GlobalThreadDataElement.getTStatStringHeading(this.trial);
                int n8 = string.length();
                int n9 = 0;
                while (n9 < n8) {
                    string2 = string2 + "-";
                    ++n9;
                }
                AttributedString attributedString = new AttributedString(string2);
                attributedString.addAttribute(TextAttribute.FONT, this.MonoFont);
                graphics.drawString(attributedString.getIterator(), 20, n += this.spacing);
                n = n + this.spacing + 10;
                AttributedString attributedString2 = new AttributedString(string);
                attributedString2.addAttribute(TextAttribute.FONT, this.MonoFont);
                graphics.drawString(attributedString2.getIterator(), 20, n);
                n = n + this.spacing + 10;
                graphics.drawString(attributedString.getIterator(), 20, n);
                this.startLocation = n;
                this.newYPanelSize = n + (this.tmpMeanDataElementList.size() + 1) * this.spacing;
                n6 = (n4 - n) / this.spacing - 1;
                n7 = (n5 - n) / this.spacing + 1;
                if (n > n4 || n > n5) {
                    if (n > n4) {
                        n6 = 0;
                    }
                    if (n > n5) {
                        n7 = 0;
                    }
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                if (n6 > this.tmpMeanDataElementList.size() - 1) {
                    n6 = this.tmpMeanDataElementList.size() - 1;
                }
                if (n7 > this.tmpMeanDataElementList.size() - 1) {
                    n7 = this.tmpMeanDataElementList.size() - 1;
                }
                n += n6 * this.spacing;
                int n10 = n6;
                while (n10 <= n7) {
                    this.tmpSMWMeanDataElement = (SMWMeanDataElement)this.tmpMeanDataElementList.elementAt(n10);
                    string = this.tmpSMWMeanDataElement.getMeanTotalStatString(this.mTSWindow.units());
                    n += this.spacing;
                    graphics.setColor(Color.black);
                    AttributedString attributedString3 = new AttributedString(string);
                    attributedString3.addAttribute(TextAttribute.FONT, this.MonoFont);
                    if (this.tmpSMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                        attributedString3.addAttribute(TextAttribute.FOREGROUND, this.trial.getColorChooser().getHighlightColor(), GlobalThreadDataElement.getPositionOfName(), string.length());
                    } else if (this.tmpSMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                        attributedString3.addAttribute(TextAttribute.FOREGROUND, this.trial.getColorChooser().getGroupHighlightColor(), GlobalThreadDataElement.getPositionOfName(), string.length());
                    } else {
                        attributedString3.addAttribute(TextAttribute.FOREGROUND, this.tmpSMWMeanDataElement.getMappingColor(), GlobalThreadDataElement.getPositionOfName(), string.length());
                    }
                    graphics.drawString(attributedString3.getIterator(), 20, n);
                    if (n3 < 2 * this.fmMonoFont.stringWidth(string)) {
                        n3 = 20 + 2 * this.fmMonoFont.stringWidth(string);
                    }
                    ++n10;
                }
                if (this.newYPanelSize >= this.yPanelSize || n3 >= this.xPanelSize) {
                    this.yPanelSize = this.newYPanelSize + 1;
                    this.xPanelSize = n3 + 1;
                    this.revalidate();
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "MTSWP03");
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            try {
                Object object = actionEvent.getSource();
                SMWMeanDataElement sMWMeanDataElement = null;
                if (!(object instanceof JMenuItem)) break block7;
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (!(this.clickedOnObject instanceof SMWMeanDataElement)) break block7;
                    sMWMeanDataElement = (SMWMeanDataElement)this.clickedOnObject;
                    this.trial.getColorChooser().setHighlightColorMappingID(sMWMeanDataElement.getMappingID());
                    MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, sMWMeanDataElement.getMappingID(), this.trial.getStaticMainWindow().getSMWData());
                    this.trial.getSystemEvents().addObserver(mappingDataWindow);
                    mappingDataWindow.show();
                    break block7;
                }
                if (string.equals("Change Function Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWMeanDataElement) {
                        n = ((SMWMeanDataElement)this.clickedOnObject).getMappingID();
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    Color color = globalMappingElement.getMappingColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) == null) break block7;
                    globalMappingElement.setSpecificColor(color);
                    globalMappingElement.setColorFlag(true);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    break block7;
                }
                if (string.equals("Reset to Generic Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWMeanDataElement) {
                        n = ((SMWMeanDataElement)this.clickedOnObject).getMappingID();
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "MTSWP04");
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        block5: {
            try {
                String string;
                int n;
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                int n4 = mouseEvent.getClickCount();
                int n5 = n3 - this.startLocation;
                int n6 = n5 / this.spacing;
                int n7 = (n6 + 1) * this.spacing;
                int n8 = n7 - this.maxFontAscent;
                if (n5 < n8 || n5 > n7 || n6 >= this.tmpMeanDataElementList.size()) break block5;
                this.tmpSMWMeanDataElement = (SMWMeanDataElement)this.tmpMeanDataElementList.elementAt(n6);
                if (this.fmMonoFont == null || n2 > (n = this.fmMonoFont.stringWidth(string = this.tmpSMWMeanDataElement.getMeanTotalStatString(this.mTSWindow.units())) + 20)) break block5;
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    this.clickedOnObject = this.tmpSMWMeanDataElement;
                    this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                    break block5;
                }
                if (this.trial.getColorChooser().getHighlightColorMappingID() == -1) {
                    this.trial.getColorChooser().setHighlightColorMappingID(this.tmpSMWMeanDataElement.getMappingID());
                    break block5;
                }
                if (this.trial.getColorChooser().getHighlightColorMappingID() != this.tmpSMWMeanDataElement.getMappingID()) {
                    this.trial.getColorChooser().setHighlightColorMappingID(this.tmpSMWMeanDataElement.getMappingID());
                    break block5;
                }
                this.trial.getColorChooser().setHighlightColorMappingID(-1);
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "MTSWP05");
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }
}

