/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.swing.Timer;
import javax.swing.UIManager;
import paraprof.Application;
import paraprof.ApplicationManager;
import paraprof.Experiment;
import paraprof.HelpWindow;
import paraprof.ParaProfManager;
import paraprof.SavedPreferences;
import paraprof.Trial;

public class ParaProf
implements ActionListener {
    static boolean debugIsOn = false;
    static String profilePathName = null;
    static int defaultNumberPrecision = 4;
    static boolean dbSupport = false;
    static SavedPreferences savedPreferences = new SavedPreferences();
    static ApplicationManager applicationManager = new ApplicationManager();
    static HelpWindow helpWindow = new HelpWindow();
    private static String USAGE = "ParaProf/ParaProf (help | debug)";
    static Runtime runtime;
    static boolean runHasBeenOpened;

    public ParaProf() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
    }

    public void startSystem() {
        try {
            Object object;
            Object object2;
            try {
                object2 = new FileInputStream("ParaProfPreferences.dat");
                ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object2);
                savedPreferences = (SavedPreferences)objectInputStream.readObject();
            }
            catch (Exception exception) {
                if (exception instanceof FileNotFoundException) {
                    System.out.println("No preference file present, using defaults!");
                }
                System.out.println("There was an internal error whilst trying to read the Racy preference");
                System.out.println("file.  Please delete this file, or replace it with a valid one!");
                System.out.println("Note: Deleting the file will cause Racy to restore the default preferences");
            }
            object2 = new File("pprof.dat");
            boolean bl = false;
            Trial trial = null;
            if (((File)object2).exists()) {
                System.out.println("Found pprof.dat!");
                object = applicationManager.addApplication();
                ((Application)object).setApplicationName("Default App");
                Experiment experiment = ((Application)object).addExperiment();
                experiment.setExperimentName("Default Exp");
                String string = null;
                String string2 = null;
                String string3 = null;
                string = ((File)object2).getCanonicalPath();
                string2 = applicationManager.getPathReverse(string);
                string3 = "Default Trial : " + string2;
                trial = experiment.addTrial();
                trial.setProfilePathName(string);
                trial.setProfilePathName(string2);
                trial.setTrialName(string3);
                trial.buildStaticData((File)object2);
                bl = true;
            } else {
                object = new File(".");
                Experiment experiment = null;
                String string = ((File)object).getCanonicalPath();
                File[] fileArray = ((File)object).listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    String string4;
                    File file;
                    String string5;
                    File file2 = fileArray[n];
                    if (file2 != null && (string5 = file2.getName()).indexOf("MULTI__") != -1 && (file = new File(string4 = string + "/" + string5 + "/pprof.dat")).exists()) {
                        if (!bl) {
                            System.out.println("Found pprof.dat ... loading");
                            Application application = applicationManager.addApplication();
                            application.setApplicationName("Default App");
                            experiment = application.addExperiment();
                            experiment.setExperimentName("Default Exp");
                            String string6 = null;
                            String string7 = null;
                            String string8 = null;
                            string6 = string;
                            string7 = applicationManager.getPathReverse(string6);
                            string8 = "Default Trial : " + string7;
                            trial = experiment.addTrial();
                            trial.setProfilePathName(string6);
                            trial.setProfilePathName(string7);
                            trial.setTrialName(string8);
                            trial.buildStaticData(file);
                            System.out.println("Found: " + string4);
                            bl = true;
                        } else {
                            trial.buildStaticData(file);
                        }
                    }
                    ++n;
                }
                if (!bl) {
                    System.out.println("Did not find pprof.dat!");
                }
            }
            if (!bl) {
                System.out.println("No profile data found!");
            } else {
                trial.showMainWindow();
            }
            object = new ParaProfManager();
            ((ParaProfManager)object).expandDefaultTrialNode();
        }
        catch (Exception exception) {
            System.out.println("An un-caught exception has occurred within the program!");
            System.out.println("The details of this execption has been stored in a file named: exception.err");
            System.out.println("Please email this file to Robert Bell at bertie@cs.uoregon.edu ");
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Timer) {
            System.out.println("------------------------");
            System.out.println("The amount of memory used by the system is: " + runtime.totalMemory());
            System.out.println("The amount of memory free to the system is: " + runtime.freeMemory());
        }
    }

    public static String getInfoString() {
        return new String("ParaProf Version 1.2 ... The Paraducks Group!");
    }

    public static void systemError(Object object, Component component, String string) {
        if (object != null) {
            if (object instanceof Exception) {
                if (debugIsOn) {
                    System.out.println(((Exception)object).toString());
                    ((Exception)object).printStackTrace();
                    System.out.println("");
                    System.out.println("");
                }
                System.out.println("An exception was caught at " + string);
            } else {
                System.out.println("An error was detected at " + string);
            }
        } else {
            System.out.println("An error was detected at " + string);
        }
        System.out.println("Please email us at: tau-bugs@cs.uoregon.edu");
        System.out.println("");
        System.out.println("If possible, include the profile files that caused this error,");
        System.out.println("and a brief desciption your sequence of operation.");
        System.out.println("");
        System.out.println("Also email this error message,as it will tell us where the error occured.");
        System.out.println("");
        System.out.println("Thank you for your help!");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string;
            if ((string = stringArray[n++]).equalsIgnoreCase("HELP")) {
                System.err.println(USAGE);
                System.exit(-1);
            }
            if (!string.equalsIgnoreCase("DEBUG")) continue;
            debugIsOn = true;
        }
        runtime = Runtime.getRuntime();
        ParaProf paraProf = new ParaProf();
        if (debugIsOn) {
            Timer timer = new Timer(8000, paraProf);
            timer.start();
        }
        paraProf.startSystem();
    }

    static {
        runHasBeenOpened = false;
    }
}

