/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.Border;
import paraprof.ColorPair;
import paraprof.GlobalMapping;
import paraprof.GlobalMappingElement;
import paraprof.ParaProf;
import paraprof.PrefSpacingPanel;
import paraprof.SavedPreferences;
import paraprof.Trial;

public class Preferences
extends JFrame
implements ActionListener,
Observer {
    private Trial trial = null;
    private PrefSpacingPanel pSPanel;
    private JCheckBox loadPprofDat;
    private JRadioButton normal;
    private JRadioButton bold;
    private JRadioButton italic;
    private ButtonGroup buttonGroup;
    private JLabel fontLabel = new JLabel("Font Selection");
    private JComboBox fontComboBox;
    private JLabel barSpacingLabel = new JLabel("Adjust Bar Spacing");
    private JLabel barHeightLabel = new JLabel("Adjust Bar Height");
    private JSlider barSpacingSlider = new JSlider(1, 0, 100, 0);
    private JSlider barHeightSlider = new JSlider(1, 0, 100, 0);
    private JButton colorButton;
    int fontStyle;
    private boolean barDetailsSet = false;
    private int barSpacing = -1;
    private int barHeight = -1;
    String paraProfFont;
    String inExValue;
    String sortBy;
    private boolean mShown = false;

    public Preferences(Trial trial, SavedPreferences savedPreferences) {
        Object object;
        this.trial = trial;
        if (savedPreferences != null) {
            this.paraProfFont = savedPreferences.getParaProfFont();
            this.barSpacing = savedPreferences.getBarSpacing();
            this.barHeight = savedPreferences.getBarHeight();
            this.inExValue = savedPreferences.getInExValue();
            this.sortBy = savedPreferences.getSortBy();
            this.fontStyle = savedPreferences.getFontStyle();
            this.barDetailsSet = savedPreferences.getBarDetailsSet();
        } else {
            this.inExValue = new String("Exclusive");
            object = new String("mappingID");
            this.paraProfFont = "SansSerif";
            this.barHeight = 0;
            this.barSpacing = 0;
            this.fontStyle = 0;
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Preferences.this.thisWindowClosing(windowEvent);
            }
        });
        object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = ((GraphicsEnvironment)object).getAvailableFontFamilyNames();
        this.fontComboBox = new JComboBox<String>(stringArray);
        int n = this.fontComboBox.getItemCount();
        int n2 = 0;
        String string = (String)this.fontComboBox.getItemAt(n2);
        while (n2 < n && !this.paraProfFont.equals(string)) {
            string = (String)this.fontComboBox.getItemAt(++n2);
        }
        if (n2 == n) {
            System.out.println("The default font was not found!!  This is not a good thing as it is a default Java font!!");
        } else {
            this.fontComboBox.setSelectedIndex(n2);
        }
        this.barHeightSlider.setValue(this.barHeight);
        this.barSpacingSlider.setValue(this.barSpacing);
        this.fontComboBox.addActionListener(this);
        this.pSPanel = new PrefSpacingPanel(this.trial);
        this.setTitle("ParaProf Preferences: No Data Loaded");
        int n3 = 900;
        int n4 = 350;
        this.setSize(new Dimension(n3, n4));
        this.setResizable(false);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n5 = dimension.height;
        int n6 = dimension.width;
        int n7 = 0;
        int n8 = 0;
        this.setLocation(n7, n8);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Edit Color Map");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Save Color Map");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Load Color Map");
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Apply and Close Window");
        jMenuItem4.addActionListener(this);
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Exit ParaProf!");
        jMenuItem5.addActionListener(this);
        jMenu.add(jMenuItem5);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        Border border = BorderFactory.createLoweredBevelBorder();
        Border border2 = BorderFactory.createRaisedBevelBorder();
        Border border3 = BorderFactory.createEmptyBorder();
        JScrollPane jScrollPane = new JScrollPane(this.pSPanel);
        jScrollPane.setBorder(border);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        this.barSpacingSlider.setPaintTicks(true);
        this.barSpacingSlider.setMajorTickSpacing(20);
        this.barSpacingSlider.setMinorTickSpacing(5);
        this.barSpacingSlider.setPaintLabels(true);
        this.barSpacingSlider.addChangeListener(this.pSPanel);
        this.barHeightSlider.setPaintTicks(true);
        this.barHeightSlider.setMajorTickSpacing(20);
        this.barHeightSlider.setMinorTickSpacing(5);
        this.barHeightSlider.setPaintLabels(true);
        this.barHeightSlider.addChangeListener(this.pSPanel);
        this.normal = new JRadioButton("Plain Font", this.fontStyle == 0 || this.fontStyle == 2);
        this.normal.addActionListener(this);
        this.bold = new JRadioButton("Bold Font", this.fontStyle == 1 || this.fontStyle == 3);
        this.bold.addActionListener(this);
        this.italic = new JRadioButton("Italic Font", this.fontStyle == 2 || this.fontStyle == 3);
        this.italic.addActionListener(this);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.normal);
        this.buttonGroup.add(this.bold);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.fontLabel, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.fontComboBox, gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.normal, gridBagConstraints, 2, 0, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.bold, gridBagConstraints, 3, 0, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.italic, gridBagConstraints, 4, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(jScrollPane, gridBagConstraints, 0, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.barSpacingLabel, gridBagConstraints, 2, 2, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.barSpacingSlider, gridBagConstraints, 2, 3, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.barHeightLabel, gridBagConstraints, 3, 2, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.barHeightSlider, gridBagConstraints, 3, 3, 1, 1);
    }

    public void showPreferencesWindow() {
        this.setTitle("ParaProf Preferences: " + ParaProf.profilePathName);
        this.show();
    }

    public void setSavedPreferences() {
        ParaProf.savedPreferences.setParaProfFont(this.paraProfFont);
        ParaProf.savedPreferences.setBarSpacing(this.barSpacing);
        ParaProf.savedPreferences.setBarHeight(this.barHeight);
        ParaProf.savedPreferences.setInExValue(this.inExValue);
        ParaProf.savedPreferences.setSortBy(this.sortBy);
        ParaProf.savedPreferences.setFontStyle(this.fontStyle);
        ParaProf.savedPreferences.setBarDetailsSet(this.barDetailsSet);
    }

    public boolean areBarDetailsSet() {
        return this.barDetailsSet;
    }

    public String getParaProfFont() {
        return this.paraProfFont;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setBarDetails(Graphics2D graphics2D) {
        if (!this.barDetailsSet) {
            Font font = new Font(this.paraProfFont, this.fontStyle, 12);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n = fontMetrics.getAscent();
            int n2 = fontMetrics.getMaxDescent();
            int n3 = n + n2;
            this.setBarDetails(n, n3 + 5);
            this.setSliders(n, n3 + 5);
        }
    }

    public void setBarDetails(int n, int n2) {
        this.barHeight = n;
        this.barSpacing = n2;
        this.barDetailsSet = true;
    }

    public void setSliders(int n, int n2) {
        this.barHeightSlider.setValue(n);
        this.barSpacingSlider.setValue(n2);
    }

    public int getBarSpacing() {
        return this.barSpacing;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setInExValue(String string) {
        this.inExValue = string;
    }

    public String getInExValue() {
        return this.inExValue;
    }

    public void setSortBy(String string) {
        this.sortBy = string;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("colorEvent")) {
            this.pSPanel.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object instanceof JMenuItem) {
            if (string.equals("Edit Color Map")) {
                this.trial.getColorChooser().showColorChooser();
            } else if (string.equals("Load Color Map")) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File("."));
                int n = jFileChooser.showOpenDialog(this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (file != null) {
                        System.out.println("Loading color map ...");
                        this.loadColorMap(file);
                        this.trial.getSystemEvents().updateRegisteredObjects("prefEvent");
                        System.out.println("Done loading color map ...");
                    } else {
                        System.out.println("There was some sort of internal error!");
                    }
                }
            } else if (string.equals("Save Color Map")) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File("."));
                jFileChooser.setSelectedFile(new File("colorMap.dat"));
                int n = jFileChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (file != null) {
                        try {
                            Object object2;
                            Object object3;
                            Vector<Object> vector = new Vector<Object>();
                            GlobalMapping globalMapping = this.trial.getGlobalMapping();
                            int n2 = globalMapping.getNumberOfMappings(0);
                            int n3 = 0;
                            while (n3 < n2) {
                                object3 = globalMapping.getGlobalMappingElement(n3, 0);
                                if (((GlobalMappingElement)object3).getMappingName() != null) {
                                    object2 = new ColorPair(((GlobalMappingElement)object3).getMappingName(), ((GlobalMappingElement)object3).getMappingColor());
                                    vector.add(object2);
                                }
                                ++n3;
                            }
                            Collections.sort(vector);
                            object3 = new PrintWriter(new FileWriter(file));
                            System.out.println("Saving color map ...");
                            if (ParaProf.debugIsOn) {
                                System.out.println("**********************");
                                System.out.println("Color values loaded were:");
                            }
                            object2 = vector.elements();
                            while (object2.hasMoreElements()) {
                                ColorPair colorPair = (ColorPair)object2.nextElement();
                                Color color = colorPair.getMappingColor();
                                if (ParaProf.debugIsOn) {
                                    System.out.println("MAPPING_NAME=\"" + colorPair.getMappingName() + "\"" + " RGB=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"");
                                }
                                ((PrintWriter)object3).println("MAPPING_NAME=\"" + colorPair.getMappingName() + "\"" + " RGB=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"");
                            }
                            if (ParaProf.debugIsOn) {
                                System.out.println("**********************");
                            }
                            System.out.println("Done saving color map!");
                            ((PrintWriter)object3).close();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(this, "An error occured whilst trying to save the color map.", "Error!", 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog(this, "No filename was given!", "Error!", 0);
                    }
                }
            } else if (string.equals("Exit ParaProf!")) {
                this.setVisible(false);
                this.dispose();
                System.exit(0);
            } else if (string.equals("Apply and Close Window")) {
                this.setVisible(false);
                this.trial.getSystemEvents().updateRegisteredObjects("prefEvent");
            }
        } else if (object instanceof JRadioButton) {
            if (string.equals("Plain Font")) {
                this.fontStyle = this.italic.isSelected() ? 2 : 0;
                this.pSPanel.repaint();
            } else if (string.equals("Bold Font")) {
                this.fontStyle = this.italic.isSelected() ? 3 : 1;
                this.pSPanel.repaint();
            } else if (string.equals("Italic Font")) {
                this.fontStyle = this.italic.isSelected() ? (this.normal.isSelected() ? 2 : 3) : (this.normal.isSelected() ? 0 : 1);
                this.pSPanel.repaint();
            }
        } else if (object == this.fontComboBox) {
            this.paraProfFont = (String)this.fontComboBox.getSelectedItem();
            this.pSPanel.repaint();
        }
    }

    public void updateBarDetails() {
        this.barHeight = this.barHeightSlider.getValue();
        this.barSpacing = this.barSpacingSlider.getValue();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    public void loadColorMap(File file) {
        try {
            Serializable serializable;
            ColorPair colorPair;
            StringTokenizer stringTokenizer;
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Vector<ColorPair> vector = new Vector<ColorPair>();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            GlobalMapping globalMapping = this.trial.getGlobalMapping();
            while ((string = bufferedReader.readLine()) != null) {
                stringTokenizer = new StringTokenizer(string, "\"");
                colorPair = new ColorPair();
                string = stringTokenizer.nextToken();
                string = stringTokenizer.nextToken();
                colorPair.setMappingName(string);
                string = stringTokenizer.nextToken();
                string = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string, ",");
                string = stringTokenizer2.nextToken();
                n = Integer.parseInt(string);
                string = stringTokenizer2.nextToken();
                n2 = Integer.parseInt(string);
                string = stringTokenizer2.nextToken();
                n3 = Integer.parseInt(string);
                serializable = new Color(n, n2, n3);
                colorPair.setMappingColor((Color)serializable);
                vector.add(colorPair);
            }
            if (ParaProf.debugIsOn) {
                System.out.println("**********************");
                System.out.println("Color values loaded were:");
            }
            stringTokenizer = vector.elements();
            while (stringTokenizer.hasMoreElements()) {
                colorPair = (ColorPair)stringTokenizer.nextElement();
                int n4 = globalMapping.getMappingId(colorPair.getMappingName(), 0);
                if (n4 == -1) continue;
                serializable = globalMapping.getGlobalMappingElement(n4, 0);
                Color color = colorPair.getMappingColor();
                serializable.setSpecificColor(color);
                serializable.setColorFlag(true);
                if (!ParaProf.debugIsOn) continue;
                System.out.println("MAPPING_NAME=\"" + colorPair.getMappingName() + "\"" + " RGB=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"");
            }
            if (ParaProf.debugIsOn) {
                System.out.println("**********************");
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "P01");
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }
}

