/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import paraprof.GlobalMapping;
import paraprof.GlobalMappingElement;
import paraprof.Trial;

public class SMWMeanDataElement
implements Comparable {
    private Trial trial = null;
    GlobalMappingElement tmpGME;
    GlobalMapping globalMappingReference;
    int mappingID;
    double value;
    int xBeginPosition;
    int xEndPosition;
    int yBeginPosition;
    int yEndPosition;
    boolean highlighted = false;
    int sortSetting = 0;
    boolean sortByMappingID;
    boolean sortByName;
    boolean sortByValue;
    boolean sortByReverse;
    boolean compareOnMappingName;

    public SMWMeanDataElement(Trial trial) {
        this.trial = trial;
        this.globalMappingReference = this.trial.getGlobalMapping();
        this.value = 0.0;
        this.xBeginPosition = 0;
        this.xEndPosition = 0;
        this.yBeginPosition = 0;
        this.yEndPosition = 0;
        this.sortByMappingID = false;
        this.sortByName = true;
        this.sortByValue = false;
        this.sortByReverse = false;
    }

    public String getMappingName() {
        this.tmpGME = this.globalMappingReference.getGlobalMappingElement(this.mappingID, 0);
        return this.tmpGME.getMappingName();
    }

    public void setMappingID(int n) {
        this.mappingID = n;
    }

    public int getMappingID() {
        return this.mappingID;
    }

    public Color getMappingColor() {
        this.tmpGME = this.globalMappingReference.getGlobalMappingElement(this.mappingID, 0);
        return this.tmpGME.getMappingColor();
    }

    public boolean isGroupMember(int n) {
        return this.globalMappingReference.isGroupMember(this.mappingID, n, 0);
    }

    public int compareTo(Object object) {
        double d = 0.0;
        switch (this.sortSetting) {
            case 1: {
                return ((SMWMeanDataElement)object).getMappingID() - this.mappingID;
            }
            case 2: {
                return this.mappingID - ((SMWMeanDataElement)object).getMappingID();
            }
            case 3: {
                return ((SMWMeanDataElement)object).getMappingName().compareTo(this.getMappingName());
            }
            case 4: {
                return this.getMappingName().compareTo(((SMWMeanDataElement)object).getMappingName());
            }
            case 5: {
                d = this.value - ((SMWMeanDataElement)object).getValue();
                if (d < 0.0) {
                    return 1;
                }
                if (d == 0.0) {
                    return 0;
                }
                return -1;
            }
            case 6: {
                d = this.value - ((SMWMeanDataElement)object).getValue();
                if (d < 0.0) {
                    return -1;
                }
                if (d == 0.0) {
                    return 0;
                }
                return 1;
            }
        }
        return 0;
    }

    public int testCompareTo(Object object) {
        double d = 0.0;
        if (this.sortByMappingID) {
            if (!this.sortByReverse) {
                return this.mappingID - ((SMWMeanDataElement)object).getMappingID();
            }
            return ((SMWMeanDataElement)object).getMappingID() - this.mappingID;
        }
        if (this.sortByName) {
            if (!this.sortByReverse) {
                return this.getMappingName().compareTo(((SMWMeanDataElement)object).getMappingName());
            }
            return ((SMWMeanDataElement)object).getMappingName().compareTo(this.getMappingName());
        }
        d = this.value - ((SMWMeanDataElement)object).getValue();
        if (d < 0.0) {
            if (!this.sortByReverse) {
                return -1;
            }
            return 1;
        }
        if (d == 0.0) {
            return 0;
        }
        if (!this.sortByReverse) {
            return 1;
        }
        return -1;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    public boolean getMeanValuesSet() {
        this.tmpGME = this.globalMappingReference.getGlobalMappingElement(this.mappingID, 0);
        return this.tmpGME.getMeanValuesSet();
    }

    public double getMeanExclusiveValue() {
        this.tmpGME = this.globalMappingReference.getGlobalMappingElement(this.mappingID, 0);
        return this.tmpGME.getMeanExclusiveValue(this.trial.getCurValLoc());
    }

    public double getMeanExclusivePercentValue() {
        this.tmpGME = this.globalMappingReference.getGlobalMappingElement(this.mappingID, 0);
        return this.tmpGME.getMeanExclusivePercentValue(this.trial.getCurValLoc());
    }

    public double getMeanInclusiveValue() {
        this.tmpGME = this.globalMappingReference.getGlobalMappingElement(this.mappingID, 0);
        return this.tmpGME.getMeanInclusiveValue(this.trial.getCurValLoc());
    }

    public double getMeanInclusivePercentValue() {
        this.tmpGME = this.globalMappingReference.getGlobalMappingElement(this.mappingID, 0);
        return this.tmpGME.getMeanInclusivePercentValue(this.trial.getCurValLoc());
    }

    public String getMeanTotalStatString(int n) {
        this.tmpGME = this.globalMappingReference.getGlobalMappingElement(this.mappingID, 0);
        return this.tmpGME.getMeanTotalStatString(n, this.trial.getCurValLoc());
    }

    public double getMeanNumberOfCalls() {
        this.tmpGME = this.globalMappingReference.getGlobalMappingElement(this.mappingID, 0);
        return this.tmpGME.getMeanNumberOfCalls();
    }

    public double getMeanNumberOfSubRoutines() {
        this.tmpGME = this.globalMappingReference.getGlobalMappingElement(this.mappingID, 0);
        return this.tmpGME.getMeanNumberOfSubRoutines();
    }

    public double getMeanUserSecPerCall() {
        this.tmpGME = this.globalMappingReference.getGlobalMappingElement(this.mappingID, 0);
        return this.tmpGME.getMeanUserSecPerCall(this.trial.getCurValLoc());
    }

    public void setDrawCoords(int n, int n2, int n3, int n4) {
        this.xBeginPosition = n;
        this.xEndPosition = n2;
        this.yBeginPosition = n3;
        this.yEndPosition = n4;
    }

    public int getXBeg() {
        return this.xBeginPosition;
    }

    public int getXEnd() {
        return this.xEndPosition;
    }

    public int getYBeg() {
        return this.yBeginPosition;
    }

    public int getYEnd() {
        return this.yEndPosition;
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setSortSetting(int n) {
        this.sortSetting = n;
    }

    public void setSortByMappingID() {
        this.sortByMappingID = true;
        this.sortByName = false;
        this.sortByValue = false;
    }

    public void setSortByName() {
        this.sortByMappingID = false;
        this.sortByName = true;
        this.sortByValue = false;
    }

    public void setSortByValue() {
        this.sortByMappingID = false;
        this.sortByName = false;
        this.sortByValue = true;
    }

    public void setSortByReverse(boolean bl) {
        this.sortByReverse = bl;
    }
}

